/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover.db;

import com.google.gson.Gson;
import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.RecoverRegistry;
import com.netease.yidun.sdk.antispam.recover.db.RecoverRepository;
import com.netease.yidun.sdk.antispam.recover.db.RecoverRepositoryReadHandler;
import com.netease.yidun.sdk.antispam.recover.db.file.ErrorRecoverFile;
import com.netease.yidun.sdk.antispam.recover.db.file.RecoverFile;
import com.netease.yidun.sdk.core.utils.StringUtils;
import java.io.File;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecoverRepository<T>
implements RecoverRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRecoverRepository.class);
    private Gson gson = new Gson();
    private RecoverRepositoryReadHandler<T> recoverRepositoryReadHandler;
    private Class<T> entityClass;
    private RecoverFile recoverFile;
    private ErrorRecoverFile errorRecoverFile;

    public DefaultRecoverRepository(String dbName, Class<T> entityClass, RecoverRepositoryReadHandler<T> recoverRepositoryReadHandler, RecoverConfig recoverConfig) {
        this.entityClass = entityClass;
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            dbName = this.entityClass.getSimpleName();
        }
        this.recoverRepositoryReadHandler = recoverRepositoryReadHandler;
        this.errorRecoverFile = new ErrorRecoverFile(new File(recoverConfig.getRecoverErrorFilePath(dbName)), line -> {
            Object data = this.gson.fromJson(line, this.entityClass);
            return this.recoverRepositoryReadHandler.tryRecover(data);
        }, recoverConfig);
        this.recoverFile = new RecoverFile(new File(recoverConfig.getRecoverFilePath(dbName)), line -> {
            Object data = this.gson.fromJson(line, this.entityClass);
            boolean opRet = this.recoverRepositoryReadHandler.handleRecover(data);
            if (!opRet && !recoverConfig.isRecoverFailAbortEnable()) {
                this.errorRecoverFile.write(line);
            }
            return opRet;
        }, recoverConfig);
        RecoverRegistry.register(dbName, this.recoverFile, this.errorRecoverFile);
    }

    @Override
    public void store(T data) {
        if (data == null) {
            return;
        }
        String strData = this.gson.toJson(data);
        this.recoverFile.write(strData);
    }

    @Override
    public void store(Collection<T> datas) throws InterruptedException {
        if (datas == null || datas.isEmpty()) {
            return;
        }
        String[] strDatas = new String[datas.size()];
        int index = 0;
        for (T data : datas) {
            String strData = this.gson.toJson(data);
            strDatas[index++] = strData;
        }
        this.recoverFile.write(strDatas);
    }

    @Override
    public void checkFileSizeLimit() {
        this.recoverFile.checkFileSizeLimit();
    }

    @Override
    public void start() {
        this.recoverFile.start();
    }

    @Override
    public void stop() {
        this.recoverFile.stop();
    }
}

