/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover.db.asyn;

import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.db.DefaultRecoverRepository;
import com.netease.yidun.sdk.antispam.recover.db.RecoverRepositoryReadHandler;
import com.netease.yidun.sdk.antispam.recover.db.asyn.RecoverAsyner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecoverAsyner<T>
extends DefaultRecoverRepository<T>
implements RecoverAsyner<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRecoverAsyner.class);
    private final BlockingQueue<T> blockingQueue = new LinkedBlockingQueue<T>(2048);
    private static final int BATCH_SIZE = 400;
    private volatile boolean isStoped = false;
    private Class<T> entityClass;

    public DefaultRecoverAsyner(String dbPath, Class<T> entityClass, RecoverRepositoryReadHandler<T> recoverRepositoryReadHandler, RecoverConfig recoverConfig) {
        super(dbPath, entityClass, recoverRepositoryReadHandler, recoverConfig);
        this.entityClass = entityClass;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void asyn(T data) {
        this.checkFileSizeLimit();
        if (this.isStoped) {
            throw new IllegalStateException("current recover is stopped");
        }
        try {
            this.blockingQueue.put(data);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void asyn(Collection<T> datas) {
        for (T data : datas) {
            this.asyn(data);
        }
    }

    @Override
    public void start() {
        super.start();
        StoreThread storeThread = new StoreThread();
        storeThread.setName("recover-store-thread-" + this.entityClass.getSimpleName());
        storeThread.start();
    }

    @Override
    public void stop() {
        if (this.isStoped) {
            return;
        }
        super.stop();
        this.isStoped = true;
        try {
            if (this.blockingQueue.isEmpty()) {
                return;
            }
            ArrayList<T> list = new ArrayList<T>(this.blockingQueue.size());
            while (!this.blockingQueue.isEmpty()) {
                T data = this.blockingQueue.take();
                list.add(data);
            }
            this.store(list);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public class StoreThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList list = new ArrayList();
            while (!DefaultRecoverAsyner.this.isStoped) {
                try {
                    for (int count = 0; count <= 400; ++count) {
                        Object data = DefaultRecoverAsyner.this.blockingQueue.take();
                        list.add(data);
                        if (!DefaultRecoverAsyner.this.blockingQueue.isEmpty()) continue;
                        break;
                    }
                    DefaultRecoverAsyner.this.store(list);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                finally {
                    list.clear();
                }
            }
        }
    }
}

