/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover.db.file;

import com.netease.yidun.sdk.antispam.recover.LifeCycle;
import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.db.file.RecoverFileHandler;
import com.netease.yidun.sdk.core.utils.FileKits;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorRecoverFile
implements LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(ErrorRecoverFile.class);
    private File file;
    private RecoverFileHandler recoverFileHandler;
    private Object writeLock = new Object();
    private final RecoverConfig recoverConfig;

    public ErrorRecoverFile(File file, RecoverFileHandler recoverFileHandler, RecoverConfig recoverConfig) {
        if (this.fileError(file)) {
            throw new IllegalArgumentException("Invalid db file " + file + ", cause: Failed to create directory " + file.getParentFile() + "!");
        }
        this.file = file;
        this.recoverFileHandler = recoverFileHandler;
        this.recoverConfig = recoverConfig;
    }

    private boolean fileError(File file) {
        return !file.exists() && file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String ... datas) {
        if (datas == null || datas.length == 0) {
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.append(datas);
        }
    }

    public String getName() {
        return this.file.getName();
    }

    public long getLength() {
        return this.file.exists() ? this.file.length() : 0L;
    }

    private void append(String[] datas) {
        try {
            if (this.recoverConfig.fileSizeLimitEnable()) {
                FileKits.append((String[])datas, (File)this.file, (long)this.recoverConfig.getRecoverFileSizeLimitInByte());
            } else {
                FileKits.append((String[])datas, (File)this.file);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            try (FileReader fr = new FileReader(this.file);
                 BufferedReader bf = new BufferedReader(fr);){
                List<String> failed = this.recover(bf);
                Object object = this.writeLock;
                synchronized (object) {
                    failed.addAll(this.recover(bf));
                    this.clearAndAppend(failed);
                }
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    private List<String> recover(BufferedReader bufferedReader) throws IOException {
        String line;
        ArrayList<String> errorLines = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            try {
                boolean ret = this.recoverFileHandler.handle(line);
                if (ret) continue;
                log.error("file:{}, \u6062\u590d\u5931\u8d25\uff0cdata: {}", (Object)this.file.getName(), (Object)line);
                errorLines.add(line);
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u6062\u590d\u53d1\u751f\u5f02\u5e38 line\uff1a{}", (Object)line, (Object)e);
            }
        }
        return errorLines;
    }

    private void clearAndAppend(List<String> failed) {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            FileKits.clear((File)this.file);
            FileKits.append(failed, (File)this.file);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

