/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover.db.file;

import com.netease.yidun.sdk.antispam.recover.LifeCycle;
import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.db.file.RecoverFileHandler;
import com.netease.yidun.sdk.antispam.recover.exception.FileSizeLimitExceedException;
import com.netease.yidun.sdk.core.utils.FileKits;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverFile
implements LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(RecoverFile.class);
    private File file;
    private RecoverFileHandler recoverFileHandler;
    private Object writeLock = new Object();
    private final AtomicBoolean fileSizeLimitExceed = new AtomicBoolean(false);
    private final RecoverConfig recoverConfig;
    private final AtomicLong lastCheckFileSizeTime = new AtomicLong(0L);
    private static final long HALF_SECOND_IN_NANO = TimeUnit.MICROSECONDS.toNanos(500L);

    public RecoverFile(File file, RecoverFileHandler recoverFileHandler, RecoverConfig recoverConfig) {
        if (this.fileError(file)) {
            throw new IllegalArgumentException("Invalid db file " + file + ", cause: Failed to create directory " + file.getParentFile() + "!");
        }
        this.file = file;
        this.recoverFileHandler = recoverFileHandler;
        this.recoverConfig = recoverConfig;
        if (recoverConfig.fileSizeLimitEnable()) {
            this.updateIfExceedFileSizeLimit();
        }
    }

    private boolean fileError(File file) {
        return !file.exists() && file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs();
    }

    public RecoverFileHandler getRecoverFileHandler() {
        return this.recoverFileHandler;
    }

    public Object getWriteLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String ... datas) {
        if (datas == null || datas.length == 0) {
            return;
        }
        try {
            File lockFile;
            if (this.recoverConfig.fileSizeLimitEnable()) {
                while (this.isFileSizeLimitExceed()) {
                    log.warn("file[{}] exceeded size limit[{}], sleep 2s", (Object)this.file.getName(), (Object)this.recoverConfig.getRecoverFileSizeLimitInByte());
                    Thread.sleep(2000L);
                    this.updateIfExceedFileSizeLimit();
                }
            }
            if (!(lockFile = new File(this.file.getAbsolutePath() + ".lock")).exists()) {
                lockFile.createNewFile();
            }
            try (RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
                 FileChannel channel = raf.getChannel();
                 FileLock lock = channel.lock();){
                if (log.isDebugEnabled()) {
                    log.debug("lock file success {}, isValid:{}", (Object)lockFile.getAbsolutePath(), (Object)lock.isValid());
                }
                channel.truncate(0L);
                channel.write(ByteBuffer.wrap((this.recoverConfig.getLocalAddress() + "_" + System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8)));
                Object object = this.writeLock;
                synchronized (object) {
                    this.append(datas);
                }
            }
        }
        catch (Throwable e) {
            log.error("append file [{}] unexpected error, cause: {}", new Object[]{this.file.getAbsolutePath(), e.getMessage(), e});
            log.error("append failed data: " + Arrays.toString(datas));
        }
    }

    private void append(String[] datas) throws IOException {
        FileKits.append((String[])datas, (File)this.file);
        if (this.recoverConfig.fileSizeLimitEnable()) {
            this.updateIfExceedFileSizeLimit();
        }
    }

    private void updateIfExceedFileSizeLimit() {
        this.fileSizeLimitExceed.set(this.file.length() >= this.recoverConfig.getRecoverFileSizeLimitInByte());
        this.lastCheckFileSizeTime.set(System.nanoTime());
    }

    public void checkFileSizeLimit() {
        if (!this.recoverConfig.fileSizeLimitEnable()) {
            return;
        }
        if (this.isFileSizeLimitExceed() && System.nanoTime() - this.lastCheckFileSizeTime.get() > HALF_SECOND_IN_NANO) {
            this.updateIfExceedFileSizeLimit();
        }
        if (this.isFileSizeLimitExceed()) {
            throw new FileSizeLimitExceedException(String.format("file[%s] exceeded size limit[%s]", this.file.getName(), this.recoverConfig.getRecoverFileSizeLimitInByte()));
        }
    }

    private boolean isFileSizeLimitExceed() {
        return this.fileSizeLimitExceed.get();
    }

    public String getFilePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

