/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover.recovery;

import com.netease.yidun.sdk.antispam.recover.LifeCycle;
import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.recovery.RecoverTask;
import com.netease.yidun.sdk.core.utils.NamedThreadFactory;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverManager
implements LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RecoverConfig recoverConfig;
    private final ScheduledThreadPoolExecutor recoverScheduled;
    private volatile boolean isStarted = false;

    public RecoverManager(RecoverConfig recoverConfig) {
        this.recoverConfig = recoverConfig;
        this.recoverScheduled = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("recover-task", true));
    }

    @Override
    public synchronized void start() {
        try {
            if (this.isStarted) {
                return;
            }
            log.info("RecoverManager start, recoverConfig: {}", (Object)this.recoverConfig);
            this.doStart();
            this.isStarted = true;
        }
        catch (Throwable e) {
            throw new RuntimeException("RecoverManager start error", e);
        }
    }

    private void doStart() throws IOException {
        try {
            File dir = new File(this.recoverConfig.getBasePath());
            if (!dir.exists()) {
                Files.createDirectories(Paths.get(this.recoverConfig.getBasePath(), new String[0]), new FileAttribute[0]);
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        this.recoverScheduled.scheduleWithFixedDelay(new RecoverTask(this.recoverConfig), this.recoverConfig.getInitialDelayInSec(), this.recoverConfig.getClusterCleanIntervalInSec(), TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        this.recoverScheduled.shutdown();
        try {
            if (!this.recoverScheduled.awaitTermination(10L, TimeUnit.SECONDS)) {
                log.error("await recoverScheduled thread process 10 seconds,don't await anymore");
                this.recoverScheduled.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("awaitTermination recoverScheduled error", (Throwable)e);
        }
    }
}

