/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.recover.recovery;

import com.netease.yidun.sdk.antispam.recover.RecoverConfig;
import com.netease.yidun.sdk.antispam.recover.RecoverRegistry;
import com.netease.yidun.sdk.antispam.recover.db.file.ErrorRecoverFile;
import com.netease.yidun.sdk.antispam.recover.db.file.RecoverFile;
import com.netease.yidun.sdk.antispam.recover.db.file.RecoverFileHandler;
import com.netease.yidun.sdk.core.utils.FileKits;
import com.netease.yidun.sdk.core.utils.NamedThreadFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String basePath;
    private final String clusterRecoveryLockFilePath;
    private final String localAddress;
    private final RecoverConfig recoverConfig;
    private final ExecutorService recoverExecutor;

    public RecoverTask(RecoverConfig recoverConfig) {
        this.recoverConfig = recoverConfig;
        this.basePath = recoverConfig.getBasePath();
        this.clusterRecoveryLockFilePath = recoverConfig.getRecoverLockFilePath();
        this.localAddress = recoverConfig.getLocalAddress();
        this.recoverExecutor = new ThreadPoolExecutor(recoverConfig.getClusterRecoverPoolSize(), recoverConfig.getClusterRecoverPoolSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), (ThreadFactory)new NamedThreadFactory("recover-worker", true));
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        try {
            File lockFile = new File(this.clusterRecoveryLockFilePath);
            if (!lockFile.exists()) {
                lockFile.createNewFile();
            }
            try (RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
                 FileChannel channel = raf.getChannel();
                 FileLock lock = channel.tryLock();){
                if (lock == null) {
                    log.warn("Can not lock the file " + this.clusterRecoveryLockFilePath + ", ignore and retry later, maybe other java process use the file");
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("lock file success {}, currentIp:{}", (Object)this.clusterRecoveryLockFilePath, (Object)this.recoverConfig.getLocalAddress());
                }
                channel.truncate(0L);
                channel.write(ByteBuffer.wrap((this.localAddress + "_start_" + System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8)));
                this.dealRecoverFiles();
                this.dealErrorFiles();
                channel.truncate(0L);
                channel.write(ByteBuffer.wrap((this.localAddress + "_end_" + System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8)));
            }
        }
        catch (Throwable e) {
            log.warn("OfflineRecoveryTask error, cause: " + e.getMessage(), e);
        }
        log.info("\u6570\u636e\u6062\u590d\u903b\u8f91\u7ed3\u675f\uff0c\u4efb\u52a1\u6267\u884c\u8282\u70b9: {}, total cost: {}ms", (Object)this.recoverConfig.getLocalAddress(), (Object)(System.currentTimeMillis() - start));
    }

    private void dealRecoverFiles() throws InterruptedException {
        List<File> recoverFileList = this.getRecoverFileList();
        if (recoverFileList.isEmpty()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(recoverFileList.size());
        for (File recover : recoverFileList) {
            if (!recover.exists() || recover.length() == 0L) {
                latch.countDown();
                continue;
            }
            this.recoverExecutor.execute(() -> {
                try {
                    long temp = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug("{} \u6062\u590d\u5f00\u59cb! \u4efb\u52a1\u6267\u884c\u8282\u70b9: {},", (Object)recover.getName(), (Object)this.recoverConfig.getLocalAddress());
                    }
                    this.handleRecover(recover);
                    log.info("{} \u6062\u590d\u7ed3\u675f\uff01\u4efb\u52a1\u6267\u884c\u8282\u70b9: {}, cost:{} ms", new Object[]{recover.getName(), this.recoverConfig.getLocalAddress(), System.currentTimeMillis() - temp});
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    private void dealErrorFiles() throws InterruptedException {
        if (RecoverRegistry.getErrorRecoverFileList().isEmpty()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(RecoverRegistry.getErrorRecoverFileList().size());
        for (ErrorRecoverFile errorRecoverFile : RecoverRegistry.getErrorRecoverFileList()) {
            if (errorRecoverFile.getLength() == 0L) {
                latch.countDown();
                continue;
            }
            this.recoverExecutor.execute(() -> {
                try {
                    long temp = System.currentTimeMillis();
                    errorRecoverFile.recover();
                    log.info("{} \u6062\u590d\u7ed3\u675f\uff01\u4efb\u52a1\u6267\u884c\u8282\u70b9: {}, cost:{} ms", new Object[]{errorRecoverFile.getName(), this.recoverConfig.getLocalAddress(), System.currentTimeMillis() - temp});
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    private void handleRecover(File recoverFile) {
        try {
            String dbName = this.parseDbName(recoverFile.getName());
            RecoverFileHandler recoverFileHandler = RecoverRegistry.lookupHandler(dbName);
            if (recoverFileHandler == null) {
                log.error("no recoverFileHandler found for recoverFile[{}], db: [{}]", (Object)recoverFile.getName(), (Object)dbName);
                return;
            }
            boolean fileRecoverDone = false;
            while (!fileRecoverDone) {
                fileRecoverDone = this.recoverAndClean(recoverFile, recoverFileHandler, dbName);
            }
        }
        catch (Throwable e) {
            log.error("recover file [{}] unexpected error, cause: {}", (Object)recoverFile.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoverAndClean(File recoverFile, RecoverFileHandler recoverFileHandler, String dbName) throws IOException {
        Object object;
        int lastHandleLine = 0;
        boolean readFileError = false;
        long start = System.currentTimeMillis();
        try {
            FileReader fr = new FileReader(recoverFile);
            object = null;
            try (LineNumberReader lr = new LineNumberReader(fr);){
                String line;
                while ((line = lr.readLine()) != null && lr.getLineNumber() <= this.recoverConfig.getRecoverLinesPerTime()) {
                    try {
                        recoverFileHandler.handle(line);
                        lastHandleLine = lr.getLineNumber();
                    }
                    catch (Exception e) {
                        log.error("\u6570\u636e\u6062\u590d\u53d1\u751f\u5f02\u5e38 line\uff1a{}", (Object)line, (Object)e);
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fr != null) {
                    if (object != null) {
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fr.close();
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("error when read recoverFile[{}], cause:{}", new Object[]{recoverFile.getAbsolutePath(), e.getMessage(), e});
            readFileError = true;
        }
        if (readFileError || lastHandleLine == 0) {
            return true;
        }
        log.info("recover {} lines from {}, recoverCost: {}ms", new Object[]{lastHandleLine, recoverFile.getName(), System.currentTimeMillis() - start});
        start = System.currentTimeMillis();
        if (this.isLocalRecoverFile(recoverFile.getAbsolutePath(), dbName)) {
            RecoverFile localRecoverFile = RecoverRegistry.lookupFile(dbName);
            object = localRecoverFile.getWriteLock();
            synchronized (object) {
                this.handleClean(recoverFile, lastHandleLine);
            }
        }
        File lockFile = new File(recoverFile.getAbsolutePath() + ".lock");
        if (!lockFile.exists()) {
            lockFile.createNewFile();
        }
        try (RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
             FileChannel channel = raf.getChannel();
             FileLock lock = channel.lock();){
            if (log.isDebugEnabled()) {
                log.debug("lock file success {}, currentIp:{}", (Object)lockFile.getAbsolutePath(), (Object)this.recoverConfig.getLocalAddress());
            }
            channel.truncate(0L);
            channel.write(ByteBuffer.wrap((this.localAddress + "_" + System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8)));
            this.handleClean(recoverFile, lastHandleLine);
        }
        log.info("remove {} lines from {}, removeCost: {}ms", new Object[]{lastHandleLine, recoverFile.getName(), System.currentTimeMillis() - start});
        return false;
    }

    private boolean isLocalRecoverFile(String absolutePath, String dbName) {
        RecoverFile localRecoverFile = RecoverRegistry.lookupFile(dbName);
        return localRecoverFile != null && Objects.equals(absolutePath, localRecoverFile.getFilePath());
    }

    private void handleClean(File recoverFile, int lastHandleLine) throws IOException {
        log.info("recover file {} success , remove {} lines from head", (Object)recoverFile.getAbsolutePath(), (Object)lastHandleLine);
        FileKits.removeLinesFromHead((File)recoverFile, (int)lastHandleLine);
    }

    private String parseDbName(String recoverFileName) {
        if (this.recoverConfig.isIpIsolateEnable()) {
            return recoverFileName.substring(recoverFileName.indexOf("_") + 1, recoverFileName.indexOf(".recover"));
        }
        return recoverFileName.substring(0, recoverFileName.indexOf(".recover"));
    }

    private List<File> getRecoverFileList() {
        File[] files = new File(this.basePath).listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> list = new ArrayList<File>(files.length);
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".recover")) continue;
            list.add(file);
        }
        return list;
    }
}

