/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.antispam.report.v1.submit.request;

import com.google.gson.Gson;
import com.netease.yidun.sdk.antispam.report.v1.submit.response.ReportCheckResponseV1;
import com.netease.yidun.sdk.core.request.PostFormRequest;
import com.netease.yidun.sdk.core.utils.StringHashMap;
import com.netease.yidun.sdk.core.utils.StringUtils;
import com.netease.yidun.sdk.core.validation.limitation.NotBlank;
import com.netease.yidun.sdk.core.validation.limitation.Size;
import com.netease.yidun.sdk.core.validation.limitation.Valid;
import java.util.List;
import java.util.Map;

public class ReportSubmitRequestV1
extends PostFormRequest<ReportCheckResponseV1> {
    private static final Gson GSON = new Gson();
    @Size(max=128, message="ip\u6700\u957f128\u4e2a\u5b57\u7b26")
    private String ip;
    @Size(max=128, message="account\u6700\u957f128\u4e2a\u5b57\u7b26")
    private String account;
    @Size(max=128, message="deviceId\u6700\u957f128\u4e2a\u5b57\u7b26")
    private String deviceId;
    @Size(max=4, message="deviceType\u6700\u957f4\u4e2a\u5b57\u7b26")
    private String deviceType;
    @Size(max=128, message="dataId\u6700\u957f128\u4e2a\u5b57\u7b26")
    private String dataId;
    @Valid
    private List<DataItem> content;
    @Valid
    private List<DataItem> evidence;
    private Map<String, List<DataItem>> customParseFieldMap;
    private Map<String, String> customUnParseFieldMap;
    @Size(max=512, message="callback\u6700\u957f512\u4e2a\u5b57\u7b26")
    private String callback;
    @Size(max=1024, message="callbackUrl\u6700\u957f1024\u4e2a\u5b57\u7b26")
    private String callbackUrl;
    private Long publishTime;
    @Size(max=256, message="token\u6700\u957f256\u4e2a\u5b57\u7b26")
    private String token;
    @NotBlank(message="reportedId\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=64, message="reportedId\u6700\u957f64\u4e2a\u5b57\u7b26")
    public String reportedId;
    @Size(max=64, message="scenarios\u6700\u957f64\u4e2a\u5b57\u7b26")
    public String scenarios;
    @Size(max=64, message="reportType\u6700\u957f64\u4e2a\u5b57\u7b26")
    public String reportType;
    @Size(max=64, message="roomId\u6700\u957f64\u4e2a\u5b57\u7b26")
    private String roomId;
    private String checkLanguageCode;

    public ReportSubmitRequestV1() {
        this.productCode = "report";
        this.uriPattern = "/v1/report/submit";
        this.version = "v1";
    }

    protected Map<String, String> getCustomSignParams() {
        StringHashMap params = new StringHashMap();
        params.put("ip", this.getIp());
        params.put("account", this.getAccount());
        params.put("deviceId", this.getDeviceId());
        params.put("deviceType", this.getDeviceType());
        params.put("dataId", this.getDataId());
        params.put("callback", this.getCallback());
        params.put("callbackUrl", this.getCallbackUrl());
        params.put("publishTime", (Object)this.getPublishTime());
        params.put("token", this.getToken());
        params.put("reportedId", this.getReportedId());
        params.put("scenarios", this.getScenarios());
        params.put("reportType", this.getReportType());
        params.put("roomId", this.getRoomId());
        params.put("checkLanguageCode", this.getCheckLanguageCode());
        if (this.content != null && !this.content.isEmpty()) {
            params.put("content", GSON.toJson(this.getContent()));
        }
        if (this.evidence != null && !this.evidence.isEmpty()) {
            params.put("evidence", GSON.toJson(this.getEvidence()));
        }
        if (this.customParseFieldMap != null && !this.customParseFieldMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.customParseFieldMap.entrySet()) {
                List dataItemList = (List)entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || dataItemList == null || dataItemList.isEmpty()) continue;
                params.put(entry.getKey(), GSON.toJson((Object)dataItemList));
            }
        }
        if (this.customUnParseFieldMap != null && !this.customUnParseFieldMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.customUnParseFieldMap.entrySet()) {
                String data = (String)entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || !StringUtils.isNotBlank((CharSequence)data)) continue;
                params.put(entry.getKey(), data);
            }
        }
        return params;
    }

    public Class<ReportCheckResponseV1> getResponseClass() {
        return ReportCheckResponseV1.class;
    }

    public ReportSubmitRequestV1 ip(String ip) {
        this.ip = ip;
        return this;
    }

    public ReportSubmitRequestV1 account(String account) {
        this.account = account;
        return this;
    }

    public ReportSubmitRequestV1 deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public ReportSubmitRequestV1 deviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public ReportSubmitRequestV1 dataId(String dataId) {
        this.dataId = dataId;
        return this;
    }

    public ReportSubmitRequestV1 content(List<DataItem> content) {
        this.content = content;
        return this;
    }

    public ReportSubmitRequestV1 customParseFieldMap(Map<String, List<DataItem>> customParseFieldMap) {
        this.customParseFieldMap = customParseFieldMap;
        return this;
    }

    public ReportSubmitRequestV1 customUnParseFieldMap(Map<String, String> customUnParseFieldMap) {
        this.customUnParseFieldMap = customUnParseFieldMap;
        return this;
    }

    public ReportSubmitRequestV1 callback(String callback) {
        this.callback = callback;
        return this;
    }

    public ReportSubmitRequestV1 callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public ReportSubmitRequestV1 publishTime(Long publishTime) {
        this.publishTime = publishTime;
        return this;
    }

    public ReportSubmitRequestV1 token(String token) {
        this.token = token;
        return this;
    }

    public ReportSubmitRequestV1 reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    public ReportSubmitRequestV1 scenarios(String scenarios) {
        this.scenarios = scenarios;
        return this;
    }

    public ReportSubmitRequestV1 reportedId(String reportedId) {
        this.reportedId = reportedId;
        return this;
    }

    public ReportSubmitRequestV1 roomId(String roomId) {
        this.roomId = roomId;
        return this;
    }

    public ReportSubmitRequestV1 evidence(List<DataItem> evidence) {
        this.evidence = evidence;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public List<DataItem> getContent() {
        return this.content;
    }

    public void setContent(List<DataItem> content) {
        this.content = content;
    }

    public List<DataItem> getEvidence() {
        return this.evidence;
    }

    public void setEvidence(List<DataItem> evidence) {
        this.evidence = evidence;
    }

    public Map<String, List<DataItem>> getCustomParseFieldMap() {
        return this.customParseFieldMap;
    }

    public void setCustomParseFieldMap(Map<String, List<DataItem>> customParseFieldMap) {
        this.customParseFieldMap = customParseFieldMap;
    }

    public Map<String, String> getCustomUnParseFieldMap() {
        return this.customUnParseFieldMap;
    }

    public void setCustomUnParseFieldMap(Map<String, String> customUnParseFieldMap) {
        this.customUnParseFieldMap = customUnParseFieldMap;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public Long getPublishTime() {
        return this.publishTime;
    }

    public void setPublishTime(Long publishTime) {
        this.publishTime = publishTime;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getReportedId() {
        return this.reportedId;
    }

    public void setReportedId(String reportedId) {
        this.reportedId = reportedId;
    }

    public String getScenarios() {
        return this.scenarios;
    }

    public void setScenarios(String scenarios) {
        this.scenarios = scenarios;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getCheckLanguageCode() {
        return this.checkLanguageCode;
    }

    public void setCheckLanguageCode(String checkLanguageCode) {
        this.checkLanguageCode = checkLanguageCode;
    }

    public String toString() {
        return "ReportSubmitRequestV1{ip='" + this.ip + '\'' + ", account='" + this.account + '\'' + ", deviceId='" + this.deviceId + '\'' + ", deviceType='" + this.deviceType + '\'' + ", dataId='" + this.dataId + '\'' + ", content=" + this.content + ", evidence=" + this.evidence + ", customParseFieldMap=" + this.customParseFieldMap + ", customUnParseFieldMap=" + this.customUnParseFieldMap + ", callback='" + this.callback + '\'' + ", callbackUrl='" + this.callbackUrl + '\'' + ", publishTime=" + this.publishTime + ", token='" + this.token + '\'' + ", reportedId='" + this.reportedId + '\'' + ", scenarios='" + this.scenarios + '\'' + ", reportType='" + this.reportType + '\'' + ", roomId='" + this.roomId + '\'' + ", checkLanguageCode='" + this.checkLanguageCode + '\'' + '}';
    }

    public static class DataItem {
        @NotBlank(message="type\u4e0d\u80fd\u4e3a\u7a7a")
        @Size(min=1, max=10, message="type\u6700\u957f10\u4e2a\u5b57\u7b26")
        private String type;
        @NotBlank(message="data\u4e0d\u80fd\u4e3a\u7a7a")
        private String data;
        @Size(max=128, message="dataId\u6700\u957f128\u4e2a\u5b57\u7b26")
        private String dataId;

        public DataItem type(String type) {
            this.type = type;
            return this;
        }

        public DataItem data(String data) {
            this.data = data;
            return this;
        }

        public DataItem dataId(String dataId) {
            this.dataId = dataId;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getDataId() {
            return this.dataId;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public String toString() {
            return "DataItem{type='" + this.type + '\'' + ", data='" + this.data + '\'' + ", dataId='" + this.dataId + '\'' + '}';
        }
    }
}

