/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.auth.ocr;

import com.netease.yidun.sdk.auth.ocr.bankcard.v1.BankCardOcrRequest;
import com.netease.yidun.sdk.auth.ocr.bankcard.v1.BankCardOcrResponse;
import com.netease.yidun.sdk.auth.ocr.businesslicense.v1.BusinessLicenseOcrRequest;
import com.netease.yidun.sdk.auth.ocr.businesslicense.v1.BusinessLicenseOcrResponse;
import com.netease.yidun.sdk.auth.ocr.idcard.v1.IdCardOcrRequest;
import com.netease.yidun.sdk.auth.ocr.idcard.v1.IdCardOcrResponse;
import com.netease.yidun.sdk.auth.ocr.licenseplate.v1.LicensePlateOcrRequest;
import com.netease.yidun.sdk.auth.ocr.licenseplate.v1.LicensePlateOcrResponse;
import com.netease.yidun.sdk.core.client.Client;
import com.netease.yidun.sdk.core.client.ClientProfile;
import com.netease.yidun.sdk.core.client.DefaultClient;
import com.netease.yidun.sdk.core.request.BaseRequest;

public class OcrClient {
    private final Client client;

    public OcrClient(Client client) {
        this.client = client;
    }

    public OcrClient(String secretId, String secretKey) {
        ClientProfile profile = ClientProfile.defaultProfile((String)secretId, (String)secretKey).preheatRequestsForValidation(new BaseRequest[]{new BankCardOcrRequest(null), new BusinessLicenseOcrRequest(null), new IdCardOcrRequest(null), new LicensePlateOcrRequest(null)});
        this.client = new DefaultClient(profile);
    }

    public OcrClient(ClientProfile profile) {
        this((Client)new DefaultClient(profile));
    }

    public Client getClient() {
        return this.client;
    }

    public Client client() {
        return this.client;
    }

    public BusinessLicenseOcrResponse checkBusinessLicense(BusinessLicenseOcrRequest request) {
        return (BusinessLicenseOcrResponse)this.client.execute((BaseRequest)request);
    }

    public IdCardOcrResponse checkIdCard(IdCardOcrRequest request) {
        return (IdCardOcrResponse)this.client.execute((BaseRequest)request);
    }

    public BankCardOcrResponse checkBankCard(BankCardOcrRequest request) {
        return (BankCardOcrResponse)this.client.execute((BaseRequest)request);
    }

    public LicensePlateOcrResponse checkLicensePlate(LicensePlateOcrRequest request) {
        return (LicensePlateOcrResponse)this.client.execute((BaseRequest)request);
    }

    public String toString() {
        return "OcrClient(client=" + this.client + ")";
    }
}

