/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.common;

import com.google.gson.Gson;
import com.netease.yidun.sdk.core.request.PostFormRequest;
import com.netease.yidun.sdk.core.response.BaseResponse;
import com.netease.yidun.sdk.core.utils.ClassUtils;
import com.netease.yidun.sdk.core.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class CustomSignParamRequest<T extends BaseResponse>
extends PostFormRequest<T> {
    protected Map<String, String> getCustomSignParams() {
        Map customSignParams = super.getCustomSignParams();
        for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != CustomSignParamRequest.class; clazz = clazz.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(declaredField.getModifiers())) continue;
                try {
                    ParameterizedType parameterizedType;
                    Type[] typeArguments;
                    Object value = this.getFieldValue(clazz, declaredField);
                    if (value == null) continue;
                    if (value instanceof String) {
                        customSignParams.put(declaredField.getName(), (String)value);
                        continue;
                    }
                    if (value instanceof Collection && declaredField.getGenericType() != null && declaredField.getGenericType() instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)declaredField.getGenericType()).getActualTypeArguments()).length > 0 && typeArguments[0] instanceof Class && ClassUtils.isPrimitiveOrWrapper((Class)((Class)typeArguments[0]))) {
                        String signValue = ((Collection)value).stream().map(String::valueOf).collect(Collectors.joining(","));
                        customSignParams.put(declaredField.getName(), signValue.toString());
                        continue;
                    }
                    customSignParams.put(declaredField.getName(), new Gson().toJson(value));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return customSignParams;
    }

    private Object getFieldValue(Class clazz, Field declaredField) throws IllegalAccessException {
        try {
            Method method = clazz.getMethod("get" + StringUtils.upperCaseFirstLetter((String)declaredField.getName()), new Class[0]);
            return method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            declaredField.setAccessible(true);
            return declaredField.get((Object)this);
        }
    }
}

