/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.irisk;

import com.netease.yidun.sdk.core.client.Client;
import com.netease.yidun.sdk.core.client.ClientProfile;
import com.netease.yidun.sdk.core.client.DefaultClient;
import com.netease.yidun.sdk.core.utils.AssertUtils;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ClientRegistry {
    private static final Map<String, Object> clientMap = new ConcurrentHashMap<String, Object>();

    public static <T> T register(ClientProfile profile, Class<T> clazz) {
        AssertUtils.notNull((Object)profile, (String)"ClientProfile can not be null");
        String key = profile.getCredentials().secretId() + "," + clazz.getName();
        return (T)Optional.ofNullable(clientMap.get(key)).orElseGet(() -> clientMap.computeIfAbsent(key, k -> {
            try {
                return clazz.getDeclaredConstructor(Client.class).newInstance(new DefaultClient(profile));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }
}

