/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.irisk.v1;

import com.netease.yidun.sdk.core.client.Client;
import com.netease.yidun.sdk.core.client.ClientProfile;
import com.netease.yidun.sdk.core.client.DefaultClient;
import com.netease.yidun.sdk.core.request.BaseRequest;
import com.netease.yidun.sdk.irisk.ClientRegistry;
import com.netease.yidun.sdk.irisk.v1.antigold.IRiskAntiGoldCheckRequest;
import com.netease.yidun.sdk.irisk.v1.antigold.IRiskAntiGoldCheckResponse;
import com.netease.yidun.sdk.irisk.v1.check.IRiskCheckRequest;
import com.netease.yidun.sdk.irisk.v1.check.IRiskCheckResponse;
import com.netease.yidun.sdk.irisk.v1.config.IRiskConfigRequest;
import com.netease.yidun.sdk.irisk.v1.config.IRiskConfigResponse;
import com.netease.yidun.sdk.irisk.v1.detail.IRiskDetailRequest;
import com.netease.yidun.sdk.irisk.v1.detail.IRiskDetailResponse;
import com.netease.yidun.sdk.irisk.v1.dispose.IRiskDisposeUploadRequest;
import com.netease.yidun.sdk.irisk.v1.dispose.IRiskDisposeUploadResponse;
import com.netease.yidun.sdk.irisk.v1.list.IRiskListAddRequest;
import com.netease.yidun.sdk.irisk.v1.list.IRiskListAddResponse;
import com.netease.yidun.sdk.irisk.v1.list.IRiskListQueryRequest;
import com.netease.yidun.sdk.irisk.v1.list.IRiskListQueryResponse;
import com.netease.yidun.sdk.irisk.v1.mediacheck.IRiskMediaBatchQueryRequest;
import com.netease.yidun.sdk.irisk.v1.mediacheck.IRiskMediaBatchQueryResponse;
import com.netease.yidun.sdk.irisk.v1.mediacheck.IRiskMediaCheckRequest;
import com.netease.yidun.sdk.irisk.v1.mediacheck.IRiskMediaCheckResponse;
import com.netease.yidun.sdk.irisk.v1.mediacheck.IRiskMediaQueryRequest;
import com.netease.yidun.sdk.irisk.v1.mediacheck.IRiskMediaQueryResponse;
import com.netease.yidun.sdk.irisk.v1.report.IRiskReportDataRequest;
import com.netease.yidun.sdk.irisk.v1.report.IRiskReportDataResponse;

public class IRiskClient {
    private final Client client;

    public IRiskClient(Client client) {
        this.client = client;
    }

    public IRiskClient(ClientProfile profile) {
        this((Client)new DefaultClient(profile));
    }

    public static IRiskClient getInstance(String secretId, String secretKey) {
        ClientProfile profile = ClientProfile.defaultProfile((String)secretId, (String)secretKey).preheatRequestsForValidation(new BaseRequest[]{new IRiskCheckRequest(null), new IRiskDetailRequest(null)});
        return ClientRegistry.register(profile, IRiskClient.class);
    }

    public static IRiskClient getInstance(ClientProfile profile) {
        return ClientRegistry.register(profile, IRiskClient.class);
    }

    public Client getClient() {
        return this.client;
    }

    public Client client() {
        return this.client;
    }

    public IRiskCheckResponse check(IRiskCheckRequest request) {
        return (IRiskCheckResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskMediaCheckResponse mediaCheck(IRiskMediaCheckRequest request) {
        return (IRiskMediaCheckResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskMediaQueryResponse mediaQuery(IRiskMediaQueryRequest request) {
        return (IRiskMediaQueryResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskMediaBatchQueryResponse mediaBatchQuery(IRiskMediaBatchQueryRequest request) {
        return (IRiskMediaBatchQueryResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskConfigResponse getConfig(IRiskConfigRequest request) {
        return (IRiskConfigResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskDetailResponse getDetail(IRiskDetailRequest request) {
        return (IRiskDetailResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskDisposeUploadResponse disposeUpload(IRiskDisposeUploadRequest request) {
        return (IRiskDisposeUploadResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskAntiGoldCheckResponse antiGoldCheck(IRiskAntiGoldCheckRequest request) {
        return (IRiskAntiGoldCheckResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskReportDataResponse reportData(IRiskReportDataRequest request) {
        return (IRiskReportDataResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskListQueryResponse listQuery(IRiskListQueryRequest request) {
        return (IRiskListQueryResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskListAddResponse listAdd(IRiskListAddRequest request) {
        return (IRiskListAddResponse)this.client.execute((BaseRequest)request);
    }

    public String toString() {
        return "IRiskCheckClient(client=" + this.client + ")";
    }
}

