/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yidun.sdk.irisk.v6;

import com.netease.yidun.sdk.core.client.Client;
import com.netease.yidun.sdk.core.client.ClientProfile;
import com.netease.yidun.sdk.core.client.DefaultClient;
import com.netease.yidun.sdk.core.request.BaseRequest;
import com.netease.yidun.sdk.core.response.DataResponse;
import com.netease.yidun.sdk.irisk.ClientRegistry;
import com.netease.yidun.sdk.irisk.v6.check.IRiskCheckV6Request;
import com.netease.yidun.sdk.irisk.v6.check.IRiskCheckV6Response;
import com.netease.yidun.sdk.irisk.v6.check.v600.IRiskCheckV600Request;
import com.netease.yidun.sdk.irisk.v6.check.v600.IRiskCheckV600Result;
import com.netease.yidun.sdk.irisk.v6.check.v600.hitinfo.HitInfo;
import com.netease.yidun.sdk.irisk.v6.check.v601.IRiskCheckV601Request;
import com.netease.yidun.sdk.irisk.v6.check.v602.HitInfoV602;
import com.netease.yidun.sdk.irisk.v6.check.v602.IRiskCheckV602Request;
import com.netease.yidun.sdk.irisk.v6.check.v603.IRiskCheckV603Request;
import com.netease.yidun.sdk.irisk.v6.check.v603.IRiskCheckV603Result;
import com.netease.yidun.sdk.irisk.v6.check.v603.ip.IpBasicInfo;
import com.netease.yidun.sdk.irisk.v6.check.v603.ip.IpInfo;
import com.netease.yidun.sdk.irisk.v6.check.v603.ip.IpRiskInfo;
import com.netease.yidun.sdk.irisk.v6.check.v603.phone.PhoneBasicInfo;
import com.netease.yidun.sdk.irisk.v6.check.v603.phone.PhoneInfo;
import com.netease.yidun.sdk.irisk.v6.check.v603.phone.PhoneRiskInfo;
import com.netease.yidun.sdk.irisk.v6.detail.IRiskDetailV6Request;
import com.netease.yidun.sdk.irisk.v6.detail.IRiskDetailV6Response;

public class IRiskV6Client {
    private final Client client;

    public IRiskV6Client(Client client) {
        this.client = client;
    }

    public IRiskV6Client(ClientProfile profile) {
        this((Client)new DefaultClient(profile));
    }

    public static IRiskV6Client getInstance(String secretId, String secretKey) {
        ClientProfile profile = ClientProfile.defaultProfile((String)secretId, (String)secretKey).preheatRequestsForValidation(new BaseRequest[]{new IRiskCheckV6Request(null), new IRiskDetailV6Request(null)});
        return ClientRegistry.register(profile, IRiskV6Client.class);
    }

    public static IRiskV6Client getInstance(ClientProfile profile) {
        return ClientRegistry.register(profile, IRiskV6Client.class);
    }

    public Client getClient() {
        return this.client;
    }

    public Client client() {
        return this.client;
    }

    public IRiskCheckV6Response check(IRiskCheckV6Request request) {
        return (IRiskCheckV6Response)this.client.execute((BaseRequest)request);
    }

    public DataResponse<IRiskCheckV600Result<HitInfo>> check(IRiskCheckV600Request request) {
        return (DataResponse)this.client.execute((BaseRequest)request);
    }

    public DataResponse<IRiskCheckV600Result<HitInfo>> check(IRiskCheckV601Request request) {
        return (DataResponse)this.client.execute((BaseRequest)request);
    }

    public DataResponse<IRiskCheckV600Result<HitInfoV602>> check(IRiskCheckV602Request request) {
        return (DataResponse)this.client.execute((BaseRequest)request);
    }

    public DataResponse<IRiskCheckV603Result<HitInfoV602, PhoneInfo<PhoneBasicInfo, PhoneRiskInfo>, IpInfo<IpBasicInfo, IpRiskInfo>>> check(IRiskCheckV603Request request) {
        return (DataResponse)this.client.execute((BaseRequest)request);
    }

    public IRiskDetailV6Response detailV6(IRiskDetailV6Request request) {
        return (IRiskDetailV6Response)this.client.execute((BaseRequest)request);
    }

    public String toString() {
        return "IRiskCheckV6Client(client=" + this.client + ")";
    }
}

