/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.foreground;

import android.text.TextUtils;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.util.ContextUtils;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Authenticate
extends Thread {
    public static final String TAG = "Authenticate";
    public static final String kRtcDot = "-";
    public static final int AUTHENTICATE_CODE = 1999;
    public static final int TIME_OUT = 8000;
    public static final int RETRY_NUM = 3;
    public volatile boolean stop = false;
    private static Authenticate instance;
    private final String appKey;
    private AuthenticateCallback callback;
    private int retryNum;

    private Authenticate(String appKey, AuthenticateCallback callback) {
        this.appKey = appKey;
        this.callback = callback;
        this.retryNum = 3;
    }

    public static Authenticate getInstance(String appKey, AuthenticateCallback callback) {
        if (instance == null) {
            instance = new Authenticate(appKey, callback);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        while (!this.stop && this.retryNum > 0) {
            HttpURLConnection connection = null;
            InputStream inputStream = null;
            try {
                int len;
                URL url = new URL(this.getSDKConfigServer());
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
                connection.setRequestProperty("Charset", "UTF-8");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                connection.setConnectTimeout(8000);
                connection.connect();
                String body = "appkey=" + this.appKey + "&sdkVersion=" + "5.6.25" + kRtcDot + 2600 + kRtcDot + "5084820937";
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
                writer.write(body);
                writer.close();
                int code = connection.getResponseCode();
                if (code != 200) continue;
                inputStream = connection.getInputStream();
                byte[] bytes = new byte[1024];
                StringBuilder sb = new StringBuilder();
                while ((len = inputStream.read(bytes)) != -1) {
                    sb.append(new String(bytes, 0, len, StandardCharsets.UTF_8));
                }
                String result = sb.toString();
                if (TextUtils.isEmpty((CharSequence)result)) continue;
                JSONObject jsonObject = null;
                try {
                    jsonObject = new JSONObject(result);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (jsonObject == null || jsonObject.optInt("code") != 200) continue;
                JSONArray array = jsonObject.optJSONArray("data");
                if (array != null) {
                    for (int i = 0; i < array.length(); ++i) {
                        if (1999 != array.getInt(i) || this.callback == null) continue;
                        this.callback.result(false);
                        break;
                    }
                }
                this.stop = true;
            }
            catch (Exception e) {
                Logging.i(TAG, "auth check failed, reason network error.");
            }
            finally {
                try {
                    if (connection != null) {
                        connection.disconnect();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    Thread.sleep(8000L);
                    --this.retryNum;
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getSDKConfigServer() {
        return ContextUtils.getDebug() ? "http://webtest.netease.im/nrtcproxy/nrtc/getSdkConfig.action" : "https://nrtc.netease.im/nrtc/getSdkConfig.action";
    }

    public void release() {
        this.stop = true;
        instance = null;
        this.callback = null;
    }

    public static interface AuthenticateCallback {
        public void result(boolean var1);
    }
}

