/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.foreground;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.RequiresPermission;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.netease.lava.nertc.foreground.ForegroundService;
import com.netease.lava.nertc.impl.NERtcCore;
import com.netease.lava.webrtc.CalledByNative;
import java.util.HashMap;

public class ForegroundKit {
    private static final String TAG = "ForegroundKit";
    public static final String BACKGROUND_WAKEUP_TIME = "background.wakeup.time";
    public static final String INTENT_REMOTE_VIEW = "intent.remote.view";
    public static final String INTENT_PENDINT_INTENT = "intent.pending.intent";
    public static final String INTENT_SMALL_ICON = "intent.samll.icon";
    public static final String INTENT_TITLE = "intent.title";
    public static final String INTENT_CONTENT = "intent.content";
    public static final String INTENT_LARGE_ICON = "intent.large.icon";
    public static final String G2_APP_KEY = "g2.app.key";
    private ForegroundService.ForegroundBinder foregroundService;
    private ForegroundServiceConnection foregroundServiceConnection;
    private static ForegroundKit foregroundKit;
    private Context mContext;
    private boolean openReady = false;
    private Config config;
    public static boolean mCacheReport;

    private ForegroundKit(Context context) {
        this.mContext = context;
    }

    @CalledByNative
    public static synchronized ForegroundKit getInstance(Context context) {
        if (foregroundKit == null) {
            foregroundKit = new ForegroundKit(context);
        }
        return foregroundKit;
    }

    @RequiresPermission(value="android.permission.FOREGROUND_SERVICE")
    @CalledByNative
    public int init(String appKey, long backgroundTime) {
        int err = 0;
        if (this.mContext == null) {
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            return -1;
        }
        mCacheReport = false;
        if (this.openReady) {
            if (this.foregroundService != null && this.foregroundService.serviceStop()) {
                this.foregroundService.start();
                if (this.checkEngineVaild()) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("pkg", this.mContext.getPackageName());
                    NERtcCore.getInstance().getMainChannel().getLiteEngine().reportApiEvent("startForeground", 0, param.toString());
                } else {
                    mCacheReport = true;
                }
                return 0;
            }
            return -2;
        }
        Intent intent = new Intent();
        intent.setClass(this.mContext, ForegroundService.class);
        intent.putExtra(G2_APP_KEY, appKey);
        if (backgroundTime > 0L) {
            intent.putExtra(BACKGROUND_WAKEUP_TIME, backgroundTime);
        }
        if (this.config != null) {
            if (this.config.remoteViews != null) {
                intent.putExtra(INTENT_REMOTE_VIEW, (Parcelable)this.config.remoteViews);
            }
            if (this.config.pendIntent != null) {
                intent.putExtra(INTENT_PENDINT_INTENT, (Parcelable)this.config.pendIntent);
            }
            if (this.config.icon != -1) {
                intent.putExtra(INTENT_SMALL_ICON, this.config.icon);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.title)) {
                intent.putExtra(INTENT_TITLE, this.config.title);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.content)) {
                intent.putExtra(INTENT_CONTENT, this.config.content);
            }
            if (this.config.LargeIcon != -1) {
                intent.putExtra(INTENT_LARGE_ICON, this.config.LargeIcon);
            }
        }
        this.foregroundServiceConnection = new ForegroundServiceConnection();
        this.mContext.bindService(intent, (ServiceConnection)this.foregroundServiceConnection, 1);
        this.openReady = true;
        if (this.checkEngineVaild()) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("pkg", this.mContext.getPackageName());
            NERtcCore.getInstance().getMainChannel().getLiteEngine().reportApiEvent("startForeground", 0, param.toString());
        } else {
            mCacheReport = true;
        }
        return err;
    }

    private boolean checkEngineVaild() {
        if (NERtcCore.getInstance().getMainChannel() == null) {
            return false;
        }
        return NERtcCore.getInstance().getMainChannel().getLiteEngine() != null;
    }

    public int setConfig(@NonNull Config config) {
        if (config.icon == -1) {
            return -1;
        }
        try {
            this.mContext.getResources().getDrawable(config.icon);
            if (config.LargeIcon != -1) {
                this.mContext.getResources().getDrawable(config.LargeIcon);
            }
        }
        catch (Exception e) {
            return -3;
        }
        this.config = config;
        return 0;
    }

    @CalledByNative
    private int setConfigByNative(String title, String content, int icon, int largeIcon) {
        Config config = new Config();
        config.title = title;
        config.content = content;
        config.icon = icon;
        config.LargeIcon = largeIcon;
        return this.setConfig(config);
    }

    @SuppressLint(value={"InvalidWakeLockTag"})
    @RequiresPermission(allOf={"android.permission.WAKE_LOCK", "android.permission.DISABLE_KEYGUARD"})
    @CalledByNative
    public int wakeUpAndUnlock() {
        if (this.mContext == null) {
            return -1;
        }
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        boolean screenOn = pm.isScreenOn();
        if (!screenOn) {
            PowerManager.WakeLock wl = pm.newWakeLock(805306394, "bright");
            wl.acquire(10000L);
            wl.release();
        }
        KeyguardManager keyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        KeyguardManager.KeyguardLock keyguardLock = keyguardManager.newKeyguardLock("unLock");
        keyguardLock.reenableKeyguard();
        keyguardLock.disableKeyguard();
        return 0;
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    @CalledByNative
    public void startVibrate(long[] pattern, int repeat) {
        if (this.mContext == null) {
            return;
        }
        Vibrator vb = (Vibrator)this.mContext.getSystemService("vibrator");
        vb.vibrate(pattern, repeat);
    }

    @CalledByNative
    public void release() {
        try {
            if (this.mContext != null && this.foregroundServiceConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.foregroundServiceConnection);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mContext = null;
        foregroundKit = null;
        this.openReady = false;
        this.foregroundService = null;
        this.foregroundServiceConnection = null;
        mCacheReport = false;
    }

    @CalledByNative
    public boolean checkFloatPermission() {
        if (this.mContext == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return Settings.canDrawOverlays((Context)this.mContext.getApplicationContext());
        }
        return true;
    }

    @CalledByNative
    public boolean requestFloatPermission() {
        if (this.mContext == null) {
            return false;
        }
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
                intent.setData(Uri.parse((String)("package:" + this.mContext.getPackageName())));
                intent.setFlags(0x10000000);
                this.mContext.startActivity(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @CalledByNative
    public boolean checkNotifySetting() {
        if (this.mContext == null) {
            return false;
        }
        NotificationManagerCompat mananger = NotificationManagerCompat.from((Context)this.mContext);
        return mananger.areNotificationsEnabled();
    }

    @CalledByNative
    public boolean requestNotifyPermission() {
        if (this.mContext == null) {
            return false;
        }
        try {
            Intent intent = new Intent();
            if (Build.VERSION.SDK_INT >= 26) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.APP_PACKAGE", this.mContext.getPackageName());
            } else if (Build.VERSION.SDK_INT >= 21) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("app_package", this.mContext.getPackageName());
                intent.putExtra("app_uid", this.mContext.getApplicationInfo().uid);
            } else {
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.setData(Uri.fromParts((String)"package", (String)this.mContext.getPackageName(), null));
            }
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @RequiresApi(api=23)
    public boolean isIgnoringBatteryOptimizations() {
        if (this.mContext == null) {
            return false;
        }
        boolean isIgnoring = false;
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        if (powerManager != null) {
            isIgnoring = powerManager.isIgnoringBatteryOptimizations(this.mContext.getPackageName());
        }
        return isIgnoring;
    }

    public void setWindowFlags(@NonNull Activity activity) {
        activity.getWindow().addFlags(0x600080);
        activity.getWindow().addFlags(524288);
    }

    @RequiresApi(api=23)
    public void requestBatteryOptimization() {
        if (this.mContext == null) {
            return;
        }
        try {
            Intent intent = new Intent();
            intent.setAction("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
            intent.setData(Uri.parse((String)("package:" + this.mContext.getPackageName())));
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showActivity(@NonNull String packageName) {
        if (this.mContext == null) {
            return;
        }
        Intent intent = this.mContext.getPackageManager().getLaunchIntentForPackage(packageName);
        this.mContext.startActivity(intent);
    }

    private void showActivity(@NonNull String packageName, @NonNull String activityDir) {
        if (this.mContext == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityDir));
        intent.addFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    static {
        mCacheReport = false;
    }

    private class ForegroundServiceConnection
    implements ServiceConnection {
        private ForegroundServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                if (service instanceof ForegroundService.ForegroundBinder && service instanceof ForegroundService.ForegroundBinder) {
                    ForegroundKit.this.foregroundService = (ForegroundService.ForegroundBinder)service;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            ForegroundKit.this.foregroundService = null;
        }
    }

    public static class Config {
        public RemoteViews remoteViews;
        public Intent pendIntent;
        public String title;
        public String content;
        public int icon = -1;
        public int LargeIcon = -1;
    }

    public static class ErrorCode {
        public static final int NoFatalError = 0;
        public static final int InvalidOperator = -1;
        public static final int OpenReady = -2;
        public static final int NotFoundResource = -3;
    }
}

