/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.foreground;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.RemoteViews;
import com.netease.lava.nertc.foreground.Authenticate;
import com.netease.lava.webrtc.Logging;
import java.lang.reflect.Method;

public class ForegroundService
extends Service
implements Authenticate.AuthenticateCallback {
    private static final String TAG = "ForegroundService";
    private static final int NOTIFICATION_ID = 65536;
    private Notification foreNotification;
    private PowerManager.WakeLock wakeLock;
    private static final long default_time = 600000L;
    private long backgroundTime;
    private RemoteViews remoteViews;
    private Intent pendIntent;
    private int icon;
    private String title = "ForegroundService";
    private String content = "ForegroundService";
    private int LargeIcon;
    private String G2AppKey;
    private boolean stopService;
    private Authenticate authenticate;

    public IBinder onBind(Intent intent) {
        try {
            this.backgroundTime = intent.getLongExtra("background.wakeup.time", 600000L);
            this.remoteViews = (RemoteViews)intent.getParcelableExtra("intent.remote.view");
            this.pendIntent = (Intent)intent.getParcelableExtra("intent.pending.intent");
            this.icon = intent.getIntExtra("intent.samll.icon", -1);
            this.LargeIcon = intent.getIntExtra("intent.large.icon", -1);
            this.G2AppKey = intent.getStringExtra("g2.app.key");
            if (!TextUtils.isEmpty((CharSequence)intent.getStringExtra("intent.title"))) {
                this.title = intent.getStringExtra("intent.title");
            }
            if (!TextUtils.isEmpty((CharSequence)intent.getStringExtra("intent.content"))) {
                this.content = intent.getStringExtra("intent.content");
            }
            Logging.i(TAG, "onBind, background time : " + this.backgroundTime + ", remoteView : " + this.remoteViews + ", pendIntent : " + this.pendIntent + ", icon : " + this.icon + ", title : " + this.title + ", content : " + this.content + ", LargeIcon : " + this.LargeIcon);
            this.startForegroundService();
            this.authenticate = Authenticate.getInstance(this.G2AppKey, this);
            if (this.authenticate != null) {
                this.authenticate.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ForegroundBinder();
    }

    private void startForegroundService() {
        this.stopService = false;
        this.createNotification();
        this.startForeground();
        this.acquireWakeLock();
    }

    public boolean onUnbind(Intent intent) {
        Logging.i(TAG, "onUnbind");
        try {
            this.backgroundTime = 600000L;
            this.stopForeground(true);
            this.releaseWakeLock();
            this.releaseAuth();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        Logging.i(TAG, "onDestroy");
        this.stopService = true;
        this.releaseAuth();
    }

    private void releaseAuth() {
        try {
            if (this.authenticate != null) {
                this.authenticate.release();
                this.authenticate = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void result(boolean val) {
        if (!val) {
            Logging.i(TAG, "auth check failed, stop foreground service.");
            this.stopForeground(true);
            this.stopSelf();
            this.stopService = true;
        } else {
            Logging.i(TAG, "auth check successful.");
        }
    }

    private void createNotification() {
        if (Build.VERSION.SDK_INT >= 26) {
            int importance = 4;
            NotificationChannel channel = new NotificationChannel(this.title, (CharSequence)this.title, importance);
            channel.setDescription(this.content);
            NotificationManager notificationManager = (NotificationManager)this.getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
        }
        Intent notificationIntent = new Intent(this.getApplicationContext(), this.getApplicationContext().getClass());
        if (this.pendIntent != null) {
            notificationIntent = this.pendIntent;
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)notificationIntent, (int)0);
        Notification.Builder builder = new Notification.Builder(this.getApplicationContext()).setContentTitle((CharSequence)this.title).setContentIntent(pendingIntent).setContentText((CharSequence)this.content);
        if (this.remoteViews != null) {
            builder.setContent(this.remoteViews);
        }
        if (this.icon != -1) {
            builder.setSmallIcon(this.icon);
        }
        if (this.LargeIcon != -1) {
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.LargeIcon));
        }
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId(this.title);
        }
        this.foreNotification = builder.build();
    }

    private void startForeground() {
        Method method = null;
        try {
            method = this.getClass().getMethod("startForeground", Integer.TYPE, Notification.class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            Log.i((String)TAG, (String)"Not found startForeground(I,Notification,I) method.");
        }
        if (Build.VERSION.SDK_INT >= 29 && method != null) {
            try {
                this.startForeground(65536, this.foreNotification, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stopForeground(true);
                this.startForeground(65536, this.foreNotification);
            }
        } else {
            this.startForeground(65536, this.foreNotification);
        }
    }

    @SuppressLint(value={"InvalidWakeLockTag"})
    private void acquireWakeLock() {
        if (null == this.wakeLock) {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            this.wakeLock = pm.newWakeLock(1, TAG);
            if (null != this.wakeLock) {
                this.wakeLock.acquire(this.backgroundTime);
                Logging.i(TAG, "acquire wakeLock successful.");
            }
        }
    }

    private void releaseWakeLock() {
        try {
            if (null != this.wakeLock) {
                if (this.wakeLock.isHeld()) {
                    this.wakeLock.release();
                }
                this.wakeLock = null;
                Logging.i(TAG, "release wake lock successful.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class ForegroundBinder
    extends Binder {
        public ForegroundService getService() {
            return ForegroundService.this;
        }

        public void start() {
            ForegroundService.this.startForegroundService();
        }

        public boolean serviceStop() {
            return ForegroundService.this.stopService;
        }
    }
}

