/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.impl;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.media.projection.MediaProjection;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import com.netease.lava.api.IVideoRender;
import com.netease.lava.nertc.foreground.ForegroundKit;
import com.netease.lava.nertc.impl.EmptyNERtcCallbackEx;
import com.netease.lava.nertc.impl.RtcParameters;
import com.netease.lava.nertc.impl.VideoFrameUtils;
import com.netease.lava.nertc.impl.audio.NERtcAudioFrameObserverWrapper;
import com.netease.lava.nertc.impl.channel.RtcChannelImpl;
import com.netease.lava.nertc.impl.lite.LiteHelper;
import com.netease.lava.nertc.impl.wrapper.NERtcPreDecodeObserverWrapper;
import com.netease.lava.nertc.impl.wrapper.NERtcVideoEncoderQosObserverWrapper;
import com.netease.lava.nertc.sdk.LastmileProbeConfig;
import com.netease.lava.nertc.sdk.NERtc;
import com.netease.lava.nertc.sdk.NERtcCallback;
import com.netease.lava.nertc.sdk.NERtcDataExternalFrame;
import com.netease.lava.nertc.sdk.NERtcEx;
import com.netease.lava.nertc.sdk.NERtcExternalVideoRenderer;
import com.netease.lava.nertc.sdk.NERtcFeatureType;
import com.netease.lava.nertc.sdk.NERtcJoinChannelOptions;
import com.netease.lava.nertc.sdk.NERtcMediaRelayParam;
import com.netease.lava.nertc.sdk.NERtcOption;
import com.netease.lava.nertc.sdk.NERtcParameters;
import com.netease.lava.nertc.sdk.NERtcVersion;
import com.netease.lava.nertc.sdk.NERtcVideoCorrectionConfiguration;
import com.netease.lava.nertc.sdk.audio.NERtcAudioEncodedFrame;
import com.netease.lava.nertc.sdk.audio.NERtcAudioExternalFrame;
import com.netease.lava.nertc.sdk.audio.NERtcAudioFrameObserver;
import com.netease.lava.nertc.sdk.audio.NERtcAudioFrameRequestFormat;
import com.netease.lava.nertc.sdk.audio.NERtcAudioProcessObserver;
import com.netease.lava.nertc.sdk.audio.NERtcAudioRecordingConfiguration;
import com.netease.lava.nertc.sdk.audio.NERtcAudioStreamType;
import com.netease.lava.nertc.sdk.audio.NERtcCreateAudioEffectOption;
import com.netease.lava.nertc.sdk.audio.NERtcCreateAudioMixingOption;
import com.netease.lava.nertc.sdk.audio.NERtcDistanceRolloffModel;
import com.netease.lava.nertc.sdk.audio.NERtcPositionInfo;
import com.netease.lava.nertc.sdk.audio.NERtcRangeAudioMode;
import com.netease.lava.nertc.sdk.audio.NERtcReverbParam;
import com.netease.lava.nertc.sdk.audio.NERtcSpatializerRenderMode;
import com.netease.lava.nertc.sdk.audio.NERtcSpatializerRoomProperty;
import com.netease.lava.nertc.sdk.cdn.NERtcPushStreamingConfig;
import com.netease.lava.nertc.sdk.channel.NERtcChannel;
import com.netease.lava.nertc.sdk.encryption.NERtcEncryptionConfig;
import com.netease.lava.nertc.sdk.live.AddLiveTaskCallback;
import com.netease.lava.nertc.sdk.live.DeleteLiveTaskCallback;
import com.netease.lava.nertc.sdk.live.NERtcLiveStreamTaskInfo;
import com.netease.lava.nertc.sdk.live.UpdateLiveTaskCallback;
import com.netease.lava.nertc.sdk.predecoder.NERtcPreDecodeObserver;
import com.netease.lava.nertc.sdk.stats.NERtcStatsObserver;
import com.netease.lava.nertc.sdk.video.NERtcBeautyEffectType;
import com.netease.lava.nertc.sdk.video.NERtcCameraCaptureConfig;
import com.netease.lava.nertc.sdk.video.NERtcRemoteVideoStreamType;
import com.netease.lava.nertc.sdk.video.NERtcScreenConfig;
import com.netease.lava.nertc.sdk.video.NERtcTakeSnapshotCallback;
import com.netease.lava.nertc.sdk.video.NERtcVideoCallback;
import com.netease.lava.nertc.sdk.video.NERtcVideoConfig;
import com.netease.lava.nertc.sdk.video.NERtcVideoEncodedFrame;
import com.netease.lava.nertc.sdk.video.NERtcVideoEncoderQosObserver;
import com.netease.lava.nertc.sdk.video.NERtcVideoFrame;
import com.netease.lava.nertc.sdk.video.NERtcVideoStreamType;
import com.netease.lava.nertc.sdk.video.NERtcVirtualBackgroundSource;
import com.netease.lava.nertc.sdk.watermark.NERtcVideoWatermarkConfig;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.EglBase10Impl;
import com.netease.lava.webrtc.EglBase14Impl;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.device.AndroidDeviceInfo;
import com.netease.yunxin.lite.LiteEngineCenter;
import com.netease.yunxin.lite.model.LiteSDKBeautyExtraTemplateType;
import com.netease.yunxin.lite.model.LiteSDKConfig;
import com.netease.yunxin.lite.model.LiteSDKReverbParam;
import com.netease.yunxin.lite.util.BeautyFileUtil;
import com.netease.yunxin.lite.util.CommonUtils;
import com.netease.yunxin.lite.util.Compatibility;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.LooperUtils;
import com.netease.yunxin.lite.util.NativeLibLoader;
import com.netease.yunxin.lite.util.OldVersionCompatUtil;
import com.netease.yunxin.lite.util.SystemPermissionUtils;
import com.netease.yunxin.lite.util.ThreadUtils;
import com.netease.yunxin.lite.util.emulator.EmulatorCheckUtil;
import com.netease.yunxin.lite.video.IVideoFrameFilter;
import com.netease.yunxin.lite.video.LiteNativeCapturerObserver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class NERtcCore
extends NERtcEx {
    private static final String TAG = "NERtcImpl";
    private final Object mEngineLock = new Object();
    private RtcChannelImpl mMainChannel;
    private NERtcCallback mCallback;
    private final List<RtcChannelImpl> mChannelList = new ArrayList<RtcChannelImpl>();
    private JSONObject mSettingJson;
    private JSONObject mPrivateSettingJson;
    private String mConfigEngineParam;
    private Handler mEglHandler;
    private EglBase mEglBase;
    private EglBase mEglBaseVideoCallback;
    private LiteSDKConfig sdkConfig;
    private ByteBuffer mCallbackDirectBuffer;
    private int audioProfile = -1;
    private int audioScenario = -1;

    public NERtcCore() {
        NativeLibLoader.loadLibrary("nertc_sdk");
        NativeLibLoader.loadLibrary("NERtcFaceDetect");
        NativeLibLoader.loadLibrary("NERtcBeauty");
        NativeLibLoader.loadLibrary("NERtcPersonSegment");
        NativeLibLoader.loadLibrary("NERtcFaceEnhance");
        NativeLibLoader.loadLibrary("NERtcVideoDenoise");
        NativeLibLoader.loadLibrary("NERtcSuperResolution");
        NativeLibLoader.loadLibrary("NERtcnn");
        NativeLibLoader.loadLibrary("NERtcAiHowling");
        NativeLibLoader.loadLibrary("NERtcAiDenoise");
        NativeLibLoader.loadLibrary("NERtcAudio3D");
    }

    public static NERtcCore getInstance() {
        return SingletonHolder.instance;
    }

    public RtcChannelImpl getMainChannel() {
        return this.mMainChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Context context, String appKey, NERtcCallback callback, NERtcOption option) throws Exception {
        int logLevel = option != null ? option.logLevel : 2;
        long startTime = SystemClock.uptimeMillis();
        EmulatorCheckUtil.getSingleInstance();
        LiteHelper.enableLogToDebugOutput(logLevel);
        OldVersionCompatUtil.init(context);
        this.sdkConfig = new LiteSDKConfig();
        this.sdkConfig.appKey = appKey;
        this.sdkConfig.logLevel = logLevel;
        this.sdkConfig.logDirPath = option != null ? option.logDir : null;
        this.sdkConfig.audioDumpDir = option != null ? option.audioDumpDir : null;
        this.sdkConfig.serverAddresses = LiteHelper.getLiteServerAddress(option != null ? option.serverAddresses : null);
        int n = this.sdkConfig.areaCodeType = option != null ? option.areaCodeType : 0;
        if (option != null && option.eglContext != null) {
            this.sdkConfig.eglContext = option.eglContext;
            if (option.eglContext instanceof EGLContext) {
                this.sdkConfig.eglContext = new EglBase14Impl.Context((EGLContext)option.eglContext);
            } else if (option.eglContext instanceof javax.microedition.khronos.egl.EGLContext) {
                this.sdkConfig.eglContext = new EglBase10Impl.Context((javax.microedition.khronos.egl.EGLContext)option.eglContext);
            } else if (option.eglContext instanceof EglBase) {
                this.sdkConfig.eglContext = ((EglBase)option.eglContext).getEglBaseContext();
            }
        } else {
            this.mEglBase = EglBase.create(EglBase.ConfigType.kConfigType_PLAIN);
            this.sdkConfig.eglContext = this.mEglBase.getEglBaseContext();
        }
        LiteNativeCapturerObserver.setEGLBase((EglBase.Context)this.sdkConfig.eglContext);
        Object object = this.mEngineLock;
        synchronized (object) {
            LiteEngineCenter.initialize(this.sdkConfig);
            if (this.mSettingJson != null) {
                LiteEngineCenter.setParameters(this.mSettingJson.toString());
            }
            if (!TextUtils.isEmpty((CharSequence)this.mConfigEngineParam)) {
                LiteEngineCenter.setPassThroughParameters(this.mConfigEngineParam);
            }
            if (this.mMainChannel != null) {
                this.mCallback = callback;
                this.mMainChannel.setMainChannelNERtcCallback(callback);
                return;
            }
            this.mCallback = callback;
            this.mMainChannel = new RtcChannelImpl("Main", this.mCallback, true, this.mChannelList, this.mEngineLock);
            if (this.audioProfile != -1 && this.audioScenario != -1) {
                this.mMainChannel.getLiteEngine().setAudioProfileAndScenario(this.audioProfile, this.audioScenario);
            }
            if (ForegroundKit.mCacheReport && context != null) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("pkg", context.getPackageName());
                this.mMainChannel.getLiteEngine().reportApiEvent("startForeground", 0, param.toString());
            }
            if (this.mPrivateSettingJson != null && this.mPrivateSettingJson.length() > 0) {
                this.mMainChannel.getLiteEngine().executePrivateApi(this.mPrivateSettingJson.toString());
            }
        }
        EglBase.initCache();
        this.printCommonInfo();
        long endTime = SystemClock.uptimeMillis();
        long timeIntervalMs = endTime - startTime;
        this.mMainChannel.getLiteEngine().setInitializeDone(timeIntervalMs);
        Logging.i(TAG, "init, context:" + context + ", callback:" + callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Logging.i(TAG, "release start");
        EglBase.clearCache();
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.mMainChannel != null) {
                this.mMainChannel.release();
                this.mMainChannel = null;
            }
            ArrayList<RtcChannelImpl> tmpList = new ArrayList<RtcChannelImpl>(this.mChannelList.size());
            tmpList.addAll(this.mChannelList);
            for (RtcChannelImpl channel : tmpList) {
                channel.release();
            }
            this.mChannelList.clear();
            LiteEngineCenter.unInitialize();
        }
        this.mSettingJson = null;
        this.mPrivateSettingJson = null;
        this.mConfigEngineParam = null;
        this.audioProfile = -1;
        this.audioScenario = -1;
        if (this.mEglBase != null) {
            this.mEglBase.release();
            this.mEglBase = null;
        }
        LiteNativeCapturerObserver.setFilter(null);
        LiteNativeCapturerObserver.setEGLBase(null);
        this.releaseEglHandler();
        Logging.i(TAG, "release finish");
    }

    private void releaseEglHandler() {
        if (this.mEglHandler == null) {
            return;
        }
        Logging.i(TAG, "release egl handler start");
        this.mEglHandler.post(() -> {
            if (this.mEglBaseVideoCallback != null) {
                this.mEglBaseVideoCallback.release();
                this.mEglBaseVideoCallback = null;
            }
            Logging.i(TAG, "release egl handler end");
        });
        LooperUtils.quitSafely(this.mEglHandler);
        this.mCallbackDirectBuffer = null;
        this.mEglHandler = null;
    }

    @Override
    public int joinChannel(String token, String channelName, long uid) {
        if (this.checkUninitialized("joinChannel, token:" + token + ", channelName:" + channelName + ", uid:" + uid)) {
            return 30005;
        }
        this.mMainChannel.setChannelName(channelName);
        return this.mMainChannel.joinChannel(token, uid, null);
    }

    @Override
    public int joinChannel(String token, String channelName, long uid, NERtcJoinChannelOptions channelOptions) {
        if (this.checkUninitialized("joinChannel, token:" + token + ", channelName:" + channelName + ", uid:" + uid + ", channelOptions:" + channelOptions)) {
            return 30005;
        }
        this.mMainChannel.setChannelName(channelName);
        return this.mMainChannel.joinChannel(token, uid, channelOptions);
    }

    @Override
    public int updatePermissionKey(String key) {
        if (this.checkUninitialized("updatePermissionKey")) {
            return 30005;
        }
        return this.mMainChannel.updatePermissionKey(key);
    }

    @Override
    public int leaveChannel() {
        if (this.checkUninitialized("leaveChannel")) {
            return 30005;
        }
        return this.mMainChannel.leaveChannel();
    }

    @Override
    public int enableLocalAudio(boolean enable) {
        if (this.checkUninitialized("enableLocalAudio: " + enable)) {
            return 30005;
        }
        return this.mMainChannel.enableLocalAudio(enable);
    }

    @Override
    public int subscribeRemoteAudioStream(long uid, boolean subscribe) {
        if (this.checkUninitialized("subscribeRemoteAudioStream uid: " + uid + " ,subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mMainChannel.subscribeRemoteAudioStream(uid, subscribe);
    }

    @Override
    public int subscribeAllRemoteAudioStreams(boolean subscribe) {
        if (this.checkUninitialized("subscribeAllRemoteAudioStreams subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mMainChannel.subscribeAllRemoteAudioStreams(subscribe);
    }

    @Override
    public int setAudioProfile(int profile, int scenario) {
        this.audioProfile = profile;
        this.audioScenario = scenario;
        if (this.checkUninitialized("setAudioProfile profile: " + profile + " , scenario: " + scenario)) {
            return 0;
        }
        return this.mMainChannel.getLiteEngine().setAudioProfileAndScenario(profile, scenario);
    }

    @Override
    public int setAudioProfile(int profile) {
        this.audioProfile = profile;
        if (this.checkUninitialized("setAudioProfile profile: " + profile)) {
            return 0;
        }
        return this.mMainChannel.getLiteEngine().setAudioProfile(profile);
    }

    @Override
    public int setAudioScenario(int scenario) {
        this.audioScenario = scenario;
        if (this.checkUninitialized("setAudioScenario scenario: " + scenario)) {
            return 0;
        }
        return this.mMainChannel.getLiteEngine().setAudioScenario(scenario);
    }

    @Override
    public int setCameraCaptureConfig(NERtcCameraCaptureConfig captureConfig) {
        return this.setCameraCaptureConfig(captureConfig, null);
    }

    @Override
    public int setCameraCaptureConfig(NERtcCameraCaptureConfig captureConfig, NERtcVideoStreamType streamType) {
        if (this.checkUninitialized("setCameraCaptureConfig captureConfig: " + captureConfig + " ,streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mMainChannel.setCameraCaptureConfig(captureConfig, streamType);
    }

    @Override
    public int setLocalVideoConfig(NERtcVideoConfig videoConfig) {
        return this.setLocalVideoConfig(videoConfig, null);
    }

    @Override
    public int setLocalVideoConfig(NERtcVideoConfig videoConfig, NERtcVideoStreamType streamType) {
        if (this.checkUninitialized("setLocalVideoConfig: " + videoConfig + ", streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mMainChannel.setLocalVideoConfig(videoConfig, streamType);
    }

    @Override
    public int startVideoPreview() {
        return this.startVideoPreview(null);
    }

    @Override
    public int startVideoPreview(NERtcVideoStreamType streamType) {
        if (this.checkUninitialized("startVideoPreview streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().startPreview(LiteHelper.getLiteMediaStreamType(streamType));
    }

    @Override
    public int stopVideoPreview() {
        return this.stopVideoPreview(null);
    }

    @Override
    public int stopVideoPreview(NERtcVideoStreamType streamType) {
        if (this.checkUninitialized("stopVideoPreview streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().stopPreview(LiteHelper.getLiteMediaStreamType(streamType));
    }

    @Override
    public int setupLocalVideoCanvas(IVideoRender render) {
        if (this.checkUninitialized("setupLocalVideoCanvas: " + render)) {
            return 30005;
        }
        return this.mMainChannel.setupLocalVideoCanvas(render);
    }

    @Override
    public int setupRemoteVideoCanvas(IVideoRender render, long uid) {
        if (this.checkUninitialized("setupRemoteVideoCanvas render: " + render + " uid: " + uid)) {
            return 30005;
        }
        return this.mMainChannel.setupRemoteVideoCanvas(render, uid);
    }

    @Override
    public int enableLocalVideo(boolean enable) {
        return this.enableLocalVideo(null, enable);
    }

    @Override
    public int enableLocalVideo(NERtcVideoStreamType streamType, boolean enable) {
        if (this.checkUninitialized("enableLocalVideo: " + enable + ",streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mMainChannel.enableLocalVideo(streamType, enable);
    }

    @Override
    public int subscribeRemoteVideoStream(long uid, NERtcRemoteVideoStreamType streamType, boolean subscribe) {
        if (this.checkUninitialized("subscribeRemoteVideoStream uid: " + uid + " type: " + (Object)((Object)streamType) + " subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mMainChannel.subscribeRemoteVideoStream(uid, streamType, subscribe);
    }

    @Override
    public int muteLocalAudioStream(boolean mute) {
        if (this.checkUninitialized("muteLocalAudioStream:" + mute)) {
            return 30005;
        }
        return this.mMainChannel.muteLocalAudioStream(mute);
    }

    @Override
    public int muteLocalVideoStream(boolean mute) {
        return this.muteLocalVideoStream(null, mute);
    }

    @Override
    public int muteLocalVideoStream(NERtcVideoStreamType streamType, boolean mute) {
        if (this.checkUninitialized("muteLocalVideoStream:" + mute + ", streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mMainChannel.muteLocalVideoStream(mute, streamType);
    }

    @Override
    public int sendSEIMsg(String seiMsg, NERtcVideoStreamType streamType) {
        if (this.checkUninitialized("sendSEIMsg:" + seiMsg + " streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mMainChannel.sendSEIMsg(seiMsg, streamType);
    }

    @Override
    public int sendSEIMsg(String seiMsg) {
        if (this.checkUninitialized("sendSEIMsg:" + seiMsg)) {
            return 30005;
        }
        return this.mMainChannel.sendSEIMsg(seiMsg);
    }

    @Override
    public int switchCamera() {
        if (this.checkUninitialized("switchCamera")) {
            return 30005;
        }
        return this.mMainChannel.switchCamera();
    }

    @Override
    public boolean isCameraZoomSupported() {
        if (this.checkUninitialized("isCameraZoomSupported")) {
            return false;
        }
        return this.mMainChannel.getLiteEngine().isCameraZoomSupported();
    }

    @Override
    public void setCameraZoomFactor(float zoomValue) {
        if (this.checkUninitialized("setCameraZoomFactor: " + zoomValue)) {
            return;
        }
        this.mMainChannel.getLiteEngine().setCameraZoomFactor(zoomValue);
    }

    @Override
    public int getCameraCurrentZoom() {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return (int)this.mMainChannel.getLiteEngine().getCameraCurrentZoom();
    }

    @Override
    public int getCameraMaxZoom() {
        if (this.checkUninitialized("getCameraMaxZoom")) {
            return 30005;
        }
        return (int)this.mMainChannel.getLiteEngine().getCameraMaxZoom();
    }

    @Override
    public boolean isCameraTorchSupported() {
        if (this.checkUninitialized(null)) {
            return false;
        }
        return this.mMainChannel.getLiteEngine().isCameraTorchSupported();
    }

    @Override
    public int setCameraTorchOn(boolean on) {
        if (this.checkUninitialized("setCameraTorchOn: " + on)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setCameraTorchOn(on);
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        if (this.checkUninitialized(null)) {
            return false;
        }
        return this.mMainChannel.getLiteEngine().isCameraExposurePositionSupported();
    }

    @Override
    public int setCameraExposurePosition(float x, float y) {
        if (this.checkUninitialized("setCameraExposurePosition, x:" + x + " ,y:" + y)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setCameraExposurePosition(x, y);
    }

    @Override
    public boolean isCameraFocusSupported() {
        if (this.checkUninitialized(null)) {
            return false;
        }
        return this.mMainChannel.getLiteEngine().isCameraFocusSupported();
    }

    @Override
    public int setCameraFocusPosition(float x, float y) {
        if (this.checkUninitialized("setCameraFocusPosition, x:" + x + " ,y:" + y)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setCameraFocusPosition(x, y);
    }

    @Override
    public boolean isSpeakerphoneOn() {
        if (this.checkUninitialized(null)) {
            return false;
        }
        return this.mMainChannel.getLiteEngine().getLoudspeakerMode();
    }

    @Override
    public int setSpeakerphoneOn(boolean enable) {
        if (this.checkUninitialized("setSpeakerphoneOn: " + enable)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setLoudspeakerMode(enable);
    }

    @Override
    public int setAudioFocusMode(int focusMode) {
        if (this.checkUninitialized("setAudioFocusMode: " + focusMode)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setAudioFocusMode(focusMode);
    }

    @Override
    public int startAudioDump() {
        if (this.checkUninitialized("startAudioDump")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().startAudioDump();
    }

    @Override
    public int startAudioDumpWithType(int dumpType) {
        if (this.checkUninitialized("startAudioDumpWithType: " + dumpType)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().startAudioDumpWithType(dumpType);
    }

    @Override
    public int stopAudioDump() {
        if (this.checkUninitialized("stopAudioDump")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().stopAudioDump();
    }

    @Override
    public int setAudioEffectPreset(int preset) {
        if (this.checkUninitialized("setAudioEffectPreset:" + preset)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setAudioEffectPreset(preset);
    }

    @Override
    public int setVoiceBeautifierPreset(int preset) {
        if (this.checkUninitialized("setVoiceBeautifierPreset:" + preset)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setVoiceBeautifierPreset(preset);
    }

    @Override
    public int setLocalVoicePitch(double pitch) {
        if (this.checkUninitialized("setLocalVoicePitch:" + pitch)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setLocalVoicePitch(pitch);
    }

    @Override
    public int setLocalVoiceEqualization(int bandFrequency, int bandGain) {
        if (this.checkUninitialized("setLocalVoiceEqualization, bandFrequency:" + bandFrequency + ", bandGain:" + bandGain)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setLocalVoiceEqualization(bandFrequency, bandGain);
    }

    @Override
    public int setLocalVoiceReverbParam(NERtcReverbParam param) {
        if (param == null) {
            Logging.e(TAG, "setLocalVoiceReverbParam, param is null");
            return 30003;
        }
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        LiteSDKReverbParam reverbParam = new LiteSDKReverbParam();
        reverbParam.wetGain = param.wetGain;
        reverbParam.dryGain = param.dryGain;
        reverbParam.damping = param.damping;
        reverbParam.roomSize = param.roomSize;
        reverbParam.decayTime = param.decayTime;
        reverbParam.preDelay = param.preDelay;
        return this.mMainChannel.getLiteEngine().setLocalVoiceReverbParam(reverbParam);
    }

    @Override
    public int setupLocalSubStreamVideoCanvas(IVideoRender render) {
        if (this.checkUninitialized("setupLocalSubStreamVideoCanvas: " + render)) {
            return 30005;
        }
        return this.mMainChannel.setupLocalSubStreamVideoCanvas(render);
    }

    @Override
    public int setupRemoteSubStreamVideoCanvas(IVideoRender render, long uid) {
        if (this.checkUninitialized("setupRemoteSubStreamVideoCanvas render: " + render + " uid: " + uid)) {
            return 30005;
        }
        return this.mMainChannel.setupRemoteSubStreamVideoCanvas(render, uid);
    }

    @Override
    public int setLocalExternalVideoRenderer(NERtcVideoStreamType streamType, NERtcExternalVideoRenderer renderer) {
        if (this.checkUninitialized("setLocalExternalVideoRenderer streamType=" + (Object)((Object)streamType) + ", renderer=" + CommonUtils.getHashCode(renderer))) {
            return 30005;
        }
        return this.mMainChannel.setLocalExternalVideoRenderer(streamType, renderer);
    }

    @Override
    public int setRemoteExternalVideoRenderer(NERtcVideoStreamType streamType, long uid, NERtcExternalVideoRenderer renderer) {
        if (this.checkUninitialized("setRemoteExternalVideoRenderer streamType=" + (Object)((Object)streamType) + ", uid=" + uid + ", renderer=" + CommonUtils.getHashCode(renderer))) {
            return 30005;
        }
        return this.mMainChannel.setRemoteExternalVideoRenderer(streamType, uid, renderer);
    }

    @Override
    public int startScreenCapture(NERtcScreenConfig screenConfig, Intent intent, MediaProjection.Callback callback) {
        if (intent == null) {
            Logging.e(TAG, "startScreenCapture error invalid param! intent is null");
            return 30003;
        }
        if (this.checkUninitialized("startScreenCapture screenConfig:" + screenConfig + " , intent: " + intent + " , callback: " + callback)) {
            return 30005;
        }
        return this.mMainChannel.startScreenCapture(screenConfig, intent, callback);
    }

    @Override
    public void stopScreenCapture() {
        if (this.checkUninitialized("stopScreenCapture")) {
            return;
        }
        this.mMainChannel.stopScreenCapture();
    }

    @Override
    public int enableLoopbackRecording(boolean enable, Intent intent, MediaProjection.Callback callback) {
        if (this.checkUninitialized("enableLoopbackRecording, enable: " + enable + " intent: " + intent + " callback: " + callback)) {
            return 30005;
        }
        return this.mMainChannel.enableLoopbackRecording(enable, intent, callback);
    }

    @Override
    public int adjustLoopBackRecordingSignalVolume(int volume) {
        if (this.checkUninitialized("adjustLoopBackRecordingSignalVolume, volume: " + volume)) {
            return 30005;
        }
        return this.mMainChannel.adjustLoopBackRecordingSignalVolume(volume);
    }

    @Override
    public int subscribeRemoteSubStreamVideo(long uid, boolean subscribe) {
        if (this.checkUninitialized("subscribeRemoteSubStreamVideo, uid: " + uid + " subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mMainChannel.subscribeRemoteSubStreamVideo(uid, subscribe);
    }

    @Override
    public int setExternalVideoSource(boolean enable) {
        return this.setExternalVideoSource(null, enable);
    }

    @Override
    public int setExternalVideoSource(NERtcVideoStreamType streamType, boolean enable) {
        if (this.checkUninitialized("setExternalVideoSource enable: " + enable + ", streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mMainChannel.setExternalVideoSource(streamType, enable);
    }

    @Override
    public boolean pushExternalVideoFrame(NERtcVideoFrame frame) {
        return this.pushExternalVideoFrame(null, frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushExternalVideoFrame(NERtcVideoStreamType streamType, NERtcVideoFrame frame) {
        if (frame == null || frame.format == null) {
            Logging.i(TAG, "pushExternalVideoFrame frame or format is null");
            return false;
        }
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.checkUninitialized(null)) {
                return false;
            }
            return this.mMainChannel.pushExternalVideoFrame(streamType, frame);
        }
    }

    @Override
    public int pushExternalAudioEncodedFrame(NERtcAudioEncodedFrame encodedAudioFrame) {
        return this.pushExternalAudioEncodedFrameInternal(0, encodedAudioFrame);
    }

    @Override
    public int pushExternalSubStreamAudioEncodedFrame(NERtcAudioEncodedFrame encodedAudioFrame) {
        return this.pushExternalAudioEncodedFrameInternal(1, encodedAudioFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pushExternalVideoEncodedFrame(NERtcVideoStreamType streamType, NERtcVideoEncodedFrame encodedFrame) {
        if (encodedFrame == null || encodedFrame.codecType == null || encodedFrame.frameType == null) {
            Logging.i(TAG, "pushExternalVideoEncodedFrame frame or codecType or frameType is null");
            return 30003;
        }
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.checkUninitialized(null)) {
                return 30005;
            }
            return this.mMainChannel.getLiteEngine().pushExternalVideoEncodedFrame(LiteHelper.getLiteMediaStreamType(streamType), encodedFrame.codecType == null ? 3 : encodedFrame.codecType.intValue, encodedFrame.frameType == null ? 1 : encodedFrame.frameType.intValue, encodedFrame.nalLengths, encodedFrame.nalData, encodedFrame.timestampUs, encodedFrame.width, encodedFrame.height);
        }
    }

    @Override
    public int setExternalAudioSource(boolean enable, int sampleRate, int channels) {
        if (this.checkUninitialized("setExternalAudioSource, enable:" + enable + ", sampleRate:" + sampleRate + ", channels:" + channels)) {
            return 30005;
        }
        return this.mMainChannel.setExternalAudioSource(enable, sampleRate, channels);
    }

    @Override
    public int setPreDecodeObserver(NERtcPreDecodeObserver observer) {
        if (this.checkUninitialized("setPreDecodeObserver, observer:" + observer)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setPreDecodeObserver(observer == null ? null : new NERtcPreDecodeObserverWrapper(observer));
    }

    @Override
    public int setVideoEncoderQosObserver(NERtcVideoEncoderQosObserver encoderQosObserver) {
        if (this.checkUninitialized("setVideoEncoderQosObserver, observer:" + encoderQosObserver)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setVideoEncoderQosObserver(encoderQosObserver == null ? null : new NERtcVideoEncoderQosObserverWrapper(encoderQosObserver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pushExternalAudioFrame(NERtcAudioExternalFrame frame) {
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.checkUninitialized(null)) {
                return 30005;
            }
            return this.mMainChannel.pushExternalAudioFrame(frame, 0);
        }
    }

    @Override
    public int setExternalAudioRender(boolean enable, int sampleRate, int channels) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        if (sampleRate < 0 || channels < 0) {
            Logging.e(TAG, "setExternalAudioRender invalid param with sampleRate: " + sampleRate + ", channels: " + channels);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setExternalAudioRender(enable, sampleRate, channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pullExternalAudioFrame(ByteBuffer buffer, int len) {
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.checkUninitialized(null)) {
                return 30005;
            }
            if (buffer == null || buffer.capacity() < len) {
                return 30003;
            }
            if (!buffer.isDirect()) {
                return 30003;
            }
            return this.mMainChannel.getLiteEngine().pullExternalAudioFrame(buffer, len);
        }
    }

    @Override
    public void setVideoCallback(final NERtcVideoCallback videoCallback, final boolean textureWithI420) {
        if (this.checkUninitialized("setVideoCallback, videoCallback:" + videoCallback + ", textureWithI420: " + textureWithI420)) {
            return;
        }
        if (videoCallback == null) {
            LiteNativeCapturerObserver.setFilter(null);
        } else {
            LiteNativeCapturerObserver.setFilter(new IVideoFrameFilter(){
                NERtcVideoFrame rtcVideoFrame = null;
                VideoFrame filterdFrame = null;

                @Override
                public VideoFrame onVideoFrameFilter(VideoFrame videoFrame) {
                    Handler eglHandler = NERtcCore.this.mEglHandler;
                    if (eglHandler == null) {
                        HandlerThread thread = new HandlerThread("NERtcGLThread");
                        thread.start();
                        eglHandler = new Handler(thread.getLooper());
                        NERtcCore.this.mEglHandler = eglHandler;
                    }
                    if (this.rtcVideoFrame == null) {
                        this.rtcVideoFrame = new NERtcVideoFrame();
                    }
                    this.rtcVideoFrame.width = videoFrame.getBuffer().getWidth();
                    this.rtcVideoFrame.height = videoFrame.getBuffer().getHeight();
                    this.rtcVideoFrame.rotation = videoFrame.getRotation();
                    this.rtcVideoFrame.timeStamp = videoFrame.getTimestampNs();
                    int dataLength = this.rtcVideoFrame.width * this.rtcVideoFrame.height * 3 / 2;
                    if (this.rtcVideoFrame.data == null || this.rtcVideoFrame.data.length < dataLength) {
                        this.rtcVideoFrame.data = new byte[dataLength];
                        NERtcCore.this.mCallbackDirectBuffer = ByteBuffer.allocateDirect(this.rtcVideoFrame.data.length);
                    }
                    this.rtcVideoFrame = VideoFrameUtils.getNeRTCVideoFrame(videoFrame, textureWithI420, this.rtcVideoFrame, NERtcCore.this.mCallbackDirectBuffer);
                    if (this.rtcVideoFrame == null) {
                        return null;
                    }
                    ThreadUtils.runOnThreadBlocking(eglHandler, () -> {
                        boolean filter;
                        if (NERtcCore.this.mEglBaseVideoCallback == null) {
                            NERtcCore.this.mEglBaseVideoCallback = EglBase.create((EglBase.Context)((NERtcCore)NERtcCore.this).sdkConfig.eglContext, EglBase.ConfigType.kConfigType_PIXEL_BUFFER);
                            NERtcCore.this.mEglBaseVideoCallback.createDummyPbufferSurface();
                            NERtcCore.this.mEglBaseVideoCallback.makeCurrent();
                        }
                        if (!(filter = videoCallback.onVideoCallback(this.rtcVideoFrame))) {
                            this.filterdFrame = null;
                            return;
                        }
                        if (ContextUtils.isUseGlFinish()) {
                            GLES20.glFinish();
                        } else {
                            GLES20.glFlush();
                        }
                        this.filterdFrame = VideoFrameUtils.getWebRtcVideoFrame(this.rtcVideoFrame, videoFrame);
                    });
                    return this.filterdFrame;
                }
            });
        }
        JSONObject param = new JSONObject();
        try {
            param.put("callback", (Object)String.valueOf(videoCallback != null ? Integer.valueOf(videoCallback.hashCode()) : "null"));
            param.put("force_i420", textureWithI420);
            this.mMainChannel.getLiteEngine().reportApiEvent("setVideoCallback", 0, param.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int setAudioFrameObserver(NERtcAudioFrameObserver observer) {
        if (this.checkUninitialized("setAudioFrameObserver, observer:" + observer)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setAudioFrameObserver(observer == null ? null : new NERtcAudioFrameObserverWrapper(observer));
    }

    @Override
    public int setAudioProcessObserver(NERtcAudioProcessObserver audioProcessObserver) {
        if (this.checkUninitialized("setAudioProcessObserver, observer:" + audioProcessObserver)) {
            return 30005;
        }
        return this.mMainChannel.setAudioProcessObserver(audioProcessObserver);
    }

    @Override
    public int setRecordingAudioFrameParameters(NERtcAudioFrameRequestFormat format) {
        if (this.checkUninitialized("setRecordingAudioFrameParameters, format:" + format)) {
            return 30005;
        }
        if (format == null) {
            Logging.e(TAG, "setRecordingAudioFrameParameters, invalid params");
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setRecordingAudioFrameParameters(LiteHelper.getLiteAudioFrameRequestFormat(format));
    }

    @Override
    public int setPlaybackAudioFrameParameters(NERtcAudioFrameRequestFormat format) {
        if (this.checkUninitialized("setRecordingAudioFrameParameters, format:" + format)) {
            return 30005;
        }
        if (format == null) {
            Logging.e(TAG, "setPlaybackAudioFrameParameters, invalid params");
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setPlaybackAudioFrameParameters(LiteHelper.getLiteAudioFrameRequestFormat(format));
    }

    @Override
    public int setMixedAudioFrameParameters(NERtcAudioFrameRequestFormat format) {
        if (this.checkUninitialized("setRecordingAudioFrameParameters, format:" + format)) {
            return 30005;
        }
        if (format == null) {
            Logging.e(TAG, "setMixedAudioFrameParameters, invalid params");
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setMixedAudioFrameParameters(LiteHelper.getLiteAudioFrameRequestFormat(format));
    }

    @Override
    public void postOnGLThread(Runnable runnable) {
        Handler eglHandler = this.mEglHandler;
        if (eglHandler == null || !eglHandler.post(runnable)) {
            Logging.e(TAG, "postOnGLThread failed:" + runnable + ", handler: " + eglHandler);
        }
    }

    @Override
    public void setStatsObserver(NERtcStatsObserver statsObserver) {
        if (this.checkUninitialized("setStatsObserver, observer:" + statsObserver)) {
            return;
        }
        this.mMainChannel.setStatsObserver(statsObserver);
    }

    @Override
    public int enableAudioVolumeIndication(boolean enable, int interval) {
        if (this.checkUninitialized("enableAudioVolumeIndication, enable:" + enable + ", interval:" + interval)) {
            return 30005;
        }
        return this.mMainChannel.enableAudioVolumeIndication(enable, interval, false);
    }

    @Override
    public int enableAudioVolumeIndication(boolean enable, int interval, boolean enableVad) {
        if (this.checkUninitialized("enableAudioVolumeIndication, enable:" + enable + ", interval:" + interval + ", enableVad: " + enableVad)) {
            return 30005;
        }
        return this.mMainChannel.enableAudioVolumeIndication(enable, interval, enableVad);
    }

    @Override
    public int adjustRecordingSignalVolume(int volume) {
        if (this.checkUninitialized("adjustRecordingSignalVolume, volume:" + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(TAG, "adjustRecordingSignalVolume invalid param with volume: " + volume);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().adjustRecordingSignalVolume(volume);
    }

    @Override
    public int adjustPlaybackSignalVolume(int volume) {
        if (this.checkUninitialized("adjustPlaybackSignalVolume, volume:" + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(TAG, "adjustPlaybackSignalVolume invalid param with volume: " + volume);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().adjustPlaybackSignalVolume(volume);
    }

    @Override
    public int startAudioMixing(NERtcCreateAudioMixingOption option) {
        if (this.checkUninitialized("startAudioMixing, path:" + option.path)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().startAudioMixing(LiteHelper.getLiteAudioMixingOption(option));
    }

    @Override
    public int stopAudioMixing() {
        if (this.checkUninitialized("stopAudioMixing")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().stopAudioMixing();
    }

    @Override
    public int pauseAudioMixing() {
        if (this.checkUninitialized("pauseAudioMixing")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().pauseAudioMixing();
    }

    @Override
    public int resumeAudioMixing() {
        if (this.checkUninitialized("resumeAudioMixing")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().resumeAudioMixing();
    }

    @Override
    public int setAudioMixingSendVolume(int volume) {
        if (this.checkUninitialized("setAudioMixingSendVolume")) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(TAG, "setAudioMixingSendVolume invalid param with volume: " + volume);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setAudioMixingSendVolume(volume);
    }

    @Override
    public int getAudioMixingSendVolume() {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().getAudioMixingSendVolume();
    }

    @Override
    public int setAudioMixingPlaybackVolume(int volume) {
        if (this.checkUninitialized("setAudioMixingPlaybackVolume:" + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(TAG, "adjustLoopBackRecordingSignalVolume invalid param with volume: " + volume);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setAudioMixingPlaybackVolume(volume);
    }

    @Override
    public int getAudioMixingPlaybackVolume() {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().getAudioMixingPlaybackVolume();
    }

    @Override
    public long getAudioMixingDuration() {
        if (this.checkUninitialized(null)) {
            return 30005L;
        }
        return this.mMainChannel.getLiteEngine().getAudioMixingDuration();
    }

    @Override
    public long getAudioMixingCurrentPosition() {
        if (this.checkUninitialized(null)) {
            return 30005L;
        }
        return this.mMainChannel.getLiteEngine().getAudioMixingCurrentPosition();
    }

    @Override
    public int setAudioMixingPosition(long position) {
        if (this.checkUninitialized("setAudioMixingPosition:" + position)) {
            return 30005;
        }
        if (position < 0L) {
            Logging.e(TAG, "setAudioMixingPosition invalid param with position: " + position);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setAudioMixingPosition(position);
    }

    @Override
    public int playEffect(int effectId, NERtcCreateAudioEffectOption option) {
        if (this.checkUninitialized("playEffect:" + effectId + ", path:" + option.path)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().playEffect(effectId, LiteHelper.getLiteAudioEffectOption(option));
    }

    @Override
    public int stopEffect(int effectId) {
        if (this.checkUninitialized("stopEffect:" + effectId)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().stopEffect(effectId);
    }

    @Override
    public int stopAllEffects() {
        if (this.checkUninitialized("stopAllEffects")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().stopAllEffects();
    }

    @Override
    public int pauseEffect(int effectId) {
        if (this.checkUninitialized("pauseEffect:" + effectId)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().pauseEffect(effectId);
    }

    @Override
    public int resumeEffect(int effectId) {
        if (this.checkUninitialized("resumeEffect:" + effectId)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().resumeEffect(effectId);
    }

    @Override
    public int pauseAllEffects() {
        if (this.checkUninitialized("pauseAllEffects")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().pauseAllEffects();
    }

    @Override
    public int resumeAllEffects() {
        if (this.checkUninitialized("resumeAllEffects")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().resumeAllEffects();
    }

    @Override
    public int setEffectSendVolume(int effectId, int volume) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(TAG, "setEffectSendVolume invalid param with effectId: " + effectId + "volume: " + volume);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setEffectSendVolume(effectId, volume);
    }

    @Override
    public int getEffectSendVolume(int effectId) {
        if (this.checkUninitialized("getEffectSendVolume, effectId:" + effectId)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().getEffectSendVolume(effectId);
    }

    @Override
    public int setEffectPlaybackVolume(int effectId, int volume) {
        if (this.checkUninitialized("setEffectPlaybackVolume, effectId:" + effectId + ", volume:" + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(TAG, "setEffectPlaybackVolume invalid param with effectId: " + effectId + "volume: " + volume);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setEffectPlaybackVolume(effectId, volume);
    }

    @Override
    public int setEffectPosition(int effectId, long position) {
        if (this.checkUninitialized("setEffectPosition, effectId:" + effectId + ", position:" + position)) {
            return 30005;
        }
        if (position < 0L) {
            Logging.e(TAG, "setEffectPosition invalid param with position: " + position);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setEffectPosition(effectId, position);
    }

    @Override
    public int setEffectPitch(int effectId, int pitch) {
        if (this.checkUninitialized("setEffectPitch, effectId:" + effectId + ", pitch:" + pitch)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setEffectPitch(effectId, pitch);
    }

    @Override
    public int getEffectPitch(int effectId) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().getEffectPitch(effectId);
    }

    @Override
    public int setNERtcCallback(NERtcCallback callback) {
        int ret = 0;
        if (this.checkUninitialized("setNERtcCallback, callback:" + callback)) {
            ret = 30005;
        } else {
            NERtcCallback finalCallback;
            this.mCallback = finalCallback = callback == null ? new EmptyNERtcCallbackEx() : callback;
            this.mMainChannel.setMainChannelNERtcCallback(finalCallback);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("callback", NERtcCore.hashCodeStr(callback));
        this.mMainChannel.getLiteEngine().reportApiEvent("setNERtcCallback", ret, param.toString());
        return ret;
    }

    @Override
    public void setCallbackHandler(Handler callbackHandler) {
        int ret = 0;
        if (this.checkUninitialized("setListenerHandler, listenerHandler:" + callbackHandler)) {
            ret = 30005;
        } else {
            this.mMainChannel.setChannelCallbackHandler(callbackHandler);
        }
        HashMap<String, Handler> param = new HashMap<String, Handler>();
        param.put("callbackHandler", callbackHandler);
        this.mMainChannel.getLiteEngine().reportApiEvent("setCallbackHandler", ret, param.toString());
    }

    @Override
    public int setAudioRecvRange(int audibleDistance, int conversationalDistance, NERtcDistanceRolloffModel rollOff) {
        if (this.checkUninitialized("setAudioRecvRange audibleDistance:" + audibleDistance + " \uff0cconversationalDistance: " + conversationalDistance + ", rollOff: " + (Object)((Object)rollOff))) {
            return 30005;
        }
        return this.mMainChannel.setAudioRecvRange(audibleDistance, conversationalDistance, rollOff);
    }

    @Override
    public int updateSelfPosition(NERtcPositionInfo info) {
        if (this.checkUninitialized("updateSelfPosition info:" + info)) {
            return 30005;
        }
        return this.mMainChannel.updateSelfPosition(info);
    }

    @Override
    public int enableSpatializerRoomEffects(boolean enable) {
        if (this.checkUninitialized("EnableSpatializerRoomEffects enable:" + enable)) {
            return 30005;
        }
        return this.mMainChannel.enableSpatializerRoomEffects(enable);
    }

    @Override
    public int setSpatializerRoomProperty(NERtcSpatializerRoomProperty property) {
        if (this.checkUninitialized("NERtcSpatializerRoomProperty property:" + property)) {
            return 30005;
        }
        return this.mMainChannel.setSpatializerRoomProperty(property);
    }

    @Override
    public int setSpatializerRenderMode(NERtcSpatializerRenderMode mode) {
        if (this.checkUninitialized("SetSpatializerRenderMode mode:" + (Object)((Object)mode))) {
            return 30005;
        }
        return this.mMainChannel.setSpatializerRenderMode(mode);
    }

    @Override
    public int enableSpatializer(boolean enable, boolean applyToTeam) {
        if (this.checkUninitialized("EnableSpatializer enable:" + enable + ", applyToTeam: " + applyToTeam)) {
            return 30005;
        }
        return this.mMainChannel.enableSpatializer(enable, applyToTeam);
    }

    @Override
    public int initSpatializer() {
        if (this.checkUninitialized("initSpatializer")) {
            return 30005;
        }
        return this.mMainChannel.initSpatializer();
    }

    @Override
    public int setRangeAudioMode(NERtcRangeAudioMode mode) {
        if (this.checkUninitialized("setRangeAudioMode mode:" + (Object)((Object)mode))) {
            return 30005;
        }
        return this.mMainChannel.setRangeAudioMode(mode);
    }

    @Override
    public int setRangeAudioTeamID(int teamId) {
        if (this.checkUninitialized("setRangeAudioTeamID teamId:" + teamId)) {
            return 30005;
        }
        return this.mMainChannel.setRangeAudioTeamID(teamId);
    }

    @Override
    public int setSubscribeAudioBlocklist(long[] uidArray, NERtcAudioStreamType streamType) {
        if (this.checkUninitialized("setSubscribeAudioBlocklist")) {
            return 30005;
        }
        return this.mMainChannel.setSubscribeAudioBlocklist(uidArray, streamType);
    }

    @Override
    public int setSubscribeAudioAllowlist(long[] uidArray) {
        if (this.checkUninitialized("setSubscribeAudioAllowlist")) {
            return 30005;
        }
        return this.mMainChannel.setSubscribeAudioAllowlist(uidArray);
    }

    @Override
    public int startPushStreaming(NERtcPushStreamingConfig config) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        if (config == null) {
            Logging.e(TAG, "startPushStreaming invalid param with config is null");
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().startPushStreaming(config.streamingUrl, LiteHelper.getLiteJoinParameter(config.streamingRoomInfo.token, config.streamingRoomInfo.channelName, config.streamingRoomInfo.uid, null));
    }

    @Override
    public int stopPushStreaming() {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().stopPushStreaming();
    }

    @Override
    public int getEffectPlaybackVolume(int effectId) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().getEffectPlaybackVolume(effectId);
    }

    @Override
    public long getEffectCurrentPosition(int effectId) {
        if (this.checkUninitialized(null)) {
            return 30005L;
        }
        return this.mMainChannel.getLiteEngine().getEffectCurrentPosition(effectId);
    }

    @Override
    public long getEffectDuration(int effectId) {
        if (this.checkUninitialized(null)) {
            return 30005L;
        }
        return this.mMainChannel.getLiteEngine().getEffectDuration(effectId);
    }

    @Override
    public int enableEarback(boolean enabled, int volume) {
        if (this.checkUninitialized("enableEarback, enabled:" + enabled + ", volume:" + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(TAG, "enableEarback invalid param with volume: " + volume);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().enableEarback(enabled, volume);
    }

    @Override
    public int setEarbackVolume(int volume) {
        if (this.checkUninitialized("setEarbackVolume, volume:" + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(TAG, "setEarbackVolume invalid param with volume: " + volume);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().setEarbackVolume(volume);
    }

    @Override
    public int setPlayoutDeviceMute(boolean mute) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setPlayoutDeviceMute(mute);
    }

    @Override
    public boolean isPlayoutDeviceMute() {
        if (this.checkUninitialized(null)) {
            return false;
        }
        return this.mMainChannel.getLiteEngine().isPlayoutDeviceMute();
    }

    @Override
    public int setRecordDeviceMute(boolean mute) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setRecordDeviceMute(mute);
    }

    @Override
    public boolean isRecordDeviceMute() {
        if (this.checkUninitialized(null)) {
            return false;
        }
        return this.mMainChannel.getLiteEngine().isRecordDeviceMute();
    }

    @Override
    public void uploadSdkInfo() {
        if (this.checkUninitialized("uploadSdkInfo")) {
            return;
        }
        this.mMainChannel.getLiteEngine().uploadSdkInfo();
    }

    @Override
    public int addLiveStreamTask(NERtcLiveStreamTaskInfo taskInfo, AddLiveTaskCallback addLiveTaskCallback) {
        if (this.checkUninitialized("addLiveStreamTask taskInfo:" + taskInfo + " \uff0ccallback: " + addLiveTaskCallback)) {
            return 30005;
        }
        return this.mMainChannel.addLiveStreamTask(taskInfo, addLiveTaskCallback);
    }

    @Override
    public int updateLiveStreamTask(NERtcLiveStreamTaskInfo taskInfo, UpdateLiveTaskCallback updateLiveTaskCallback) {
        if (this.checkUninitialized("updateLiveStreamTask taskInfo:" + taskInfo + " \uff0ccallback: " + updateLiveTaskCallback)) {
            return 30005;
        }
        return this.mMainChannel.updateLiveStreamTask(taskInfo, updateLiveTaskCallback);
    }

    @Override
    public int removeLiveStreamTask(String taskId, DeleteLiveTaskCallback deleteLiveTaskCallback) {
        if (this.checkUninitialized("removeLiveStreamTask taskId:" + taskId + " \uff0ccallback: " + deleteLiveTaskCallback)) {
            return 30005;
        }
        return this.mMainChannel.removeLiveStreamTask(taskId, deleteLiveTaskCallback);
    }

    @Override
    public int setChannelProfile(int channelProfile) {
        if (this.checkUninitialized("setChannelProfile: " + channelProfile)) {
            return 30005;
        }
        return this.mMainChannel.setChannelProfile(channelProfile);
    }

    @Override
    public int enableDualStreamMode(boolean enable) {
        if (this.checkUninitialized("enableDualStreamMode: " + enable)) {
            return 30005;
        }
        return this.mMainChannel.enableDualStreamMode(enable);
    }

    @Override
    public int getConnectionState() {
        if (this.checkUninitialized(null)) {
            return 0;
        }
        return this.mMainChannel.getConnectionState();
    }

    @Override
    public int setClientRole(int role) {
        if (this.checkUninitialized("setClientRole: " + role)) {
            return 30005;
        }
        return this.mMainChannel.setClientRole(role);
    }

    @Override
    public int takeLocalSnapshot(NERtcVideoStreamType streamType, NERtcTakeSnapshotCallback callback) {
        if (this.checkUninitialized("takeLocalSnapshot streamType: " + (Object)((Object)streamType) + " ,callback: " + callback)) {
            return 30005;
        }
        return this.mMainChannel.takeLocalSnapshot(streamType, callback);
    }

    @Override
    public int takeRemoteSnapshot(long uid, NERtcVideoStreamType streamType, NERtcTakeSnapshotCallback callback) {
        if (this.checkUninitialized("takeRemoteSnapshot uid: " + uid + " ,streamType: " + (Object)((Object)streamType) + " ,callback: " + callback)) {
            return 30005;
        }
        return this.mMainChannel.takeRemoteSnapshot(uid, streamType, callback);
    }

    @Override
    public int switchChannel(String token, String channelName) {
        if (this.checkUninitialized("switchChannel token: " + token + " ,channelName: " + channelName)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().switchChannel(LiteHelper.getLiteSwitchParameter(token, channelName, null));
    }

    @Override
    public int switchChannel(String token, String channelName, NERtcJoinChannelOptions channelOptions) {
        if (this.checkUninitialized("switchChannel token: " + token + " ,channelName: " + channelName + ", channelOptions:" + channelOptions)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().switchChannel(LiteHelper.getLiteSwitchParameter(token, channelName, channelOptions));
    }

    @Override
    public int startAudioRecording(String filePath, int sampleRate, int quality) {
        if (this.checkUninitialized("startAudioRecording filePath: " + filePath + " ,sampleRate: " + sampleRate + " ,quality: " + quality)) {
            return 30005;
        }
        if (sampleRate < 0) {
            Logging.e(TAG, "startAudioRecording invalid param with sampleRate:" + sampleRate + ", quality:" + quality);
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().startAudioRecording(filePath, sampleRate, quality);
    }

    @Override
    public int startAudioRecordingWithConfig(NERtcAudioRecordingConfiguration audioRecordConfig) {
        if (audioRecordConfig == null) {
            Logging.e(TAG, "startAudioRecordingWithConfig invalid param");
            return 30003;
        }
        return this.mMainChannel.getLiteEngine().startAudioRecordingWithConfig(audioRecordConfig.recordFilePath, audioRecordConfig.recordSampleRate, audioRecordConfig.recordQuality, audioRecordConfig.recordPosition == null ? 0 : audioRecordConfig.recordPosition.ordinal(), audioRecordConfig.recordCycleTime == null ? 0 : audioRecordConfig.recordCycleTime.getValue());
    }

    @Override
    public int stopAudioRecording() {
        if (this.checkUninitialized("stopAudioRecording")) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().stopAudioRecording();
    }

    @Override
    public int getAudioMixingPitch() {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().getAudioMixingPitch();
    }

    @Override
    public int setAudioMixingPitch(int pitch) {
        if (this.checkUninitialized("setAudioMixingPitch , pitch: " + pitch)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setAudioMixingPitch(pitch);
    }

    @Override
    public int setLocalMediaPriority(int priority, boolean isPreemptive) {
        if (this.checkUninitialized("setLocalMediaPriority priority: " + priority + " ,isPreemptive: " + isPreemptive)) {
            return 30005;
        }
        return this.mMainChannel.setLocalMediaPriority(priority, isPreemptive);
    }

    @Override
    public int startChannelMediaRelay(NERtcMediaRelayParam.ChannelMediaRelayConfiguration config) {
        if (this.checkUninitialized("startChannelMediaRelay config: " + config)) {
            return 30005;
        }
        return this.mMainChannel.startChannelMediaRelay(config);
    }

    @Override
    public int updateChannelMediaRelay(NERtcMediaRelayParam.ChannelMediaRelayConfiguration config) {
        if (this.checkUninitialized("updateChannelMediaRelay config: " + config)) {
            return 30005;
        }
        return this.mMainChannel.updateChannelMediaRelay(config);
    }

    @Override
    public int stopChannelMediaRelay() {
        if (this.checkUninitialized("stopChannelMediaRelay")) {
            return 30005;
        }
        return this.mMainChannel.stopChannelMediaRelay();
    }

    @Override
    public int adjustUserPlaybackSignalVolume(long uid, int volume) {
        if (this.checkUninitialized("adjustUserPlaybackSignalVolume uid: " + uid + " ,volume: " + volume)) {
            return 30005;
        }
        return this.mMainChannel.adjustUserPlaybackSignalVolume(uid, volume);
    }

    @Override
    public int adjustChannelPlaybackSignalVolume(int volume) {
        if (this.checkUninitialized("adjustChannelPlaybackSignalVolume volume: " + volume)) {
            return 30005;
        }
        return this.mMainChannel.adjustChannelPlaybackSignalVolume(volume);
    }

    @Override
    public int setLocalPublishFallbackOption(int option) {
        if (this.checkUninitialized("setLocalPublishFallbackOption option: " + option)) {
            return 30005;
        }
        return this.mMainChannel.setLocalPublishFallbackOption(option);
    }

    @Override
    public int setRemoteSubscribeFallbackOption(int option) {
        if (this.checkUninitialized("setRemoteSubscribeFallbackOption option: " + option)) {
            return 30005;
        }
        return this.mMainChannel.setRemoteSubscribeFallbackOption(option);
    }

    @Override
    public int enableSuperResolution(boolean enable) {
        if (this.checkUninitialized("enableSuperResolution: " + enable)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().enableSuperResolution(enable);
    }

    @Override
    public int enableEncryption(boolean enable, NERtcEncryptionConfig config) {
        if (this.checkUninitialized("enableEncryption: " + enable)) {
            return 30005;
        }
        return this.mMainChannel.enableEncryption(enable, config);
    }

    @Override
    public NERtcChannel createChannel(String channelName) {
        Logging.i(TAG, "createChannel: " + channelName);
        return new RtcChannelImpl(channelName, this.mCallback, false, this.mChannelList, this.mEngineLock);
    }

    @Override
    public int startLastmileProbeTest(LastmileProbeConfig config) {
        if (this.checkUninitialized("startLastmileProbeTest: " + config)) {
            return 30005;
        }
        return this.mMainChannel.startLastmileProbeTest(config);
    }

    @Override
    public int stopLastmileProbeTest() {
        if (this.checkUninitialized("stopLastmileProbeTest")) {
            return 30005;
        }
        return this.mMainChannel.stopLastmileProbeTest();
    }

    @Override
    public int enableVideoCorrection(boolean enable) {
        if (this.checkUninitialized("enableVideoCorrection: " + enable)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().enableLocalVideoCorrection(enable);
    }

    @Override
    public int setVideoCorrectionConfig(NERtcVideoCorrectionConfiguration config) {
        if (this.checkUninitialized("setVideoCorrectionConfig: " + config)) {
            return 30005;
        }
        if (config == null) {
            return this.mMainChannel.getLiteEngine().setLocalVideoCorrectionConfig(true, LiteHelper.getLiteVideoCorrection(null));
        }
        return this.mMainChannel.getLiteEngine().setLocalVideoCorrectionConfig(false, LiteHelper.getLiteVideoCorrection(config));
    }

    @Override
    public int enableVirtualBackground(boolean enabled, NERtcVirtualBackgroundSource backgroundSource) {
        boolean isInvalidParam;
        if (this.checkUninitialized("enableVirtualBackground " + enabled + ", " + backgroundSource)) {
            return 30005;
        }
        boolean bl = isInvalidParam = enabled && backgroundSource == null;
        if (isInvalidParam) {
            Logging.e(TAG, "enableVirtualBackground invalid parameters");
            int ret = 30003;
            this.mMainChannel.getLiteEngine().reportApiEvent("enableVirtualBackground", ret, null);
            return ret;
        }
        return this.mMainChannel.getLiteEngine().enableVirtualBackground(enabled, LiteHelper.getLiteVirtualBackgroundSource(backgroundSource));
    }

    @Override
    public int setRemoteHighPriorityAudioStream(boolean enabled, long uid) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.setRemoteHighPriorityAudioStream(enabled, uid);
    }

    @Override
    public int setCloudProxy(int proxyType) {
        if (this.checkUninitialized("setCloudProxy: " + proxyType)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setCloudProxy(proxyType);
    }

    @Override
    public int startBeauty() {
        String beautyRootDir;
        int ret;
        block11: {
            boolean needUpdate;
            ret = 0;
            if (this.checkUninitialized("startBeauty")) {
                return 30005;
            }
            beautyRootDir = BeautyFileUtil.getFilePath(ContextUtils.getContext(), "");
            BeautyFileUtil.copyModelFiles(ContextUtils.getContext());
            String assetsVersionPath = BeautyFileUtil.getFilePath(ContextUtils.getContext(), "assetsVersion");
            File assetsVersionFile = new File(assetsVersionPath);
            try {
                if (assetsVersionFile.exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(assetsVersionFile));
                    String localVersion = reader.readLine();
                    reader.close();
                    localVersion = localVersion.trim();
                    needUpdate = !localVersion.equalsIgnoreCase("5.6.25");
                } else {
                    needUpdate = true;
                    BufferedWriter writer = new BufferedWriter(new FileWriter(assetsVersionFile));
                    writer.write("5.6.25");
                    writer.close();
                }
            }
            catch (IOException e) {
                Logging.w(TAG, "startBeauty " + e.toString());
                ret = 30006;
                break block11;
            }
            BeautyFileUtil.copyAllFiles(ContextUtils.getContext(), "beauty", needUpdate);
            File modelFile = new File(beautyRootDir, "model.dat");
            File beautyTemplateDir = new File(beautyRootDir, "beauty");
            if (!modelFile.exists()) {
                Logging.w(TAG, "startBeauty model.dat not prepared");
                ret = 30005;
            } else if (!beautyTemplateDir.exists()) {
                Logging.w(TAG, "startBeauty beauty template not prepared");
                ret = 30005;
            }
        }
        if (ret != 0) {
            this.mMainChannel.getLiteEngine().reportApiEvent("startBeauty", ret, null);
        } else {
            ret = this.mMainChannel.getLiteEngine().initBeauty(beautyRootDir);
            if (ret != 0) {
                Logging.w(TAG, "startBeauty initBeauty failed, return " + ret);
            }
        }
        return ret;
    }

    @Override
    public void stopBeauty() {
        if (this.checkUninitialized("stopBeauty")) {
            return;
        }
        this.mMainChannel.getLiteEngine().destroyBeauty();
    }

    @Override
    public int enableBeauty(boolean enable) {
        int ret = 30005;
        if (this.checkUninitialized("enableBeauty")) {
            return ret;
        }
        return this.mMainChannel.getLiteEngine().enableBeauty(enable);
    }

    @Override
    public int setBeautyEffect(NERtcBeautyEffectType beautyType, float level) {
        int ret = 30005;
        if (this.checkUninitialized("setBeautyEffect level: " + level)) {
            return ret;
        }
        return this.mMainChannel.getLiteEngine().setBeautyEffect(beautyType.getValue(), level);
    }

    @Override
    public int addBeautyFilter(String path) {
        int ret = 30005;
        if (this.checkUninitialized("addBeautyFilter path: " + path)) {
            return ret;
        }
        File templateFile = new File(TextUtils.isEmpty((CharSequence)path) ? "" : path, "template.json");
        if (!templateFile.exists()) {
            ret = 30003;
            this.mMainChannel.getLiteEngine().reportApiEvent("addBeautyFilter", ret, null);
            Logging.w(TAG, "addBeautyFilter failed, " + templateFile.getAbsolutePath() + " not exist");
            return ret;
        }
        return this.mMainChannel.getLiteEngine().addExtraTemplate(LiteSDKBeautyExtraTemplateType.kRTCBeautyExtraTemplateTypeFilter.getValue(), templateFile.getAbsolutePath());
    }

    @Override
    public void removeBeautyFilter() {
        if (this.checkUninitialized("removeBeautyFilter")) {
            return;
        }
        this.mMainChannel.getLiteEngine().removeExtraTemplate(LiteSDKBeautyExtraTemplateType.kRTCBeautyExtraTemplateTypeFilter.getValue());
    }

    @Override
    public int setBeautyFilterLevel(float level) {
        int ret = 30005;
        if (this.checkUninitialized("setBeautyFilterLevel level: " + level)) {
            return ret;
        }
        return this.mMainChannel.getLiteEngine().setBeautyEffect(-1, level);
    }

    @Override
    public int addBeautySticker(String path) {
        int ret = 30005;
        if (this.checkUninitialized("addBeautySticker path: " + path)) {
            return ret;
        }
        File templateFile = new File(TextUtils.isEmpty((CharSequence)path) ? "" : path, "template.json");
        if (!templateFile.exists()) {
            ret = 30003;
            this.mMainChannel.getLiteEngine().reportApiEvent("addBeautySticker", ret, null);
            Logging.w(TAG, "addBeautySticker failed, " + templateFile.getAbsolutePath() + " not exist");
            return ret;
        }
        return this.mMainChannel.getLiteEngine().addExtraTemplate(LiteSDKBeautyExtraTemplateType.kRTCBeautyExtraTemplateTypeSticker.getValue(), templateFile.getAbsolutePath());
    }

    @Override
    public void removeBeautySticker() {
        if (this.checkUninitialized("removeBeautySticker")) {
            return;
        }
        this.mMainChannel.getLiteEngine().removeExtraTemplate(LiteSDKBeautyExtraTemplateType.kRTCBeautyExtraTemplateTypeSticker.getValue());
    }

    @Override
    public int addBeautyMakeup(String path) {
        int ret = 30005;
        if (this.checkUninitialized("addBeautyMakeup path: " + path)) {
            return ret;
        }
        File templateFile = new File(TextUtils.isEmpty((CharSequence)path) ? "" : path, "template.json");
        if (!templateFile.exists()) {
            ret = 30003;
            this.mMainChannel.getLiteEngine().reportApiEvent("addBeautyMakeup", ret, null);
            Logging.w(TAG, "addBeautyMakeup failed, " + templateFile.getAbsolutePath() + " not exist");
            return ret;
        }
        return this.mMainChannel.getLiteEngine().addExtraTemplate(LiteSDKBeautyExtraTemplateType.kRTCBeautyExtraTemplateTypeMakeup.getValue(), templateFile.getAbsolutePath());
    }

    @Override
    public void removeBeautyMakeup() {
        if (this.checkUninitialized("removeBeautyMakeup")) {
            return;
        }
        this.mMainChannel.getLiteEngine().removeExtraTemplate(LiteSDKBeautyExtraTemplateType.kRTCBeautyExtraTemplateTypeMakeup.getValue());
    }

    @Override
    public int setLocalVideoWatermarkConfigs(NERtcVideoStreamType type, NERtcVideoWatermarkConfig config) {
        if (this.checkUninitialized("setLocalVideoWatermarkConfigs type: " + (Object)((Object)type) + " ,config: " + config)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setLocalVideoWatermarkConfigs(LiteHelper.getLiteMediaStreamType(type), LiteHelper.getLiteVideoWatermarkConfig(config));
    }

    @Override
    public int switchCameraWithPosition(int cameraPos) {
        if (this.checkUninitialized("switchCameraWithPosition, pos: " + cameraPos)) {
            return 30005;
        }
        return this.mMainChannel.switchCameraWithPosition(cameraPos);
    }

    @Override
    public int setAudioSubscribeOnlyBy(long[] uidArray) {
        if (this.checkUninitialized("setAudioSubscribeOnlyBy")) {
            return 30005;
        }
        return this.mMainChannel.setAudioSubscribeOnlyBy(uidArray);
    }

    @Override
    public int enableLocalSubStreamAudio(boolean enable) {
        if (this.checkUninitialized("enableLocalSubStreamAudio: " + enable)) {
            return 30005;
        }
        return this.mMainChannel.enableLocalSubStreamAudio(enable);
    }

    @Override
    public int subscribeRemoteSubStreamAudio(long uid, boolean subscribe) {
        if (this.checkUninitialized("subscribeRemoteSubStreamAudio uid: " + uid + " ,subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mMainChannel.subscribeRemoteSubStreamAudio(uid, subscribe);
    }

    @Override
    public void setStreamAlignmentProperty(boolean enable) {
        if (this.checkUninitialized("setStreamAlignmentProperty: " + enable)) {
            return;
        }
        this.mMainChannel.getLiteEngine().setStreamAlignmentProperty(enable);
    }

    @Override
    public long getNtpTimeOffset() {
        if (this.checkUninitialized(null)) {
            return 0L;
        }
        return this.mMainChannel.getLiteEngine().getNtpTimeOffset();
    }

    @Override
    public int muteLocalSubStreamAudio(boolean mute) {
        if (this.checkUninitialized("muteLocalSubStreamAudio: " + mute)) {
            return 30005;
        }
        return this.mMainChannel.muteLocalSubStreamAudio(mute);
    }

    @Override
    public int setExternalSubStreamAudioSource(boolean enabled, int sampleRate, int channels) {
        if (this.checkUninitialized("setExternalSubStreamAudioSource, enable:" + enabled + ", sampleRate:" + sampleRate + ", channels:" + channels)) {
            return 30005;
        }
        return this.mMainChannel.getLiteEngine().setExternalAudioSource(enabled, sampleRate, channels, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pushExternalSubStreamAudioFrame(NERtcAudioExternalFrame frame) {
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.checkUninitialized(null)) {
                return 30005;
            }
            return this.mMainChannel.pushExternalAudioFrame(frame, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentCamera() {
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.checkUninitialized(null)) {
                return 30005;
            }
            return this.mMainChannel.getCurrentCamera();
        }
    }

    @Override
    public int enableMediaPub(int mediaType, boolean enable) {
        if (this.checkUninitialized("enableMediaPub: " + enable + " , mediaType: " + mediaType)) {
            return 30005;
        }
        return this.mMainChannel.enableMediaPub(mediaType, enable);
    }

    @Override
    public int enableLocalData(boolean enabled) {
        if (this.checkUninitialized("enableLocalData enabled: " + enabled)) {
            return 30005;
        }
        return this.mMainChannel.enableLocalData(enabled);
    }

    @Override
    public int subscribeRemoteData(boolean subscribe, long userID) {
        if (this.checkUninitialized("subscribeRemoteData subscribe: " + subscribe + " , userID: " + userID)) {
            return 30005;
        }
        return this.mMainChannel.subscribeRemoteData(subscribe, userID);
    }

    @Override
    public int sendData(NERtcDataExternalFrame frame) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.sendData(frame);
    }

    @Override
    public int reportCustomEvent(String eventName, String customIdentify, HashMap<String, Object> param) {
        if (this.checkUninitialized(null)) {
            return 30005;
        }
        return this.mMainChannel.reportCustomEvent(eventName, customIdentify, param);
    }

    @Override
    public boolean isFeatureSupported(NERtcFeatureType featureType) {
        if (this.checkUninitialized("isFeatureSupported")) {
            return false;
        }
        return this.mMainChannel.getLiteEngine().isFeatureSupport(featureType.ordinal());
    }

    @Override
    public void setParameters(NERtcParameters params) throws IllegalArgumentException {
        if (params == null) {
            return;
        }
        RtcParameters raw = params.getRawParameters();
        Set<String> keySet = raw.keys();
        if (keySet.isEmpty()) {
            return;
        }
        if (this.mSettingJson == null) {
            this.mSettingJson = new JSONObject();
        }
        if (this.mPrivateSettingJson == null) {
            this.mPrivateSettingJson = new JSONObject();
        }
        try {
            int codecType;
            if (raw.containsKey("sdk.enable.encrypt.log")) {
                this.mSettingJson.put("sdk.enable.encrypt.log", raw.getBoolean("sdk.enable.encrypt.log"));
                LiteEngineCenter.setParameters(this.mSettingJson.toString());
                raw.removeParameters("sdk.enable.encrypt.log");
            }
            if (raw.containsKey("key_test_server_uri")) {
                this.mSettingJson.put("sdk.enable.debug.environment", raw.getBoolean("key_test_server_uri"));
                LiteEngineCenter.setParameters(this.mSettingJson.toString());
                ContextUtils.setDebug(raw.getBoolean("key_test_server_uri"));
                raw.removeParameters("key_test_server_uri");
            }
            if (raw.containsKey("key_auto_subscribe_audio")) {
                this.mSettingJson.put("sdk.auto.subscribe.audio", params.getBoolean(NERtcParameters.KEY_AUTO_SUBSCRIBE_AUDIO));
                raw.removeParameters("key_auto_subscribe_audio");
            }
            if (raw.containsKey("key_video_local_preview_mirror")) {
                this.mSettingJson.put("sdk.mirror.with.front.camera", params.getBoolean(NERtcParameters.KEY_VIDEO_LOCAL_PREVIEW_MIRROR));
                raw.removeParameters("key_video_local_preview_mirror");
            }
            if (raw.containsKey("key_server_record_audio")) {
                this.mSettingJson.put("sdk.enable.record.audio", params.getBoolean(NERtcParameters.KEY_SERVER_RECORD_AUDIO));
                raw.removeParameters("key_server_record_audio");
            }
            if (raw.containsKey("key_server_record_video")) {
                this.mSettingJson.put("sdk.enable.record.video", params.getBoolean(NERtcParameters.KEY_SERVER_RECORD_VIDEO));
                raw.removeParameters("key_server_record_video");
            }
            if (raw.containsKey("key_server_record_speaker")) {
                this.mSettingJson.put("sdk.enable.record.host", params.getBoolean(NERtcParameters.KEY_SERVER_RECORD_SPEAKER));
                raw.removeParameters("key_server_record_speaker");
            }
            if (raw.containsKey("key_server_record_mode")) {
                this.mSettingJson.put("sdk.set.record.type", params.getInteger(NERtcParameters.KEY_SERVER_RECORD_MODE));
                raw.removeParameters("key_server_record_mode");
            }
            if (raw.containsKey("key_video_encode_mode")) {
                String encodeMode = params.getString(NERtcParameters.KEY_VIDEO_ENCODE_MODE);
                codecType = -1;
                if ("media_codec_hardware".equals(encodeMode)) {
                    codecType = 1;
                } else if ("media_codec_software".equals(encodeMode)) {
                    codecType = 0;
                }
                this.mSettingJson.put("sdk.prefer.encode.mode", codecType);
                raw.removeParameters("key_video_encode_mode");
            }
            if (raw.containsKey("key_video_decode_mode")) {
                String decodeMode = params.getString(NERtcParameters.KEY_VIDEO_DECODE_MODE);
                codecType = -1;
                if ("media_codec_hardware".equals(decodeMode)) {
                    codecType = 1;
                } else if ("media_codec_software".equals(decodeMode)) {
                    codecType = 0;
                }
                this.mSettingJson.put("sdk.prefer.decode.mode", codecType);
                raw.removeParameters("key_video_decode_mode");
            }
            if (raw.containsKey("key_video_camera_type")) {
                this.mSettingJson.put("sdk.set.camera.type", params.getInteger(NERtcParameters.KEY_VIDEO_CAMERA_TYPE));
                raw.removeParameters("key_video_camera_type");
            }
            if (raw.containsKey("key_publish_self_stream")) {
                this.mSettingJson.put("sdk.enable.push.self.stream", params.getBoolean(NERtcParameters.KEY_PUBLISH_SELF_STREAM));
                raw.removeParameters("key_publish_self_stream");
            }
            if (raw.containsKey("key_video_send_mode")) {
                this.mSettingJson.put("sdk.publish.video.mode", params.getInteger(NERtcParameters.KEY_VIDEO_SEND_MODE));
                raw.removeParameters("key_video_send_mode");
            }
            if (raw.containsKey("key_auto_subscribe_video")) {
                this.mSettingJson.put("sdk.auto.subscribe.video", params.getBoolean(NERtcParameters.KEY_AUTO_SUBSCRIBE_VIDEO));
                raw.removeParameters("key_auto_subscribe_video");
            }
            if (raw.containsKey("key_auto_subscribe_data")) {
                this.mSettingJson.put("sdk.auto.subscribe.data", params.getBoolean(NERtcParameters.KEY_AUTO_SUBSCRIBE_DATA));
                raw.removeParameters("key_auto_subscribe_data");
            }
            if (raw.containsKey("key_simulator_threshold")) {
                EmulatorCheckUtil.getSingleInstance().setThreshold(params.getInteger(NERtcParameters.KEY_SIMULATOR_THRESHOLD));
                raw.removeParameters("key_simulator_threshold");
            }
            if (raw.containsKey("key_audio_bluetooth_sco")) {
                boolean isSco = params.getBoolean(NERtcParameters.KEY_AUDIO_BLUETOOTH_SCO);
                if (isSco && !SystemPermissionUtils.checkBluetoothScoConnectPermission(ContextUtils.getContext())) {
                    isSco = false;
                    Logging.e(TAG, "no bluetooth permission so force use a2dp ");
                }
                this.mSettingJson.put("sdk.audio.enable.bluetooth.sco", isSco ? 1 : 0);
                raw.removeParameters("key_audio_bluetooth_sco");
            }
            if (raw.containsKey("key_disable_video_decoder")) {
                this.mSettingJson.put("sdk.disable.video.decoder", params.getBoolean(NERtcParameters.KEY_DISABLE_VIDEO_DECODER));
                raw.removeParameters("key_disable_video_decoder");
            }
            if (raw.containsKey("key_enable_1v1_mode")) {
                this.mSettingJson.put("sdk.enable.1v1.Mode", params.getBoolean(NERtcParameters.KEY_ENABLE_1V1_MODEL));
                raw.removeParameters("key_enable_1v1_mode");
            }
            if (raw.containsKey("key_custom_extra_info")) {
                this.mSettingJson.put("sdk.set.extra.info", (Object)params.getString(NERtcParameters.KEY_CUSTOM_EXTRA_INFO));
                raw.removeParameters("key_custom_extra_info");
            }
            if (raw.containsKey("key_enable_report_volume_when_mute")) {
                this.mSettingJson.put("sdk.enable.report.volume.with.mute", params.getBoolean(NERtcParameters.KEY_ENABLE_REPORT_VOLUME_WHEN_MUTE));
                raw.removeParameters("key_enable_report_volume_when_mute");
            }
            if (raw.containsKey("key_disable_first_user_create_channel")) {
                this.mSettingJson.put("sdk.disable.first.user.create.channel", params.getBoolean(NERtcParameters.KEY_DISABLE_FIRST_USER_CREATE_CHANNEL));
                raw.removeParameters("key_disable_first_user_create_channel");
            }
            if (raw.containsKey("key_h265_switch")) {
                this.mSettingJson.put("sdk.prefer.h265", raw.getBoolean("key_h265_switch"));
                raw.removeParameters("key_h265_switch");
            }
            if (raw.containsKey("key_nevc_switch")) {
                this.mSettingJson.put("sdk.prefer.nevc", raw.getBoolean("key_nevc_switch"));
                raw.removeParameters("key_nevc_switch");
            }
            if (raw.containsKey("key_data_encrypt_mode")) {
                this.mSettingJson.put("sdk.enable.encrypt.media", raw.getBoolean("key_data_encrypt_mode"));
                raw.removeParameters("key_data_encrypt_mode");
            }
            if (raw.containsKey("key_media_server_uri")) {
                this.mSettingJson.put("sdk.set.tune.server", (Object)raw.getString("key_media_server_uri"));
                raw.removeParameters("key_media_server_uri");
            }
            if (raw.containsKey("key_quic_server_uri")) {
                this.mSettingJson.put("sdk.set.signal.proxy.server", (Object)raw.getString("key_quic_server_uri"));
                raw.removeParameters("key_quic_server_uri");
            }
            if (raw.containsKey("key_dispatcher_forwarded_ip")) {
                this.mSettingJson.put("sdk.set.forward.server", (Object)raw.getString("key_dispatcher_forwarded_ip"));
                raw.removeParameters("key_dispatcher_forwarded_ip");
            }
            if (raw.containsKey("key_audio_aec_enable")) {
                this.mSettingJson.put("sdk.enable.aec", raw.getBoolean("key_audio_aec_enable"));
                raw.removeParameters("key_audio_aec_enable");
            }
            if (raw.containsKey("key_audio_agc_enable")) {
                this.mSettingJson.put("sdk.enable.agc", raw.getBoolean("key_audio_agc_enable"));
                raw.removeParameters("key_audio_agc_enable");
            }
            if (raw.containsKey("key_audio_ns_enable")) {
                this.mSettingJson.put("sdk.enable.ns", raw.getBoolean("key_audio_ns_enable"));
                raw.removeParameters("key_audio_ns_enable");
            }
            if (raw.containsKey("key_audio_external_audio_mix")) {
                this.mSettingJson.put("sdk.enable.audio.mix", raw.getBoolean("key_audio_external_audio_mix"));
                raw.removeParameters("key_audio_external_audio_mix");
            }
            if (raw.containsKey("key_audio_ai_ns_enable")) {
                this.mSettingJson.put("sdk.enable.audio.ains", raw.getBoolean("key_audio_ai_ns_enable"));
                raw.removeParameters("key_audio_ai_ns_enable");
            }
            if (raw.containsKey("key_vp8_mode")) {
                this.mSettingJson.put("sdk.set.vp8.mode", raw.getInteger("key_vp8_mode"));
                raw.removeParameters("key_vp8_mode");
            }
            if (raw.containsKey("sdk.audience.keep.audio.recording")) {
                this.mSettingJson.put("sdk.audience.keep.audio.recording", raw.getBoolean("sdk.audience.keep.audio.recording"));
                raw.removeParameters("sdk.audience.keep.audio.recording");
            }
            if (raw.containsKey("sdk.audio.codec.bitrate")) {
                this.mSettingJson.put("sdk.audio.codec.bitrate", raw.getInteger("sdk.audio.codec.bitrate"));
                raw.removeParameters("sdk.audio.codec.bitrate");
            }
            if (raw.containsKey("sdk.cdn.gop")) {
                this.mSettingJson.put("sdk.cdn.gop", raw.getInteger("sdk.cdn.gop"));
                raw.removeParameters("sdk.cdn.gop");
            }
            if (raw.containsKey("key_audiomix_enable_without_mic")) {
                this.mSettingJson.put("sdk.enable.audio.mixing.pub.standalone", raw.getBoolean("key_audiomix_enable_without_mic"));
                raw.removeParameters("key_audiomix_enable_without_mic");
            }
            if (raw.containsKey("sdk.join.max.time.out")) {
                this.mSettingJson.put("sdk.join.max.time.out", raw.getInteger("sdk.join.max.time.out"));
                raw.removeParameters("sdk.join.max.time.out");
            }
            if (raw.containsKey("key_disable_sdk_audio_route")) {
                this.mSettingJson.put("sdk.audio.disable.route", raw.getBoolean("key_disable_sdk_audio_route"));
                raw.removeParameters("key_disable_sdk_audio_route");
            }
            if (raw.containsKey("sdk.disable.getChannelInfo")) {
                this.mPrivateSettingJson.put(LiteHelper.getLitePrivateParamKey("sdk.disable.getChannelInfo"), raw.getBoolean("sdk.disable.getChannelInfo"));
                raw.removeParameters("sdk.disable.getChannelInfo");
            }
            if (raw.containsKey("sdk.getChannelInfo.custom.data")) {
                this.mPrivateSettingJson.put(LiteHelper.getLitePrivateParamKey("sdk.getChannelInfo.custom.data"), (Object)raw.getString("sdk.getChannelInfo.custom.data"));
                raw.removeParameters("sdk.getChannelInfo.custom.data");
            }
            if (raw.containsKey("sdk.getChannelInfo.response")) {
                this.mPrivateSettingJson.put(LiteHelper.getLitePrivateParamKey("sdk.getChannelInfo.response"), (Object)raw.getString("sdk.getChannelInfo.response"));
                raw.removeParameters("sdk.getChannelInfo.response");
            }
            if (raw.containsKey("sdk.private.api.request.asr.caption")) {
                this.mPrivateSettingJson.put("sdk.private.api.request.asr.caption", (Object)raw.getString("sdk.private.api.request.asr.caption"));
                raw.removeParameters("sdk.private.api.request.asr.caption");
            } else {
                this.mPrivateSettingJson.remove("sdk.private.api.request.asr.caption");
            }
            String configEngine = this.parseConfigEngineParameters(raw);
            if (!TextUtils.isEmpty((CharSequence)configEngine) && this.mMainChannel != null) {
                LiteEngineCenter.setPassThroughParameters(configEngine);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, Objects.requireNonNull(e.getMessage()));
        }
        if (this.mMainChannel != null) {
            LiteEngineCenter.setParameters(this.mSettingJson.toString());
            if (this.mPrivateSettingJson != null && this.mPrivateSettingJson.length() > 0) {
                this.mMainChannel.getLiteEngine().executePrivateApi(this.mPrivateSettingJson.toString());
            }
        }
    }

    @Override
    public String getParameter(String parameterKey, String extraInfo) {
        if (this.mMainChannel != null) {
            return this.mMainChannel.getLiteEngine().getParameters(LiteHelper.getLitePrivateParamKey(parameterKey), extraInfo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pushExternalAudioEncodedFrameInternal(int audioType, NERtcAudioEncodedFrame frame) {
        if (frame == null || frame.payloadType == null) {
            Logging.i(TAG, "pushExternalAudioEncodedFrame frame or payloadType is null");
            return 30003;
        }
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.checkUninitialized(null)) {
                return 30005;
            }
            return this.mMainChannel.getLiteEngine().pushExternalAudioEncodedFrame(audioType, frame.data, frame.timeStampUs, frame.sampleRate, frame.channels, frame.samplesPerChannel, frame.encodedLen, frame.encodedTimestamp, frame.payloadType == null ? 111 : frame.payloadType.intValue, frame.rmsLevel);
        }
    }

    private String parseConfigEngineParameters(RtcParameters raw) {
        if (raw != null) {
            Set<String> keySet = raw.keys();
            if (keySet.isEmpty()) {
                return null;
            }
            JSONObject engineJson = new JSONObject();
            for (String key : keySet) {
                try {
                    if (key.startsWith("engine.") || key.startsWith("lava.") || key.startsWith("e.")) {
                        engineJson.put(key, raw.getObject(key));
                        continue;
                    }
                    this.mSettingJson.put(key, raw.getObject(key));
                }
                catch (Exception e) {
                    Logging.e(TAG, "parseConfigEngineParameters:" + e.getMessage());
                }
            }
            if (engineJson.length() > 0) {
                this.mConfigEngineParam = engineJson.toString();
                return this.mConfigEngineParam;
            }
        }
        return null;
    }

    private void printCommonInfo() {
        this.printNERTCInfo();
        this.printDeviceInfo();
    }

    private void printNERTCInfo() {
        NERtcVersion version = NERtc.version();
        Logging.w(TAG, "nertc: {ver:" + version.versionName + "." + version.versionCode + ", rev:" + version.buildRevision + ", branch:" + version.buildBranch + ", date:" + version.buildDate + ", host:" + version.buildHost + ", type:" + version.buildType + ", env:" + version.serverEnv + "}");
        Logging.i(TAG, "submodules: {lava:" + version.engineRevision + "}");
    }

    public static String hashCodeStr(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getSimpleName() + "##" + obj.hashCode();
    }

    private void printDeviceInfo() {
        try {
            Context context = ContextUtils.getContext();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String packageName = packageInfo.packageName;
            String versionName = packageInfo.versionName;
            int versionCode = packageInfo.versionCode;
            int targetSdkVersion = packageInfo.applicationInfo.targetSdkVersion;
            Object[] supported_abis = Compatibility.runningOnLollipopOrHigher() ? Build.SUPPORTED_ABIS : new String[]{Build.CPU_ABI};
            StringBuilder sb = new StringBuilder();
            sb.append("SUPPORTED_ABIS:");
            if (supported_abis != null) {
                sb.append(Arrays.toString(supported_abis));
            }
            long kbToGB = 0x40000000L;
            double totalMemory = (double)AndroidDeviceInfo.getTotalMemory(context) * 1.0 / (double)kbToGB;
            double gHZ = (double)AndroidDeviceInfo.getCPUMaxFreqKHz() * 1.0 / 1000000.0;
            Logging.i(TAG, "App: {packageName:[" + packageName + "], version:" + versionName + ", build:" + versionCode + ", targetSdkVer:" + targetSdkVersion + ", pid:" + Process.myPid() + ", uid:" + Process.myUid() + "}");
            Logging.i(TAG, "Device: {MANUFACTURER:" + Build.MANUFACTURER + ", HARDWARE:" + Build.HARDWARE + ", CPU:" + AndroidDeviceInfo.getDeviceCpuName() + ", MODEL:" + Build.MODEL + ", BOARD:" + Build.BOARD + ", SDK_INT:" + Build.VERSION.SDK_INT + ", " + sb.toString() + ", DISPLAY:" + Build.DISPLAY + ", CPUName: " + AndroidDeviceInfo.getDeviceCpuName() + ", Memory:" + String.format(Locale.CHINA, "%.2f", totalMemory) + "GB,GHZ:" + String.format(Locale.CHINA, "%.2f", gHZ) + "}");
        }
        catch (Exception e) {
            Logging.e(TAG, "Host: {Unknown}");
        }
    }

    private boolean checkUninitialized(String errorMsg) {
        if (this.mMainChannel == null) {
            if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
                Logging.e(TAG, "uninitialized " + errorMsg);
            }
            return true;
        }
        return false;
    }

    private static class SingletonHolder {
        static NERtcCore instance = new NERtcCore();

        private SingletonHolder() {
        }
    }
}

