/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.impl;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import com.netease.compiler.CheckCallback;
import com.netease.lava.nertc.impl.NERtcCore;
import com.netease.lava.nertc.impl.RtcConnectionType;
import com.netease.lava.nertc.impl.lite.LiteHelper;
import com.netease.lava.nertc.sdk.LastmileProbeResult;
import com.netease.lava.nertc.sdk.NERtcCallback;
import com.netease.lava.nertc.sdk.NERtcCallbackEx;
import com.netease.lava.nertc.sdk.NERtcConstants;
import com.netease.lava.nertc.sdk.NERtcUserJoinExtraInfo;
import com.netease.lava.nertc.sdk.NERtcUserLeaveExtraInfo;
import com.netease.lava.nertc.sdk.audio.NERtcAudioProcessObserver;
import com.netease.lava.nertc.sdk.channel.NERtcChannelCallback;
import com.netease.lava.nertc.sdk.video.NERtcVideoStreamType;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.LiteEngineCenter;
import com.netease.yunxin.lite.model.LiteSDKAudioVolumeInfo;
import com.netease.yunxin.lite.model.LiteSDKEngineSink;
import com.netease.yunxin.lite.model.LiteSDKProbeEngineSink;
import com.netease.yunxin.lite.model.LiteSDKProbeResult;
import com.netease.yunxin.lite.model.LiteSDKPushStreamingEngineSink;
import java.nio.ByteBuffer;

public class NERtcSinkWrapper
implements LiteSDKEngineSink,
LiteSDKProbeEngineSink,
LiteSDKPushStreamingEngineSink {
    private static final String TAG = "NERtcSinkWrapper";
    private NERtcCallback mCallback = null;
    private NERtcCallbackEx mCallbackEx = null;
    private NERtcChannelCallback mChannelCallback = null;
    private Object mEngineLock = null;
    private volatile NERtcAudioProcessObserver mAudioProcessObserver = null;
    private boolean mIsMainChannel;
    private Handler mCallbackListener = new Handler(Looper.getMainLooper());

    public void setCallback(NERtcCallback callback, boolean isMainChannel) {
        this.mCallback = callback;
        this.mCallbackEx = callback instanceof NERtcCallbackEx ? (NERtcCallbackEx)this.mCallback : null;
        this.mIsMainChannel = isMainChannel;
    }

    public void setEngineLock(Object engineLock) {
        this.mEngineLock = engineLock;
    }

    public void setCallbackHandler(Handler callbackHandler) {
        Logging.i(TAG, "setListenerHandler, listenerHandler : " + callbackHandler);
        this.mCallbackListener = callbackHandler == null ? new Handler(Looper.getMainLooper()) : callbackHandler;
    }

    public void setChannelCallback(NERtcChannelCallback channelCallback) {
        this.mChannelCallback = channelCallback;
    }

    public void setAudioProcessObserver(NERtcAudioProcessObserver audioProcessObserver) {
        this.mAudioProcessObserver = audioProcessObserver;
    }

    @Override
    @CheckCallback
    public void onJoin(int result, long channelId, long userId, int role, long rtt, long elapsedTime, String errMsg) {
        Logging.i(TAG, "onJoin result: " + result + " ,channelId: " + channelId + " ,userId: " + userId + " ,role: " + role + " ,rtt: " + rtt + " ,elapsedTime: " + elapsedTime + " ,errMsg: " + errMsg);
        NERtcCallback callback = this.mCallback;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.reportNotifyEvent("OnJoin", () -> this.mChannelCallback.onJoinChannel(result, channelId, elapsedTime, userId)));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> this.reportNotifyEvent("OnJoin", () -> callback.onJoinChannel(result, channelId, elapsedTime, userId)));
        }
    }

    @Override
    @CheckCallback
    public void onLeave(int result, long channelId) {
        Logging.i(TAG, "onLeave result: " + result + " ,channelId: " + channelId);
        NERtcCallback callback = this.mCallback;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onLeaveChannel(result));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onLeaveChannel(result));
        }
    }

    @Override
    @CheckCallback
    public void onDisconnect(int reason) {
        Logging.i(TAG, "onDisconnect reason: " + reason);
        NERtcCallback callback = this.mCallback;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onDisconnect(reason));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onDisconnect(reason));
        }
    }

    @Override
    @CheckCallback
    public void onUserJoin(long userId, String userName, String custom_info) {
        Logging.i(TAG, "onUserJoin userId: " + userId + " ,userName: " + userName + " ,custom_info: " + custom_info);
        NERtcCallback callback = this.mCallback;
        NERtcUserJoinExtraInfo joinExtraInfo = new NERtcUserJoinExtraInfo();
        joinExtraInfo.customInfo = custom_info;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserJoined(userId));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserJoined(userId));
        }
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserJoined(userId, joinExtraInfo));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserJoined(userId, joinExtraInfo));
        }
    }

    @Override
    @CheckCallback
    public void onUserLeave(long userId, int reason, String custom_info) {
        Logging.i(TAG, "onUserLeave userId: " + userId + " ,reason: " + reason);
        NERtcCallback callback = this.mCallback;
        NERtcUserLeaveExtraInfo leaveExtraInfo = new NERtcUserLeaveExtraInfo();
        leaveExtraInfo.customInfo = custom_info;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserLeave(userId, reason));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserLeave(userId, reason));
        }
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserLeave(userId, reason, leaveExtraInfo));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserLeave(userId, reason, leaveExtraInfo));
        }
    }

    @Override
    @CheckCallback
    public void onUserAudioStart(long userId, boolean mute, int streamType) {
        Logging.i(TAG, "onUserAudioStart userId: " + userId + " ,mute: " + mute + " , streamType:" + streamType);
        this.runOnListenerThread(() -> {
            if (this.mChannelCallback != null) {
                if (streamType == 0) {
                    this.mChannelCallback.onUserAudioStart(userId);
                    if (mute) {
                        this.mChannelCallback.onUserAudioMute(userId, mute);
                    }
                    return;
                }
                if (streamType == 1) {
                    this.mChannelCallback.onUserSubStreamAudioStart(userId);
                    if (mute) {
                        this.mChannelCallback.onUserSubStreamAudioMute(userId, mute);
                    }
                    return;
                }
                return;
            }
            if (this.mCallback != null && this.mIsMainChannel) {
                if (streamType == 0) {
                    this.mCallback.onUserAudioStart(userId);
                    if (this.mCallbackEx != null && mute) {
                        this.mCallbackEx.onUserAudioMute(userId, mute);
                    }
                    return;
                }
                if (this.mCallbackEx != null && streamType == 1) {
                    this.mCallbackEx.onUserSubStreamAudioStart(userId);
                    if (mute) {
                        this.mCallbackEx.onUserSubStreamAudioMute(userId, mute);
                    }
                    return;
                }
                return;
            }
        });
    }

    @Override
    @CheckCallback
    public void onUserAudioMute(long userId, boolean mute, int streamType) {
        Logging.i(TAG, "onUserAudioMute userId: " + userId + " ,mute: " + mute + " , streamType:" + streamType);
        this.runOnListenerThread(() -> {
            if (streamType == 0) {
                if (this.mChannelCallback != null) {
                    this.mChannelCallback.onUserAudioMute(userId, mute);
                } else if (this.mCallbackEx != null && this.mIsMainChannel) {
                    this.mCallbackEx.onUserAudioMute(userId, mute);
                }
                return;
            }
            if (streamType == 1) {
                if (this.mChannelCallback != null) {
                    this.mChannelCallback.onUserSubStreamAudioMute(userId, mute);
                } else if (this.mCallbackEx != null && this.mIsMainChannel) {
                    this.mCallbackEx.onUserSubStreamAudioMute(userId, mute);
                }
                return;
            }
        });
    }

    @Override
    @CheckCallback
    public void onUserAudioStop(long userId, int streamType) {
        Logging.i(TAG, "onUserAudioStop userId: " + userId + " , streamType:" + streamType);
        this.runOnListenerThread(() -> {
            if (streamType == 0) {
                if (this.mChannelCallback != null) {
                    this.mChannelCallback.onUserAudioStop(userId);
                } else if (this.mCallback != null && this.mIsMainChannel) {
                    this.mCallback.onUserAudioStop(userId);
                }
                return;
            }
            if (streamType == 1) {
                if (this.mChannelCallback != null) {
                    this.mChannelCallback.onUserSubStreamAudioStop(userId);
                } else if (this.mCallbackEx != null && this.mIsMainChannel) {
                    this.mCallbackEx.onUserSubStreamAudioStop(userId);
                }
                return;
            }
        });
    }

    @Override
    @CheckCallback
    public void onLocalAudioFirstPacketSent(int streamType) {
        Logging.i(TAG, "onLocalAudioFirstPacketSent streamType: " + streamType);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onLocalAudioFirstPacketSent(LiteHelper.getAudioStreamTypeFromLite(streamType)));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onLocalAudioFirstPacketSent(LiteHelper.getAudioStreamTypeFromLite(streamType)));
        }
    }

    @Override
    @CheckCallback
    public void onUserFirstAudioDataReceived(long userId, int streamType) {
        Logging.i(TAG, "onUserFirstAudioDataReceived userId: " + userId + " ,streamType: " + streamType);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onFirstAudioDataReceived(userId));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onFirstAudioDataReceived(userId));
        }
    }

    @Override
    @CheckCallback
    public void onUserFirstAudioFrameDecoded(long userId, int streamType) {
        Logging.i(TAG, "onUserFirstAudioFrameDecoded userId: " + userId + " ,streamType: " + streamType);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onFirstAudioFrameDecoded(userId));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onFirstAudioFrameDecoded(userId));
        }
    }

    @Override
    @CheckCallback
    public void onAudioDeviceRoutingChanged(int routing) {
        Logging.i(TAG, "onAudioDeviceRoutingChanged routing: " + routing);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            int device = 0;
            switch (routing) {
                case 0: 
                case 3: {
                    device = 0;
                    break;
                }
                case 1: {
                    device = 1;
                    break;
                }
                case 2: {
                    device = 2;
                    break;
                }
                case 4: {
                    device = 3;
                    break;
                }
            }
            int finalDevice = device;
            this.runOnListenerThread(() -> callback.onAudioDeviceChanged(finalDevice));
        }
    }

    @Override
    @CheckCallback
    public void OnAudioDeviceStateChanged(String deviceId, int type, int state) {
        int sdkAudioDeviceState;
        int sdkAudioDeviceType;
        Logging.i(TAG, "OnAudioDeviceStateChanged, deviceId:" + deviceId + ", type:" + type + ", state:" + state);
        switch (type) {
            case 1: {
                sdkAudioDeviceType = 1;
                break;
            }
            case 2: {
                sdkAudioDeviceType = 2;
                break;
            }
            default: {
                Logging.e(TAG, "Unexpected value: " + type);
                return;
            }
        }
        switch (state) {
            case 3: {
                sdkAudioDeviceState = 1;
                break;
            }
            case 4: {
                sdkAudioDeviceState = 2;
                break;
            }
            default: {
                return;
            }
        }
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            int finalSdkAudioDeviceType = sdkAudioDeviceType;
            int finalSdkAudioDeviceState = sdkAudioDeviceState;
            this.runOnListenerThread(() -> this.reportNotifyEvent("OnAudioDeviceStateChanged", () -> callback.onAudioDeviceStateChange(finalSdkAudioDeviceType, finalSdkAudioDeviceState)));
        }
    }

    @Override
    @CheckCallback
    public void OnAudioDeviceError(String deviceId, int type, int error) {
        int sdkAudioDeviceError;
        int sdkAudioDeviceType;
        Logging.e(TAG, "OnAudioDeviceError, deviceId:" + deviceId + ", type:" + type + ", error:" + error);
        switch (type) {
            case 1: {
                sdkAudioDeviceType = 1;
                break;
            }
            case 2: {
                sdkAudioDeviceType = 2;
                break;
            }
            default: {
                Logging.e(TAG, "Unexpected value: " + type);
                return;
            }
        }
        switch (error) {
            case 1: 
            case 4: {
                sdkAudioDeviceError = 3;
                break;
            }
            case 2: 
            case 5: {
                sdkAudioDeviceError = 4;
                break;
            }
            default: {
                return;
            }
        }
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            int finalSdkAudioDeviceType = sdkAudioDeviceType;
            int finalSdkAudioDeviceError = sdkAudioDeviceError;
            this.runOnListenerThread(() -> callback.onAudioDeviceStateChange(finalSdkAudioDeviceType, finalSdkAudioDeviceError));
        }
    }

    @Override
    @CheckCallback
    public void onAudioRecording(int code, String filePath) {
        Logging.i(TAG, "onAudioRecording, code: " + code + ", filePath: " + filePath);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onAudioRecording(code, filePath));
        }
    }

    @Override
    @CheckCallback
    public void onAudioHasHowling(boolean flag) {
        if (this.mAudioProcessObserver != null) {
            this.mAudioProcessObserver.onAudioHasHowling(flag);
        }
    }

    @Override
    @CheckCallback
    public void onLocalAudioVolumeIndication(int volume, boolean vadFlag) {
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> {
                this.mChannelCallback.onLocalAudioVolumeIndication(volume);
                this.mChannelCallback.onLocalAudioVolumeIndication(volume, vadFlag);
            });
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> {
                callback.onLocalAudioVolumeIndication(volume);
                callback.onLocalAudioVolumeIndication(volume, vadFlag);
            });
        }
    }

    @Override
    @CheckCallback
    public void onRemoteAudioVolumeIndication(LiteSDKAudioVolumeInfo[] volumeInfo, long total_volume) {
        if (volumeInfo == null) {
            return;
        }
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onRemoteAudioVolumeIndication(volumeInfo, (int)total_volume));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onRemoteAudioVolumeIndication(volumeInfo, (int)total_volume));
        }
    }

    @Override
    @CheckCallback
    public void onUserVideoStart(long userId, int width, int height, boolean mute, int streamType, boolean isFakeVideo) {
        int profile;
        Logging.i(TAG, "onUserVideoStart userId: " + userId + " ,width: " + width + " ,height: " + height + " ,mute: " + mute + " ,streamType: " + streamType + " ,isFakeVideo: " + isFakeVideo);
        int n = profile = isFakeVideo ? 6 : LiteEngineCenter.getBestVideoProfileType(width, height);
        if (streamType == 2) {
            NERtcCallback callback = this.mCallback;
            if (this.mChannelCallback != null) {
                this.runOnListenerThread(() -> {
                    this.mChannelCallback.onUserVideoStart(userId, profile);
                    if (mute) {
                        this.mChannelCallback.onUserVideoMute(userId, mute);
                        this.mChannelCallback.onUserVideoMute(this.toNeRtcVideoType(streamType), userId, mute);
                    }
                });
            } else if (callback != null && this.mIsMainChannel) {
                this.runOnListenerThread(() -> {
                    callback.onUserVideoStart(userId, profile);
                    if (mute && this.mCallbackEx != null) {
                        this.mCallbackEx.onUserVideoMute(userId, mute);
                        this.mCallbackEx.onUserVideoMute(this.toNeRtcVideoType(streamType), userId, mute);
                    }
                });
            }
        } else if (streamType == 3) {
            NERtcCallbackEx callback = this.mCallbackEx;
            if (this.mChannelCallback != null) {
                this.runOnListenerThread(() -> {
                    this.mChannelCallback.onUserSubStreamVideoStart(userId, profile);
                    if (mute) {
                        this.mChannelCallback.onUserVideoMute(this.toNeRtcVideoType(streamType), userId, mute);
                    }
                });
            } else if (callback != null && this.mIsMainChannel) {
                this.runOnListenerThread(() -> {
                    callback.onUserSubStreamVideoStart(userId, profile);
                    if (mute) {
                        callback.onUserVideoMute(this.toNeRtcVideoType(streamType), userId, mute);
                    }
                });
            }
        }
    }

    @Override
    @CheckCallback
    public void onUserVideoMute(long userId, boolean mute, int streamType) {
        Logging.i(TAG, "onUserVideoMute userId: " + userId + " ,mute: " + mute + " ,streamType: " + streamType);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> {
                if (streamType == 2) {
                    this.mChannelCallback.onUserVideoMute(userId, mute);
                }
                this.mChannelCallback.onUserVideoMute(this.toNeRtcVideoType(streamType), userId, mute);
            });
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> {
                if (streamType == 2) {
                    callback.onUserVideoMute(userId, mute);
                }
                callback.onUserVideoMute(this.toNeRtcVideoType(streamType), userId, mute);
            });
        }
    }

    @Override
    @CheckCallback
    public void onUserVideoStop(long userId, int streamType) {
        Logging.i(TAG, "onUserVideoStop userId: " + userId + " ,streamType: " + streamType);
        if (streamType == 2) {
            NERtcCallback callback = this.mCallback;
            if (this.mChannelCallback != null) {
                this.runOnListenerThread(() -> this.mChannelCallback.onUserVideoStop(userId));
            } else if (callback != null && this.mIsMainChannel) {
                this.runOnListenerThread(() -> callback.onUserVideoStop(userId));
            }
        } else if (streamType == 3) {
            NERtcCallbackEx callback = this.mCallbackEx;
            if (this.mChannelCallback != null) {
                this.runOnListenerThread(() -> this.mChannelCallback.onUserSubStreamVideoStop(userId));
            } else if (callback != null && this.mIsMainChannel) {
                this.runOnListenerThread(() -> callback.onUserSubStreamVideoStop(userId));
            }
        }
    }

    @Override
    @CheckCallback
    public void onUserFirstVideoDataReceived(long userId, int streamType) {
        Logging.i(TAG, "onUserFirstVideoDataReceived userId: " + userId + " ,streamType: " + streamType);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> {
                if (streamType == 2) {
                    this.mChannelCallback.onFirstVideoDataReceived(userId);
                }
                this.mChannelCallback.onFirstVideoDataReceived(this.toNeRtcVideoType(streamType), userId);
            });
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> {
                if (streamType == 2) {
                    callback.onFirstVideoDataReceived(userId);
                }
                callback.onFirstVideoDataReceived(this.toNeRtcVideoType(streamType), userId);
            });
        }
    }

    @Override
    @CheckCallback
    public void onUserFirstVideoFrameDecoded(long userId, int streamType, int width, int height) {
        Logging.i(TAG, "onUserFirstVideoFrameDecoded userId: " + userId + " ,streamType: " + streamType + " ,width: " + width + " ,height: " + height);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> {
                if (streamType == 2) {
                    this.mChannelCallback.onFirstVideoFrameDecoded(userId, width, height);
                }
                this.mChannelCallback.onFirstVideoFrameDecoded(this.toNeRtcVideoType(streamType), userId, width, height);
            });
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> {
                if (streamType == 2) {
                    callback.onFirstVideoFrameDecoded(userId, width, height);
                }
                callback.onFirstVideoFrameDecoded(this.toNeRtcVideoType(streamType), userId, width, height);
            });
        }
    }

    @Override
    @CheckCallback
    public void onUserFirstVideoFrameRender(long userId, int streamType, int width, int height, long elapsedTime) {
        Logging.i(TAG, "onUserFirstVideoFrameRender, userId:" + userId + ", streamType:" + streamType + ", width:" + width + ", height:" + height + ", elapsedTime:" + elapsedTime);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onFirstVideoFrameRender(userId, this.toNeRtcVideoType(streamType), width, height, elapsedTime));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onFirstVideoFrameRender(userId, this.toNeRtcVideoType(streamType), width, height, elapsedTime));
        }
    }

    @Override
    @CheckCallback
    public void onChannelStateChanged(int state, int reason) {
        Logging.i(TAG, "onChannelStateChanged state: " + state + " ,reason: " + reason);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.reportNotifyEvent("OnChannelStateChanged", () -> this.mChannelCallback.onConnectionStateChanged(LiteHelper.liteChannelStateToSDK(state), reason)));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> this.reportNotifyEvent("OnChannelStateChanged", () -> callback.onConnectionStateChanged(LiteHelper.liteChannelStateToSDK(state), reason)));
        }
    }

    @Override
    @CheckCallback
    public void onVideoDeviceStateChanged(String deviceId, int deviceState) {
        Logging.i(TAG, "onVideoDeviceStateChanged deviceId: " + deviceId + " ,deviceState: " + deviceState);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            int state = -1;
            if (deviceState == 3) {
                state = 1;
            } else if (deviceState == 4) {
                state = 2;
            }
            if (state != -1) {
                int finalState = state;
                this.runOnListenerThread(() -> this.reportNotifyEvent("OnVideoDeviceStateChanged", () -> callback.onVideoDeviceStageChange(finalState)));
            }
        }
    }

    @Override
    @CheckCallback
    public void onVideoDeviceError(String deviceId, int deviceError) {
        Logging.i(TAG, "onVideoDeviceError deviceId: " + deviceId + " ,deviceError: " + deviceError);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            int state = deviceError == 0 ? 4 : (deviceError == 3 ? 3 : 5);
            int finalState = state;
            this.runOnListenerThread(() -> callback.onVideoDeviceStageChange(finalState));
        }
    }

    @Override
    @CheckCallback
    public void onCameraFocusChanged(int left, int top, int right, int bottom) {
        Logging.i(TAG, "onCameraFocusChanged left: " + left + " ,top: " + top + " ,right: " + right + " ,bottom: " + bottom);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onCameraFocusChanged(new Rect(left, top, right, bottom)));
        }
    }

    @Override
    @CheckCallback
    public void onCameraExposureChanged(int left, int top, int right, int bottom) {
        Logging.i(TAG, "onCameraExposureChanged left: " + left + " ,top: " + top + " ,right: " + right + " ,bottom: " + bottom);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onCameraExposureChanged(new Rect(left, top, right, bottom)));
        }
    }

    @Override
    @CheckCallback
    public void onNetworkTypeChanged(int newType) {
        Logging.i(TAG, "onNetworkTypeChanged, newType:" + newType);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            int type = this.liteNetWorkToSDK(newType);
            Logging.i(TAG, "onNetworkTypeChanged: " + RtcConnectionType.toString(type));
            this.runOnListenerThread(() -> callback.onConnectionTypeChanged(type));
        }
    }

    private int liteNetWorkToSDK(int newType) {
        switch (newType) {
            case 1: {
                return NERtcConstants.ConnectionType.CONNECTION_ETHERNET;
            }
            case 2: {
                return NERtcConstants.ConnectionType.CONNECTION_WIFI;
            }
            case 3: {
                return NERtcConstants.ConnectionType.CONNECTION_2G;
            }
            case 4: {
                return NERtcConstants.ConnectionType.CONNECTION_3G;
            }
            case 5: {
                return NERtcConstants.ConnectionType.CONNECTION_4G;
            }
            case 6: {
                return NERtcConstants.ConnectionType.CONNECTION_5G;
            }
            case 8: {
                return NERtcConstants.ConnectionType.CONNECTION_BLUETOOTH;
            }
            case 9: {
                return NERtcConstants.ConnectionType.CONNECTION_NONE;
            }
        }
        return NERtcConstants.ConnectionType.CONNECTION_UNKNOWN;
    }

    @Override
    @CheckCallback
    public void onAudioMixingStateChanged(int state, int errorCode) {
        Logging.i(TAG, "onAudioMixingStateChanged, state:" + state + ", errorCode:" + errorCode);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback == null) {
            return;
        }
        block0 : switch (state) {
            case 0: {
                this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(0));
                break;
            }
            case 1: {
                switch (errorCode) {
                    case 3: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(1));
                        break block0;
                    }
                    case 4: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(2));
                        break block0;
                    }
                    case 5: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(3));
                        break block0;
                    }
                    case 6: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(4));
                        break block0;
                    }
                    case 7: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(5));
                        break block0;
                    }
                    case 8: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(6));
                        break block0;
                    }
                    case 9: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(7));
                        break block0;
                    }
                    case 10: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(8));
                        break block0;
                    }
                    case 11: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(9));
                        break block0;
                    }
                    case 12: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(10));
                        break block0;
                    }
                    case 13: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(11));
                        break block0;
                    }
                    case 14: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(12));
                        break block0;
                    }
                    case 15: {
                        this.runOnListenerThread(() -> callback.onAudioMixingStateChanged(13));
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Override
    @CheckCallback
    public void onAudioMixingTimestampUpdate(long timestamp) {
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onAudioMixingTimestampUpdate(timestamp));
        }
    }

    @Override
    @CheckCallback
    public void onAudioEffectFinished(int effectId) {
        Logging.i(TAG, "onAudioEffectFinished, effectId:" + effectId);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onAudioEffectFinished(effectId));
        }
    }

    @Override
    @CheckCallback
    public void onAudioEffectTimestampUpdate(int effectId, long timestamp) {
        Logging.i(TAG, "onAudioEffectTimestampUpdate, effectId:" + effectId + ", timestamp: " + timestamp);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onAudioEffectTimestampUpdate(effectId, timestamp));
        }
    }

    @Override
    @CheckCallback
    public void onLiveStreamState(String taskId, String url, int stateCode) {
        Logging.i(TAG, "onLiveStreamState, taskId:" + taskId + ", url:" + url + ", stateCode:" + stateCode);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onLiveStreamState(taskId, url, stateCode));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onLiveStreamState(taskId, url, stateCode));
        }
    }

    @Override
    @CheckCallback
    public void onError(int errorCode) {
        Logging.e(TAG, "onError, errorCode:" + errorCode);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onError(errorCode));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onError(errorCode));
        }
    }

    @Override
    @CheckCallback
    public void onWarning(int warningCode) {
        Logging.w(TAG, "onWarning, warningCode:" + warningCode);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onWarning(warningCode));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onWarning(warningCode));
        }
    }

    @Override
    @CheckCallback
    public void onApiCallExecuted(String apiName, int result, String message) {
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onApiCallExecuted(apiName, result, message));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onApiCallExecuted(apiName, result, message));
        }
    }

    @Override
    @CheckCallback
    public void OnRejoinStart(long channelId, long userId) {
        Logging.i(TAG, "OnRejoinStart, channelId:" + channelId + ", userId:" + userId);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onReconnectingStart(channelId, userId));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(callback::onReconnectingStart);
        }
    }

    @Override
    @CheckCallback
    public void OnRejoin(int result, long channelId, long userId) {
        Logging.i(TAG, "OnRejoin, result:" + result + ", channelId:" + channelId + ", userId:" + userId);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onReJoinChannel(result, channelId));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onReJoinChannel(result, channelId));
        }
    }

    @Override
    @CheckCallback
    public void onUserRoleChanged(int oldRole, int newRole) {
        Logging.i(TAG, "onUserRoleChanged, oldRole:" + oldRole + ", newRole:" + newRole);
        NERtcCallback callback = this.mCallback;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onClientRoleChange(oldRole, newRole));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onClientRoleChange(oldRole, newRole));
        }
    }

    @Override
    @CheckCallback
    public void onPublishFallbackToAudioOnly(boolean isFallback, boolean isMainStream) {
        Logging.i(TAG, "onPublishFallbackToAudioOnly, isFallback:" + isFallback + ", isMainStream:" + isMainStream);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onLocalPublishFallbackToAudioOnly(isFallback, isMainStream ? NERtcVideoStreamType.kNERtcVideoStreamTypeMain : NERtcVideoStreamType.kNERtcVideoStreamTypeSub));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onLocalPublishFallbackToAudioOnly(isFallback, isMainStream ? NERtcVideoStreamType.kNERtcVideoStreamTypeMain : NERtcVideoStreamType.kNERtcVideoStreamTypeSub));
        }
    }

    @Override
    @CheckCallback
    public void onSubscribeFallbackToAudioOnly(long userId, boolean isFallback, boolean isMainStream) {
        Logging.i(TAG, "onSubscribeFallbackToAudioOnly, userId: " + userId + ", isFallback:" + isFallback + ", isMainStream:" + isMainStream);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onRemoteSubscribeFallbackToAudioOnly(userId, isFallback, isMainStream ? NERtcVideoStreamType.kNERtcVideoStreamTypeMain : NERtcVideoStreamType.kNERtcVideoStreamTypeSub));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onRemoteSubscribeFallbackToAudioOnly(userId, isFallback, isMainStream ? NERtcVideoStreamType.kNERtcVideoStreamTypeMain : NERtcVideoStreamType.kNERtcVideoStreamTypeSub));
        }
    }

    @Override
    @CheckCallback
    public void onSwitchChannel(String channelName, int result, String errMsg) {
        Logging.i(TAG, "onSwitchChannel, channelName:" + channelName + ", result:" + result + ", errMsg:" + errMsg);
    }

    @Override
    @CheckCallback
    public void OnVideoReceiveSizeChanged(long userId, int streamType, int width, int height) {
        Logging.i(TAG, "onVideoReceiveSizeChanged, userId:" + userId + " , streamType: " + streamType + ", width: " + width + " , height:" + height);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onRemoteVideoSizeChanged(userId, this.toNeRtcVideoType(streamType), width, height));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onRemoteVideoSizeChanged(userId, this.toNeRtcVideoType(streamType), width, height));
        }
    }

    @Override
    @CheckCallback
    public void OnLocalVideoRenderSizeChanged(int streamType, int width, int height) {
        Logging.i(TAG, "OnLocalVideoRenderSizeChanged, streamType:" + streamType + " , width: " + width + ", height: " + height);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onLocalVideoRenderSizeChanged(this.toNeRtcVideoType(streamType), width, height));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onLocalVideoRenderSizeChanged(this.toNeRtcVideoType(streamType), width, height));
        }
    }

    @Override
    @CheckCallback
    public void onReceiveSEIMessage(long user_id, String data) {
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onRecvSEIMsg(user_id, data));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onRecvSEIMsg(user_id, data));
        }
    }

    @Override
    @CheckCallback
    public void OnMediaRelayStateDidChange(int state, String destChannelName, long destUid) {
        Logging.i(TAG, "OnMediaRelayStateDidChange, state:" + state + ", destChannelName: " + destChannelName + ", destUid: " + destUid);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onMediaRelayStatesChange(state, destChannelName));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onMediaRelayStatesChange(state, destChannelName));
        }
    }

    @Override
    @CheckCallback
    public void OnMediaRelayDidReceiveEvent(int event, int errorCode, String destChannelName, long destUid) {
        Logging.i(TAG, "OnMediaRelayDidReceiveEvent, event:" + event + ", errorCode:" + errorCode + ", destChannelName: " + destChannelName + ", destUid: " + destUid);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onMediaRelayReceiveEvent(event, errorCode, destChannelName));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onMediaRelayReceiveEvent(event, errorCode, destChannelName));
        }
    }

    @Override
    @CheckCallback
    public void onMediaRightDidChanged(boolean isAudioBannedByServer, boolean isVideoBannedByServer) {
        Logging.i(TAG, "onMediaRightDidChanged, isAudioBannedByServer:" + isAudioBannedByServer + ", isVideoBannedByServer:" + isVideoBannedByServer);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onMediaRightChange(isAudioBannedByServer, isVideoBannedByServer));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onMediaRightChange(isAudioBannedByServer, isVideoBannedByServer));
        }
    }

    @Override
    @CheckCallback
    public void onVirtualBackgroundSourceEnabled(boolean enabled, int reason) {
        Logging.i(TAG, "onVirtualBackgroundSourceEnabled, enabled:" + enabled + ", reason:" + reason);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onVirtualBackgroundSourceEnabled(enabled, reason));
        }
    }

    @Override
    @CheckCallback
    public void onLocalVideoEncoderWatermarkState(int streamType, int state) {
        Logging.i(TAG, "onLocalVideoEncoderWatermarkState, streamType:" + streamType + ", state: " + state);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onLocalVideoWatermarkState(streamType == 2 ? NERtcVideoStreamType.kNERtcVideoStreamTypeMain : NERtcVideoStreamType.kNERtcVideoStreamTypeSub, state));
        }
    }

    @Override
    @CheckCallback
    public void onUserDataStart(long userId) {
        Logging.i(TAG, "onUserDataStart, userId:" + userId);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserDataStart(userId));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserDataStart(userId));
        }
    }

    @Override
    @CheckCallback
    public void onUserDataStop(long userId) {
        Logging.i(TAG, "onUserDataStop, userId:" + userId);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserDataStop(userId));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserDataStop(userId));
        }
    }

    @Override
    @CheckCallback
    public void onUserDataReceiveMessage(long userId, ByteBuffer bufferData, long bufferSize) {
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserDataReceiveMessage(userId, bufferData, bufferSize));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserDataReceiveMessage(userId, bufferData, bufferSize));
        }
    }

    @Override
    @CheckCallback
    public void onUserDataStateChanged(long userId) {
        Logging.i(TAG, "onUserDataStateChanged, userId:" + userId);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserDataStateChanged(userId));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserDataStateChanged(userId));
        }
    }

    @Override
    @CheckCallback
    public void onUserDataBufferedAmountChanged(long userId, long previousAmount) {
        Logging.i(TAG, "onUserDataBufferedAmountChanged, userId:" + userId + " , previousAmount: " + previousAmount);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onUserDataBufferedAmountChanged(userId, previousAmount));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onUserDataBufferedAmountChanged(userId, previousAmount));
        }
    }

    @Override
    @CheckCallback
    public void onPermissionKeyWillExpire() {
        Logging.i(TAG, "onPermissionKeyWillExpire");
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onPermissionKeyWillExpire());
        }
    }

    @Override
    @CheckCallback
    public void onUpdatePermissionKey(int errorCode, String data, long timeout_interval) {
        Logging.i(TAG, "onUpdatePermissionKey");
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onUpdatePermissionKey(data, errorCode, (int)timeout_interval));
        }
    }

    @Override
    @CheckCallback
    public void onProbeNetworkQuality(int quality) {
        Logging.i(TAG, "onProbeNetworkQuality, quality:" + quality);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onLastmileQuality(quality));
        }
    }

    @Override
    @CheckCallback
    public void onProbeResult(LiteSDKProbeResult result) {
        Logging.i(TAG, "onProbeResult, result:" + result);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            LastmileProbeResult finalProbeResult;
            LastmileProbeResult probeResult = null;
            if (result != null) {
                probeResult = new LastmileProbeResult();
                probeResult.state = (short)result.type;
                probeResult.rtt = (int)result.rtt;
                if (result.upLinkResult != null) {
                    probeResult.uplinkReport = new LastmileProbeResult.LastmileProbeOneWayResult();
                    probeResult.uplinkReport.packetLossRate = (int)result.upLinkResult.packetLossRate;
                    probeResult.uplinkReport.availableBandwidth = (int)result.upLinkResult.availableBandwidth * 1000;
                    probeResult.uplinkReport.jitter = (int)result.upLinkResult.jitter;
                }
                if (result.downLinkResult != null) {
                    probeResult.downlinkReport = new LastmileProbeResult.LastmileProbeOneWayResult();
                    probeResult.downlinkReport.packetLossRate = (int)result.downLinkResult.packetLossRate;
                    probeResult.downlinkReport.availableBandwidth = (int)result.downLinkResult.availableBandwidth * 1000;
                    probeResult.downlinkReport.jitter = (int)result.downLinkResult.jitter;
                }
            }
            if ((finalProbeResult = probeResult) != null) {
                Logging.i(TAG, "onProbeResult, final result:" + finalProbeResult);
            }
            this.runOnListenerThread(() -> callback.onLastmileProbeResult(finalProbeResult));
        }
    }

    @Override
    @CheckCallback
    public void onLabFeatureCallback(String key, String param) {
        if (!key.equals("asr_caption_result")) {
            Logging.i(TAG, "onLabFeatureCallback, key:" + key + " , param: " + param);
        }
        NERtcCallbackEx callback = this.mCallbackEx;
        if (this.mChannelCallback != null) {
            this.runOnListenerThread(() -> this.mChannelCallback.onLabFeatureCallback(key, param));
        } else if (callback != null && this.mIsMainChannel) {
            this.runOnListenerThread(() -> callback.onLabFeatureCallback(key, param));
        }
    }

    @Override
    public void onStartPushStreaming(int result, long channelId) {
        Logging.i(TAG, "onStartPushStreaming, result:" + result + " , channelId: " + channelId);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onStartPushStreaming(result, channelId));
        }
    }

    @Override
    public void onStopPushStreaming(int result) {
        Logging.i(TAG, "onStopPushStreaming, result:" + result);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onStopPushStreaming(result));
        }
    }

    @Override
    public void onPushStreamingReconnecting(int reason) {
        Logging.i(TAG, "onPushStreamingReconnecting, reason:" + reason);
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onPushStreamingReconnecting(reason));
        }
    }

    @Override
    public void onPushStreamingReconnectedSuccess() {
        Logging.i(TAG, "onPushStreamingReconnectedSuccess");
        NERtcCallbackEx callback = this.mCallbackEx;
        if (callback != null) {
            this.runOnListenerThread(() -> callback.onPushStreamingReconnectedSuccess());
        }
    }

    private NERtcVideoStreamType toNeRtcVideoType(int streamType) {
        NERtcVideoStreamType neRtcVideoStreamType = NERtcVideoStreamType.kNERtcVideoStreamTypeMain;
        switch (streamType) {
            case 2: {
                neRtcVideoStreamType = NERtcVideoStreamType.kNERtcVideoStreamTypeMain;
                break;
            }
            case 3: {
                neRtcVideoStreamType = NERtcVideoStreamType.kNERtcVideoStreamTypeSub;
                break;
            }
        }
        return neRtcVideoStreamType;
    }

    public boolean isMainChannel() {
        return this.mIsMainChannel;
    }

    @Override
    @CheckCallback
    public void onPushStreamingStateUpdate(int state, long cid) {
    }

    @Override
    @CheckCallback
    public void onFirstPacketSentForPushStreaming(int type, long timeMs, String sourceId, long cid) {
    }

    @Override
    @CheckCallback
    public void onSetUserPubStreamTypeError(int errCode, long cid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportNotifyEvent(String event, ReportNotifyTask task) {
        long callBeforeTime = System.nanoTime();
        task.reportEvent();
        Object object = this.mEngineLock;
        synchronized (object) {
            if (NERtcCore.getInstance().getMainChannel() == null) {
                Logging.e(TAG, "report Notify event failed, main channel is null.");
                return;
            }
            if (NERtcCore.getInstance().getMainChannel().getLiteEngine() == null) {
                Logging.e(TAG, "report Notify event failed, lite engine is null.");
                return;
            }
            int ret = NERtcCore.getInstance().getMainChannel().getLiteEngine().reportNotifyConsEvent(event, System.nanoTime() - callBeforeTime);
            if (ret != 0) {
                Logging.w(TAG, "report failed, ret \uff1a " + ret);
            }
        }
    }

    private void runOnListenerThread(Runnable task) {
        Handler handler = this.mCallbackListener;
        if (handler == null) {
            Logging.w(TAG, "handler is null !!!");
            return;
        }
        if (Looper.myLooper() != handler.getLooper()) {
            handler.post(task);
        } else {
            task.run();
        }
    }

    private static interface ReportNotifyTask {
        public void reportEvent();
    }
}

