/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.impl;

import com.netease.lava.nertc.sdk.video.NERtcVideoFrame;
import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.NV21Buffer;
import com.netease.lava.webrtc.RendererCommon;
import com.netease.lava.webrtc.TextureBufferImpl;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.YuvHelper;
import java.nio.ByteBuffer;

public class VideoFrameUtils {
    public static NERtcVideoFrame getNeRTCVideoFrame(VideoFrame videoFrame, boolean textureWithI420, NERtcVideoFrame rtcVideoFrame, ByteBuffer directBuffer) {
        if (videoFrame == null || rtcVideoFrame == null) {
            return null;
        }
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        try {
            if (textureWithI420 && buffer instanceof VideoFrame.TextureBuffer) {
                VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                if (rtcVideoFrame.data == null || rtcVideoFrame.data.length < buffer.getWidth() * buffer.getHeight() * 3 / 2) {
                    Logging.e("VideoEffectUtils", "RTCVideoFrame data length illegal");
                    return null;
                }
                if (i420Buffer == null || directBuffer == null) {
                    return null;
                }
                directBuffer.position(0);
                YuvHelper.I420Copy(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), directBuffer, i420Buffer.getWidth(), i420Buffer.getHeight());
                directBuffer.position(0);
                directBuffer.get(rtcVideoFrame.data);
                i420Buffer.release();
                rtcVideoFrame.textureId = ((TextureBufferImpl)buffer).getTextureId();
                rtcVideoFrame.format = NERtcVideoFrame.Format.TEXTURE_OES;
            } else if (buffer instanceof TextureBufferImpl) {
                rtcVideoFrame.textureId = ((TextureBufferImpl)buffer).getTextureId();
                rtcVideoFrame.format = NERtcVideoFrame.Format.TEXTURE_OES;
            } else if (buffer instanceof VideoFrame.I420Buffer) {
                JavaI420Buffer i420Buffer = (JavaI420Buffer)buffer;
                int chromaHeight = (i420Buffer.getHeight() + 1) / 2;
                int sizeY = i420Buffer.getHeight() * i420Buffer.getStrideY();
                int sizeU = chromaHeight * i420Buffer.getStrideU();
                int sizeV = chromaHeight * i420Buffer.getStrideV();
                if (rtcVideoFrame.data == null || rtcVideoFrame.data.length < sizeY + sizeU + sizeV) {
                    Logging.e("VideoEffectUtils", "RTCVideoFrame data  length : " + rtcVideoFrame.data.length + " YUV:" + (sizeY + sizeU + sizeV));
                    return null;
                }
                i420Buffer.getDataY().get(rtcVideoFrame.data, 0, sizeY);
                i420Buffer.getDataU().get(rtcVideoFrame.data, sizeY, sizeU);
                i420Buffer.getDataV().get(rtcVideoFrame.data, sizeY + sizeU, sizeV);
                rtcVideoFrame.format = NERtcVideoFrame.Format.I420;
            } else if (buffer instanceof NV21Buffer) {
                rtcVideoFrame.data = ((NV21Buffer)buffer).getData();
                rtcVideoFrame.format = NERtcVideoFrame.Format.NV21;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rtcVideoFrame = null;
        }
        return rtcVideoFrame;
    }

    public static NERtcVideoFrame getNeRTCVideoFrame(VideoFrame videoFrame, boolean textureWithI420, NERtcVideoFrame rtcVideoFrame) {
        if (videoFrame == null || rtcVideoFrame == null) {
            return null;
        }
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        try {
            if (textureWithI420 && buffer instanceof VideoFrame.TextureBuffer) {
                VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                int chromaHeight = (i420Buffer.getHeight() + 1) / 2;
                int sizeY = i420Buffer.getHeight() * i420Buffer.getStrideY();
                int sizeU = chromaHeight * i420Buffer.getStrideU();
                int sizeV = chromaHeight * i420Buffer.getStrideV();
                int length = i420Buffer.getWidth() * i420Buffer.getHeight() * 3 / 2;
                if (rtcVideoFrame.data == null || length < sizeY + sizeU + sizeV) {
                    sizeY = i420Buffer.getWidth() * i420Buffer.getHeight();
                    sizeU = i420Buffer.getWidth() * i420Buffer.getHeight() / 4;
                    sizeV = i420Buffer.getWidth() * i420Buffer.getHeight() / 4;
                }
                if (rtcVideoFrame.data == null || rtcVideoFrame.data.length < sizeY + sizeU + sizeV) {
                    Logging.e("VideoEffectUtils", "RTCVideoFrame data  length : " + rtcVideoFrame.data.length + " YUV:" + (sizeY + sizeU + sizeV));
                    return null;
                }
                i420Buffer.getDataY().get(rtcVideoFrame.data, 0, sizeY);
                i420Buffer.getDataU().get(rtcVideoFrame.data, sizeY, sizeU);
                i420Buffer.getDataV().get(rtcVideoFrame.data, sizeY + sizeU, sizeV);
                i420Buffer.release();
                rtcVideoFrame.textureId = ((TextureBufferImpl)buffer).getTextureId();
                rtcVideoFrame.format = NERtcVideoFrame.Format.TEXTURE_OES;
            } else if (buffer instanceof TextureBufferImpl) {
                rtcVideoFrame.textureId = ((TextureBufferImpl)buffer).getTextureId();
                rtcVideoFrame.format = ((TextureBufferImpl)buffer).getType() == VideoFrame.TextureBuffer.Type.OES ? NERtcVideoFrame.Format.TEXTURE_OES : NERtcVideoFrame.Format.TEXTURE_RGB;
                rtcVideoFrame.rotation = videoFrame.getRotation();
                rtcVideoFrame.timeStamp = videoFrame.getTimestampNs();
                rtcVideoFrame.width = videoFrame.getBuffer().getWidth();
                rtcVideoFrame.height = videoFrame.getBuffer().getHeight();
                rtcVideoFrame.transformMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(((TextureBufferImpl)buffer).getTransformMatrix());
            } else if (buffer instanceof VideoFrame.WrapTextureBuffer) {
                rtcVideoFrame.textureId = ((VideoFrame.WrapTextureBuffer)buffer).getTextureId();
                rtcVideoFrame.format = NERtcVideoFrame.Format.TEXTURE_RGB;
                rtcVideoFrame.rotation = videoFrame.getRotation();
                rtcVideoFrame.timeStamp = videoFrame.getTimestampNs();
                rtcVideoFrame.width = videoFrame.getBuffer().getWidth();
                rtcVideoFrame.height = videoFrame.getBuffer().getHeight();
                rtcVideoFrame.transformMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(((VideoFrame.WrapTextureBuffer)buffer).getTransformMatrix());
            } else if (buffer instanceof VideoFrame.I420Buffer) {
                VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)buffer;
                int chromaHeight = (i420Buffer.getHeight() + 1) / 2;
                int sizeY = i420Buffer.getHeight() * i420Buffer.getStrideY();
                int sizeU = chromaHeight * i420Buffer.getStrideU();
                int sizeV = chromaHeight * i420Buffer.getStrideV();
                if (rtcVideoFrame.data == null || rtcVideoFrame.data.length < sizeY + sizeU + sizeV) {
                    Logging.e("VideoEffectUtils", "RTCVideoFrame data  length : " + rtcVideoFrame.data.length + " YUV:" + (sizeY + sizeU + sizeV));
                    return null;
                }
                i420Buffer.getDataY().get(rtcVideoFrame.data, 0, sizeY);
                i420Buffer.getDataU().get(rtcVideoFrame.data, sizeY, sizeU);
                i420Buffer.getDataV().get(rtcVideoFrame.data, sizeY + sizeU, sizeV);
                rtcVideoFrame.format = NERtcVideoFrame.Format.I420;
            } else if (buffer instanceof NV21Buffer) {
                rtcVideoFrame.data = ((NV21Buffer)buffer).getData();
                rtcVideoFrame.format = NERtcVideoFrame.Format.NV21;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rtcVideoFrame = null;
        }
        return rtcVideoFrame;
    }

    public static VideoFrame getWebRtcVideoFrame(NERtcVideoFrame rtcVideoFrame, VideoFrame originFrame) {
        if (rtcVideoFrame == null || originFrame == null) {
            return null;
        }
        VideoFrame webRTCVideoFrame = null;
        try {
            switch (rtcVideoFrame.format) {
                case TEXTURE_RGB: {
                    ((TextureBufferImpl)originFrame.getBuffer()).setTextureId(rtcVideoFrame.textureId);
                    ((TextureBufferImpl)originFrame.getBuffer()).setType(VideoFrame.TextureBuffer.Type.RGB);
                    webRTCVideoFrame = originFrame;
                    break;
                }
                case TEXTURE_OES: {
                    ((TextureBufferImpl)originFrame.getBuffer()).setTextureId(rtcVideoFrame.textureId);
                    ((TextureBufferImpl)originFrame.getBuffer()).setType(VideoFrame.TextureBuffer.Type.OES);
                    webRTCVideoFrame = originFrame;
                    break;
                }
                case I420: {
                    int width = rtcVideoFrame.width;
                    int height = rtcVideoFrame.height;
                    int chromaHeight = (height + 1) / 2;
                    int strideUV = (width + 1) / 2;
                    int yPos = 0;
                    int uPos = yPos + width * height;
                    int vPos = uPos + strideUV * chromaHeight;
                    int lenth = width * height + 2 * strideUV * chromaHeight;
                    if (rtcVideoFrame.data == null || rtcVideoFrame.data.length < lenth) {
                        Logging.e("VideoEffectUtils", "RTCVideoFrame data length: " + rtcVideoFrame.data.length + " i420 buffer length: " + lenth);
                        break;
                    }
                    JavaI420Buffer filteredI420Buffer = JavaI420Buffer.allocate(width, height);
                    filteredI420Buffer.getDataY().put(rtcVideoFrame.data, yPos, width * height);
                    filteredI420Buffer.getDataU().put(rtcVideoFrame.data, uPos, strideUV * chromaHeight);
                    filteredI420Buffer.getDataV().put(rtcVideoFrame.data, vPos, strideUV * chromaHeight);
                    webRTCVideoFrame = new VideoFrame(filteredI420Buffer, rtcVideoFrame.rotation, rtcVideoFrame.timeStamp);
                    break;
                }
                case NV21: {
                    int width = rtcVideoFrame.width;
                    int height = rtcVideoFrame.height;
                    NV21Buffer nv21Buffer = new NV21Buffer(rtcVideoFrame.data, width, height, null);
                    webRTCVideoFrame = new VideoFrame(nv21Buffer, rtcVideoFrame.rotation, rtcVideoFrame.timeStamp);
                    break;
                }
                default: {
                    Logging.w("VideoFrameUtils", "VideoFrame format:" + (Object)((Object)rtcVideoFrame.format));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            webRTCVideoFrame = null;
        }
        return webRTCVideoFrame;
    }
}

