/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.impl.channel;

import android.content.Intent;
import android.media.projection.MediaProjection;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.text.TextUtils;
import com.netease.lava.api.IVideoRender;
import com.netease.lava.nertc.impl.NERtcSinkWrapper;
import com.netease.lava.nertc.impl.lite.LiteHelper;
import com.netease.lava.nertc.impl.live.NERtcLiveStreamCallbackWrapper;
import com.netease.lava.nertc.impl.live.NERtcLiveStreamHelper;
import com.netease.lava.nertc.impl.stats.NERtcStatsObserverWrapper;
import com.netease.lava.nertc.impl.wrapper.NERtcSnapshotCallbackWrapper;
import com.netease.lava.nertc.sdk.LastmileProbeConfig;
import com.netease.lava.nertc.sdk.NERtcCallback;
import com.netease.lava.nertc.sdk.NERtcDataExternalFrame;
import com.netease.lava.nertc.sdk.NERtcExternalVideoRenderer;
import com.netease.lava.nertc.sdk.NERtcJoinChannelOptions;
import com.netease.lava.nertc.sdk.NERtcMediaRelayParam;
import com.netease.lava.nertc.sdk.audio.NERtcAudioExternalFrame;
import com.netease.lava.nertc.sdk.audio.NERtcAudioProcessObserver;
import com.netease.lava.nertc.sdk.audio.NERtcAudioStreamType;
import com.netease.lava.nertc.sdk.audio.NERtcDistanceRolloffModel;
import com.netease.lava.nertc.sdk.audio.NERtcPositionInfo;
import com.netease.lava.nertc.sdk.audio.NERtcRangeAudioMode;
import com.netease.lava.nertc.sdk.audio.NERtcSpatializerRenderMode;
import com.netease.lava.nertc.sdk.audio.NERtcSpatializerRoomProperty;
import com.netease.lava.nertc.sdk.channel.NERtcChannel;
import com.netease.lava.nertc.sdk.channel.NERtcChannelCallback;
import com.netease.lava.nertc.sdk.encryption.NERtcEncryptionConfig;
import com.netease.lava.nertc.sdk.live.AddLiveTaskCallback;
import com.netease.lava.nertc.sdk.live.DeleteLiveTaskCallback;
import com.netease.lava.nertc.sdk.live.NERtcLiveStreamTaskInfo;
import com.netease.lava.nertc.sdk.live.UpdateLiveTaskCallback;
import com.netease.lava.nertc.sdk.stats.NERtcStatsObserver;
import com.netease.lava.nertc.sdk.video.NERtcCameraCaptureConfig;
import com.netease.lava.nertc.sdk.video.NERtcExternalVideoRendererWrapper;
import com.netease.lava.nertc.sdk.video.NERtcRemoteVideoStreamType;
import com.netease.lava.nertc.sdk.video.NERtcScreenConfig;
import com.netease.lava.nertc.sdk.video.NERtcTakeSnapshotCallback;
import com.netease.lava.nertc.sdk.video.NERtcTextureView;
import com.netease.lava.nertc.sdk.video.NERtcVideoConfig;
import com.netease.lava.nertc.sdk.video.NERtcVideoFrame;
import com.netease.lava.nertc.sdk.video.NERtcVideoStreamType;
import com.netease.lava.nertc.sdk.video.NERtcVideoView;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.EglBase14Impl;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.RendererCommon;
import com.netease.lava.webrtc.SurfaceViewRenderer;
import com.netease.lava.webrtc.TextureBufferImpl;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.YuvConverter;
import com.netease.lava.webrtc.YuvHelper;
import com.netease.yunxin.lite.LiteEngine;
import com.netease.yunxin.lite.LiteEngineCenter;
import com.netease.yunxin.lite.LiteProbeEngine;
import com.netease.yunxin.lite.model.LiteSDKEngineConfig;
import com.netease.yunxin.lite.model.LiteSDKEngineParameter;
import com.netease.yunxin.lite.model.LiteSDKProbeConfig;
import com.netease.yunxin.lite.model.LiteSDKVideoCanvas;
import com.netease.yunxin.lite.util.CommonUtils;
import com.netease.yunxin.lite.util.LiteYuvHelper;
import com.netease.yunxin.lite.util.LooperUtils;
import com.netease.yunxin.lite.util.ThreadUtils;
import com.netease.yunxin.lite.video.VideoViewActionListener;
import com.netease.yunxin.lite.video.render.TextureViewRenderer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class RtcChannelImpl
extends NERtcChannel
implements VideoViewActionListener {
    private String TAG;
    private String mChannelName;
    private LiteEngine mLiteEngine;
    private LiteProbeEngine mProbeEngine;
    private final List<RtcChannelImpl> mChannelList;
    private final Object mEngineLock = new Object();
    private final NERtcSinkWrapper mSinkWrapper = new NERtcSinkWrapper();
    private String permissionSecretKey;
    private final HashMap<NERtcVideoStreamType, ExternalVideoInfo> mExternalVideoMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtcChannelImpl(String channelName, NERtcCallback callback, boolean isMain, List<RtcChannelImpl> channelList, Object engineLock) {
        this.TAG = "RtcChannelImpl_" + channelName;
        Logging.i(this.TAG, "new RtcChannelImpl");
        this.mChannelName = channelName;
        Object object = this.mEngineLock;
        synchronized (object) {
            this.mLiteEngine = LiteEngineCenter.createEngine(new LiteSDKEngineConfig(), this.mSinkWrapper);
            this.mLiteEngine.initialize(new LiteSDKEngineParameter());
            this.mSinkWrapper.setCallback(callback, isMain);
            this.mSinkWrapper.setEngineLock(engineLock);
        }
        this.mChannelList = channelList;
        this.mChannelList.add(this);
    }

    public void setChannelName(String channelName) {
        this.TAG = "RtcChannelImpl_" + channelName;
        this.mChannelName = channelName;
    }

    public LiteEngine getLiteEngine() {
        return this.mLiteEngine;
    }

    @Override
    public String getChannelName() {
        if (this.engineIsNull(null)) {
            return this.mChannelName;
        }
        String engineChannelName = this.mLiteEngine.getChannelName();
        return TextUtils.isEmpty((CharSequence)engineChannelName) ? this.mChannelName : engineChannelName;
    }

    public int setAudioProcessObserver(NERtcAudioProcessObserver audioProcessObserver) {
        Logging.i(this.TAG, "setAudioProcessObserver, observer:" + audioProcessObserver);
        this.mSinkWrapper.setAudioProcessObserver(audioProcessObserver);
        return 0;
    }

    private boolean isChannelJoinedWithUserId(String channelName, long userId) {
        if (this.engineIsNull(null)) {
            return false;
        }
        return this.mLiteEngine.isChannelJoinedWithUserId(channelName, userId);
    }

    public boolean checkHasJoined(String channelName, long userId) {
        for (RtcChannelImpl channel : this.mChannelList) {
            if (!channel.isChannelJoinedWithUserId(channelName, userId)) continue;
            return true;
        }
        return false;
    }

    public long getMainChannelUid() {
        if (this.mChannelList.size() > 0) {
            return this.mChannelList.get(0).getChannelUid();
        }
        return 0L;
    }

    private long getChannelUid() {
        return this.mLiteEngine.getMainChannelUid();
    }

    @Override
    public void setChannelCallback(NERtcChannelCallback channelCallback) {
        Logging.i(this.TAG, "setChannelCallback: " + channelCallback);
        this.mSinkWrapper.setChannelCallback(channelCallback);
    }

    @Override
    public void setChannelCallbackHandler(Handler callbackHandler) {
        Logging.i(this.TAG, "setChannelListenerHandler: " + callbackHandler);
        this.mSinkWrapper.setCallbackHandler(callbackHandler);
    }

    @Override
    public void setStatsObserver(NERtcStatsObserver statsObserver) {
        if (this.engineIsNull("setStatsObserver")) {
            return;
        }
        this.mLiteEngine.setMediaStatsObserver(statsObserver == null ? null : new NERtcStatsObserverWrapper(statsObserver));
    }

    @Override
    public int setChannelProfile(int channelProfile) {
        if (this.engineIsNull("setChannelProfile")) {
            return 30005;
        }
        return this.mLiteEngine.setChannelProfile(channelProfile);
    }

    @Override
    public int joinChannel(String token) {
        return this.joinChannel(token, this.getMainChannelUid(), null);
    }

    @Override
    public int joinChannel(String token, long userId) {
        return this.joinChannel(token, userId, null);
    }

    @Override
    public int joinChannel(String token, long userId, NERtcJoinChannelOptions channelOptions) {
        Logging.i(this.TAG, "joinChannel, token:" + token + ", channelName:" + this.mChannelName + ", uid:" + userId + "channelOptions:" + (channelOptions != null ? channelOptions.toString() : ""));
        if (this.engineIsNull("joinChannel")) {
            return 30005;
        }
        if (this.checkHasJoined(this.mChannelName, userId)) {
            Logging.e(this.TAG, "channel: " + this.mChannelName + " has already joined with: " + userId);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("cname", (Object)this.mChannelName);
                jsonObject.put("local_uid", userId);
                jsonObject.put("token", (Object)token);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.mLiteEngine.reportApiEvent("joinChannel", 30004, jsonObject.toString());
            return 30004;
        }
        if (this.mProbeEngine != null && this.mProbeEngine.getConnectionState() != 0) {
            String errorInfo = "engine is in probe status";
            Logging.e(this.TAG, errorInfo);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("errorInfo", (Object)errorInfo);
                jsonObject.put("channelName", (Object)this.mChannelName);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.mLiteEngine.reportApiEvent("joinChannel", 30005, jsonObject.toString());
            return 30005;
        }
        return this.mLiteEngine.join(LiteHelper.getLiteJoinParameter(token, this.mChannelName, userId, channelOptions));
    }

    @Override
    public int updatePermissionKey(String key) {
        if (this.engineIsNull("updatePermissionKey")) {
            return 30005;
        }
        this.permissionSecretKey = key;
        return this.mLiteEngine.updatePermissionKey(key);
    }

    @Override
    public int leaveChannel() {
        if (this.engineIsNull("leaveChannel")) {
            return 30005;
        }
        return this.mLiteEngine.leave();
    }

    @Override
    public int enableLocalAudio(boolean enable) {
        if (this.engineIsNull("enableLocalAudio ,enable: " + enable)) {
            return 30005;
        }
        return this.mLiteEngine.enableLocalAudio(enable, 0);
    }

    @Override
    public int enableMediaPub(int mediaType, boolean enable) {
        if (this.engineIsNull("enableMediaPub , mediaType: " + mediaType + " ,enable: " + enable)) {
            return 30005;
        }
        return this.mLiteEngine.enableMediaPub(enable, mediaType);
    }

    @Override
    public int muteLocalAudioStream(boolean mute) {
        if (this.engineIsNull("muteLocalAudioStream, mute: " + mute)) {
            return 30005;
        }
        return this.mLiteEngine.muteLocalAudio(mute, 0);
    }

    @Override
    public int subscribeRemoteAudioStream(long uid, boolean subscribe) {
        if (this.engineIsNull("subscribeRemoteAudioStream uid: " + uid + " ,subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mLiteEngine.subscribeRemoteAudio(subscribe, uid, 0);
    }

    @Override
    public int subscribeAllRemoteAudioStreams(boolean subscribe) {
        if (this.engineIsNull("subscribeAllRemoteAudioStreams subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mLiteEngine.subscribeAllRemoteAudio(subscribe);
    }

    @Override
    public int setCameraCaptureConfig(NERtcCameraCaptureConfig captureConfig) {
        return this.setCameraCaptureConfig(captureConfig, null);
    }

    @Override
    public int setCameraCaptureConfig(NERtcCameraCaptureConfig captureConfig, NERtcVideoStreamType streamType) {
        if (this.engineIsNull("setCameraCaptureConfig captureConfig: " + captureConfig + " ,streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        if (captureConfig == null) {
            this.mLiteEngine.reportApiEvent("setCameraCaptureConfig", 30003, null);
            return 30003;
        }
        return this.mLiteEngine.setCameraCaptureConfig(LiteHelper.getLiteCameraConfig(captureConfig), LiteHelper.getLiteMediaStreamType(streamType));
    }

    @Override
    public int setLocalVideoConfig(NERtcVideoConfig videoConfig) {
        return this.setLocalVideoConfig(videoConfig, null);
    }

    @Override
    public int setLocalVideoConfig(NERtcVideoConfig videoConfig, NERtcVideoStreamType streamType) {
        if (this.engineIsNull("setLocalVideoConfig: " + videoConfig + " ,streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        if (videoConfig == null) {
            this.mLiteEngine.reportApiEvent("setLocalVideoConfig", 30003, null);
            return 30003;
        }
        return this.mLiteEngine.setVideoEncoderConfig(LiteHelper.getLiteVideoConfig(videoConfig), LiteHelper.getLiteMediaStreamType(streamType));
    }

    @Override
    public int enableDualStreamMode(boolean enable) {
        Logging.i(this.TAG, "enableDualStreamMode: " + enable);
        if (this.engineIsNull("enableDualStreamMode: " + enable)) {
            return 30005;
        }
        return this.mLiteEngine.enableDualStreamMode(enable);
    }

    @Override
    public int setupLocalVideoCanvas(IVideoRender render) {
        String logMsg = "setupLocalVideoCanvas: " + render;
        if (this.engineIsNull(logMsg)) {
            return 30005;
        }
        Logging.i(this.TAG, logMsg);
        LiteSDKVideoCanvas canvas = this.createLiteSDKVideoCanvas(render, "0_video");
        if (render != null) {
            render.setViewActionListener(this, 2);
        }
        canvas.useExternalRender = false;
        return this.mLiteEngine.setupLocalCanvas(2, canvas);
    }

    @Override
    public int setupRemoteVideoCanvas(IVideoRender render, long uid) {
        String logMsg = "setupRemoteVideoCanvas render: " + render + " uid: " + uid;
        if (this.engineIsNull(logMsg)) {
            return 30005;
        }
        Logging.i(this.TAG, logMsg);
        LiteSDKVideoCanvas canvas = this.createLiteSDKVideoCanvas(render, uid + "_video");
        canvas.useExternalRender = false;
        return this.mLiteEngine.setupRemoteCanvas(uid, 2, canvas);
    }

    @Override
    public int enableLocalVideo(boolean enable) {
        return this.enableLocalVideo(null, enable);
    }

    @Override
    public int enableLocalVideo(NERtcVideoStreamType streamType, boolean enable) {
        if (this.engineIsNull("enableLocalVideo: " + enable + " ,streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mLiteEngine.enableLocalVideo(enable, LiteHelper.getLiteMediaStreamType(streamType));
    }

    @Override
    public int muteLocalVideoStream(boolean mute) {
        return this.muteLocalVideoStream(mute, null);
    }

    @Override
    public int muteLocalVideoStream(boolean mute, NERtcVideoStreamType streamType) {
        if (this.engineIsNull("muteLocalVideoStream: ,streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mLiteEngine.muteLocalVideo(mute, LiteHelper.getLiteMediaStreamType(streamType));
    }

    @Override
    public int setupLocalSubStreamVideoCanvas(IVideoRender render) {
        if (this.engineIsNull("setupLocalSubStreamVideoCanvas: " + render)) {
            return 30005;
        }
        Logging.i(this.TAG, "setupLocalSubStreamVideoCanvas render: " + render);
        LiteSDKVideoCanvas canvas = this.createLiteSDKVideoCanvas(render, "0_screen");
        if (render != null) {
            render.setViewActionListener(this, 3);
        }
        canvas.useExternalRender = false;
        return this.mLiteEngine.setupLocalCanvas(3, canvas);
    }

    @Override
    public int setupRemoteSubStreamVideoCanvas(IVideoRender render, long uid) {
        String logMsg = "setupRemoteSubStreamVideoCanvas render: " + render + " uid: " + uid;
        if (this.engineIsNull(logMsg)) {
            return 30005;
        }
        Logging.i(this.TAG, logMsg);
        LiteSDKVideoCanvas canvas = this.createLiteSDKVideoCanvas(render, uid + "_screen");
        canvas.useExternalRender = false;
        return this.mLiteEngine.setupRemoteCanvas(uid, 3, canvas);
    }

    @Override
    public int setLocalExternalVideoRenderer(NERtcVideoStreamType streamType, NERtcExternalVideoRenderer renderer) {
        String logMsg = "setLocalExternalVideoRenderer streamType=" + (Object)((Object)streamType) + ", renderer=" + CommonUtils.getHashCode(renderer);
        if (this.engineIsNull(logMsg)) {
            return 30005;
        }
        Logging.i(this.TAG, logMsg);
        NERtcExternalVideoRendererWrapper videoRender = null;
        if (renderer != null) {
            videoRender = new NERtcExternalVideoRendererWrapper(renderer);
        }
        LiteSDKVideoCanvas canvas = this.createLiteSDKVideoCanvas(videoRender, "0_video");
        int ret = this.mLiteEngine.setupLocalCanvas(LiteHelper.getLiteMediaStreamType(streamType), canvas);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("streamType", (Object)LiteHelper.getVideoStreamTypeString(streamType));
            jsonObject.put("renderer", (Object)CommonUtils.getHashCode(renderer));
            jsonObject.put("bufferType", LiteHelper.getBufferType(videoRender));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.mLiteEngine.reportApiEvent("setLocalExternalVideoRenderer", ret, jsonObject.toString());
        return ret;
    }

    @Override
    public int setRemoteExternalVideoRenderer(NERtcVideoStreamType streamType, long uid, NERtcExternalVideoRenderer renderer) {
        String logMsg = "setRemoteExternalVideoRenderer streamType=" + (Object)((Object)streamType) + ", uid=" + uid + ", renderer=" + CommonUtils.getHashCode(renderer);
        if (this.engineIsNull(logMsg)) {
            return 30005;
        }
        Logging.i(this.TAG, logMsg);
        NERtcExternalVideoRendererWrapper videoRender = null;
        if (renderer != null) {
            videoRender = new NERtcExternalVideoRendererWrapper(renderer);
        }
        LiteSDKVideoCanvas canvas = this.createLiteSDKVideoCanvas(videoRender, "0_video");
        int ret = this.mLiteEngine.setupRemoteCanvas(uid, LiteHelper.getLiteMediaStreamType(streamType), canvas);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("streamType", (Object)LiteHelper.getVideoStreamTypeString(streamType));
            jsonObject.put("uid", uid);
            jsonObject.put("renderer", (Object)CommonUtils.getHashCode(renderer));
            jsonObject.put("bufferType", LiteHelper.getBufferType(videoRender));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.mLiteEngine.reportApiEvent("setRemoteExternalVideoRenderer", ret, jsonObject.toString());
        return ret;
    }

    @Override
    public int switchCamera() {
        if (this.engineIsNull("switchCamera")) {
            return 30005;
        }
        return this.mLiteEngine.switchCamera();
    }

    @Override
    public int switchCameraWithPosition(int cameraPos) {
        if (this.engineIsNull("switchCameraWithPosition, pos: " + cameraPos)) {
            return 30005;
        }
        return this.mLiteEngine.switchCameraWithPosition(cameraPos);
    }

    @Override
    public int startScreenCapture(NERtcScreenConfig screenConfig, Intent intent, MediaProjection.Callback callback) {
        if (intent == null) {
            Logging.e(this.TAG, "startScreenCapture error invalid param! intent is null");
            return 30003;
        }
        if (this.engineIsNull("startScreenCapture screenConfig:" + screenConfig + " , intent: " + intent + " , callback: " + callback)) {
            return 30005;
        }
        return this.mLiteEngine.startScreenCapture(LiteHelper.getLiteSubStreamConfig(screenConfig, intent, callback));
    }

    @Override
    public void stopScreenCapture() {
        Logging.i(this.TAG, "stopScreenCapture");
        if (this.mLiteEngine != null) {
            this.mLiteEngine.stopScreenCapture();
        }
    }

    @Override
    public int enableLoopbackRecording(boolean enable, Intent intent, MediaProjection.Callback callback) {
        if (this.engineIsNull("enableLoopbackRecording, enable: " + enable + " intent: " + intent + " callback: " + callback)) {
            return 30005;
        }
        return this.mLiteEngine.enableLoopbackRecording(enable, intent, callback);
    }

    @Override
    public int adjustLoopBackRecordingSignalVolume(int volume) {
        if (this.engineIsNull("adjustLoopBackRecordingSignalVolume, volume: " + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(this.TAG, "adjustLoopBackRecordingSignalVolume invalid param with volume: " + volume);
            return 30003;
        }
        return this.mLiteEngine.adjustLoopbackRecordingSignalVolume(volume);
    }

    @Override
    public int subscribeRemoteVideoStream(long uid, NERtcRemoteVideoStreamType streamType, boolean subscribe) {
        if (this.engineIsNull("subscribeRemoteVideoStream uid: " + uid + " NERtcRemoteVideoStreamType: " + (Object)((Object)streamType) + " subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mLiteEngine.subscribeRemoteVideo(subscribe, streamType == null ? 0 : streamType.ordinal(), 2, uid);
    }

    @Override
    public int subscribeRemoteSubStreamVideo(long uid, boolean subscribe) {
        Logging.i(this.TAG, "subscribeRemoteSubStreamVideo, uid: " + uid + " subscribe: " + subscribe);
        if (this.engineIsNull("subscribeRemoteSubStreamVideo, uid: " + uid + " subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mLiteEngine.subscribeRemoteVideo(subscribe, 0, 3, uid);
    }

    @Override
    public int setExternalVideoSource(boolean enable) {
        return this.setExternalVideoSource(null, enable);
    }

    @Override
    public int setExternalVideoSource(NERtcVideoStreamType streamType, boolean enable) {
        if (this.engineIsNull("setExternalVideoSource, enable: " + enable + ", streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        int ret = this.mLiteEngine.setExternalVideoSource(enable, LiteHelper.getLiteMediaStreamType(streamType));
        if (enable) {
            if (ret == 0) {
                this.createExternalVideo(streamType);
            }
        } else {
            this.releaseExternalVideo(streamType);
        }
        return ret;
    }

    @Override
    public boolean pushExternalVideoFrame(NERtcVideoFrame frame) {
        return this.pushExternalVideoFrame(null, frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushExternalVideoFrame(NERtcVideoStreamType streamType, NERtcVideoFrame frame) {
        Object object = this.mEngineLock;
        synchronized (object) {
            ExternalVideoInfo externalVideoInfo = this.mExternalVideoMap.get((Object)streamType);
            if (this.engineIsNull("pushExternalVideoFrame") || externalVideoInfo == null) {
                return false;
            }
            switch (frame.format) {
                case I420: {
                    break;
                }
                case NV21: 
                case RGBA: {
                    if (externalVideoInfo.rawI420 == null || externalVideoInfo.rawI420.length != frame.width * frame.height * 3 / 2) {
                        externalVideoInfo.rawI420 = new byte[frame.width * frame.height * 3 / 2];
                    }
                    LiteYuvHelper.nativeToI420(frame.data, frame.format == NERtcVideoFrame.Format.RGBA ? 4 : 2, frame.width, frame.height, externalVideoInfo.rawI420);
                    frame.data = externalVideoInfo.rawI420;
                    frame.format = NERtcVideoFrame.Format.I420;
                    break;
                }
                case TEXTURE_OES: 
                case TEXTURE_RGB: {
                    VideoFrame.TextureBuffer.Type textureType;
                    TextureBufferImpl buffer;
                    VideoFrame.I420Buffer i420Buffer;
                    if (externalVideoInfo.eglHandler == null) {
                        if (Looper.myLooper() == null) {
                            externalVideoInfo.eglThread = new HandlerThread("NERtc_External_GLThread");
                            externalVideoInfo.eglThread.start();
                            externalVideoInfo.eglHandler = new Handler(externalVideoInfo.eglThread.getLooper());
                            externalVideoInfo.yuvConverter = new YuvConverter();
                            EGLContext currentEglContext = EGL14.eglGetCurrentContext();
                            ThreadUtils.runOnThreadBlocking(externalVideoInfo.eglHandler, () -> {
                                if (externalVideoInfo.externalEglBase == null) {
                                    externalVideoInfo.externalEglBase = EglBase.create((EglBase.Context)new EglBase14Impl.Context(currentEglContext), EglBase.ConfigType.kConfigType_PIXEL_BUFFER);
                                    externalVideoInfo.externalEglBase.createDummyPbufferSurface();
                                    externalVideoInfo.externalEglBase.makeCurrent();
                                }
                            });
                        } else {
                            externalVideoInfo.eglHandler = new Handler();
                            externalVideoInfo.yuvConverter = new YuvConverter();
                        }
                    }
                    if ((i420Buffer = (buffer = new TextureBufferImpl(frame.width, frame.height, textureType = frame.format == NERtcVideoFrame.Format.TEXTURE_RGB ? VideoFrame.TextureBuffer.Type.RGB : VideoFrame.TextureBuffer.Type.OES, frame.textureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(frame.transformMatrix), externalVideoInfo.eglHandler, externalVideoInfo.yuvConverter, null)).toI420()) == null) {
                        return false;
                    }
                    if (externalVideoInfo.byteBuffer == null || externalVideoInfo.byteBuffer.limit() != buffer.getWidth() * buffer.getHeight() * 3 / 2) {
                        externalVideoInfo.byteBuffer = ByteBuffer.allocateDirect(buffer.getWidth() * buffer.getHeight() * 3 / 2);
                        externalVideoInfo.rawI420 = new byte[externalVideoInfo.byteBuffer.capacity()];
                    }
                    externalVideoInfo.byteBuffer.position(0);
                    YuvHelper.I420Copy(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), externalVideoInfo.byteBuffer, frame.width, frame.height);
                    externalVideoInfo.byteBuffer.position(0);
                    externalVideoInfo.byteBuffer.get(externalVideoInfo.rawI420);
                    frame.data = externalVideoInfo.rawI420;
                    i420Buffer.release();
                    buffer.release();
                    frame.format = NERtcVideoFrame.Format.I420;
                    break;
                }
            }
            return this.mLiteEngine.pushExternalVideoFrame(LiteHelper.getLiteMediaStreamType(streamType), frame.data, frame.width, frame.height, frame.rotation, System.currentTimeMillis()) == 0;
        }
    }

    public int setExternalAudioSource(boolean enabled, int sampleRate, int channels) {
        if (this.engineIsNull("setExternalAudioSource, enable:" + enabled + ", sampleRate:" + sampleRate + ", channels:" + channels)) {
            return 30005;
        }
        if (sampleRate < 0 || channels < 0) {
            Logging.e(this.TAG, "setExternalAudioSource invalid param with sampleRate: " + sampleRate + ", channels: " + channels);
            return 30003;
        }
        return this.mLiteEngine.setExternalAudioSource(enabled, sampleRate, channels, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pushExternalAudioFrame(NERtcAudioExternalFrame frame, int type) {
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.engineIsNull("pushExternalAudioFrame")) {
                return 30005;
            }
            if (frame == null) {
                Logging.e(this.TAG, "frame is null");
                return 30003;
            }
            return this.mLiteEngine.pushExternalAudioFrame(frame.audioData, frame.samplesPerChannel, frame.sampleRate, frame.numberOfChannels, frame.syncTimestamp, type);
        }
    }

    public int getCurrentCamera() {
        if (this.engineIsNull(null)) {
            return 30005;
        }
        return this.mLiteEngine.getCurrentCamera();
    }

    @Override
    public int setClientRole(int role) {
        if (this.engineIsNull("setClientRole: " + role)) {
            return 30005;
        }
        return this.mLiteEngine.setUserRole(role);
    }

    @Override
    public int getConnectionState() {
        if (this.engineIsNull(null)) {
            return 0;
        }
        return LiteHelper.liteChannelStateToSDK(this.mLiteEngine.getConnectionState());
    }

    @Override
    public int addLiveStreamTask(NERtcLiveStreamTaskInfo taskInfo, AddLiveTaskCallback addLiveTaskCallback) {
        if (this.engineIsNull("addLiveStreamTask taskInfo:" + taskInfo + " \uff0ccallback: " + addLiveTaskCallback)) {
            return 30005;
        }
        return this.mLiteEngine.addLiveStreamTask(NERtcLiveStreamHelper.convertLiveStreamTaskInfo(taskInfo), new NERtcLiveStreamCallbackWrapper(addLiveTaskCallback));
    }

    @Override
    public int updateLiveStreamTask(NERtcLiveStreamTaskInfo taskInfo, UpdateLiveTaskCallback updateLiveTaskCallback) {
        if (this.engineIsNull("updateLiveStreamTask taskInfo:" + taskInfo + " \uff0ccallback: " + updateLiveTaskCallback)) {
            return 30005;
        }
        return this.mLiteEngine.updateLiveStreamTask(NERtcLiveStreamHelper.convertLiveStreamTaskInfo(taskInfo), new NERtcLiveStreamCallbackWrapper(updateLiveTaskCallback));
    }

    @Override
    public int removeLiveStreamTask(String taskId, DeleteLiveTaskCallback deleteLiveTaskCallback) {
        if (this.engineIsNull("removeLiveStreamTask taskId:" + taskId + " \uff0ccallback: " + deleteLiveTaskCallback)) {
            return 30005;
        }
        return this.mLiteEngine.removeLiveStreamTask(taskId, new NERtcLiveStreamCallbackWrapper(deleteLiveTaskCallback));
    }

    @Override
    public int sendSEIMsg(String seiMsg, NERtcVideoStreamType streamType) {
        if (this.engineIsNull("sendSEIMsg:" + seiMsg + " streamType: " + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mLiteEngine.sendSEIMessage(seiMsg, LiteHelper.getLiteMediaStreamType(streamType));
    }

    @Override
    public int sendSEIMsg(String seiMsg) {
        if (this.engineIsNull("sendSEIMsg:" + seiMsg)) {
            return 30005;
        }
        return this.mLiteEngine.sendSEIMessage(seiMsg, 2);
    }

    @Override
    public int takeLocalSnapshot(NERtcVideoStreamType streamType, NERtcTakeSnapshotCallback callback) {
        if (this.engineIsNull("takeLocalSnapshot streamType: " + (Object)((Object)streamType) + " ,callback: " + callback)) {
            return 30005;
        }
        if (callback == null) {
            Logging.e(this.TAG, "takeLocalSnapshot failed! callback is null");
            return 30003;
        }
        return this.mLiteEngine.takeLocalSnapshot(LiteHelper.getLiteMediaStreamType(streamType), new NERtcSnapshotCallbackWrapper(callback));
    }

    @Override
    public int takeRemoteSnapshot(long uid, NERtcVideoStreamType streamType, NERtcTakeSnapshotCallback callback) {
        if (this.engineIsNull("takeRemoteSnapshot uid: " + uid + " ,streamType: " + (Object)((Object)streamType) + " ,callback: " + callback)) {
            return 30005;
        }
        if (callback == null) {
            Logging.e(this.TAG, "takeRemoteSnapshot failed! callback is null");
            return 30003;
        }
        return this.mLiteEngine.takeRemoteSnapshot(uid, LiteHelper.getLiteMediaStreamType(streamType), new NERtcSnapshotCallbackWrapper(callback));
    }

    @Override
    public int setLocalMediaPriority(int priority, boolean isPreemptive) {
        if (this.engineIsNull("setLocalMediaPriority priority: " + priority + " ,isPreemptive: " + isPreemptive)) {
            return 30005;
        }
        return this.mLiteEngine.setLocalMediaPriority(priority, isPreemptive);
    }

    @Override
    public int startChannelMediaRelay(NERtcMediaRelayParam.ChannelMediaRelayConfiguration config) {
        if (this.engineIsNull("startChannelMediaRelay config: " + config)) {
            return 30005;
        }
        if (config == null) {
            Logging.e(this.TAG, "startChannelMediaRelay failed! config is null");
            this.mLiteEngine.reportApiEvent("startChannelMediaRelay", 30003, null);
            return 30003;
        }
        Map<String, NERtcMediaRelayParam.ChannelMediaRelayInfo> dstConfig = config.getDstMediaInfo();
        if (dstConfig == null || dstConfig.isEmpty()) {
            Logging.e(this.TAG, "startChannelMediaRelay failed! getDstMediaInfo is empty");
            this.mLiteEngine.reportApiEvent("startChannelMediaRelay", 30003, null);
            return 30003;
        }
        return this.mLiteEngine.startMediaRelayInfos(LiteHelper.getLiteMediaRelay(dstConfig));
    }

    @Override
    public int updateChannelMediaRelay(NERtcMediaRelayParam.ChannelMediaRelayConfiguration config) {
        if (this.engineIsNull("updateChannelMediaRelay config: " + config)) {
            return 30005;
        }
        if (config == null) {
            Logging.e(this.TAG, "updateChannelMediaRelay failed! config is null");
            this.mLiteEngine.reportApiEvent("updateChannelMediaRelay", 30003, null);
            return 30003;
        }
        Map<String, NERtcMediaRelayParam.ChannelMediaRelayInfo> dstConfig = config.getDstMediaInfo();
        if (dstConfig == null || dstConfig.isEmpty()) {
            Logging.e(this.TAG, "updateChannelMediaRelay failed! getDstMediaInfo is empty");
            this.mLiteEngine.reportApiEvent("updateChannelMediaRelay", 30003, null);
            return 30003;
        }
        return this.mLiteEngine.updateMediaRelayInfos(LiteHelper.getLiteMediaRelay(dstConfig));
    }

    @Override
    public int stopChannelMediaRelay() {
        if (this.engineIsNull("stopChannelMediaRelay")) {
            return 30005;
        }
        return this.mLiteEngine.stopMediaRelayInfos();
    }

    @Override
    public int enableAudioVolumeIndication(boolean enable, int interval, boolean enableVad) {
        if (this.engineIsNull("enableAudioVolumeIndication, enable:" + enable + ", interval:" + interval + ", enableVad: " + enableVad)) {
            return 30005;
        }
        if (enable && (interval < 100 || interval % 100 != 0)) {
            Logging.i(this.TAG, "enableAudioVolumeIndication param error");
            return 30003;
        }
        return this.mLiteEngine.enableAudioVolumeIndication(enable, interval, enableVad);
    }

    @Override
    public int adjustUserPlaybackSignalVolume(long uid, int volume) {
        if (this.engineIsNull("adjustUserPlaybackSignalVolume uid: " + uid + " ,volume: " + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(this.TAG, "adjustUserPlaybackSignalVolume invalid param with volume: " + volume);
            return 30003;
        }
        return this.mLiteEngine.adjustUserPlaybackSignalVolume(uid, volume);
    }

    @Override
    public int adjustChannelPlaybackSignalVolume(int volume) {
        if (this.engineIsNull("adjustChannelPlaybackSignalVolume, volume: " + volume)) {
            return 30005;
        }
        if (volume < 0) {
            Logging.e(this.TAG, "adjustChannelPlaybackSignalVolume invalid param with volume: " + volume);
            return 30003;
        }
        return this.mLiteEngine.adjustChannelPlaybackSignalVolume(volume);
    }

    @Override
    public int setLocalPublishFallbackOption(int option) {
        if (this.engineIsNull("setLocalPublishFallbackOption option: " + option)) {
            return 30005;
        }
        return this.mLiteEngine.setPublishFallbackOption(option);
    }

    @Override
    public int setRemoteSubscribeFallbackOption(int option) {
        if (this.engineIsNull("setRemoteSubscribeFallbackOption option: " + option)) {
            return 30005;
        }
        return this.mLiteEngine.setSubscribeFallbackOption(option);
    }

    @Override
    public int enableEncryption(boolean enable, NERtcEncryptionConfig config) {
        if (this.engineIsNull("enable: " + enable + " NERtcEncryptionConfig option: " + config)) {
            return 30005;
        }
        return this.mLiteEngine.enableMediaCrypto(LiteHelper.getLiteMediaCryptoConfig(enable, config));
    }

    public int startLastmileProbeTest(LastmileProbeConfig config) {
        if (this.engineIsNull("startLastmileProbeTest: " + config)) {
            return 30005;
        }
        if (config == null || 100000 > config.expectedUplinkBitrate || 5000000 < config.expectedUplinkBitrate || 100000 > config.expectedDownlinkBitrate || 5000000 < config.expectedDownlinkBitrate || !config.probeUplink && !config.probeDownlink) {
            Logging.e(this.TAG, "start probe failed for config is invalid");
            this.mLiteEngine.reportApiEvent("startLastmileProbeTest", 30003, "");
            return 30003;
        }
        int connectionState = this.mLiteEngine.getConnectionState();
        if (connectionState != 0 && connectionState != 6) {
            Logging.e(this.TAG, "cannot probe for connection state:" + connectionState);
            this.mLiteEngine.reportApiEvent("startLastmileProbeTest", 30005, "");
            return 30005;
        }
        if (this.mProbeEngine != null && this.mProbeEngine.getConnectionState() != 0) {
            Logging.e(this.TAG, "already is in probe testing");
            this.mLiteEngine.reportApiEvent("startLastmileProbeTest", 30005, "");
            return 30005;
        }
        LiteSDKEngineConfig engineConfig = new LiteSDKEngineConfig();
        engineConfig.mode = 3;
        this.mProbeEngine = LiteEngineCenter.createProbeEngine(engineConfig, this.mSinkWrapper);
        int result = this.mProbeEngine.initialize(new LiteSDKEngineParameter());
        if (result != 0) {
            this.mLiteEngine.reportApiEvent("startLastmileProbeTest", 30001, "");
            LiteEngineCenter.destroyProbeEngine(this.mProbeEngine);
            this.mProbeEngine = null;
            Logging.e(this.TAG, "initialize probe engine failed");
            return result;
        }
        LiteSDKProbeConfig liteConfig = new LiteSDKProbeConfig();
        liteConfig.upLink = config.probeUplink;
        liteConfig.downLink = config.probeDownlink;
        liteConfig.expectedUpLinkBitrate = config.expectedUplinkBitrate;
        liteConfig.expectedDownLinkBitrate = config.expectedDownlinkBitrate;
        result = this.mProbeEngine.startProbe(liteConfig);
        if (result != 0) {
            LiteEngineCenter.destroyProbeEngine(this.mProbeEngine);
            this.mProbeEngine = null;
            Logging.e(this.TAG, "start probe failed: " + result);
        }
        return result;
    }

    public int stopLastmileProbeTest() {
        if (this.engineIsNull("stopLastmileProbeTest")) {
            return 30005;
        }
        if (this.mProbeEngine == null) {
            Logging.e(this.TAG, "not already is in probe testing");
            this.mLiteEngine.reportApiEvent("stopLastmileProbeTest", 30005, "");
            return 0;
        }
        int result = this.mProbeEngine.stopProbe();
        if (result != 0) {
            Logging.e(this.TAG, "stop probe failed");
        }
        LiteEngineCenter.destroyProbeEngine(this.mProbeEngine);
        this.mProbeEngine = null;
        return result;
    }

    @Override
    public int setRemoteHighPriorityAudioStream(boolean enabled, long uid) {
        if (this.engineIsNull("setRemoteHighPriorityAudioStream enabled: " + enabled + " ,uid: " + uid)) {
            return 30005;
        }
        return this.mLiteEngine.setHighPriorityRemoteAudioStream(enabled, uid, 0);
    }

    @Override
    public int setAudioSubscribeOnlyBy(long[] uidArray) {
        if (this.engineIsNull("setAudioSubscribeOnlyBy : " + Arrays.toString(uidArray))) {
            return 30005;
        }
        return this.mLiteEngine.setAudioSubscribeOnlyBy(uidArray);
    }

    @Override
    public int setAudioRecvRange(int audible_distance, int conversational_distance, NERtcDistanceRolloffModel roll_off) {
        if (this.engineIsNull("setAudioRecvRange audible_distance:" + audible_distance + " \uff0cconversational_distance: " + conversational_distance + ", roll_off: " + (Object)((Object)roll_off))) {
            return 30005;
        }
        return this.mLiteEngine.setAudioRecvRange(audible_distance, conversational_distance, LiteHelper.getLiteDistanceRolloffModel(roll_off));
    }

    @Override
    public int updateSelfPosition(NERtcPositionInfo info) {
        if (this.engineIsNull("updateSelfPosition:" + info)) {
            return 30005;
        }
        return this.mLiteEngine.updateSelfPosition(info.mSpeakerPosition, info.mSpeakerQuaternion, info.mHeadPosition, info.mHeadQuaternion);
    }

    @Override
    public int enableSpatializerRoomEffects(boolean enable) {
        if (this.engineIsNull("enableSpatializerRoomEffects enable:" + enable)) {
            return 30005;
        }
        return this.mLiteEngine.enableSpatializerRoomEffects(enable);
    }

    @Override
    public int setSpatializerRoomProperty(NERtcSpatializerRoomProperty roomProperty) {
        if (this.engineIsNull("setSpatializerRoomProperty room_property:" + roomProperty)) {
            return 30005;
        }
        return this.mLiteEngine.setSpatializerRoomProperty(LiteHelper.getLiteSpatializerRoomProperty(roomProperty));
    }

    @Override
    public int setSpatializerRenderMode(NERtcSpatializerRenderMode mode) {
        if (this.engineIsNull("setSpatializerRenderMode mode:" + (Object)((Object)mode))) {
            return 30005;
        }
        return this.mLiteEngine.setSpatializerRenderMode(LiteHelper.getLiteSpatializerRenderMode(mode));
    }

    @Override
    public int enableSpatializer(boolean enable, boolean applyToTeam) {
        if (this.engineIsNull("enableSpatializer enable:" + enable + " applyToTeam:" + applyToTeam)) {
            return 30005;
        }
        return this.mLiteEngine.enableSpatializer(enable, applyToTeam);
    }

    @Override
    public int initSpatializer() {
        if (this.engineIsNull("initSpatializer")) {
            return 30005;
        }
        return this.mLiteEngine.initSpatializer();
    }

    @Override
    public int setRangeAudioMode(NERtcRangeAudioMode mode) {
        if (this.engineIsNull("setRangeAudioMode: mode" + (Object)((Object)mode))) {
            return 30005;
        }
        return this.mLiteEngine.setRangeAudioMode(LiteHelper.getLiteRangeAudioMode(mode));
    }

    @Override
    public int setRangeAudioTeamID(int teamId) {
        if (this.engineIsNull("setRangeAudioTeamID: teamId" + teamId)) {
            return 30005;
        }
        return this.mLiteEngine.setRangeAudioTeamID(teamId);
    }

    @Override
    public int setSubscribeAudioBlocklist(long[] uidArray, NERtcAudioStreamType streamType) {
        if (this.engineIsNull("setSubscribeAudioBlocklist streamType:" + (Object)((Object)streamType))) {
            return 30005;
        }
        return this.mLiteEngine.setSubscribeAudioBlocklist(uidArray, LiteHelper.getLiteAudioStreamType(streamType));
    }

    @Override
    public int setSubscribeAudioAllowlist(long[] uidArray) {
        if (this.engineIsNull("setSubscribeAudioAllowlist")) {
            return 30005;
        }
        return this.mLiteEngine.setSubscribeAudioAllowlist(uidArray);
    }

    @Override
    public int enableLocalSubStreamAudio(boolean enable) {
        if (this.engineIsNull("enableLocalSubStreamAudio: " + enable)) {
            return 30005;
        }
        return this.mLiteEngine.enableLocalAudio(enable, 1);
    }

    @Override
    public int muteLocalSubStreamAudio(boolean mute) {
        if (this.engineIsNull("muteLocalSubStreamAudio: " + mute)) {
            return 30005;
        }
        return this.mLiteEngine.muteLocalAudio(mute, 1);
    }

    @Override
    public int subscribeRemoteSubStreamAudio(long uid, boolean subscribe) {
        if (this.engineIsNull("subscribeRemoteSubStreamAudio uid: " + uid + " ,subscribe: " + subscribe)) {
            return 30005;
        }
        return this.mLiteEngine.subscribeRemoteAudio(subscribe, uid, 1);
    }

    @Override
    public int enableLocalData(boolean enabled) {
        if (this.engineIsNull("enableLocalData enabled: " + enabled)) {
            return 30005;
        }
        return this.mLiteEngine.enableLocalData(enabled);
    }

    @Override
    public int subscribeRemoteData(boolean subscribe, long userID) {
        if (this.engineIsNull("subscribeRemoteData subscribe: " + subscribe + " , userID: " + userID)) {
            return 30005;
        }
        return this.mLiteEngine.subscribeRemoteData(subscribe, userID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendData(NERtcDataExternalFrame frame) {
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.engineIsNull(null)) {
                return 30005;
            }
            if (frame == null) {
                Logging.e(this.TAG, "data frame is null");
                return 30003;
            }
            if (frame.dataSize == 0L) {
                Logging.e(this.TAG, "data size is 0");
                return 30003;
            }
            if (frame.dataSize > 128000L) {
                Logging.e(this.TAG, "data size is overflow");
                return 30123;
            }
            return this.mLiteEngine.sendData(frame.externalData, frame.dataSize);
        }
    }

    @Override
    public int reportCustomEvent(String eventName, String customIdentify, HashMap<String, Object> param) {
        if (this.engineIsNull("reportCustomEvent eventName: " + eventName + ", customIdentify: " + customIdentify + ", param: " + param)) {
            return 30005;
        }
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return 30003;
        }
        String reportParamJson = param == null ? "" : param.toString();
        return this.mLiteEngine.reportCustomEvent(eventName, customIdentify, reportParamJson);
    }

    @Override
    public void mirrorChange(int streamType, boolean mirror) {
        if (this.engineIsNull("mirrorChange streamType: " + streamType + " ,mirror: " + mirror)) {
            return;
        }
        this.mLiteEngine.setLocalVideoMirrorMode(streamType, mirror ? 1 : 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Logging.i(this.TAG, "release start");
        Object object = this.mEngineLock;
        synchronized (object) {
            if (this.mLiteEngine != null) {
                this.mLiteEngine.unInitialize();
                LiteEngineCenter.destroyEngine(this.mLiteEngine);
                this.mLiteEngine = null;
            }
        }
        this.releaseExternalVideo(NERtcVideoStreamType.kNERtcVideoStreamTypeMain);
        this.releaseExternalVideo(NERtcVideoStreamType.kNERtcVideoStreamTypeSub);
        if (this.mChannelList != null) {
            this.mChannelList.remove(this);
        }
        Logging.i(this.TAG, "release finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExternalVideo(NERtcVideoStreamType streamType) {
        Object object = this.mEngineLock;
        synchronized (object) {
            this.releaseExternalVideo(streamType);
            ExternalVideoInfo externalVideoInfo = new ExternalVideoInfo();
            this.mExternalVideoMap.put(streamType, externalVideoInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseExternalVideo(NERtcVideoStreamType streamType) {
        Object object = this.mEngineLock;
        synchronized (object) {
            ExternalVideoInfo externalVideoInfo = this.mExternalVideoMap.get((Object)streamType);
            if (externalVideoInfo == null || externalVideoInfo.eglHandler == null) {
                return;
            }
            Logging.i(this.TAG, "release egl handler start");
            externalVideoInfo.eglHandler.post(() -> {
                if (externalVideoInfo.externalEglBase != null) {
                    externalVideoInfo.externalEglBase.release();
                    externalVideoInfo.externalEglBase = null;
                }
                if (externalVideoInfo.yuvConverter != null) {
                    externalVideoInfo.yuvConverter.release();
                    externalVideoInfo.yuvConverter = null;
                }
                Logging.i(this.TAG, "release egl handler end");
            });
            LooperUtils.quitSafely(externalVideoInfo.eglHandler);
            externalVideoInfo.eglHandler = null;
            if (externalVideoInfo.eglThread != null) {
                try {
                    externalVideoInfo.eglThread.join(200L);
                    externalVideoInfo.eglThread = null;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.mExternalVideoMap.remove((Object)streamType);
        }
    }

    public void setMainChannelNERtcCallback(NERtcCallback callback) {
        Logging.i(this.TAG, "setMainChannelNERtcCallback  ,callback: " + callback);
        if (this.mSinkWrapper.isMainChannel()) {
            this.mSinkWrapper.setCallback(callback, true);
        }
    }

    private LiteSDKVideoCanvas createLiteSDKVideoCanvas(IVideoRender render, String name) {
        LiteSDKVideoCanvas canvas = new LiteSDKVideoCanvas();
        if (render instanceof NERtcVideoView) {
            canvas.render = ((NERtcVideoView)render).mVideoView;
            ((SurfaceViewRenderer)((Object)canvas.render)).setLogName(name);
            ((SurfaceViewRenderer)((Object)canvas.render)).setReportFpsInterval(2000L);
        } else if (render instanceof NERtcTextureView) {
            canvas.render = ((NERtcTextureView)render).mVideoView;
            ((TextureViewRenderer)((Object)canvas.render)).setLogName(name);
            ((TextureViewRenderer)((Object)canvas.render)).setReportFpsInterval(2000L);
        } else {
            canvas.render = render;
        }
        canvas.renderHashCode = CommonUtils.getHashCode(render);
        canvas.useExternalRender = LiteHelper.isExternalRender(render);
        canvas.bufferType = LiteHelper.getBufferType(render);
        return canvas;
    }

    private boolean engineIsNull(String msg) {
        if (this.mLiteEngine != null) {
            return false;
        }
        if (msg != null) {
            Logging.e(this.TAG, "engine is null , msg is " + msg);
        }
        return true;
    }

    private static class ExternalVideoInfo {
        public byte[] rawI420;
        private HandlerThread eglThread;
        public Handler eglHandler;
        public EglBase externalEglBase;
        public YuvConverter yuvConverter;
        public ByteBuffer byteBuffer;

        private ExternalVideoInfo() {
        }
    }
}

