/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.impl.lite;

import android.content.Intent;
import android.media.projection.MediaProjection;
import com.netease.lava.api.IVideoRender;
import com.netease.lava.nertc.sdk.NERtcJoinChannelOptions;
import com.netease.lava.nertc.sdk.NERtcMediaRelayParam;
import com.netease.lava.nertc.sdk.NERtcServerAddresses;
import com.netease.lava.nertc.sdk.NERtcVideoCorrectionConfiguration;
import com.netease.lava.nertc.sdk.audio.NERtcAudioEncodedFrame;
import com.netease.lava.nertc.sdk.audio.NERtcAudioFrameRequestFormat;
import com.netease.lava.nertc.sdk.audio.NERtcAudioStreamType;
import com.netease.lava.nertc.sdk.audio.NERtcCreateAudioEffectOption;
import com.netease.lava.nertc.sdk.audio.NERtcCreateAudioMixingOption;
import com.netease.lava.nertc.sdk.audio.NERtcDistanceRolloffModel;
import com.netease.lava.nertc.sdk.audio.NERtcRangeAudioMode;
import com.netease.lava.nertc.sdk.audio.NERtcSpatializerRenderMode;
import com.netease.lava.nertc.sdk.audio.NERtcSpatializerRoomProperty;
import com.netease.lava.nertc.sdk.encryption.NERtcEncryptionConfig;
import com.netease.lava.nertc.sdk.encryption.NERtcPacketObserverWrapper;
import com.netease.lava.nertc.sdk.video.NERtcCameraCaptureConfig;
import com.netease.lava.nertc.sdk.video.NERtcScreenConfig;
import com.netease.lava.nertc.sdk.video.NERtcTextureView;
import com.netease.lava.nertc.sdk.video.NERtcVideoConfig;
import com.netease.lava.nertc.sdk.video.NERtcVideoEncodedFrame;
import com.netease.lava.nertc.sdk.video.NERtcVideoStreamType;
import com.netease.lava.nertc.sdk.video.NERtcVideoView;
import com.netease.lava.nertc.sdk.video.NERtcVirtualBackgroundSource;
import com.netease.lava.nertc.sdk.watermark.NERtcVideoWatermarkConfig;
import com.netease.lava.nertc.sdk.watermark.NERtcVideoWatermarkImageConfig;
import com.netease.lava.nertc.sdk.watermark.NERtcVideoWatermarkTextConfig;
import com.netease.lava.nertc.sdk.watermark.NERtcVideoWatermarkTimestampConfig;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.SurfaceViewRenderer;
import com.netease.yunxin.lite.LiteEngineCenter;
import com.netease.yunxin.lite.model.LiteSDKAudioEncodedFrame;
import com.netease.yunxin.lite.model.LiteSDKAudioFrameRequestFormat;
import com.netease.yunxin.lite.model.LiteSDKCameraCaptureConfiguration;
import com.netease.yunxin.lite.model.LiteSDKCreateAudioEffectOption;
import com.netease.yunxin.lite.model.LiteSDKCreateAudioMixingOption;
import com.netease.yunxin.lite.model.LiteSDKJoinParameter;
import com.netease.yunxin.lite.model.LiteSDKLowLatencyParameter;
import com.netease.yunxin.lite.model.LiteSDKMediaCryptoConfig;
import com.netease.yunxin.lite.model.LiteSDKMediaRelayItem;
import com.netease.yunxin.lite.model.LiteSDKServerAddresses;
import com.netease.yunxin.lite.model.LiteSDKSpatializerRoomProperty;
import com.netease.yunxin.lite.model.LiteSDKVideoCanvas;
import com.netease.yunxin.lite.model.LiteSDKVideoCorrectionConfiguration;
import com.netease.yunxin.lite.model.LiteSDKVideoEncodeConfig;
import com.netease.yunxin.lite.model.LiteSDKVideoEncodedFrame;
import com.netease.yunxin.lite.model.LiteSDKVideoProfileUtil;
import com.netease.yunxin.lite.model.LiteSDKVirtualBackgroundSource;
import com.netease.yunxin.lite.util.CommonUtils;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.FileUtil;
import com.netease.yunxin.lite.video.encode.watermark.LiteSDKVideoWatermarkConfig;
import com.netease.yunxin.lite.video.encode.watermark.LiteSDKVideoWatermarkImageConfig;
import com.netease.yunxin.lite.video.encode.watermark.LiteSDKVideoWatermarkTextConfig;
import com.netease.yunxin.lite.video.encode.watermark.LiteSDKVideoWatermarkTimestampConfig;
import com.netease.yunxin.lite.video.render.TextureViewRenderer;
import java.util.Map;

public class LiteHelper {
    public static int liteChannelStateToSDK(int liteState) {
        int state = 0;
        switch (liteState) {
            case 0: 
            case 3: 
            case 4: {
                state = 1;
                break;
            }
            case 1: {
                state = 2;
                break;
            }
            case 2: {
                state = 3;
                break;
            }
            case 5: {
                state = 4;
                break;
            }
            case 6: {
                state = 5;
                break;
            }
        }
        return state;
    }

    public static LiteSDKJoinParameter getLiteJoinParameter(String token, String channelName, long uid, NERtcJoinChannelOptions channelOptions) {
        LiteSDKJoinParameter parameter = new LiteSDKJoinParameter();
        parameter.channelName = channelName;
        parameter.userId = uid;
        parameter.userName = String.valueOf(uid);
        parameter.token = token;
        if (channelOptions != null) {
            parameter.customInfo = channelOptions.customInfo;
            parameter.permissionKey = channelOptions.permissionKey;
        }
        if (channelOptions != null && channelOptions.lowLatencyOptions != null) {
            parameter.lowLatencyParam = new LiteSDKLowLatencyParameter();
            parameter.lowLatencyParam.enable = channelOptions.lowLatencyOptions.enableLowLatency;
            parameter.lowLatencyParam.playTimeout = channelOptions.lowLatencyOptions.playTimeout;
            if (channelOptions.lowLatencyOptions.enableLowLatency && channelOptions.lowLatencyOptions.playCanvas != null) {
                parameter.lowLatencyParam.playCanvas = LiteHelper.createLiteSDKVideoCanvas(channelOptions.lowLatencyOptions.playCanvas, "low_latency_broadcaster_video");
            }
        }
        return parameter;
    }

    private static LiteSDKVideoCanvas createLiteSDKVideoCanvas(IVideoRender render, String name) {
        LiteSDKVideoCanvas canvas = new LiteSDKVideoCanvas();
        if (render instanceof NERtcVideoView) {
            canvas.render = ((NERtcVideoView)render).mVideoView;
            ((SurfaceViewRenderer)((Object)canvas.render)).setLogName(name);
            ((SurfaceViewRenderer)((Object)canvas.render)).setReportFpsInterval(2000L);
        } else if (render instanceof NERtcTextureView) {
            canvas.render = ((NERtcTextureView)render).mVideoView;
            ((TextureViewRenderer)((Object)canvas.render)).setLogName(name);
            ((TextureViewRenderer)((Object)canvas.render)).setReportFpsInterval(2000L);
        } else {
            canvas.render = render;
        }
        canvas.renderHashCode = CommonUtils.getHashCode(render);
        canvas.useExternalRender = LiteHelper.isExternalRender(render);
        canvas.bufferType = LiteHelper.getBufferType(render);
        return canvas;
    }

    public static LiteSDKJoinParameter getLiteSwitchParameter(String token, String channelName, NERtcJoinChannelOptions channelOptions) {
        LiteSDKJoinParameter parameter = new LiteSDKJoinParameter();
        parameter.token = token;
        parameter.channelName = channelName;
        if (channelOptions != null) {
            parameter.customInfo = channelOptions.customInfo;
            parameter.permissionKey = channelOptions.permissionKey;
        }
        return parameter;
    }

    public static LiteSDKCameraCaptureConfiguration getLiteCameraConfig(NERtcCameraCaptureConfig captureConfig) {
        LiteSDKCameraCaptureConfiguration configuration = new LiteSDKCameraCaptureConfiguration();
        configuration.captureWidth = captureConfig.captureWidth;
        configuration.captureHeight = captureConfig.captureHeight;
        configuration.extraRotation = captureConfig.extraRotation == null ? 0 : 90 * captureConfig.extraRotation.ordinal();
        return configuration;
    }

    public static LiteSDKVideoEncodeConfig getLiteVideoConfig(NERtcVideoConfig videoConfig) {
        LiteSDKVideoEncodeConfig config = new LiteSDKVideoEncodeConfig();
        config.width = videoConfig.width;
        config.height = videoConfig.height;
        if (config.width == 0 || config.height == 0) {
            LiteSDKVideoProfileUtil profileUtil = new LiteSDKVideoProfileUtil();
            profileUtil.profile = videoConfig.videoProfile;
            profileUtil.cropMode = 0;
            LiteEngineCenter.getResolutionWithProfileType(profileUtil);
            if (profileUtil.getWidth() != 0 && profileUtil.getHeight() != 0) {
                config.width = profileUtil.getWidth();
                config.height = profileUtil.getHeight();
            }
        }
        config.colorFormat = videoConfig.colorFormat;
        config.degradationPreference = videoConfig.degradationPrefer == null ? 0 : videoConfig.degradationPrefer.ordinal();
        config.cropMode = videoConfig.videoCropMode;
        config.mirrorMode = videoConfig.mirrorMode == null ? 0 : videoConfig.mirrorMode.ordinal();
        config.orientationMode = videoConfig.orientationMode == null ? 0 : videoConfig.orientationMode.ordinal();
        config.frameRate = videoConfig.frameRate.getValue();
        config.minFrameRate = videoConfig.minFramerate;
        config.bitrate = videoConfig.bitrate;
        config.minBitrate = videoConfig.minBitrate;
        return config;
    }

    public static LiteSDKVideoEncodeConfig getLiteSubStreamConfig(NERtcScreenConfig screenConfig, Intent intent, MediaProjection.Callback callback) {
        LiteSDKVideoEncodeConfig subStreamEncodeConfig = new LiteSDKVideoEncodeConfig();
        subStreamEncodeConfig.intent = intent;
        subStreamEncodeConfig.callback = callback;
        if (screenConfig != null) {
            int n = subStreamEncodeConfig.preference = screenConfig.contentPrefer == null ? 0 : screenConfig.contentPrefer.ordinal();
            if (subStreamEncodeConfig.width == 0 || subStreamEncodeConfig.height == 0) {
                LiteSDKVideoProfileUtil profileUtil = new LiteSDKVideoProfileUtil();
                profileUtil.profile = screenConfig.videoProfile;
                LiteEngineCenter.getResolutionWithProfileType(profileUtil);
                if (profileUtil.getWidth() != 0 && profileUtil.getHeight() != 0) {
                    subStreamEncodeConfig.width = profileUtil.getWidth();
                    subStreamEncodeConfig.height = profileUtil.getHeight();
                }
            }
            subStreamEncodeConfig.frameRate = screenConfig.frameRate.getValue();
            subStreamEncodeConfig.minFrameRate = screenConfig.minFramerate;
            subStreamEncodeConfig.bitrate = screenConfig.bitrate;
            subStreamEncodeConfig.minBitrate = screenConfig.minBitrate;
            subStreamEncodeConfig.degradationPreference = screenConfig.degradationPrefer == null ? 0 : screenConfig.degradationPrefer.ordinal();
        }
        return subStreamEncodeConfig;
    }

    public static LiteSDKAudioFrameRequestFormat getLiteAudioFrameRequestFormat(NERtcAudioFrameRequestFormat format) {
        LiteSDKAudioFrameRequestFormat requestFormat = new LiteSDKAudioFrameRequestFormat();
        if (format != null) {
            requestFormat.channels = format.getChannels();
            requestFormat.sampleRate = format.getSampleRate();
            requestFormat.mode = format.getOpMode();
        } else {
            requestFormat.reset = true;
        }
        return requestFormat;
    }

    public static LiteSDKSpatializerRoomProperty getLiteSpatializerRoomProperty(NERtcSpatializerRoomProperty roomProperty) {
        LiteSDKSpatializerRoomProperty spatializerRoomProperty = new LiteSDKSpatializerRoomProperty();
        if (roomProperty != null) {
            spatializerRoomProperty.roomCapacity = roomProperty.roomCapacity.getType();
            spatializerRoomProperty.material = roomProperty.material.getType();
            spatializerRoomProperty.reverbBrightness = roomProperty.reverbBrightness;
            spatializerRoomProperty.reflectionScalar = roomProperty.reflectionScalar;
            spatializerRoomProperty.reverbGain = roomProperty.reverbGain;
            spatializerRoomProperty.reverbTime = roomProperty.reverbTime;
        }
        return spatializerRoomProperty;
    }

    public static LiteSDKCreateAudioMixingOption getLiteAudioMixingOption(NERtcCreateAudioMixingOption option) {
        LiteSDKCreateAudioMixingOption liteSDKCreateAudioMixingOption = new LiteSDKCreateAudioMixingOption();
        liteSDKCreateAudioMixingOption.path = FileUtil.getContentFileFDForNative(ContextUtils.getContext(), option.path);
        liteSDKCreateAudioMixingOption.loopCount = option.loopCount;
        liteSDKCreateAudioMixingOption.enableSend = option.sendEnabled;
        liteSDKCreateAudioMixingOption.sendVolume = option.sendVolume;
        liteSDKCreateAudioMixingOption.enablePlayback = option.playbackEnabled;
        liteSDKCreateAudioMixingOption.playbackVolume = option.playbackVolume;
        liteSDKCreateAudioMixingOption.startTimestamp = option.startTimeStamp;
        liteSDKCreateAudioMixingOption.sendWithAudioType = option.sendWithAudioType == NERtcAudioStreamType.kNERtcAudioStreamTypeSub ? 1 : 0;
        liteSDKCreateAudioMixingOption.progressInterval = option.progressInterval;
        return liteSDKCreateAudioMixingOption;
    }

    public static LiteSDKCreateAudioEffectOption getLiteAudioEffectOption(NERtcCreateAudioEffectOption option) {
        LiteSDKCreateAudioEffectOption audioEffectOption = new LiteSDKCreateAudioEffectOption();
        audioEffectOption.path = FileUtil.getContentFileFDForNative(ContextUtils.getContext(), option.path);
        audioEffectOption.loopCount = option.loopCount;
        audioEffectOption.enableSend = option.sendEnabled;
        audioEffectOption.sendVolume = option.sendVolume;
        audioEffectOption.enablePlayback = option.playbackEnabled;
        audioEffectOption.playbackVolume = option.playbackVolume;
        audioEffectOption.startTimestamp = option.startTimestamp;
        audioEffectOption.sendWithType = option.sendWithAudioType == NERtcAudioStreamType.kNERtcAudioStreamTypeSub ? 1 : 0;
        audioEffectOption.progressInterval = option.progressInterval;
        return audioEffectOption;
    }

    public static LiteSDKMediaCryptoConfig getLiteMediaCryptoConfig(boolean enable, NERtcEncryptionConfig config) {
        LiteSDKMediaCryptoConfig mediaCryptoConfig = new LiteSDKMediaCryptoConfig();
        mediaCryptoConfig.enable = enable;
        if (config != null) {
            mediaCryptoConfig.mode = config.mode == null ? 0 : config.mode.ordinal();
            mediaCryptoConfig.key = config.key;
            mediaCryptoConfig.packetObserver = config.observer == null ? null : new NERtcPacketObserverWrapper(config.observer);
        }
        return mediaCryptoConfig;
    }

    public static LiteSDKVideoWatermarkConfig getLiteVideoWatermarkConfig(NERtcVideoWatermarkConfig config) {
        if (config == null || !config.isValid()) {
            return null;
        }
        LiteSDKVideoWatermarkConfig liteConfig = new LiteSDKVideoWatermarkConfig();
        liteConfig.watermarkType = config.watermarkType.ordinal();
        if (config.watermarkType == NERtcVideoWatermarkConfig.WatermarkType.kNERtcWatermarkTypeImage) {
            NERtcVideoWatermarkImageConfig imgCfg = config.imageWatermark;
            liteConfig.imageWatermark = new LiteSDKVideoWatermarkImageConfig(imgCfg.wmAlpha, imgCfg.wmWidth, imgCfg.wmHeight, imgCfg.offsetX, imgCfg.offsetY, imgCfg.imagePaths, imgCfg.fps, imgCfg.loop);
        }
        if (config.watermarkType == NERtcVideoWatermarkConfig.WatermarkType.kNERtcWatermarkTypeText) {
            NERtcVideoWatermarkTextConfig txtCfg = config.textWatermark;
            liteConfig.textWatermark = new LiteSDKVideoWatermarkTextConfig(txtCfg.content, txtCfg.fontNameOrPath, txtCfg.fontColor, txtCfg.fontSize, txtCfg.wmAlpha, txtCfg.wmWidth, txtCfg.wmColor, txtCfg.wmHeight, txtCfg.offsetX, txtCfg.offsetY);
        }
        if (config.watermarkType == NERtcVideoWatermarkConfig.WatermarkType.kNERtcWatermarkTypeTimestamp) {
            NERtcVideoWatermarkTimestampConfig timeCfg = config.timestampWatermark;
            liteConfig.timestampWatermark = new LiteSDKVideoWatermarkTimestampConfig(timeCfg.fontNameOrPath, timeCfg.fontColor, timeCfg.fontSize, timeCfg.wmColor, timeCfg.wmAlpha, timeCfg.wmWidth, timeCfg.wmHeight, timeCfg.offsetX, timeCfg.offsetY);
        }
        return liteConfig;
    }

    public static int getLiteMediaStreamType(NERtcVideoStreamType streamType) {
        int liteType;
        if (streamType == null) {
            return 2;
        }
        switch (streamType) {
            case kNERtcVideoStreamTypeSub: {
                liteType = 3;
                break;
            }
            default: {
                liteType = 2;
            }
        }
        return liteType;
    }

    public static int getLiteAudioStreamType(NERtcAudioStreamType streamType) {
        int liteType;
        if (streamType == null) {
            return 0;
        }
        switch (streamType) {
            case kNERtcAudioStreamTypeSub: {
                liteType = 1;
                break;
            }
            default: {
                liteType = 0;
            }
        }
        return liteType;
    }

    public static int getLiteDistanceRolloffModel(NERtcDistanceRolloffModel distanceRolloffModel) {
        int liteType;
        if (distanceRolloffModel == null) {
            return 2;
        }
        switch (distanceRolloffModel) {
            case kNERtcDistanceRolloffLinearOnly: {
                liteType = 3;
                break;
            }
            case kNERtcDistanceRolloffLinear: {
                liteType = 1;
                break;
            }
            case kNERtcDistanceRolloffLogarithmic: {
                liteType = 0;
                break;
            }
            default: {
                liteType = 2;
            }
        }
        return liteType;
    }

    public static void enableLogToDebugOutput(int level) {
        Logging.Severity severity;
        switch (level) {
            case 0: 
            case 1: {
                severity = Logging.Severity.LS_ERROR;
                break;
            }
            case 2: {
                severity = Logging.Severity.LS_WARNING;
                break;
            }
            case 3: {
                severity = Logging.Severity.LS_INFO;
                break;
            }
            case 4: {
                severity = Logging.Severity.LS_DETAIL_INFO;
                break;
            }
            case 5: {
                severity = Logging.Severity.LS_VERBOSE;
                break;
            }
            case 6: {
                severity = Logging.Severity.LS_SENSITIVE;
                break;
            }
            default: {
                severity = Logging.Severity.LS_NONE;
            }
        }
        Logging.enableLogToDebugOutput(severity);
        Logging.i("LiteHelper", "enableLogToDebugOutput:" + (Object)((Object)severity) + ", level:" + level);
    }

    public static LiteSDKServerAddresses getLiteServerAddress(NERtcServerAddresses neRtcServerAddresses) {
        if (neRtcServerAddresses == null) {
            return null;
        }
        LiteSDKServerAddresses addresses = new LiteSDKServerAddresses();
        addresses.lbsServer = neRtcServerAddresses.lbsServer;
        addresses.channelServer = neRtcServerAddresses.channelServer;
        addresses.compatServer = neRtcServerAddresses.compatServer;
        addresses.roomServer = neRtcServerAddresses.roomServer;
        addresses.statisticsServer = neRtcServerAddresses.statisticsServer;
        addresses.statisticsDispatchServer = neRtcServerAddresses.statisticsDispatchServer;
        addresses.statisticsBackupServer = neRtcServerAddresses.statisticsBackupServer;
        addresses.nosLbsServer = neRtcServerAddresses.nosLbsServer;
        addresses.nosUploadSever = neRtcServerAddresses.nosUploadSever;
        addresses.nosTokenServer = neRtcServerAddresses.nosTokenServer;
        addresses.cloudProxyServer = neRtcServerAddresses.cloudProxyServer;
        addresses.webSocketProxyServer = neRtcServerAddresses.webSocketProxyServer;
        addresses.quicProxyServer = neRtcServerAddresses.quicProxyServer;
        addresses.mediaProxyServer = neRtcServerAddresses.mediaProxyServer;
        addresses.useIPv6 = neRtcServerAddresses.useIPv6;
        return addresses;
    }

    public static LiteSDKMediaRelayItem[] getLiteMediaRelay(Map<String, NERtcMediaRelayParam.ChannelMediaRelayInfo> dstConfig) {
        if (dstConfig == null || dstConfig.isEmpty()) {
            return null;
        }
        int len = dstConfig.size();
        LiteSDKMediaRelayItem[] relayItems = new LiteSDKMediaRelayItem[len];
        int i = 0;
        for (NERtcMediaRelayParam.ChannelMediaRelayInfo info : dstConfig.values()) {
            LiteSDKMediaRelayItem item = new LiteSDKMediaRelayItem();
            item.channelName = info.getChannelName();
            item.channelToken = info.getChannelToken();
            item.userId = info.getChannelUid();
            relayItems[i] = item;
            ++i;
        }
        return relayItems;
    }

    public static LiteSDKVideoCorrectionConfiguration getLiteVideoCorrection(NERtcVideoCorrectionConfiguration neRtcConfig) {
        LiteSDKVideoCorrectionConfiguration config = new LiteSDKVideoCorrectionConfiguration();
        if (neRtcConfig == null) {
            return config;
        }
        config.topLeftX = neRtcConfig.topLeft == null ? 0.0f : neRtcConfig.topLeft.x;
        config.topLeftY = neRtcConfig.topLeft == null ? 0.0f : neRtcConfig.topLeft.y;
        config.topRightX = neRtcConfig.topRight == null ? 0.0f : neRtcConfig.topRight.x;
        config.topRightY = neRtcConfig.topRight == null ? 0.0f : neRtcConfig.topRight.y;
        config.bottomLeftX = neRtcConfig.bottomLeft == null ? 0.0f : neRtcConfig.bottomLeft.x;
        config.bottomLeftY = neRtcConfig.bottomLeft == null ? 0.0f : neRtcConfig.bottomLeft.y;
        config.bottomRightX = neRtcConfig.bottomRight == null ? 0.0f : neRtcConfig.bottomRight.x;
        config.bottomRightY = neRtcConfig.bottomRight == null ? 0.0f : neRtcConfig.bottomRight.y;
        config.canvasWidth = (int)neRtcConfig.canvasWidth;
        config.canvasHeight = (int)neRtcConfig.canvasHeight;
        config.enableMirror = neRtcConfig.enableMirror;
        return config;
    }

    public static LiteSDKVirtualBackgroundSource getLiteVirtualBackgroundSource(NERtcVirtualBackgroundSource neSource) {
        LiteSDKVirtualBackgroundSource source = new LiteSDKVirtualBackgroundSource();
        if (neSource == null) {
            return source;
        }
        source.backgroundSourceType = neSource.backgroundSourceType;
        source.color = neSource.color;
        source.source = neSource.source;
        source.blur_degree = neSource.blur_degree;
        return source;
    }

    public static String getLitePrivateParamKey(String sdkKey) {
        if ("sdk.disable.getChannelInfo".equals(sdkKey)) {
            return "sdk.private.api.disable.get.channel.info";
        }
        if ("sdk.getChannelInfo.custom.data".equals(sdkKey)) {
            return "sdk.private.api.get.channel.info.custom.data";
        }
        if ("sdk.getChannelInfo.request".equals(sdkKey)) {
            return "sdk.private.api.get.channel.info.request";
        }
        if ("sdk.getChannelInfo.response".equals(sdkKey)) {
            return "sdk.private.api.get.channel.info.response";
        }
        return sdkKey;
    }

    public static LiteSDKVideoEncodedFrame getLiteVideoEncodedFrame(NERtcVideoEncodedFrame videoEncodedFrame) {
        LiteSDKVideoEncodedFrame encodedFrame = new LiteSDKVideoEncodedFrame();
        encodedFrame.codecType = videoEncodedFrame.codecType == null ? 3 : videoEncodedFrame.codecType.intValue;
        encodedFrame.frameType = videoEncodedFrame.frameType == null ? 1 : videoEncodedFrame.frameType.intValue;
        encodedFrame.nalData = videoEncodedFrame.nalData;
        encodedFrame.nalLengths = videoEncodedFrame.nalLengths;
        encodedFrame.timestampUs = videoEncodedFrame.timestampUs;
        encodedFrame.height = videoEncodedFrame.height;
        encodedFrame.width = videoEncodedFrame.width;
        return encodedFrame;
    }

    public static LiteSDKAudioEncodedFrame getLiteAudioEncodedFrame(NERtcAudioEncodedFrame videoEncodedFrame) {
        LiteSDKAudioEncodedFrame encodedFrame = new LiteSDKAudioEncodedFrame();
        encodedFrame.payloadType = videoEncodedFrame.payloadType == null ? 111 : videoEncodedFrame.payloadType.intValue;
        encodedFrame.data = videoEncodedFrame.data;
        encodedFrame.timeStampUs = videoEncodedFrame.timeStampUs;
        encodedFrame.sampleRate = videoEncodedFrame.sampleRate;
        encodedFrame.channels = videoEncodedFrame.channels;
        encodedFrame.samplesPerChannel = videoEncodedFrame.samplesPerChannel;
        encodedFrame.encodedLen = videoEncodedFrame.encodedLen;
        encodedFrame.encodedTimestamp = videoEncodedFrame.encodedTimestamp;
        encodedFrame.rmsLevel = videoEncodedFrame.rmsLevel;
        return encodedFrame;
    }

    public static int getLiteSpatializerRenderMode(NERtcSpatializerRenderMode mode) {
        int liteType;
        if (mode == null) {
            return 0;
        }
        switch (mode) {
            case kNERtcSpatializerRenderBinauralLowQuality: {
                liteType = 1;
                break;
            }
            case kNERtcSpatializerRenderBinauralMediumQuality: {
                liteType = 2;
                break;
            }
            case kNERtcSpatializerRenderBinauralHighQuality: {
                liteType = 3;
                break;
            }
            case kNERtcSpatializerRenderRoomEffectsOnly: {
                liteType = 4;
                break;
            }
            default: {
                liteType = 0;
            }
        }
        return liteType;
    }

    public static int getLiteRangeAudioMode(NERtcRangeAudioMode mode) {
        int liteType;
        if (mode == null) {
            return 0;
        }
        switch (mode) {
            case kNERtcRangeAudioModeTeam: {
                liteType = 1;
                break;
            }
            case kNERtcRangeAudioModeDefault: {
                liteType = 0;
                break;
            }
            default: {
                liteType = 0;
            }
        }
        return liteType;
    }

    public static String getVideoStreamTypeString(NERtcVideoStreamType streamType) {
        String streamTypeString;
        if (streamType == null) {
            return "null";
        }
        switch (streamType) {
            case kNERtcVideoStreamTypeSub: {
                streamTypeString = "VideoStreamTypeSub";
                break;
            }
            default: {
                streamTypeString = "VideoStreamTypeMain";
            }
        }
        return streamTypeString;
    }

    public static boolean isExternalRender(IVideoRender render) {
        if (render == null) {
            return false;
        }
        return render.isExternalRender();
    }

    public static int getBufferType(IVideoRender render) {
        int bufferType;
        if (render == null) {
            return 0;
        }
        switch (render.getVideoBufferType()) {
            case VIDEO_BUFFER_TYPE_TEXTURE: {
                bufferType = 1;
                break;
            }
            default: {
                bufferType = 0;
            }
        }
        return bufferType;
    }

    public static IVideoRender.VideoBufferType getBufferType(int bufferType) {
        IVideoRender.VideoBufferType internalBufferType;
        switch (bufferType) {
            case 1: {
                internalBufferType = IVideoRender.VideoBufferType.VIDEO_BUFFER_TYPE_TEXTURE;
                break;
            }
            default: {
                internalBufferType = IVideoRender.VideoBufferType.VIDEO_BUFFER_TYPE_RAW_DATA;
            }
        }
        return internalBufferType;
    }

    public static NERtcAudioStreamType getAudioStreamTypeFromLite(int liteType) {
        switch (liteType) {
            case 1: {
                return NERtcAudioStreamType.kNERtcAudioStreamTypeSub;
            }
            case 0: {
                return NERtcAudioStreamType.kNERtcAudioStreamTypeMain;
            }
        }
        return null;
    }
}

