/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.impl.live;

import com.netease.lava.nertc.sdk.live.NERtcLiveStreamImageInfo;
import com.netease.lava.nertc.sdk.live.NERtcLiveStreamTaskInfo;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.model.live.LiteSDKLiveConfig;
import com.netease.yunxin.lite.model.live.LiteSDKLiveStreamImageInfo;
import com.netease.yunxin.lite.model.live.LiteSDKLiveStreamLayout;
import com.netease.yunxin.lite.model.live.LiteSDKLiveStreamTaskInfo;
import com.netease.yunxin.lite.model.live.LiteSDKLiveStreamUserTranscoding;

public class NERtcLiveStreamHelper {
    private static final String TAG = "NERtcLiveStreamHelper";

    public static LiteSDKLiveStreamTaskInfo convertLiveStreamTaskInfo(NERtcLiveStreamTaskInfo taskInfo) {
        if (taskInfo == null) {
            Logging.e(TAG, "convertLiveStreamTaskInfo: task info is null");
            return null;
        }
        LiteSDKLiveStreamTaskInfo info = new LiteSDKLiveStreamTaskInfo();
        info.taskId = taskInfo.taskId;
        info.url = taskInfo.url;
        info.serverRecordEnabled = taskInfo.serverRecordEnabled;
        if (taskInfo.liveMode == null) {
            Logging.e(TAG, "convertLiveStreamTaskInfo: liveMode is null");
            return null;
        }
        switch (taskInfo.liveMode) {
            case kNERtcLsModeAudio: {
                info.liveMode = LiteSDKLiveStreamTaskInfo.LiteSDKLiveStreamMode.kLiteSDKLsModeAudio;
                break;
            }
            case kNERtcLsModeVideo: {
                info.liveMode = LiteSDKLiveStreamTaskInfo.LiteSDKLiveStreamMode.kLiteSDKLsModeVideo;
                break;
            }
        }
        if (taskInfo.layout != null) {
            int i;
            info.layout = new LiteSDKLiveStreamLayout();
            info.layout.width = taskInfo.layout.width;
            info.layout.height = taskInfo.layout.height;
            info.layout.backgroundColor = taskInfo.layout.backgroundColor & 0xFFFFFF;
            if (taskInfo.layout.backgroundImgList != null && !taskInfo.layout.backgroundImgList.isEmpty()) {
                info.layout.backgroundImgArray = new LiteSDKLiveStreamImageInfo[taskInfo.layout.backgroundImgList.size()];
                for (i = 0; i < taskInfo.layout.backgroundImgList.size(); ++i) {
                    LiteSDKLiveStreamImageInfo backgroundImg = new LiteSDKLiveStreamImageInfo();
                    NERtcLiveStreamImageInfo imageInfo = taskInfo.layout.backgroundImgList.get(i);
                    backgroundImg.url = imageInfo.url;
                    backgroundImg.x = imageInfo.x;
                    backgroundImg.y = imageInfo.y;
                    backgroundImg.width = imageInfo.width;
                    backgroundImg.height = imageInfo.height;
                    backgroundImg.zOrder = imageInfo.zOrder;
                    info.layout.backgroundImgArray[i] = backgroundImg;
                }
            } else if (taskInfo.layout.backgroundImg != null) {
                info.layout.backgroundImgArray = new LiteSDKLiveStreamImageInfo[1];
                LiteSDKLiveStreamImageInfo backgroundImg = new LiteSDKLiveStreamImageInfo();
                backgroundImg.url = taskInfo.layout.backgroundImg.url;
                backgroundImg.x = taskInfo.layout.backgroundImg.x;
                backgroundImg.y = taskInfo.layout.backgroundImg.y;
                backgroundImg.width = taskInfo.layout.backgroundImg.width;
                backgroundImg.height = taskInfo.layout.backgroundImg.height;
                info.layout.backgroundImgArray[0] = backgroundImg;
            }
            if (taskInfo.layout.userTranscodingList != null) {
                info.layout.userTranscodingArray = new LiteSDKLiveStreamUserTranscoding[taskInfo.layout.userTranscodingList.size()];
                for (i = 0; i < info.layout.userTranscodingArray.length; ++i) {
                    info.layout.userTranscodingArray[i] = new LiteSDKLiveStreamUserTranscoding();
                    info.layout.userTranscodingArray[i].uid = taskInfo.layout.userTranscodingList.get((int)i).uid;
                    info.layout.userTranscodingArray[i].videoPush = taskInfo.layout.userTranscodingList.get((int)i).videoPush;
                    info.layout.userTranscodingArray[i].audioPush = taskInfo.layout.userTranscodingList.get((int)i).audioPush;
                    info.layout.userTranscodingArray[i].adaption = LiteSDKLiveStreamUserTranscoding.LiteSDKLiveStreamVideoScaleMode.kLiteSDKLsModeVideoScaleFit;
                    if (taskInfo.layout.userTranscodingList.get((int)i).adaption != null) {
                        switch (taskInfo.layout.userTranscodingList.get((int)i).adaption) {
                            case kNERtcLsModeVideoScaleFit: {
                                info.layout.userTranscodingArray[i].adaption = LiteSDKLiveStreamUserTranscoding.LiteSDKLiveStreamVideoScaleMode.kLiteSDKLsModeVideoScaleFit;
                                break;
                            }
                            case kNERtcLsModeVideoScaleCropFill: {
                                info.layout.userTranscodingArray[i].adaption = LiteSDKLiveStreamUserTranscoding.LiteSDKLiveStreamVideoScaleMode.kLiteSDKLsModeVideoScaleCropFill;
                                break;
                            }
                        }
                    }
                    info.layout.userTranscodingArray[i].x = taskInfo.layout.userTranscodingList.get((int)i).x;
                    info.layout.userTranscodingArray[i].y = taskInfo.layout.userTranscodingList.get((int)i).y;
                    info.layout.userTranscodingArray[i].width = taskInfo.layout.userTranscodingList.get((int)i).width;
                    info.layout.userTranscodingArray[i].height = taskInfo.layout.userTranscodingList.get((int)i).height;
                    info.layout.userTranscodingArray[i].zOrder = taskInfo.layout.userTranscodingList.get((int)i).zOrder;
                }
            }
        }
        if (taskInfo.config != null) {
            info.config = new LiteSDKLiveConfig();
            info.config.singleVideoPassThrough = taskInfo.config.singleVideoPassThrough;
            info.config.audioBitrate = taskInfo.config.audioBitrate;
            if (taskInfo.config.sampleRate != null) {
                switch (taskInfo.config.sampleRate) {
                    case NERtcLiveStreamAudioSampleRate32000: {
                        info.config.sampleRate = LiteSDKLiveConfig.LiteSDKLiveStreamAudioSampleRate.LiteSDKLiveStreamAudioSampleRate32000;
                        break;
                    }
                    case NERtcLiveStreamAudioSampleRate44100: {
                        info.config.sampleRate = LiteSDKLiveConfig.LiteSDKLiveStreamAudioSampleRate.LiteSDKLiveStreamAudioSampleRate44100;
                        break;
                    }
                    case NERtcLiveStreamAudioSampleRate48000: {
                        info.config.sampleRate = LiteSDKLiveConfig.LiteSDKLiveStreamAudioSampleRate.LiteSDKLiveStreamAudioSampleRate48000;
                        break;
                    }
                }
            }
            info.config.channels = taskInfo.config.channels;
            if (taskInfo.config.audioCodecProfile != null) {
                switch (taskInfo.config.audioCodecProfile) {
                    case NERtcLiveStreamAudioCodecProfileLCAAC: {
                        info.config.audioCodecProfile = LiteSDKLiveConfig.LiteSDKLiveStreamAudioCodecProfile.LiteSDKLiveStreamAudioCodecProfileLCAAC;
                        break;
                    }
                    case NERtcLiveStreamAudioCodecProfileHEAAC: {
                        info.config.audioCodecProfile = LiteSDKLiveConfig.LiteSDKLiveStreamAudioCodecProfile.LiteSDKLiveStreamAudioCodecProfileHEAAC;
                        break;
                    }
                }
            }
            info.config.interruptedPlaceImage = taskInfo.config.interruptedPlaceImage;
            info.extraInfo = taskInfo.extraInfo;
        }
        return info;
    }
}

