/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.impl.stats;

import com.netease.lava.nertc.sdk.stats.NERtcStatsObserver;
import com.netease.yunxin.lite.model.LiteSDKMediaStatsAudioRecv;
import com.netease.yunxin.lite.model.LiteSDKMediaStatsAudioSend;
import com.netease.yunxin.lite.model.LiteSDKMediaStatsCommon;
import com.netease.yunxin.lite.model.LiteSDKMediaStatsNetworkQuality;
import com.netease.yunxin.lite.model.LiteSDKMediaStatsObserver;
import com.netease.yunxin.lite.model.LiteSDKMediaStatsVideoRecv;
import com.netease.yunxin.lite.model.LiteSDKMediaStatsVideoSend;
import com.netease.yunxin.lite.util.ThreadUtils;

public class NERtcStatsObserverWrapper
implements LiteSDKMediaStatsObserver {
    private final NERtcStatsObserver observer;

    public NERtcStatsObserverWrapper(NERtcStatsObserver observer) {
        this.observer = observer;
    }

    @Override
    public void onCommonStats(LiteSDKMediaStatsCommon commonStats) {
        if (commonStats == null) {
            return;
        }
        ThreadUtils.runOnUiThread(() -> this.observer.onRtcStats(commonStats));
    }

    @Override
    public void onAudioSendStats(LiteSDKMediaStatsAudioSend audioSendStats) {
        if (audioSendStats == null || audioSendStats.audioLayers.isEmpty()) {
            return;
        }
        ThreadUtils.runOnUiThread(() -> this.observer.onLocalAudioStats(audioSendStats));
    }

    @Override
    public void onAudioRecvStats(LiteSDKMediaStatsAudioRecv[] audioRecvStats) {
        if (audioRecvStats == null || audioRecvStats.length == 0) {
            return;
        }
        ThreadUtils.runOnUiThread(() -> this.observer.onRemoteAudioStats(audioRecvStats));
    }

    @Override
    public void onVideoSendStats(LiteSDKMediaStatsVideoSend videoSendStats) {
        if (videoSendStats == null || videoSendStats.videoLayers.isEmpty()) {
            return;
        }
        ThreadUtils.runOnUiThread(() -> this.observer.onLocalVideoStats(videoSendStats));
    }

    @Override
    public void onVideoRecvStats(LiteSDKMediaStatsVideoRecv[] videoRecvStats) {
        if (videoRecvStats == null || videoRecvStats.length == 0) {
            return;
        }
        ThreadUtils.runOnUiThread(() -> this.observer.onRemoteVideoStats(videoRecvStats));
    }

    @Override
    public void onNetworkQuality(LiteSDKMediaStatsNetworkQuality[] networkQualityStats) {
        if (networkQualityStats == null || networkQualityStats.length == 0) {
            return;
        }
        ThreadUtils.runOnUiThread(() -> this.observer.onNetworkQuality(networkQualityStats));
    }
}

