/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.pstn;

import com.netease.lava.nertc.sdk.NERtcLinkEngineCallback;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.model.LiteSDKLinkEngineSink;
import com.netease.yunxin.lite.util.ThreadUtils;

public class NERtcLinkSinkWrapper
implements LiteSDKLinkEngineSink {
    private static final String TAG = "NERtcLinkSinkWrapper";
    private NERtcLinkEngineCallback mCallback;

    public void setLinkCallback(NERtcLinkEngineCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public void onLinkDirectCallStartCall(String errorMsg, int errorCode, String sessionId) {
        Logging.i(TAG, "onLinkDirectCallStartCall errorMsg: " + errorMsg + ", errorCode : " + errorCode + ", sessionId : " + sessionId);
        NERtcLinkEngineCallback callback = this.mCallback;
        if (callback != null) {
            ThreadUtils.runOnUiThread(() -> callback.onDirectStartCall(errorCode, errorMsg));
        }
    }

    @Override
    public void onLinkDirectCallHangUp(String errorMsg, int errorCode, int hangupReason, boolean isCallEstablished) {
        Logging.i(TAG, "onLinkDirectCallHangUp errorMsg: " + errorMsg + ", errorCode : " + errorCode + ", hangupReason : " + hangupReason + ", isCallEstablished : " + isCallEstablished);
        NERtcLinkEngineCallback callback = this.mCallback;
        if (callback != null) {
            ThreadUtils.runOnUiThread(() -> callback.onDirectCallHangupWithReason(hangupReason, errorCode, errorMsg, isCallEstablished));
        }
    }

    @Override
    public void onLinkDirectCallRing(int code) {
        Logging.i(TAG, "onLinkDirectCallRing: " + code);
        NERtcLinkEngineCallback callback = this.mCallback;
        if (callback != null) {
            ThreadUtils.runOnUiThread(() -> callback.onDirectCallRing(code));
        }
    }

    @Override
    public void onLinkDirectCallAccept(int callType, int code) {
        Logging.i(TAG, "onLinkDirectCallAccept callType: " + callType + " ,code: " + code);
        NERtcLinkEngineCallback callback = this.mCallback;
        if (callback != null) {
            ThreadUtils.runOnUiThread(() -> callback.onDirectCallAccept(code));
            ThreadUtils.runOnUiThread(() -> callback.onDirectCallAccept(callType, code));
        }
    }

    @Override
    public void onLinkDirectCallDisconnect(String errorMsg, int errorCode) {
        Logging.i(TAG, "onLinkDirectCallDisconnect errorMsg: " + errorMsg + ", errorCode: " + errorCode);
        NERtcLinkEngineCallback callback = this.mCallback;
        if (callback != null) {
            ThreadUtils.runOnUiThread(() -> callback.onDirectCallDisconnectWithError(errorCode, errorMsg));
        }
    }
}

