/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.pstn;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import com.netease.lava.nertc.impl.NERtcCore;
import com.netease.lava.nertc.pstn.NERtcDirectCallParam;
import com.netease.lava.nertc.pstn.NERtcLinkSinkWrapper;
import com.netease.lava.nertc.sdk.NERtcLinkEngine;
import com.netease.lava.nertc.sdk.NERtcLinkEngineCallback;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.LiteEngineCenter;
import com.netease.yunxin.lite.LiteLinkEngine;
import com.netease.yunxin.lite.model.LiteSDKEngineConfig;
import com.netease.yunxin.lite.model.LiteSDKSessionInfo;
import com.netease.yunxin.lite.model.pstn.LinkEngineDirectCallParam;
import com.netease.yunxin.lite.model.pstn.LinkEngineParameter;
import com.netease.yunxin.lite.util.NativeLibLoader;
import com.netease.yunxin.lite.util.SystemInformation;
import com.netease.yunxin.lite.util.ThreadUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class NERtcPstnImpl
extends NERtcLinkEngine {
    private static final String TAG = "NERtcPstnImpl";
    private NERtcLinkEngineCallback mCallback;
    private final NERtcLinkSinkWrapper sinkWrapper = new NERtcLinkSinkWrapper();
    private LiteLinkEngine linkEngine;

    private NERtcPstnImpl() {
        NativeLibLoader.loadLibrary("nertc_sdk");
    }

    public static NERtcPstnImpl getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public int init(Context context, NERtcLinkEngineCallback callback) {
        int ret = 0;
        if (this.linkEngine != null) {
            return ret;
        }
        if (callback == null || context == null) {
            ret = 4;
        } else {
            this.mCallback = callback;
            if (this.isMainThread()) {
                ret = this.initPstn();
            } else {
                ThreadUtils.runOnUiThreadBlocking(this::initPstn);
                if (this.linkEngine == null) {
                    ret = 1;
                }
            }
        }
        return ret;
    }

    @Override
    public int directCallStartCall(NERtcDirectCallParam callParam) {
        if (this.linkEngine == null) {
            Logging.e(TAG, "link engine is null.");
            return 2;
        }
        if (callParam == null) {
            Logging.e(TAG, "callparam is null.");
            return 4;
        }
        if (callParam.getCallee().size() > 0) {
            Logging.i(TAG, "direct start call, callee = " + callParam.getCallee().get(0) + "channelName = " + callParam.getChannelName() + ", didNumber = " + callParam.getDidNumber() + "uid = " + callParam.getUid() + ", mediaType = " + callParam.getMediaType() + ", isNumberEncrypted = " + callParam.isNumberEncrypted());
        }
        if (TextUtils.isEmpty((CharSequence)callParam.getChannelName()) || callParam.getCallee() == null || callParam.getCallee().size() == 0 || TextUtils.isEmpty((CharSequence)callParam.getAppKey()) || TextUtils.isEmpty((CharSequence)callParam.getToken())) {
            Logging.w(TAG, "direct start call, param is invaild.");
            this.linkEngine.setSessionConfig(this.getRtcSessionConfig());
            JSONObject param = new JSONObject();
            try {
                String phoneNumber;
                String string = phoneNumber = callParam.getCallee() == null || callParam.getCallee().size() == 0 ? "" : callParam.getCallee().get(0);
                if (phoneNumber.length() > 7) {
                    phoneNumber = phoneNumber.replaceAll("(\\w{3})\\w*(\\w{4})", "$1****$2");
                }
                param.put("callee", (Object)phoneNumber);
                param.put("channelName", (Object)callParam.getChannelName());
                param.put("uid", callParam.getUid());
                param.put("didNumber", (Object)callParam.getDidNumber());
                param.put("mediaType", callParam.getMediaType());
                param.put("traceId", (Object)callParam.getTraceId());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.linkEngine.reportApiEvent("directCallStartCallWithParam", 4, param.toString());
            return 4;
        }
        LinkEngineDirectCallParam directCallParam = new LinkEngineDirectCallParam();
        directCallParam.setUid(callParam.getUid());
        directCallParam.setToken(callParam.getToken());
        directCallParam.setDeviceId(SystemInformation.getDeviceId());
        directCallParam.setCallee(callParam.getCallee());
        directCallParam.setCallMediaType(callParam.getMediaType());
        directCallParam.setChannelName(callParam.getChannelName());
        directCallParam.setAppKey(callParam.getAppKey());
        directCallParam.setDidNumber(callParam.getDidNumber());
        directCallParam.setTraceId(callParam.getTraceId());
        directCallParam.setNumberEncrypted(callParam.isNumberEncrypted());
        return this.linkEngine.directCallStartCall(directCallParam, this.getRtcSessionConfig());
    }

    @Override
    public int directCallHangup() {
        Logging.i(TAG, "direct call hang up.");
        int ret = this.linkEngine == null ? 2 : this.linkEngine.directCallHangup(this.getRtcSessionConfig());
        return ret;
    }

    private LiteSDKSessionInfo getRtcSessionConfig() {
        if (NERtcCore.getInstance().getMainChannel() != null && NERtcCore.getInstance().getMainChannel().getLiteEngine() != null) {
            return NERtcCore.getInstance().getMainChannel().getLiteEngine().getRoomSessionInfo();
        }
        return new LiteSDKSessionInfo();
    }

    private int initPstn() {
        Logging.i(TAG, "initPstn");
        LiteSDKEngineConfig engineConfig = new LiteSDKEngineConfig();
        engineConfig.mode = 2;
        this.linkEngine = LiteEngineCenter.createLinkEngine(engineConfig, this.sinkWrapper);
        if (this.linkEngine != null) {
            int ret = this.linkEngine.initialize(new LinkEngineParameter());
            if (ret != 0) {
                return 1;
            }
            this.linkEngine.setSessionConfig(this.getRtcSessionConfig());
            JSONObject param = new JSONObject();
            try {
                param.put("context_delegate", (Object)(this.mCallback != null ? this.mCallback.toString() : "null"));
            }
            catch (JSONException e) {
                Logging.e(TAG, "initPstn report put error!");
            }
            this.linkEngine.reportApiEvent("setUpEngineWithContextInLinkEngine", 0, param.toString());
            this.sinkWrapper.setLinkCallback(this.mCallback);
            return 0;
        }
        return 1;
    }

    @Override
    public void release() {
        Logging.i(TAG, "release start.");
        if (this.linkEngine == null) {
            return;
        }
        LiteEngineCenter.destroyLinkEngine(this.linkEngine);
        this.linkEngine = null;
    }

    private boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    private static class SingletonHolder {
        static NERtcPstnImpl instance = new NERtcPstnImpl();

        private SingletonHolder() {
        }
    }
}

