/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.sdk.video;

import com.netease.lava.api.IVideoRender;
import com.netease.lava.nertc.impl.VideoFrameUtils;
import com.netease.lava.nertc.impl.lite.LiteHelper;
import com.netease.lava.nertc.sdk.NERtcExternalVideoRenderer;
import com.netease.lava.nertc.sdk.video.NERtcVideoFrame;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.yunxin.lite.annotation.Keep;

public class NERtcExternalVideoRendererWrapper
implements IVideoRender {
    private static final String TAG = "NERtcExternalVideoRendererWrapper";
    private NERtcExternalVideoRenderer renderer;

    public NERtcExternalVideoRendererWrapper(NERtcExternalVideoRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void setScalingType(IVideoRender.ScalingType type) {
    }

    @Override
    public IVideoRender.VideoBufferType getVideoBufferType() {
        if (this.renderer == null) {
            Logging.e(TAG, "getVideoBufferType renderer is null");
            return IVideoRender.VideoBufferType.VIDEO_BUFFER_TYPE_RAW_DATA;
        }
        return LiteHelper.getBufferType(this.renderer.getBufferType());
    }

    @Override
    public boolean isExternalRender() {
        return true;
    }

    @Override
    public void setMirror(boolean mirror) {
    }

    @Override
    public boolean isMirror() {
        return false;
    }

    @Override
    public void clearImage() {
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        if (this.renderer == null) {
            return;
        }
        if (videoFrame == null) {
            return;
        }
        NERtcVideoFrame rtcVideoFrame = new NERtcVideoFrame();
        rtcVideoFrame.width = videoFrame.getBuffer().getWidth();
        rtcVideoFrame.height = videoFrame.getBuffer().getHeight();
        rtcVideoFrame.rotation = videoFrame.getRotation();
        rtcVideoFrame.timeStamp = videoFrame.getTimestampNs();
        if (videoFrame.getBuffer() instanceof VideoFrame.I420Buffer) {
            VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)videoFrame.getBuffer();
            int chromaHeight = (i420Buffer.getHeight() + 1) / 2;
            int sizeY = i420Buffer.getHeight() * i420Buffer.getStrideY();
            int sizeU = chromaHeight * i420Buffer.getStrideU();
            int sizeV = chromaHeight * i420Buffer.getStrideV();
            int dataLength = sizeY + sizeU + sizeV;
            rtcVideoFrame.strideY = i420Buffer.getStrideY();
            rtcVideoFrame.strideU = i420Buffer.getStrideU();
            rtcVideoFrame.strideV = i420Buffer.getStrideV();
            if (rtcVideoFrame.data == null || rtcVideoFrame.data.length < dataLength) {
                rtcVideoFrame.data = new byte[dataLength];
            }
        }
        rtcVideoFrame = VideoFrameUtils.getNeRTCVideoFrame(videoFrame, false, rtcVideoFrame);
        this.renderer.onRenderFrame(rtcVideoFrame);
    }

    @Keep
    @CalledByNative
    public NERtcExternalVideoRenderer getRenderer() {
        return this.renderer;
    }
}

