/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.nertc.sdk.video;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.netease.lava.api.IVideoRender;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.yunxin.lite.video.VideoViewActionListener;
import com.netease.yunxin.lite.video.render.LiteTextureView;

public class NERtcTextureView
extends FrameLayout
implements IVideoRender {
    public LiteTextureView mVideoView;
    private VideoViewActionListener viewActionListener;
    private int streamType;

    public NERtcTextureView(Context context) {
        super(context);
        this.init(context);
    }

    public NERtcTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mVideoView = new LiteTextureView(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.addView((View)this.mVideoView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setScalingType(int type) {
        IVideoRender.ScalingType scalingType;
        switch (type) {
            case 1: {
                scalingType = IVideoRender.ScalingType.SCALE_ASPECT_FILL;
                break;
            }
            case 2: {
                scalingType = IVideoRender.ScalingType.SCALE_ASPECT_BALANCED;
                break;
            }
            default: {
                scalingType = IVideoRender.ScalingType.SCALE_ASPECT_FIT;
            }
        }
        this.setScalingType(scalingType);
    }

    @Override
    public void setScalingType(IVideoRender.ScalingType type) {
        this.mVideoView.setScalingType(type);
    }

    @Override
    public void setVideoBufferType(IVideoRender.VideoBufferType bufferType) {
    }

    @Override
    public IVideoRender.VideoBufferType getVideoBufferType() {
        return IVideoRender.VideoBufferType.VIDEO_BUFFER_TYPE_RAW_DATA;
    }

    @Override
    public void setExternalRender(boolean enable) {
    }

    @Override
    public boolean isExternalRender() {
        return false;
    }

    @Override
    public void setMirror(boolean mirror) {
        if (this.viewActionListener != null) {
            this.viewActionListener.mirrorChange(this.streamType, mirror);
        }
    }

    @Override
    public boolean isMirror() {
        return this.mVideoView.isMirror();
    }

    public void setVisibility(int visibility) {
        this.mVideoView.setVisibility(visibility);
        super.setVisibility(visibility);
    }

    @Override
    public void clearImage() {
        this.mVideoView.clearImage();
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.mVideoView.onFrame(videoFrame);
    }

    @Override
    public void setViewActionListener(VideoViewActionListener viewActionListener, int type) {
        this.viewActionListener = viewActionListener;
        this.streamType = type;
    }
}

