/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.SystemClock;
import android.view.Surface;
import com.netease.lava.webrtc.CompatVideoCodecInfo;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.EncodedImage;
import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.JavaNV12Buffer;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.MediaCodecUtils;
import com.netease.lava.webrtc.MediaCodecWrapper;
import com.netease.lava.webrtc.MediaCodecWrapperFactory;
import com.netease.lava.webrtc.SurfaceTextureHelper;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.VideoCodecStatus;
import com.netease.lava.webrtc.VideoCodecType;
import com.netease.lava.webrtc.VideoDecoder;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.VideoSink;
import com.netease.lava.webrtc.YuvHelper;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class AndroidVideoDecoder
implements VideoDecoder,
VideoSink {
    private static final String TAG = "AndroidVideoDecoder";
    private static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    private static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 150000;
    private static final int TEXTURE_DECODED_WAITING_RENDER_THRESHOLD = 15;
    private boolean enableTextureWaitingRenderTimeoutFallback;
    private float fallBackDropRateThreshold;
    private int textureDelayTimeMs = 2;
    private int textureDropCount = -1;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    @Nullable
    private final String codecName;
    private final VideoCodecType codecType;
    private final BlockingDeque<FrameInfo> frameInfos;
    private int colorFormat;
    @Nullable
    private Thread outputThread;
    private ThreadUtils.ThreadChecker outputThreadChecker;
    private ThreadUtils.ThreadChecker decoderThreadChecker;
    private volatile boolean running;
    private volatile boolean codecReleased;
    @Nullable
    private volatile Exception shutdownException;
    private final Object dimensionLock = new Object();
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private boolean keyFrameRequired;
    private int fallbackResolution;
    private int hwDecNV12ToRender;
    @Nullable
    private final EglBase.Context sharedContext;
    private int initDropFrameCount;
    private int dropedFrameCount;
    private int outputErrorCnt;
    private volatile boolean reInit;
    private boolean syncMode;
    private int dequeOutputTimeoutUs;
    private boolean enableHwDecInStuckDetector;
    private boolean forceHardwareDecode;
    private volatile boolean outputThreadError;
    @Nullable
    private FallBackChecker fallBackChecker;
    @Nullable
    private DecodeInputStuckDetector decodeInputStuckDetector;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private Surface surface;
    @Nullable
    private CompatVideoCodecInfo compatInfo;
    private MediaCodecInfo.CodecCapabilities capabilities;
    private final Object renderedTextureMetadataLock = new Object();
    @Nullable
    private DecodedTextureMetadata renderedTextureMetadata;
    @Nullable
    private VideoDecoder.Callback callback;
    @Nullable
    private MediaCodecWrapper codec;
    private boolean printOnce = true;

    AndroidVideoDecoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, VideoCodecType codecType, @Nullable EglBase.Context sharedContext, CompatVideoCodecInfo compatInfo, MediaCodecInfo.CodecCapabilities capabilities) {
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = compatInfo.getCodecName();
        this.codecType = codecType;
        this.colorFormat = compatInfo.getDecoderColorFormat();
        this.sharedContext = sharedContext;
        this.initDropFrameCount = compatInfo.getInitDropFrameCount();
        this.frameInfos = new LinkedBlockingDeque<FrameInfo>();
        this.textureDelayTimeMs = compatInfo.getTextureDelayTimeMs();
        this.fallbackResolution = compatInfo.getDecFallbackResolution();
        this.hwDecNV12ToRender = compatInfo.getHWDecNV12ToRender();
        this.fallBackDropRateThreshold = compatInfo.getDecFallbackDropRate() > 0.0f ? compatInfo.getDecFallbackDropRate() : 0.15f;
        this.enableTextureWaitingRenderTimeoutFallback = compatInfo.isEnableDecTextureWaitingRenderTimeoutFallback();
        this.capabilities = capabilities;
        this.enableHwDecInStuckDetector = compatInfo.getEnableDecInputStuckDetector();
        this.forceHardwareDecode = codecType == VideoCodecType.H264 ? compatInfo.getForceHardwareDecodeingForH264() == 1 : (codecType == VideoCodecType.H265 ? compatInfo.getForceHardwareDecodeingForH265() == 1 : false);
    }

    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        try {
            this.decoderThreadChecker = new ThreadUtils.ThreadChecker();
            boolean isSizeSupport = MediaCodecUtils.checkSize(this.capabilities, settings.width, settings.height, this.fallbackResolution);
            if (!isSizeSupport && !this.forceHardwareDecode) {
                Logging.w(TAG, " initDecode: " + settings.width + " x " + settings.height + " isSizeSupport: " + isSizeSupport + " FALLBACK_SOFTWARE");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (this.fallbackResolution > 0 && settings.width * settings.height < this.fallbackResolution) {
                Logging.w(TAG, " initDecode: " + settings.width + " x " + settings.height + " fallbackResolution " + this.fallbackResolution + " FALLBACK_SOFTWARE");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            this.callback = callback;
            if (this.sharedContext != null) {
                this.surfaceTextureHelper = this.createSurfaceTextureHelper();
                this.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
                this.surfaceTextureHelper.startListening(this);
            }
            this.syncMode = settings.syncMode;
            this.dequeOutputTimeoutUs = settings.syncMode ? 1000 : 150000;
            Logging.i(TAG, "ctor codecName: " + this.codecName + " codecType: " + (Object)((Object)this.codecType) + " colorFormat: " + this.colorFormat + " sharedContext: " + this.sharedContext + ", drop : " + this.initDropFrameCount + " textureDelayTimeMs: " + this.textureDelayTimeMs + " isSizeSupport: " + isSizeSupport + " width: " + settings.width + " height: " + settings.height + " syncMode: " + settings.syncMode + " maxSupportedInstances: " + MediaCodecUtils.getMaxSupportedInstances(this.capabilities) + " currentCodecInstances: " + MediaCodecUtils.getCodecInstances(false, this.codecName) + " enableHwDecInStuckDetector: " + this.enableHwDecInStuckDetector + " forceHardwareDecode: " + this.forceHardwareDecode + " enableTextureWaitingRenderTimeoutFallback: " + this.enableTextureWaitingRenderTimeoutFallback + " dropRateThreshold: " + this.fallBackDropRateThreshold);
            return this.initDecodeInternal(settings.width, settings.height);
        }
        catch (Exception e) {
            Logging.e(TAG, "initDecode failed so fallback software");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
    }

    private VideoCodecStatus initDecodeInternal(int width, int height) {
        this.decoderThreadChecker.checkIsOnValidThread();
        if (this.outputThread != null) {
            Logging.e(TAG, "initDecodeInternal called while the codec is already running");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (!this.isSupportedColorFormat(this.colorFormat)) {
            Logging.e(TAG, "Unsupported color format: " + this.colorFormat);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        boolean isWithinInstancesRange = MediaCodecUtils.checkCodecInstances(this.capabilities, false, this.codecName);
        if (!isWithinInstancesRange) {
            Logging.w(TAG, " initDecodeInternal:  currentCodecInstances: " + MediaCodecUtils.getCodecInstances(false, this.codecName) + " maxSupportedInstances: " + MediaCodecUtils.getMaxSupportedInstances(this.capabilities) + " isWithinInstancesRange : " + isWithinInstancesRange);
        }
        this.width = width;
        this.height = height;
        this.stride = width;
        this.sliceHeight = height;
        this.hasDecodedFirstFrame = false;
        this.keyFrameRequired = true;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (Exception e) {
            Logging.e(TAG, "Cannot create media decoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        try {
            MediaCodecUtils.addCodecInstances(false, this.codecName);
            MediaFormat format = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)width, (int)height);
            if (this.sharedContext == null) {
                format.setInteger("color-format", this.colorFormat);
            }
            Logging.d(TAG, "Format: " + format);
            this.codec.configure(format, this.surface, null, 0);
            this.codec.start();
        }
        catch (Exception e) {
            Logging.e(TAG, "initDecode failed", e);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.fallBackChecker = new FallBackChecker();
        this.decodeInputStuckDetector = new DecodeInputStuckDetector();
        if (this.fallBackDropRateThreshold > 0.0f) {
            this.fallBackChecker.updateDropRateThreshold(this.fallBackDropRateThreshold);
        }
        this.running = true;
        this.codecReleased = false;
        this.reInit = false;
        this.outputThreadError = false;
        if (!this.syncMode) {
            this.outputThread = this.createOutputThread();
            this.outputThread.start();
        } else {
            this.outputThreadChecker = new ThreadUtils.ThreadChecker();
        }
        this.dropedFrameCount = 0;
        Logging.d(TAG, "initDecodeInternal done");
        return VideoCodecStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus decode(EncodedImage frame, VideoDecoder.DecodeInfo info) {
        ByteBuffer buffer;
        int index;
        int height;
        int width;
        this.decoderThreadChecker.checkIsOnValidThread();
        long decodeInStartTimeMs = SystemClock.elapsedRealtime();
        if (this.outputThreadError) {
            Logging.e(TAG, "decode too much error ,fallback to software!");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (frame.isDecodeStuck && this.enableHwDecInStuckDetector && this.decodeInputStuckDetector != null) {
            this.decodeInputStuckDetector.updateAverageDecodeTimeThreshold(frame.netRecvFrameRate);
            if (this.decodeInputStuckDetector.isDecodeInStuck()) {
                Logging.e(TAG, "decode input stuck, average decode in time: " + this.decodeInputStuckDetector.getAverageDecoderInCostTime() + " netRecvframeRate: " + frame.netRecvFrameRate + " decodeInputStuckDetectorThreshold: " + this.decodeInputStuckDetector.getAverageDecodeTimeThreshold() + " try to fallback softwore!");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
        }
        if (this.codec == null || this.callback == null) {
            Logging.d(TAG, "decode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (frame.buffer == null) {
            Logging.e(TAG, "decode() - no input data");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        int size = frame.buffer.remaining();
        if (size == 0) {
            Logging.e(TAG, "decode() - input buffer empty");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        if (this.syncMode && this.frameInfos.size() > 0) {
            this.loopForDeliverDecodedFrame();
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
        }
        if (frame.encodedWidth * frame.encodedHeight > 0 && (frame.encodedWidth != width || frame.encodedHeight != height) || this.reInit) {
            boolean isSizeSupport = MediaCodecUtils.checkSize(this.capabilities, frame.encodedWidth, frame.encodedHeight, this.fallbackResolution);
            if (!isSizeSupport && !this.forceHardwareDecode) {
                Logging.w(TAG, " reinitDecode: " + frame.encodedWidth + " x " + frame.encodedHeight + " isSizeSupport: " + isSizeSupport + " FALLBACK_SOFTWARE");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (this.fallbackResolution > 0 && frame.encodedWidth * frame.encodedHeight < this.fallbackResolution) {
                Logging.w(TAG, " reinitDecode: " + frame.encodedWidth + " x " + frame.encodedHeight + " fallbackResolution " + this.fallbackResolution + " FALLBACK_SOFTWARE");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            VideoCodecStatus status = this.reinitDecode(frame.encodedWidth, frame.encodedHeight);
            if (status != VideoCodecStatus.OK) {
                return status;
            }
        }
        if (this.keyFrameRequired) {
            if (frame.frameType != EncodedImage.FrameType.VideoFrameKey) {
                Logging.e(TAG, "decode() - key frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
            if (!frame.completeFrame) {
                Logging.e(TAG, "decode() - complete frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
        }
        try {
            index = this.codec.dequeueInputBuffer(500000L);
        }
        catch (Exception e) {
            Logging.e(TAG, "dequeueInputBuffer failed", e);
            return VideoCodecStatus.ERROR;
        }
        if (index < 0) {
            Logging.e(TAG, "decode() - no HW buffers available; decoder falling behind");
            return VideoCodecStatus.ERROR;
        }
        try {
            buffer = this.codec.getInputBuffers()[index];
        }
        catch (Exception e) {
            Logging.e(TAG, "getInputBuffers failed", e);
            return VideoCodecStatus.ERROR;
        }
        if (buffer == null || buffer.capacity() < size) {
            Logging.e(TAG, "decode() - HW buffer too small");
            return VideoCodecStatus.ERROR;
        }
        buffer.put(frame.buffer);
        buffer.position(0);
        buffer.limit(size);
        this.frameInfos.offer(new FrameInfo(SystemClock.elapsedRealtime(), frame.rotation));
        try {
            this.codec.queueInputBuffer(index, 0, size, TimeUnit.NANOSECONDS.toMicros(frame.captureTimeNs), 0);
        }
        catch (Exception e) {
            Logging.e(TAG, "queueInputBuffer failed", e);
            this.frameInfos.pollLast();
            return VideoCodecStatus.ERROR;
        }
        if (this.keyFrameRequired) {
            this.keyFrameRequired = false;
        }
        if (this.fallBackChecker != null) {
            this.fallBackChecker.reportInput();
        }
        if (this.syncMode && this.frameInfos.size() > 0) {
            this.loopForDeliverDecodedFrame();
        }
        if (this.decodeInputStuckDetector != null) {
            long decoderInputCostTime = SystemClock.elapsedRealtime() - decodeInStartTimeMs;
            this.decodeInputStuckDetector.reportDecodeInputCostTime(decoderInputCostTime);
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public boolean getPrefersLateDecoding() {
        return true;
    }

    @Override
    @Nullable
    public String getImplementationName() {
        return this.codecName;
    }

    @Override
    public boolean isHardwareDecoder() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus release() {
        Logging.d(TAG, "release");
        VideoCodecStatus status = this.releaseInternal();
        if (this.surface != null) {
            this.releaseSurface();
            this.surface = null;
            this.surfaceTextureHelper.stopListening();
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
        }
        this.callback = null;
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private VideoCodecStatus releaseInternal() {
        Logging.d("AndroidVideoDecoder", "releaseInternal");
        if (!this.running && this.codecReleased) {
            Logging.d("AndroidVideoDecoder", "release: Decoder is not running.");
            return VideoCodecStatus.OK;
        }
        if (this.syncMode) {
            try {
                if (this.codec == null) ** GOTO lbl49
                this.outputThreadChecker.detachThread();
                releaseDone = new CountDownLatch(1);
                runMediaCodecRelease = new Runnable(){

                    @Override
                    public void run() {
                        AndroidVideoDecoder.this.releaseCodecOnOutputThread();
                        releaseDone.countDown();
                    }
                };
                new Thread(runMediaCodecRelease).start();
                if (!ThreadUtils.awaitUninterruptibly(releaseDone, 5000L)) {
                    Logging.e("AndroidVideoDecoder", "sync releaseCodecOnOutputThread timeout", new RuntimeException());
                    var3_7 = VideoCodecStatus.TIMEOUT;
                    return var3_7;
                }
                if (this.shutdownException == null) ** GOTO lbl49
                Logging.e("AndroidVideoDecoder", "sync releaseCodecOnOutputThread error", new RuntimeException(this.shutdownException));
                this.shutdownException = null;
                var3_8 = VideoCodecStatus.ERROR;
                return var3_8;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.codec = null;
                this.outputThread = null;
                this.frameInfos.clear();
            }
        } else {
            try {
                this.running = false;
                if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                    Logging.e("AndroidVideoDecoder", "Media decoder release timeout", new RuntimeException());
                    e = VideoCodecStatus.TIMEOUT;
                    return e;
                }
                if (this.shutdownException != null) {
                    Logging.e("AndroidVideoDecoder", "Media decoder release error", new RuntimeException(this.shutdownException));
                    this.shutdownException = null;
                    e = VideoCodecStatus.ERROR;
                    return e;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.codec = null;
                this.outputThread = null;
                this.frameInfos.clear();
            }
        }
        Logging.d("AndroidVideoDecoder", "releaseInternal done");
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus reinitDecode(int newWidth, int newHeight) {
        this.decoderThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "reinitDecode");
        VideoCodecStatus status = this.releaseInternal();
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        VideoCodecStatus ret = this.initDecodeInternal(newWidth, newHeight);
        Logging.d(TAG, "reinitDecode done");
        return ret;
    }

    private Thread createOutputThread() {
        return new Thread("AndroidVideoDecoder.outputThread"){

            @Override
            public void run() {
                AndroidVideoDecoder.this.outputThreadChecker = new ThreadUtils.ThreadChecker();
                while (AndroidVideoDecoder.this.running) {
                    AndroidVideoDecoder.this.deliverDecodedFrame();
                }
                AndroidVideoDecoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    private void loopForDeliverDecodedFrame() {
        while (this.syncMode && this.deliverDecodedFrame()) {
        }
    }

    protected boolean deliverDecodedFrame() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int result = this.codec.dequeueOutputBuffer(info, this.dequeOutputTimeoutUs);
            if (result < 0) {
                if (result == -2) {
                    this.reformat(this.codec.getOutputFormat());
                    return true;
                }
                if (result == -3) {
                    return true;
                }
                if (result == -1 && this.fallBackChecker != null) {
                    this.outputThreadError = this.fallBackChecker.isFallBack();
                    Logging.i(TAG, "drop rate: " + (double)this.fallBackChecker.getDropRate() * 1.0 + " return: " + result);
                }
                return false;
            }
            FrameInfo frameInfo = this.frameInfos.poll();
            int decodeTimeMs = 0;
            int rotation = 0;
            if (frameInfo != null) {
                decodeTimeMs = (int)(SystemClock.elapsedRealtime() - frameInfo.decodeStartTimeMs);
                rotation = frameInfo.rotation;
            }
            this.hasDecodedFirstFrame = true;
            if (this.surfaceTextureHelper != null) {
                this.deliverTextureFrame(result, info, rotation, decodeTimeMs);
            } else {
                this.deliverByteFrame(result, info, rotation, decodeTimeMs);
            }
            this.outputErrorCnt = 0;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.e(TAG, "deliverDecodedFrame failed.", e);
            ++this.outputErrorCnt;
            if (this.outputErrorCnt % 20 == 0) {
                this.stopOnOutputThread(e);
                this.reInit = true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTextureFrame(int index, MediaCodec.BufferInfo info, int rotation, Integer decodeTimeMs) {
        int height;
        int width;
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
        }
        object = this.renderedTextureMetadataLock;
        synchronized (object) {
            if (this.enableTextureWaitingRenderTimeoutFallback) {
                while (this.renderedTextureMetadata != null) {
                    try {
                        ++this.textureDropCount;
                        if (this.textureDropCount < 3) {
                            this.codec.releaseOutputBuffer(index, false);
                            return;
                        }
                        this.renderedTextureMetadataLock.wait(this.textureDelayTimeMs);
                        if (this.renderedTextureMetadata == null) continue;
                        if (this.textureDropCount % 5 == 0) {
                            Logging.e(TAG, "Meta data wait timed out,dropped 5 texture frames, current PTS: " + info.presentationTimeUs);
                        }
                        if (this.textureDropCount > 15) {
                            this.outputThreadError = true;
                        }
                        this.codec.releaseOutputBuffer(index, false);
                        return;
                    }
                    catch (InterruptedException ie) {
                        Logging.e(TAG, "should not happen,deliverTextureFrame Exception: " + ie);
                    }
                }
            } else if (this.renderedTextureMetadata != null) {
                this.codec.releaseOutputBuffer(index, false);
                return;
            }
            this.textureDropCount = 0;
            this.surfaceTextureHelper.setTextureSize(width, height);
            this.surfaceTextureHelper.setFrameRotation(rotation);
            this.renderedTextureMetadata = new DecodedTextureMetadata(info.presentationTimeUs, decodeTimeMs);
            this.codec.releaseOutputBuffer(index, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        int decodeTimeMs;
        long timestampNs;
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata == null) {
                Logging.e(TAG, "onTextureFrameAvailable, texture metadata is null!");
                return;
            }
            timestampNs = this.renderedTextureMetadata.presentationTimestampUs * 1000L;
            decodeTimeMs = this.renderedTextureMetadata.decodeTimeMs;
            this.renderedTextureMetadata = null;
            this.renderedTextureMetadataLock.notify();
        }
        VideoFrame frameWithModifiedTimeStamp = new VideoFrame(frame.getBuffer(), frame.getRotation(), timestampNs);
        int ret = this.callback.onDecodedFrame(frameWithModifiedTimeStamp, decodeTimeMs, null);
        if (ret >= 0) {
            this.fallBackChecker.reportOutput();
        } else {
            this.outputThreadError = this.fallBackChecker.isFallBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverByteFrame(int result, MediaCodec.BufferInfo info, int rotation, Integer decodeTimeMs) {
        VideoFrame.Buffer frameBuffer;
        int sliceHeight;
        int stride;
        int height;
        int width;
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
            stride = this.stride;
            sliceHeight = this.sliceHeight;
        }
        if (info.size < width * height * 3 / 2) {
            Logging.e(TAG, "Insufficient output buffer size: " + info.size);
            return;
        }
        if (info.size < stride * height * 3 / 2 && sliceHeight == height && stride > width) {
            int preStride = stride;
            stride = info.size * 2 / (height * 3);
            Logging.w(TAG, "codec report an incorrect stride: " + preStride + " Correct it here to: " + stride);
        }
        ByteBuffer buffer = this.codec.getOutputBuffers()[result];
        buffer.position(info.offset);
        buffer.limit(info.offset + info.size);
        buffer = buffer.slice();
        if (this.colorFormat == 19) {
            frameBuffer = this.copyI420Buffer(buffer, stride, sliceHeight, width, height);
        } else {
            frameBuffer = this.hwDecNV12ToRender > 0 ? this.copyNV12Buffer(buffer, stride, sliceHeight, width, height) : this.copyNV12ToI420Buffer(buffer, stride, sliceHeight, width, height);
            if (this.printOnce) {
                Logging.i(TAG, this.hwDecNV12ToRender > 0 ? "copyNV12Buffer" : "copyNV12ToI420Buffer");
                this.printOnce = false;
            }
        }
        this.codec.releaseOutputBuffer(result, false);
        long presentationTimeNs = info.presentationTimeUs * 1000L;
        VideoFrame frame = new VideoFrame(frameBuffer, rotation, presentationTimeNs);
        int ret = this.callback.onDecodedFrame(frame, decodeTimeMs, null);
        if (ret >= 0) {
            this.fallBackChecker.reportOutput();
        } else {
            this.outputThreadError = this.fallBackChecker.isFallBack();
        }
        frame.release();
    }

    private VideoFrame.Buffer copyNV12Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        if (stride % 2 != 0) {
            throw new AssertionError((Object)("Stride is not divisible by two: " + stride));
        }
        int chromaWidth = width;
        int chromaHeight = sliceHeight % 2 == 0 ? (height + 1) / 2 : height / 2;
        int uvStride = stride;
        boolean yPos = false;
        int yEnd = 0 + stride * height;
        int uvPos = 0 + stride * sliceHeight;
        int uvEnd = uvPos + uvStride * chromaHeight;
        VideoFrame.NV12Buffer frameBuffer = this.allocateNV12Buffer(width, height);
        buffer.limit(yEnd);
        buffer.position(0);
        this.copyPlane(buffer.slice(), stride, frameBuffer.getDataY(), frameBuffer.getStride(), width, height);
        buffer.limit(uvEnd);
        buffer.position(uvPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataUV(), frameBuffer.getStride(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(uvPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataUV = frameBuffer.getDataUV();
            dataUV.position(frameBuffer.getStride() * chromaHeight);
            dataUV.put(buffer);
        }
        return frameBuffer;
    }

    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        return new JavaNV12Buffer(width, height, stride, sliceHeight, buffer, null).toI420();
    }

    private VideoFrame.Buffer copyI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        if (stride % 2 != 0) {
            throw new AssertionError((Object)("Stride is not divisible by two: " + stride));
        }
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = sliceHeight % 2 == 0 ? (height + 1) / 2 : height / 2;
        int uvStride = stride / 2;
        boolean yPos = false;
        int yEnd = 0 + stride * height;
        int uPos = 0 + stride * sliceHeight;
        int uEnd = uPos + uvStride * chromaHeight;
        int vPos = uPos + uvStride * sliceHeight / 2;
        int vEnd = vPos + uvStride * chromaHeight;
        VideoFrame.I420Buffer frameBuffer = this.allocateI420Buffer(width, height);
        buffer.limit(yEnd);
        buffer.position(0);
        this.copyPlane(buffer.slice(), stride, frameBuffer.getDataY(), frameBuffer.getStrideY(), width, height);
        buffer.limit(uEnd);
        buffer.position(uPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataU(), frameBuffer.getStrideU(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(uPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataU = frameBuffer.getDataU();
            dataU.position(frameBuffer.getStrideU() * chromaHeight);
            dataU.put(buffer);
        }
        buffer.limit(vEnd);
        buffer.position(vPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataV(), frameBuffer.getStrideV(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(vPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataV = frameBuffer.getDataV();
            dataV.position(frameBuffer.getStrideV() * chromaHeight);
            dataV.put(buffer);
        }
        return frameBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformat(MediaFormat format) {
        int newHeight;
        int newWidth;
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Decoder format changed: " + format.toString());
        if (format.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && format.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
            newWidth = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) - format.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
            newHeight = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) - format.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
        } else {
            newWidth = format.getInteger("width");
            newHeight = format.getInteger("height");
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (newWidth != this.width || newHeight != this.height) {
                if (this.hasDecodedFirstFrame) {
                    this.stopOnOutputThread(new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + newWidth + "*" + newHeight));
                    return;
                }
                if (newWidth <= 0 || newHeight <= 0) {
                    Logging.w(TAG, "Unexpected format dimensions. Configured " + this.width + "*" + this.height + ". New " + newWidth + "*" + newHeight + ". Skip it");
                    return;
                }
                this.width = newWidth;
                this.height = newHeight;
            }
        }
        if (this.surfaceTextureHelper == null && format.containsKey("color-format")) {
            this.colorFormat = format.getInteger("color-format");
            Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
            if (!this.isSupportedColorFormat(this.colorFormat)) {
                this.stopOnOutputThread(new IllegalStateException("Unsupported color format: " + this.colorFormat));
                return;
            }
        }
        object = this.dimensionLock;
        synchronized (object) {
            if (format.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = format.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (format.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                this.sliceHeight = format.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            this.stride = Math.max(this.width, this.stride);
            this.sliceHeight = Math.max(this.height, this.sliceHeight);
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.i(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media decoder stop failed", e);
        }
        Logging.d(TAG, "Releasing MediaCodec on output thread, mediacodec stopped, releasing.");
        try {
            this.codec.release();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media decoder release failed", e);
            this.shutdownException = e;
        }
        MediaCodecUtils.removeCodecInstances(false, this.codecName);
        this.codecReleased = true;
        this.reInit = false;
        Logging.i(TAG, "Release on output thread done");
    }

    private void stopOnOutputThread(Exception e) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = e;
        Logging.i(TAG, "stopOnOutputThread, running = false");
        if (this.syncMode) {
            this.releaseCodecOnOutputThread();
            Logging.d(TAG, "stopOnOutputThread syncMode, releaseCodecOnOutputThread");
        }
    }

    private boolean isSupportedColorFormat(int colorFormat) {
        for (int supported : MediaCodecUtils.DECODER_COLOR_FORMATS) {
            if (supported != colorFormat) continue;
            return true;
        }
        return false;
    }

    protected SurfaceTextureHelper createSurfaceTextureHelper() {
        return SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext);
    }

    protected void releaseSurface() {
        this.surface.release();
    }

    protected VideoFrame.I420Buffer allocateI420Buffer(int width, int height) {
        return JavaI420Buffer.allocate(width, height);
    }

    protected VideoFrame.NV12Buffer allocateNV12Buffer(int width, int height) {
        return JavaNV12Buffer.allocate(width, height);
    }

    protected void copyPlane(ByteBuffer src, int srcStride, ByteBuffer dst, int dstStride, int width, int height) {
        YuvHelper.copyPlane(src, srcStride, dst, dstStride, width, height);
    }

    class DecodeInputStuckDetector {
        private static final long kWindowSizeMs = 2000L;
        private static final float kSensitivity = 0.8f;
        private float averageDecoderInCostTimeThreshold = -1.0f;
        private int inputCount = 0;
        private long totalDecoderInCostTime = 0L;
        private float averageDecoderInCostTime = 0.0f;
        private long currentTime = -1L;
        private boolean isWramUping = true;

        void reportDecodeInputCostTime(long decoderInCostTime) {
            this.totalDecoderInCostTime += decoderInCostTime;
            ++this.inputCount;
            this.processLogicalUnit();
        }

        private void processLogicalUnit() {
            if (this.currentTime == -1L) {
                this.currentTime = SystemClock.elapsedRealtime();
            }
            if (SystemClock.elapsedRealtime() - this.currentTime >= 2000L) {
                if (this.isWramUping) {
                    this.isWramUping = false;
                    this.averageDecoderInCostTime = (float)this.totalDecoderInCostTime / (float)this.inputCount;
                }
                this.averageDecoderInCostTime = this.averageDecoderInCostTime * 0.8f + 0.19999999f * (float)this.totalDecoderInCostTime / (float)this.inputCount;
                this.inputCount = 0;
                this.totalDecoderInCostTime = 0L;
                this.currentTime = SystemClock.elapsedRealtime();
            }
        }

        public float getAverageDecoderInCostTime() {
            return this.averageDecoderInCostTime;
        }

        boolean isDecodeInStuck() {
            if (this.averageDecoderInCostTimeThreshold > 0.0f) {
                return this.averageDecoderInCostTime > this.averageDecoderInCostTimeThreshold;
            }
            return false;
        }

        public void updateAverageDecodeTimeThreshold(float netRecvFrameRate) {
            this.averageDecoderInCostTimeThreshold = netRecvFrameRate > 30.0f ? Math.max(15.0f, 1000.0f / netRecvFrameRate - 2.0f) : 1000.0f / netRecvFrameRate - 5.0f;
        }

        public float getAverageDecodeTimeThreshold() {
            return this.averageDecoderInCostTimeThreshold;
        }
    }

    class FallBackChecker {
        private static final long kWindowSizeMs = 2000L;
        private static final float kSensitivity = 0.8f;
        private static final float kInputFrameCount = 30.0f;
        private float kDropRateThreshold = 0.15f;
        private final Object fallBackCheckerLock = new Object();
        private long curretTime = -1L;
        private long inputCount = 0L;
        private long outputCount = 0L;
        private float dropRate = 0.0f;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reportInput() {
            Object object = this.fallBackCheckerLock;
            synchronized (object) {
                this.processLogicalUnit();
                ++this.inputCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reportOutput() {
            Object object = this.fallBackCheckerLock;
            synchronized (object) {
                ++this.outputCount;
                this.processLogicalUnit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFallBack() {
            Object object = this.fallBackCheckerLock;
            synchronized (object) {
                this.processLogicalUnit();
                return this.dropRate > this.kDropRateThreshold;
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getDropRate() {
            Object object = this.fallBackCheckerLock;
            synchronized (object) {
                Logging.d(AndroidVideoDecoder.TAG, " inpinpuCount: " + this.inputCount + " outputCount: " + this.outputCount);
                return this.dropRate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateDropRateThreshold(float threshold) {
            Object object = this.fallBackCheckerLock;
            synchronized (object) {
                Logging.d(AndroidVideoDecoder.TAG, " setDropRateThreshold: " + threshold);
                this.kDropRateThreshold = threshold;
            }
        }

        private void processLogicalUnit() {
            if (this.curretTime == -1L) {
                this.curretTime = SystemClock.elapsedRealtime();
            }
            if (SystemClock.elapsedRealtime() - this.curretTime >= 2000L && (float)this.inputCount > 30.0f) {
                this.dropRate = this.dropRate * 0.8f + 0.19999999f * (float)(this.inputCount - this.outputCount) / (float)this.inputCount;
                this.inputCount = 0L;
                this.outputCount = 0L;
                this.curretTime = SystemClock.elapsedRealtime();
            }
        }
    }

    private static class DecodedTextureMetadata {
        final long presentationTimestampUs;
        final Integer decodeTimeMs;

        DecodedTextureMetadata(long presentationTimestampUs, Integer decodeTimeMs) {
            this.presentationTimestampUs = presentationTimestampUs;
            this.decodeTimeMs = decodeTimeMs;
        }
    }

    private static class FrameInfo {
        final long decodeStartTimeMs;
        final int rotation;

        FrameInfo(long decodeStartTimeMs, int rotation) {
            this.decodeStartTimeMs = decodeStartTimeMs;
            this.rotation = rotation;
        }
    }
}

