/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.os.SystemClock;
import android.view.Surface;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.EglBase14;
import com.netease.lava.webrtc.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@TargetApi(value=18)
public class EglBase14Impl
implements EglBase14 {
    private static final String TAG = "EglBase14Impl";
    private static final int EGLExt_SDK_VERSION = 18;
    private static final int CURRENT_SDK_VERSION = Build.VERSION.SDK_INT;
    private static final int MAX_CACHE_SIZE = 3;
    @Nullable
    private static ArrayList<EGL14ContextCache> egl14ContextCacheList;
    private EGLContext eglContext;
    @Nullable
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface = EGL14.EGL_NO_SURFACE;
    private int openGlesVersion;
    @Nullable
    private EGL14ContextCache currentEGL14ContextCache;
    private static final AtomicInteger contextCreateCount;
    private static final AtomicInteger contextReleaseCount;

    public static boolean isEGL14Supported() {
        Logging.d(TAG, "SDK version: " + CURRENT_SDK_VERSION + ". isEGL14Supported: " + (CURRENT_SDK_VERSION >= 18));
        return CURRENT_SDK_VERSION >= 18;
    }

    private static String createCacheKey(EGLContext sharedContext, int[] configAttributes) {
        return "context_" + sharedContext + "_config_" + Arrays.toString(configAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static EGL14ContextCache getEGL14ContextCache(EGLContext sharedContext, int[] configAttributes) {
        Class<EGL14ContextCache> clazz = EGL14ContextCache.class;
        synchronized (EGL14ContextCache.class) {
            if (egl14ContextCacheList == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            String key = EglBase14Impl.createCacheKey(sharedContext, configAttributes);
            EGL14ContextCache result = null;
            for (EGL14ContextCache contextCache : egl14ContextCacheList) {
                if (!contextCache.key.equals(key)) continue;
                result = contextCache;
                break;
            }
            if (result == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            ++result.hintCount;
            result.lastUseTime = SystemClock.elapsedRealtime() % Integer.MAX_VALUE;
            egl14ContextCacheList.remove(result);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cacheEGL14Context(EGL14ContextCache contextCache) {
        Class<EGL14ContextCache> clazz = EGL14ContextCache.class;
        synchronized (EGL14ContextCache.class) {
            if (egl14ContextCacheList == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            EGL14ContextCache removedCache = null;
            egl14ContextCacheList.add(contextCache);
            if (egl14ContextCacheList.size() > 3) {
                Collections.sort(egl14ContextCacheList, (o1, o2) -> (int)(o1.lastUseTime - o2.lastUseTime));
                removedCache = egl14ContextCacheList.remove(0);
            }
            if (removedCache != null && removedCache != contextCache) {
                Object object = EglBase.lock;
                synchronized (object) {
                    EGL14.eglDestroyContext((EGLDisplay)removedCache.eglDisplay, (EGLContext)removedCache.eglContext);
                }
                EGL14.eglTerminate((EGLDisplay)removedCache.eglDisplay);
                contextReleaseCount.incrementAndGet();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return removedCache != contextCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCache() {
        Class<EGL14ContextCache> clazz = EGL14ContextCache.class;
        synchronized (EGL14ContextCache.class) {
            EglBase14Impl.clearCache();
            egl14ContextCacheList = new ArrayList();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Class<EGL14ContextCache> clazz = EGL14ContextCache.class;
        synchronized (EGL14ContextCache.class) {
            if (egl14ContextCacheList == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            int hintCount = 0;
            for (EGL14ContextCache contextCache : egl14ContextCacheList) {
                Object object = EglBase.lock;
                synchronized (object) {
                    EGL14.eglDestroyContext((EGLDisplay)contextCache.eglDisplay, (EGLContext)contextCache.eglContext);
                }
                hintCount += contextCache.hintCount;
                EGL14.eglTerminate((EGLDisplay)contextCache.eglDisplay);
                contextReleaseCount.incrementAndGet();
            }
            Logging.d(TAG, "clearCache , totoal size: " + egl14ContextCacheList.size() + " , current create count: " + contextCreateCount.get() + " , release count: " + contextReleaseCount.get() + " , hint count: " + hintCount);
            egl14ContextCacheList = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public EglBase14Impl(EGLContext sharedContext, int[] configAttributes) {
        this.openGlesVersion = EglBase.getOpenGlesVersionFromConfig(configAttributes);
        this.currentEGL14ContextCache = EglBase14Impl.getEGL14ContextCache(sharedContext, configAttributes);
        if (this.currentEGL14ContextCache != null) {
            this.eglDisplay = this.currentEGL14ContextCache.eglDisplay;
            this.eglConfig = this.currentEGL14ContextCache.eglConfig;
            this.eglContext = this.currentEGL14ContextCache.eglContext;
        } else {
            this.eglDisplay = EglBase14Impl.getEglDisplay();
            this.eglConfig = EglBase14Impl.getEglConfig(this.eglDisplay, configAttributes);
            this.eglContext = EglBase14Impl.createEglContext(sharedContext, this.eglDisplay, this.eglConfig, this.openGlesVersion);
            String key = EglBase14Impl.createCacheKey(sharedContext, configAttributes);
            this.currentEGL14ContextCache = new EGL14ContextCache(key, this.eglContext, this.eglConfig, this.eglDisplay, configAttributes);
        }
        Logging.d(TAG, "currnet config hint count: " + this.currentEGL14ContextCache.hintCount + ", version: " + this.openGlesVersion);
    }

    @Override
    public void createSurface(Surface surface) {
        this.createSurfaceInternal(surface);
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    private void createSurfaceInternal(Object surface) {
        if (!(surface instanceof Surface) && !(surface instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a Surface or SurfaceTexture");
        }
        this.checkIsNotReleased();
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] surfaceAttribs = new int[]{12344};
        this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (Object)surface, (int[])surfaceAttribs, (int)0);
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int width, int height) {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])surfaceAttribs, (int)0);
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create pixel buffer surface with size " + width + "x" + height + ": 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
    }

    @Override
    public Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL14.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] widthArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])widthArray, (int)0);
        return widthArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] heightArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])heightArray, (int)0);
        return heightArray[0];
    }

    @Override
    public void releaseSurface() {
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY || this.eglContext == EGL14.EGL_NO_CONTEXT || this.eglConfig == null) {
            throw new RuntimeException("This object has been released");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.checkIsNotReleased();
        this.detachCurrent();
        this.releaseSurface();
        boolean cache = EglBase14Impl.cacheEGL14Context(this.currentEGL14ContextCache);
        if (cache) {
            EGL14.eglReleaseThread();
        } else {
            Object object = EglBase.lock;
            synchronized (object) {
                EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            }
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
            contextReleaseCount.incrementAndGet();
        }
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeCurrent() {
        this.checkIsNotReleased();
        Object object = EglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
                throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachCurrent() {
        Object object = EglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
                throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers(long timeStampNs) {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)timeStampNs);
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
        }
    }

    @Override
    public int getOpenGlesVersion() {
        return this.openGlesVersion;
    }

    private static EGLDisplay getEglDisplay() {
        EGLDisplay eglDisplay = EGL14.eglGetDisplay((int)0);
        if (eglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("Unable to get EGL14 display: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)eglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            throw new RuntimeException("Unable to initialize EGL14: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        return eglDisplay;
    }

    private static EGLConfig getEglConfig(EGLDisplay eglDisplay, int[] configAttributes) {
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)eglDisplay, (int[])configAttributes, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        if (numConfigs[0] <= 0) {
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        EGLConfig eglConfig = configs[0];
        if (eglConfig == null) {
            throw new RuntimeException("eglChooseConfig returned null");
        }
        return eglConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EGLContext createEglContext(@Nullable EGLContext sharedContext, EGLDisplay eglDisplay, EGLConfig eglConfig, int openGlesVersion) {
        EGLContext eglContext;
        if (sharedContext != null && sharedContext == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        int[] contextAttributes = new int[]{12440, openGlesVersion, 12344};
        EGLContext rootContext = sharedContext == null ? EGL14.EGL_NO_CONTEXT : sharedContext;
        Object object = EglBase.lock;
        synchronized (object) {
            eglContext = EGL14.eglCreateContext((EGLDisplay)eglDisplay, (EGLConfig)eglConfig, (EGLContext)rootContext, (int[])contextAttributes, (int)0);
        }
        if (eglContext == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("Failed to create EGL context , create: " + contextCreateCount.get() + ", release: " + contextReleaseCount.get() + " , error: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        contextCreateCount.incrementAndGet();
        return eglContext;
    }

    static {
        contextCreateCount = new AtomicInteger(0);
        contextReleaseCount = new AtomicInteger(0);
    }

    private static class EGL14ContextCache {
        String key;
        EGLContext eglContext;
        EGLConfig eglConfig;
        EGLDisplay eglDisplay;
        int[] configAttributes;
        int hintCount;
        long lastUseTime;

        public EGL14ContextCache(String key, EGLContext eglContext, EGLConfig eglConfig, EGLDisplay eglDisplay, int[] configAttributes) {
            this.key = key;
            this.eglContext = eglContext;
            this.eglConfig = eglConfig;
            this.eglDisplay = eglDisplay;
            this.configAttributes = configAttributes;
            this.lastUseTime = SystemClock.elapsedRealtime() % Integer.MAX_VALUE;
        }
    }

    public static class Context
    implements EglBase14.Context {
        private final EGLContext egl14Context;

        @Override
        public EGLContext getRawContext() {
            return this.egl14Context;
        }

        @Override
        @TargetApi(value=21)
        public long getNativeEglContext() {
            return CURRENT_SDK_VERSION >= 21 ? this.egl14Context.getNativeHandle() : (long)this.egl14Context.getHandle();
        }

        @Override
        public Object getEglContext() {
            return this.egl14Context;
        }

        public Context(EGLContext eglContext) {
            this.egl14Context = eglContext;
        }
    }
}

