/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.GlTextureFrameBuffer;
import com.netease.lava.webrtc.GlUtil;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.RendererCommon;
import com.netease.lava.webrtc.RendererGatherer;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.VideoFrameDrawer;
import com.netease.lava.webrtc.VideoRenderUtil;
import com.netease.lava.webrtc.VideoSink;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class EglRenderer
implements VideoSink {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 20L;
    private static final long ONE_SECONDS_TO_NANOS = TimeUnit.SECONDS.toNanos(1L);
    protected String name;
    protected long reportFpsIntervalMs = 20000L;
    private final Object handlerLock = new Object();
    @Nullable
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    @Nullable
    private EglBase eglBase;
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    @Nullable
    private RendererCommon.GlDrawer drawer;
    private boolean usePresentationTimeStamp;
    private final Matrix drawMatrix = new Matrix();
    private final Object frameLock = new Object();
    @Nullable
    private VideoFrame pendingFrame;
    private final Object layoutLock = new Object();
    private float layoutAspectRatio;
    private boolean mirror;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private long logPrintTimeNs;
    private int framesNoSurface;
    private RendererGatherer.EglRenderInfo eglRenderInfo;
    private RendererGatherer rendererGatherer;
    private final VideoRenderUtil renderUtil = new VideoRenderUtil();
    private final GlTextureFrameBuffer bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
    private final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EglRenderer.this.logStatistics();
            Object object = EglRenderer.this.handlerLock;
            synchronized (object) {
                if (EglRenderer.this.renderThreadHandler != null) {
                    EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                    EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, EglRenderer.this.reportFpsIntervalMs);
                }
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();

    public EglRenderer(String name) {
        this.name = name + ": ";
        this.eglRenderInfo = new RendererGatherer.EglRenderInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@Nullable EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer, boolean usePresentationTimeStamp) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.name + "Already initialized");
            }
            this.logD("Initializing EglRenderer");
            this.drawer = drawer;
            this.usePresentationTimeStamp = usePresentationTimeStamp;
            HandlerThread renderThread = new HandlerThread(this.name + TAG);
            renderThread.start();
            this.renderThreadHandler = new HandlerWithExceptionCallback(renderThread.getLooper(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = EglRenderer.this.handlerLock;
                    synchronized (object) {
                        EglRenderer.this.renderThreadHandler = null;
                    }
                }
            });
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, () -> {
                try {
                    if (sharedContext == null) {
                        this.logD("EglBase10.create context");
                        this.eglBase = EglBase.createEgl10(configAttributes);
                    } else {
                        this.logD("EglBase.create shared context");
                        this.eglBase = EglBase.create(sharedContext, configAttributes);
                    }
                }
                catch (Exception e) {
                    try {
                        if (sharedContext == null) {
                            this.logD("EglBase10.create new context");
                            this.eglBase = EglBase.createEgl10(EglBase.CONFIG_PLAIN);
                        } else {
                            this.logD("EglBase.create new shared context");
                            this.eglBase = EglBase.create(sharedContext, EglBase.CONFIG_PLAIN);
                        }
                    }
                    catch (Exception exception) {
                        this.eglBase = null;
                        String msg = "EglBase create context exception: " + exception.getMessage();
                        this.logE(msg);
                        this.onRenderError(this.name + msg);
                    }
                }
                this.renderUtil.create();
            });
            this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            long currentTimeNs = System.nanoTime();
            this.resetStatistics(currentTimeNs);
            this.renderThreadHandler.postDelayed(this.logStatisticsRunnable, this.reportFpsIntervalMs);
            this.eglRenderInfo.reset();
        }
    }

    public void init(@Nullable EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        this.init(sharedContext, configAttributes, drawer, false);
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    private void createEglSurfaceInternal(Object surface) {
        this.eglSurfaceCreationRunnable.setSurface(surface);
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD("Releasing.");
        CountDownLatch eglCleanupBarrier = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            this.renderThreadHandler.postAtFrontOfQueue(() -> {
                try {
                    if (this.eglBase != null) {
                        this.eglBase.makeCurrent();
                    }
                }
                catch (Exception e) {
                    this.logE("EglBase release , makeCurrent exception: " + e.getMessage());
                }
                Object object = EglBase.lock;
                synchronized (object) {
                    GLES20.glUseProgram((int)0);
                }
                if (this.drawer != null) {
                    this.drawer.release();
                    this.drawer = null;
                }
                this.frameDrawer.release();
                this.bitmapTextureFramebuffer.release();
                if (this.eglBase != null) {
                    this.logD("eglBase detach and release.");
                    this.eglBase.detachCurrent();
                    this.eglBase.release();
                    this.eglBase = null;
                }
                this.frameListeners.clear();
                eglCleanupBarrier.countDown();
                this.renderUtil.dispose();
            });
            Looper renderLooper = this.renderThreadHandler.getLooper();
            this.renderThreadHandler.post(() -> {
                this.logD("Quitting render thread.");
                renderLooper.quit();
            });
            this.renderThreadHandler = null;
        }
        if (!ThreadUtils.awaitUninterruptibly(eglCleanupBarrier, 2000L)) {
            this.logE("release timeout");
        }
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
        }
        if (this.rendererGatherer != null) {
            this.rendererGatherer.removeEglRenderInfo(this.eglRenderInfo);
        }
        this.logD("Releasing done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long currentTimeNs) {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.statisticsStartTimeNs = currentTimeNs;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
            this.framesNoSurface = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] renderStackTrace;
            Thread renderThread;
            Thread thread = renderThread = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (renderThread != null && (renderStackTrace = renderThread.getStackTrace()).length > 0) {
                this.logD("EglRenderer stack trace:");
                for (StackTraceElement traceElem : renderStackTrace) {
                    this.logD(traceElem.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean mirror) {
        this.logD("setMirror: " + mirror);
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = mirror;
        }
    }

    public int getRenderTime() {
        int time = (int)this.renderUtil.getExecuteTime();
        this.renderUtil.clearAll();
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float layoutAspectRatio) {
        this.logD("setLayoutAspectRatio: " + layoutAspectRatio);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = layoutAspectRatio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float fps) {
        this.logD("setFpsReduction: " + fps);
        Object object = this.fpsReductionLock;
        synchronized (object) {
            long previousRenderPeriodNs = this.minRenderPeriodNs;
            this.minRenderPeriodNs = fps <= 0.0f ? Long.MAX_VALUE : (long)((float)ONE_SECONDS_TO_NANOS / fps);
            if (this.minRenderPeriodNs != previousRenderPeriodNs) {
                this.nextFrameTimeNs = System.nanoTime();
            }
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void setRendererGatherer(RendererGatherer renderGatherer) {
        this.rendererGatherer = renderGatherer;
        if (this.eglRenderInfo != null) {
            this.rendererGatherer.addEglRenderInfo(this.eglRenderInfo);
        }
    }

    public void setUid(String name) {
        if (this.eglRenderInfo != null) {
            try {
                String uidChar = name.replace(":", "").replace("uid", "").trim();
                long uid = Long.parseLong(uidChar);
                this.eglRenderInfo.setUid(uid);
            }
            catch (Exception e) {
                Logging.e(TAG, "setUid error");
            }
        }
    }

    public void addFrameListener(FrameListener listener, float scale) {
        this.addFrameListener(listener, scale, null, false);
    }

    public void addFrameListener(FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        this.addFrameListener(listener, scale, drawerParam, false);
    }

    public void addFrameListener(FrameListener listener, float scale, @Nullable RendererCommon.GlDrawer drawerParam, boolean applyFpsReduction) {
        this.postToRenderThread(() -> {
            RendererCommon.GlDrawer listenerDrawer = drawerParam == null ? this.drawer : drawerParam;
            this.frameListeners.add(new FrameListenerAndParams(listener, scale, listenerDrawer, applyFpsReduction));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameListener(FrameListener listener) {
        CountDownLatch latch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
                throw new RuntimeException("removeFrameListener must not be called on the render thread.");
            }
            this.postToRenderThread(() -> {
                latch.countDown();
                Iterator<FrameListenerAndParams> iter = this.frameListeners.iterator();
                while (iter.hasNext()) {
                    if (iter.next().listener != listener) continue;
                    iter.remove();
                }
            });
        }
        ThreadUtils.awaitUninterruptibly(latch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        boolean dropOldFrame;
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                boolean bl = dropOldFrame = this.pendingFrame != null;
                if (dropOldFrame) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = frame;
                this.pendingFrame.retain();
                this.renderThreadHandler.post(this::renderFrameOnRenderThread);
            }
        }
        if (dropOldFrame) {
            object2 = this.statisticsLock;
            synchronized (object2) {
                ++this.framesDropped;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEglSurface(Runnable completionCallback) {
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                this.renderThreadHandler.postAtFrontOfQueue(() -> {
                    this.logD("releaseSurface");
                    if (this.eglBase != null) {
                        this.eglBase.detachCurrent();
                        this.eglBase.releaseSurface();
                    }
                    completionCallback.run();
                });
                return;
            }
        }
        completionCallback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private void clearSurfaceOnRenderThread(float r, float g, float b, float a) {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)r, (float)g, (float)b, (float)a);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImage(float r, float g, float b, float a) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(() -> this.clearSurfaceOnRenderThread(r, g, b, a));
        }
    }

    @TargetApi(value=26)
    private void fenceSyncGPU(VideoFrame frame) {
        boolean isTextureFrame;
        boolean isRun;
        boolean bl = isRun = this.eglBase != null && this.eglBase.getOpenGlesVersion() == 3 && Build.VERSION.SDK_INT >= 26;
        if (!isRun) {
            return;
        }
        VideoFrame.Buffer.BufferType bufferType = frame.getBuffer().getInternalBufferType();
        boolean bl2 = isTextureFrame = bufferType == VideoFrame.Buffer.BufferType.kBufferTypeTexture || bufferType == VideoFrame.Buffer.BufferType.kBufferTypeWrapTexture;
        if (isTextureFrame) {
            long fenceSyncObject;
            long l = fenceSyncObject = bufferType == VideoFrame.Buffer.BufferType.kBufferTypeTexture ? ((VideoFrame.TextureBuffer)frame.getBuffer()).getFenceSyncObject() : ((VideoFrame.WrapTextureBuffer)frame.getBuffer()).getFenceSyncObject();
            if (fenceSyncObject != 0L) {
                GLES30.glWaitSync((long)fenceSyncObject, (int)0, (long)-1L);
                GLES30.glDeleteSync((long)fenceSyncObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread() {
        float scaleY;
        float scaleX;
        float drawnAspectRatio;
        boolean shouldRenderFrame;
        VideoFrame frame;
        Object object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame == null) {
                return;
            }
            frame = this.pendingFrame;
            this.pendingFrame = null;
        }
        if (this.eglBase == null || !this.eglBase.hasSurface()) {
            if (this.framesNoSurface == 0 || this.framesNoSurface % 300 == 0) {
                this.logD("Dropping frame - No surface");
            }
            ++this.framesNoSurface;
            frame.release();
            return;
        }
        if (this.framesNoSurface > 0) {
            this.framesNoSurface = 0;
            this.logD("render frame - surface come back");
        }
        long startTime = frame.getBroadcastRenderMs() != 0L ? frame.getBroadcastRenderMs() : VideoRenderUtil.getRtcTimeMillis();
        this.renderUtil.setStartTime(startTime);
        Object object2 = this.fpsReductionLock;
        synchronized (object2) {
            if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                shouldRenderFrame = false;
            } else if (this.minRenderPeriodNs <= 0L) {
                shouldRenderFrame = true;
            } else {
                long currentTimeNs = System.nanoTime();
                if (currentTimeNs < this.nextFrameTimeNs) {
                    this.logD("Skipping frame rendering - fps reduction is active.");
                    shouldRenderFrame = false;
                } else {
                    this.nextFrameTimeNs += this.minRenderPeriodNs;
                    this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, currentTimeNs);
                    shouldRenderFrame = true;
                }
            }
        }
        long startTimeNs = System.nanoTime();
        float frameAspectRatio = (float)frame.getRotatedWidth() / (float)frame.getRotatedHeight();
        Object object3 = this.layoutLock;
        synchronized (object3) {
            drawnAspectRatio = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : frameAspectRatio;
        }
        if (frameAspectRatio > drawnAspectRatio) {
            scaleX = drawnAspectRatio / frameAspectRatio;
            scaleY = 1.0f;
        } else {
            scaleX = 1.0f;
            scaleY = frameAspectRatio / drawnAspectRatio;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(scaleX, scaleY);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        if (shouldRenderFrame) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(frame, this.drawer, this.drawMatrix, 0, 0, this.eglBase.surfaceWidth(), this.eglBase.surfaceHeight());
            long swapBuffersStartTimeNs = System.nanoTime();
            if (this.usePresentationTimeStamp) {
                this.eglBase.swapBuffers(frame.getTimestampNs());
            } else {
                this.eglBase.swapBuffers();
            }
            long currentTimeNs = System.nanoTime();
            Object object4 = this.statisticsLock;
            synchronized (object4) {
                ++this.framesRendered;
                long renderTime = currentTimeNs - startTimeNs;
                long swapBufferTime = currentTimeNs - swapBuffersStartTimeNs;
                this.renderTimeNs += renderTime;
                this.renderSwapBufferTimeNs += swapBufferTime;
                this.eglRenderInfo.setRenderTimeNs(TimeUnit.NANOSECONDS.toMillis(renderTime));
                this.eglRenderInfo.setSwapBufferTimeNs(TimeUnit.NANOSECONDS.toMillis(swapBufferTime));
            }
        }
        this.renderUtil.setEndTime(VideoRenderUtil.getRtcTimeMillis());
        this.notifyCallbacks(frame, shouldRenderFrame);
        frame.release();
    }

    private void notifyCallbacks(VideoFrame frame, boolean wasRendered) {
        if (this.frameListeners.isEmpty()) {
            return;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(1.0f, -1.0f);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        for (FrameListenerAndParams listenerAndParams : this.frameListeners) {
            if (!wasRendered && listenerAndParams.applyFpsReduction) continue;
            int scaledWidth = (int)(listenerAndParams.scale * (float)frame.getRotatedWidth());
            int scaledHeight = (int)(listenerAndParams.scale * (float)frame.getRotatedHeight());
            if (scaledWidth == 0 || scaledHeight == 0) {
                listenerAndParams.listener.onFrame(null);
                continue;
            }
            this.bitmapTextureFramebuffer.setSize(scaledWidth, scaledHeight);
            GLES20.glBindFramebuffer((int)36160, (int)this.bitmapTextureFramebuffer.getFrameBufferId());
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.bitmapTextureFramebuffer.getTextureId(), (int)0);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(frame, listenerAndParams.drawer, this.drawMatrix, 0, 0, scaledWidth, scaledHeight);
            ByteBuffer bitmapBuffer = ByteBuffer.allocateDirect(scaledWidth * scaledHeight * 4);
            GLES20.glViewport((int)0, (int)0, (int)scaledWidth, (int)scaledHeight);
            GLES20.glReadPixels((int)0, (int)0, (int)scaledWidth, (int)scaledHeight, (int)6408, (int)5121, (Buffer)bitmapBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
            Bitmap bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)bitmapBuffer);
            listenerAndParams.listener.onFrame(bitmap);
        }
    }

    private String averageTimeAsString(long sumTimeNs, int count) {
        return count <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(sumTimeNs / (long)count) + " us";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        long currentTimeNs = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long elapsedTimeNs = currentTimeNs - this.statisticsStartTimeNs;
            if (elapsedTimeNs <= 0L) {
                return;
            }
            long receivedFps = (long)this.framesReceived * ONE_SECONDS_TO_NANOS / elapsedTimeNs;
            long renderFps = (long)this.framesRendered * ONE_SECONDS_TO_NANOS / elapsedTimeNs;
            this.onReceivedFps((int)receivedFps);
            this.onRendererFps((int)renderFps);
            if (currentTimeNs - this.logPrintTimeNs >= 20L * ONE_SECONDS_TO_NANOS) {
                DecimalFormat fpsFormat = new DecimalFormat("#.0");
                this.logD("dur: " + TimeUnit.NANOSECONDS.toMillis(elapsedTimeNs) + " ms. recv: " + this.framesReceived + ". drop: " + this.framesDropped + ". render: " + this.framesRendered + ". render fps: " + fpsFormat.format(renderFps) + ". render time: " + this.averageTimeAsString(this.renderTimeNs, this.framesRendered) + ". swap time: " + this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered));
                this.logPrintTimeNs = currentTimeNs;
            }
            this.resetStatistics(currentTimeNs);
        }
    }

    protected void onRendererFps(int fps) {
    }

    protected void onReceivedFps(int fps) {
    }

    protected void onRenderError(String errMsg) {
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + string);
    }

    private void logE(String string) {
        Logging.e(TAG, this.name + string);
    }

    private static class HandlerWithExceptionCallback
    extends Handler {
        private final Runnable exceptionCallback;

        public HandlerWithExceptionCallback(Looper looper, Runnable exceptionCallback) {
            super(looper);
            this.exceptionCallback = exceptionCallback;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception e) {
                Logging.e(EglRenderer.TAG, "Exception on EglRenderer thread", e);
                this.exceptionCallback.run();
                throw e;
            }
        }
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object surface) {
            this.surface = surface;
        }

        @Override
        public synchronized void run() {
            EglRenderer.this.logD("EglSurfaceCreation run: " + this.surface);
            if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                block5: {
                    try {
                        if (this.surface instanceof Surface) {
                            EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                            break block5;
                        }
                        if (this.surface instanceof SurfaceTexture) {
                            EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                            break block5;
                        }
                        String msg = "EglBase create surface but invalid surface: " + this.surface;
                        EglRenderer.this.logE(msg);
                        EglRenderer.this.onRenderError(msg);
                        return;
                    }
                    catch (Exception e) {
                        String msg = "EglBase create surface exception: " + e.getMessage();
                        EglRenderer.this.logE(msg);
                        EglRenderer.this.onRenderError(msg);
                        return;
                    }
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener listener, float scale, RendererCommon.GlDrawer drawer, boolean applyFpsReduction) {
            this.listener = listener;
            this.scale = scale;
            this.drawer = drawer;
            this.applyFpsReduction = applyFpsReduction;
        }
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

