/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import com.netease.lava.webrtc.CalledByNative;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public class EncodedImage {
    public final ByteBuffer buffer;
    public final int encodedWidth;
    public final int encodedHeight;
    public final int actualWidth;
    public final int actualHeight;
    public final long captureTimeMs;
    public final long captureTimeNs;
    public final FrameType frameType;
    public final int rotation;
    public final boolean completeFrame;
    public final Integer qp;
    public final long targetEncBps;
    public final boolean isDecodeStuck;
    public final float netRecvFrameRate;

    @CalledByNative
    private EncodedImage(ByteBuffer buffer, int encodedWidth, int encodedHeight, int actualWidth, int actualHeight, long captureTimeNs, FrameType frameType, int rotation, boolean completeFrame, Integer qp, long targetEncBps, boolean isDecodeStuck, float netRecvFrameRate) {
        this.buffer = buffer;
        this.encodedWidth = encodedWidth;
        this.encodedHeight = encodedHeight;
        this.actualWidth = actualWidth;
        this.actualHeight = actualHeight;
        this.captureTimeMs = TimeUnit.NANOSECONDS.toMillis(captureTimeNs);
        this.captureTimeNs = captureTimeNs;
        this.frameType = frameType;
        this.rotation = rotation;
        this.completeFrame = completeFrame;
        this.qp = qp;
        this.targetEncBps = targetEncBps;
        this.isDecodeStuck = isDecodeStuck;
        this.netRecvFrameRate = netRecvFrameRate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ByteBuffer buffer;
        private int encodedWidth;
        private int encodedHeight;
        private int actualWidth;
        private int actualHeight;
        private long captureTimeNs;
        private FrameType frameType;
        private int rotation;
        private boolean completeFrame;
        private Integer qp;
        private long targetEncBps;
        private boolean isDecodeStuck;
        private float netRecvFrameRate;

        private Builder() {
        }

        public Builder setBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
            return this;
        }

        public Builder setEncodedWidth(int encodedWidth) {
            this.encodedWidth = encodedWidth;
            return this;
        }

        public Builder setEncodedHeight(int encodedHeight) {
            this.encodedHeight = encodedHeight;
            return this;
        }

        public Builder setActualWidth(int actualWidth) {
            this.actualWidth = actualWidth;
            return this;
        }

        public Builder setActualHeight(int actualHeight) {
            this.actualHeight = actualHeight;
            return this;
        }

        @Deprecated
        public Builder setCaptureTimeMs(long captureTimeMs) {
            this.captureTimeNs = TimeUnit.MILLISECONDS.toNanos(captureTimeMs);
            return this;
        }

        public Builder setCaptureTimeNs(long captureTimeNs) {
            this.captureTimeNs = captureTimeNs;
            return this;
        }

        public Builder setFrameType(FrameType frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder setCompleteFrame(boolean completeFrame) {
            this.completeFrame = completeFrame;
            return this;
        }

        public Builder setQp(Integer qp) {
            this.qp = qp;
            return this;
        }

        public Builder setTargetEncBps(long targetEncBps) {
            this.targetEncBps = targetEncBps;
            return this;
        }

        public Builder setIsDecodeStuck(boolean isDecodeStuck) {
            this.isDecodeStuck = isDecodeStuck;
            return this;
        }

        public Builder setNetRecvFrameRate(int netRecvFrameRate) {
            this.netRecvFrameRate = netRecvFrameRate;
            return this;
        }

        public EncodedImage createEncodedImage() {
            return new EncodedImage(this.buffer, this.encodedWidth, this.encodedHeight, this.actualWidth, this.actualHeight, this.captureTimeNs, this.frameType, this.rotation, this.completeFrame, this.qp, this.targetEncBps, this.isDecodeStuck, this.netRecvFrameRate);
        }
    }

    public static enum FrameType {
        EmptyFrame(0),
        VideoFrameKey(3),
        VideoFrameDelta(4);

        private final int nativeIndex;

        private FrameType(int nativeIndex) {
            this.nativeIndex = nativeIndex;
        }

        public int getNative() {
            return this.nativeIndex;
        }

        @CalledByNative(value="FrameType")
        static FrameType fromNativeIndex(int nativeIndex) {
            for (FrameType type : FrameType.values()) {
                if (type.getNative() != nativeIndex) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown native frame type: " + nativeIndex);
        }
    }
}

