/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.app.ActivityManager;
import android.os.Handler;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class ForegroundMonitor {
    private static final String TAG = "ForegroundMonitor";
    private static ForegroundMonitor sInstance;
    private boolean mIsForeground;
    private List<Observer> mObservers;
    private List<Observer> mObserversForeach;
    private ActivityManager.RunningAppProcessInfo mAppProcessInfo;
    @Nullable
    private Handler mHander;
    private final Object mLock = new Object();
    private static final int sDelay = 1000;
    private Runnable mRunnable = () -> {
        this.process();
        Object object = this.mLock;
        synchronized (object) {
            this.start(1000L);
        }
    };

    public static ForegroundMonitor getInstance() {
        if (sInstance == null) {
            sInstance = new ForegroundMonitor();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ForegroundMonitor() {
        Object object = this.mLock;
        synchronized (object) {
            this.mObservers = new LinkedList<Observer>();
            this.mObserversForeach = new LinkedList<Observer>();
        }
        this.mAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitor(Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsForeground = false;
            this.mHander = handler;
            this.start(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor() {
        Object object = this.mLock;
        synchronized (object) {
            this.stop();
        }
        this.mObservers.clear();
    }

    private void start(long delay) {
        if (this.mHander == null) {
            return;
        }
        this.mHander.removeCallbacks(this.mRunnable);
        this.mHander.postDelayed(this.mRunnable, delay);
    }

    private void stop() {
        if (this.mHander == null) {
            return;
        }
        this.mHander.removeCallbacks(this.mRunnable);
        this.mHander = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        boolean newStatus;
        try {
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)this.mAppProcessInfo);
        }
        catch (Throwable e) {
            return;
        }
        boolean bl = newStatus = this.mAppProcessInfo.importance == 100;
        if (newStatus != this.mIsForeground) {
            this.mIsForeground = newStatus;
            Iterator<Observer> iterator = this.mLock;
            synchronized (iterator) {
                this.mObserversForeach.addAll(this.mObservers);
            }
            for (Observer ob : this.mObserversForeach) {
                ob.onForegroundChanged(newStatus);
            }
            this.mObserversForeach.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer observer) {
        if (observer == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mObservers.remove(observer);
            this.mObservers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(Observer observer) {
        if (observer == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mObservers.remove(observer);
        }
    }

    public static interface Observer {
        public void onForegroundChanged(boolean var1);
    }
}

