/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.os.Environment;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.device.AndroidBlackListController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlUtil {
    private static int index;

    private GlUtil() {
    }

    public static void checkNoGLES2Error(String msg) {
        int error = GLES20.glGetError();
        if (error != 0) {
            if (index > 10000) {
                index = 0;
            }
            if (index / 100 >= 0 && index % 100 == 0) {
                Logging.e("GlUtil", msg + ": GLES20 error: " + error);
            }
            ++index;
        }
    }

    public static FloatBuffer createFloatBuffer(float[] coords) {
        ByteBuffer bb = ByteBuffer.allocateDirect(coords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(coords);
        fb.position(0);
        return fb;
    }

    public static int generateTexture(int target) {
        int[] textureArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureArray, (int)0);
        int textureId = textureArray[0];
        GLES20.glBindTexture((int)target, (int)textureId);
        GLES20.glTexParameterf((int)target, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)target, (int)10243, (float)33071.0f);
        GlUtil.checkNoGLES2Error("generateTexture");
        return textureId;
    }

    public static void allocateTexture(int textureId, int pixelFormat, int width, int height) {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glTexImage2D((int)3553, (int)0, (int)pixelFormat, (int)width, (int)height, (int)0, (int)pixelFormat, (int)5121, null);
        GLES20.glBindTexture((int)3553, (int)0);
        GlUtil.checkNoGLES2Error("allocateTexture");
    }

    public static void copyTexture(int srcTextureId, int fboId, int dstTextureId, int width, int height, boolean isGPUCopyBlackList) {
        GLES20.glBindFramebuffer((int)36160, (int)fboId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)srcTextureId, (int)0);
        if (GLES20.glCheckFramebufferStatus((int)36160) == 36053) {
            GLES20.glBindTexture((int)3553, (int)dstTextureId);
            if (AndroidBlackListController.isGPUCopyBlackList() || isGPUCopyBlackList) {
                GLES20.glCopyTexImage2D((int)3553, (int)0, (int)6408, (int)0, (int)0, (int)width, (int)height, (int)0);
            } else {
                GLES20.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height);
            }
            GLES20.glBindTexture((int)3553, (int)0);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glFlush();
        GlUtil.checkNoGLES2Error("copyTexture");
    }

    public static void dumpTexture(int dstTextureId, int fboId, int width, int height) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        FileOutputStream saveImgOut = null;
        try {
            File file = new File(Environment.getExternalStorageDirectory().getPath() + "/Texture_copy.jpg");
            saveImgOut = new FileOutputStream(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GLES20.glBindFramebuffer((int)36160, (int)fboId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)dstTextureId, (int)0);
        int errorTexture = GLES20.glGetError();
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        int errReadTexture = GLES20.glGetError();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        if (saveImgOut != null) {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)saveImgOut);
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    public static void SaveTexture(int texture_id, int width, int height, int index, boolean is_texture_2d) {
        int[] old_fbo = new int[1];
        GLES20.glGetIntegerv((int)36006, (int[])old_fbo, (int)0);
        GlUtil.checkNoGLES2Error("glGetIntegerv");
        int[] tmp_fbo = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])tmp_fbo, (int)0);
        GlUtil.checkNoGLES2Error("glGenFramebuffers");
        GLES20.glBindFramebuffer((int)36160, (int)tmp_fbo[0]);
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        if (is_texture_2d) {
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture_id, (int)0);
        } else {
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)36197, (int)texture_id, (int)0);
        }
        GlUtil.checkNoGLES2Error("glFramebufferTexture2D");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        GLES20.glPixelStorei((int)3333, (int)1);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkNoGLES2Error("glReadPixels");
        try {
            File file = new File(Environment.getExternalStorageDirectory().getPath() + "/output" + String.valueOf(index) + ".jpg");
            FileOutputStream saveImgOut = new FileOutputStream(file);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            if (saveImgOut != null) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)saveImgOut);
                saveImgOut.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GLES20.glBindFramebuffer((int)36160, (int)old_fbo[0]);
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        GLES20.glDeleteFramebuffers((int)1, (int[])tmp_fbo, (int)0);
        GlUtil.checkNoGLES2Error("glDeleteFramebuffers");
    }
}

