/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import com.netease.lava.webrtc.CompatVideoCodecInfo;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.EglBase14;
import com.netease.lava.webrtc.EncodedImage;
import com.netease.lava.webrtc.GlRectDrawer;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.MediaCodecUtils;
import com.netease.lava.webrtc.MediaCodecWrapper;
import com.netease.lava.webrtc.MediaCodecWrapperFactory;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.VideoCodecStatus;
import com.netease.lava.webrtc.VideoCodecType;
import com.netease.lava.webrtc.VideoEncoder;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.VideoFrameDrawer;
import com.netease.lava.webrtc.YuvHelper;
import com.netease.lava.webrtc.bitrate.BaseBitrateAdjuster;
import com.netease.lava.webrtc.bitrate.BitrateAdjuster;
import com.netease.lava.webrtc.bitrate.FramerateBitrateAdjuster;
import com.netease.lava.webrtc.bitrate.NewDynamicBitrateAdjuster;
import com.netease.lava.webrtc.device.AndroidDeviceInfo;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@TargetApi(value=19)
public class HardwareVideoEncoder
implements VideoEncoder {
    private static final String TAG = "HardwareVideoEncoder";
    private static final int VIDEO_ControlRateConstant = 2;
    private static final String KEY_BITRATE_MODE = "bitrate-mode";
    private static final int VIDEO_AVC_PROFILE_HIGH = 8;
    private static final int VIDEO_AVC_LEVEL_3 = 256;
    private static final int MAX_VIDEO_FRAMERATE = 30;
    private static final int MAX_ENCODER_Q_SIZE = 2;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int AUTO_BR_ADJUSTER = -1;
    private static final int BASE_BR_ADJUSTER = 0;
    private static final int DYNAMIC_BR_ADJUSTER = 1;
    private static final int FRAMERATE_BR_ADJUSTER = 2;
    private final int kLowVp8QpThreshold = 29;
    private final int kHighVp8QpThreshold = 95;
    private final int kLowH264QpThreshold = 30;
    private final int kHighH264QpThreshold = 37;
    private final int kLowH265QpThreshold = 30;
    private final int kHighH265QpThreshold = 36;
    private final int kOutputThreadExceptionThreshold = 5;
    private final int kMinCodecWidthAlign = 16;
    private final int kMinCodecHeightAlign = 4;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    @Nullable
    private final String codecName;
    private final VideoCodecType codecType;
    private final int surfaceColorFormat;
    private final int yuvColorFormat;
    private final YuvFormat yuvFormat;
    private final Map<String, String> params;
    private int keyFrameIntervalSec;
    private final long forcedKeyFrameNs;
    private BitrateAdjuster bitrateAdjuster;
    private final EglBase14.Context sharedContext;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private final VideoFrameDrawer videoFrameDrawer = new VideoFrameDrawer();
    private final BlockingDeque<EncodedImage.Builder> outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();
    private final ThreadUtils.ThreadChecker encodeThreadChecker = new ThreadUtils.ThreadChecker();
    private final ThreadUtils.ThreadChecker outputThreadChecker = new ThreadUtils.ThreadChecker();
    private VideoEncoder.Callback callback;
    private boolean automaticResizeOn;
    private static boolean isScreenCast;
    @Nullable
    private MediaCodecWrapper codec;
    @Nullable
    private Thread outputThread;
    @Nullable
    private EglBase14 textureEglBase;
    @Nullable
    private Surface textureInputSurface;
    private int width;
    private int height;
    private int actualWidth;
    private int actualHeight;
    private boolean useSurfaceMode;
    private long lastKeyFrameNs;
    @Nullable
    private ByteBuffer configBuffer;
    private int adjustedBitrate;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;
    private int fallbackResolution;
    private int targetQosBitrateBps;
    private int targetFPS;
    private boolean syncMode;
    private int dequeOutputTimeoutUs;
    private boolean enableAlignment;
    private int codecWidthAlign;
    private int codecHeightAlign;
    private int yuvSurfaceMode;
    private boolean forceHardwareEncode;
    private MediaCodecInfo.CodecCapabilities capabilities;
    private volatile boolean outputThreadError;
    private int outputThreadExceptionCount;

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, VideoCodecType codecType, Map<String, String> params, EglBase14.Context sharedContext, CompatVideoCodecInfo compatInfo, MediaCodecInfo.CodecCapabilities capabilities) {
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = compatInfo.getCodecName();
        this.codecType = codecType;
        this.surfaceColorFormat = compatInfo.getEnSurfaceColorFormat();
        this.yuvColorFormat = compatInfo.getEnYUVColorFormat();
        this.yuvFormat = YuvFormat.valueOf(this.yuvColorFormat);
        this.params = params;
        this.keyFrameIntervalSec = compatInfo.getKeyFrameIntervalSec();
        this.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(compatInfo.getForceKeyFrameIntervalMs());
        this.bitrateAdjuster = new BaseBitrateAdjuster();
        this.sharedContext = sharedContext;
        this.fallbackResolution = compatInfo.getEncFallbackResolution();
        this.capabilities = capabilities;
        this.yuvSurfaceMode = compatInfo.getEncYuvSurfaceMode();
        this.forceHardwareEncode = codecType == VideoCodecType.H264 ? compatInfo.getForceHardwareEncodeingForH264() == 1 : (codecType == VideoCodecType.H265 ? compatInfo.getForceHardwareEncodeingForH265() == 1 : false);
        this.codecWidthAlign = 0;
        this.codecHeightAlign = 0;
        this.encodeThreadChecker.detachThread();
        Logging.d(TAG, "ctor");
    }

    public static void setScreenCast(boolean isScreenCast) {
        HardwareVideoEncoder.isScreenCast = isScreenCast;
    }

    private int setBitrateAdjusterTypeForSomeModel(String codecName, int bitrateAdjusterType) {
        if (!codecName.startsWith("OMX.MTK.")) {
            if (codecName.startsWith("OMX.Exynos.")) {
                if (!(Build.MODEL.equalsIgnoreCase("MX4 Pro") || Build.MANUFACTURER.equalsIgnoreCase("vivo") && Build.MODEL.equalsIgnoreCase("V1938CT") || Build.VERSION.SDK_INT > 28)) {
                    bitrateAdjusterType = 2;
                }
            } else if (codecName.startsWith("OMX.IMG.TOPAZ.")) {
                if (!Build.HARDWARE.equalsIgnoreCase("hi6250")) {
                    bitrateAdjusterType = 2;
                }
            } else if (!codecName.startsWith("OMX.hisi.")) {
                if (codecName.startsWith("OMX.k3.")) {
                    bitrateAdjusterType = 2;
                } else if (codecName.startsWith("OMX.amlogic.")) {
                    bitrateAdjusterType = 2;
                } else if (codecName.startsWith("OMX.rk.")) {
                    bitrateAdjusterType = 2;
                }
            }
        }
        return bitrateAdjusterType;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecType type, String codecName, int bitrateAdjusterType, float minAdjustedBitratePct, float maxAdjustedBitratePct, boolean isScreenShare) {
        Logging.d(TAG, "bitrate Adjuster type: " + bitrateAdjusterType);
        Logging.d(TAG, "screen share: " + isScreenShare);
        int workbitrateAdjusterType = bitrateAdjusterType;
        if (workbitrateAdjusterType != 0 && workbitrateAdjusterType != 1 && workbitrateAdjusterType != 2) {
            workbitrateAdjusterType = -1;
        }
        if (workbitrateAdjusterType == -1) {
            workbitrateAdjusterType = isScreenShare ? 0 : 1;
            Logging.d(TAG, "before setBitrateAdjusterTypeForSomeModel : " + workbitrateAdjusterType);
            workbitrateAdjusterType = this.setBitrateAdjusterTypeForSomeModel(codecName, workbitrateAdjusterType);
            Logging.d(TAG, "after setBitrateAdjusterTypeForSomeModel : " + workbitrateAdjusterType);
        }
        Logging.d(TAG, "final work bitrate Adjuster type: " + workbitrateAdjusterType);
        BaseBitrateAdjuster bitrateAdjuster = null;
        switch (workbitrateAdjusterType) {
            case 0: {
                bitrateAdjuster = new BaseBitrateAdjuster();
                break;
            }
            case 1: {
                bitrateAdjuster = new NewDynamicBitrateAdjuster(minAdjustedBitratePct, maxAdjustedBitratePct);
                break;
            }
            case 2: {
                bitrateAdjuster = new FramerateBitrateAdjuster();
                break;
            }
            default: {
                bitrateAdjuster = new BaseBitrateAdjuster();
            }
        }
        return bitrateAdjuster;
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.callback = callback;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.actualWidth = settings.width;
        this.actualHeight = settings.height;
        this.useSurfaceMode = this.canUseSurface();
        this.syncMode = settings.syncMode;
        this.dequeOutputTimeoutUs = settings.syncMode ? 0 : 100000;
        this.yuvSurfaceMode = this.useSurfaceMode ? this.yuvSurfaceMode : 0;
        this.enableAlignment = settings.enableAlignment;
        this.alignResolutionIfNeeded();
        boolean isSizeSupport = MediaCodecUtils.checkSize(this.capabilities, this.width, this.height, this.fallbackResolution);
        if (!isSizeSupport && !this.forceHardwareEncode) {
            Logging.w(TAG, " initEncode: " + this.width + " x " + this.height + " isSizeSupport: " + isSizeSupport + " FALLBACK_SOFTWARE");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.fallbackResolution > 0 && this.actualWidth * this.actualHeight < this.fallbackResolution) {
            Logging.w(TAG, " initEncode: " + this.actualWidth + " x " + this.actualHeight + " fallbackResolution " + this.fallbackResolution + " SDK_INT: " + Build.VERSION.SDK_INT + " FALLBACK_SOFTWARE");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.bitrateAdjuster = this.createBitrateAdjuster(this.codecType, this.codecName, settings.bitrateAdjusterType, settings.minAdjustedBitratePct, settings.maxAdjustedBitratePct, settings.isScreenShare);
        if (settings.startBitrate != 0 && settings.maxFramerate != 0) {
            boolean isBitrateSupport;
            this.targetFPS = settings.maxFramerate;
            this.targetQosBitrateBps = settings.startBitrate * 1000;
            boolean isFrameRateSupport = MediaCodecUtils.checkFrameRate(this.capabilities, this.targetFPS);
            if (!isFrameRateSupport) {
                Logging.w(TAG, "initEncode: target framerate: " + this.targetFPS + "is not supported by the encoder.");
            }
            if (!(isBitrateSupport = MediaCodecUtils.checkBitrate(this.capabilities, this.targetQosBitrateBps))) {
                Logging.w(TAG, "initEncode: target bps: " + this.targetQosBitrateBps + " is not within the supported bitrate range.");
            }
            this.bitrateAdjuster.setTargets(settings.startBitrate * 1000, settings.maxFramerate);
        }
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        if (this.keyFrameIntervalSec <= 0) {
            this.keyFrameIntervalSec = settings.gop > 0 && settings.maxFramerate > 0 ? settings.gop / settings.maxFramerate : this.getDefaultKeyFrameIntervalSec(this.codecType);
        }
        Logging.i(TAG, "initEncode, codecName:" + this.codecName + " isSizeSupport: " + isSizeSupport + " codecType: " + (Object)((Object)this.codecType) + " surfaceColorFormat: " + this.surfaceColorFormat + " yuvColorFormat: " + this.yuvColorFormat + " params: " + this.params.toString() + " keyFrameIntervalSec: " + this.keyFrameIntervalSec + " forcedKeyFrameNs: " + this.forcedKeyFrameNs + " sharedContext: " + this.sharedContext + " " + this.width + " x " + this.height + ". @ " + settings.startBitrate + "kbps. Fps: " + settings.maxFramerate + " Use surface mode: " + this.useSurfaceMode + " maxSupportedInstances: " + MediaCodecUtils.getMaxSupportedInstances(this.capabilities) + " currentCodecInstances: " + MediaCodecUtils.getCodecInstances(true, this.codecName) + " syncMode: " + settings.syncMode + " yuvSurfaceMode: " + this.yuvSurfaceMode + " forceHardwareEncode: " + this.forceHardwareEncode + ", enableAlignment: " + settings.enableAlignment);
        return this.initEncodeInternal();
    }

    private int getDefaultKeyFrameIntervalSec(VideoCodecType type) {
        switch (type) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: 
            case H265: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecType " + (Object)((Object)type));
    }

    private VideoCodecStatus initEncodeInternal() {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.lastKeyFrameNs = -1L;
        boolean isWithinInstancesRange = MediaCodecUtils.checkCodecInstances(this.capabilities, true, this.codecName);
        if (!isWithinInstancesRange) {
            Logging.w(TAG, " initEncodeInternal:  currentCodecInstances: " + MediaCodecUtils.getCodecInstances(true, this.codecName) + " maxSupportedInstances: " + MediaCodecUtils.getMaxSupportedInstances(this.capabilities) + " isWithinInstancesRange: " + isWithinInstancesRange);
        }
        this.updateYuvSurfaceModeForMtk(this.width, this.height);
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (Exception e) {
            Logging.e(TAG, "Cannot create media encoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        MediaCodecUtils.addCodecInstances(true, this.codecName);
        int colorFormat = this.useSurfaceMode ? this.surfaceColorFormat : this.yuvColorFormat;
        try {
            MediaFormat format = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)this.width, (int)this.height);
            format.setInteger("bitrate", this.adjustedBitrate);
            format.setInteger(KEY_BITRATE_MODE, 2);
            format.setInteger("color-format", colorFormat);
            format.setInteger("frame-rate", this.bitrateAdjuster.getTargetsFrameRate());
            format.setInteger("i-frame-interval", this.keyFrameIntervalSec);
            if (Build.VERSION.SDK_INT >= 26) {
                format.setInteger("latency", 1);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                format.setInteger("priority", 0);
            }
            if (this.codecType == VideoCodecType.H264) {
                String compatProfile = this.params.get("profile-id");
                String compatLevel = this.params.get("level-id");
                if (compatProfile != null && compatLevel != null) {
                    Logging.d(TAG, "using compat profile: " + compatProfile + " level: " + compatLevel);
                    format.setInteger("profile", Integer.parseInt(compatProfile));
                    format.setInteger("level", Integer.parseInt(compatLevel));
                } else {
                    String profileLevelId = this.params.get("profile-level-id");
                    if (profileLevelId == null) {
                        profileLevelId = "42e01f";
                    }
                    switch (profileLevelId) {
                        case "640c1f": {
                            format.setInteger("profile", 8);
                            format.setInteger("level", 256);
                            break;
                        }
                        case "42e01f": {
                            break;
                        }
                        default: {
                            Logging.w(TAG, "Unknown profile level id: " + profileLevelId);
                        }
                    }
                }
            }
            Logging.d(TAG, "Format: " + format);
            this.codec.configure(format, null, null, 1);
            if (this.useSurfaceMode) {
                try {
                    this.textureEglBase = EglBase.createEgl14(this.sharedContext, EglBase.CONFIG_RECORDABLE_3);
                }
                catch (Exception e) {
                    this.textureEglBase = EglBase.createEgl14(this.sharedContext, EglBase.CONFIG_RECORDABLE);
                }
                this.textureInputSurface = this.codec.createInputSurface();
                this.textureEglBase.createSurface(this.textureInputSurface);
                this.textureEglBase.makeCurrent();
                if (this.yuvSurfaceMode >= 1) {
                    GLES20.glPixelStorei((int)3317, (int)1);
                }
            }
            this.codec.start();
            this.callback.onUpdateEncoderFormat(this.useSurfaceMode);
        }
        catch (Exception e) {
            Logging.e(TAG, "initEncodeInternal failed", e);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        int lowQpThreshold = 30;
        int highQpThreshold = 37;
        if (this.codecType == VideoCodecType.VP8) {
            lowQpThreshold = 29;
            highQpThreshold = 95;
        } else if (this.codecType == VideoCodecType.H264) {
            lowQpThreshold = 30;
            highQpThreshold = 37;
        } else if (this.codecType == VideoCodecType.H265) {
            lowQpThreshold = 30;
            highQpThreshold = 36;
        }
        this.bitrateAdjuster.init(lowQpThreshold, highQpThreshold);
        this.running = true;
        this.outputThreadExceptionCount = 0;
        this.outputThreadError = false;
        this.outputThreadChecker.detachThread();
        if (!this.syncMode) {
            this.outputThread = this.createOutputThread();
            this.outputThread.start();
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus release() {
        VideoCodecStatus returnValue;
        Logging.i(TAG, "release start.");
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.syncMode) {
            if (this.codec != null) {
                this.outputThreadChecker.detachThread();
                final CountDownLatch releaseDone = new CountDownLatch(1);
                Runnable runMediaCodecRelease = new Runnable(){

                    @Override
                    public void run() {
                        HardwareVideoEncoder.this.releaseCodecOnOutputThread();
                        releaseDone.countDown();
                    }
                };
                new Thread(runMediaCodecRelease).start();
                if (!ThreadUtils.awaitUninterruptibly(releaseDone, 5000L)) {
                    Logging.e(TAG, "sync releaseCodecOnOutputThread timeout");
                    returnValue = VideoCodecStatus.TIMEOUT;
                } else if (this.shutdownException != null) {
                    Logging.e(TAG, "sync releaseCodecOnOutputThread exception", this.shutdownException);
                    returnValue = VideoCodecStatus.ERROR;
                } else {
                    returnValue = VideoCodecStatus.OK;
                }
            } else {
                Logging.w(TAG, "sync mode release, codec be null!!!");
                returnValue = VideoCodecStatus.OK;
            }
        } else {
            this.running = false;
            if (this.outputThread != null && !ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                returnValue = VideoCodecStatus.TIMEOUT;
            } else if (this.shutdownException != null) {
                Logging.e(TAG, "Media encoder release exception", this.shutdownException);
                returnValue = VideoCodecStatus.ERROR;
            } else {
                returnValue = VideoCodecStatus.OK;
            }
        }
        this.textureDrawer.release();
        this.videoFrameDrawer.release();
        if (this.textureEglBase != null) {
            this.textureEglBase.release();
            this.textureEglBase = null;
        }
        if (this.textureInputSurface != null) {
            this.textureInputSurface.release();
            this.textureInputSurface = null;
        }
        this.outputBuilders.clear();
        this.codec = null;
        this.outputThread = null;
        this.bitrateAdjuster.release();
        this.encodeThreadChecker.detachThread();
        Logging.i(TAG, "release end.");
        return returnValue;
    }

    @Override
    public VideoCodecStatus encode(VideoFrame videoFrame, VideoEncoder.EncodeInfo encodeInfo) {
        boolean shouldUseSurfaceMode;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.codec == null) {
            Logging.e(TAG, "codec null, UNINITIALIZED");
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (this.outputThreadError) {
            Logging.w(TAG, "Too many exceptions in output thread, fallback to software encoder.");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        VideoFrame.Buffer videoFrameBuffer = videoFrame.getBuffer();
        boolean isTextureBuffer = videoFrameBuffer instanceof VideoFrame.TextureBuffer;
        boolean isWrapTextureBuffer = videoFrameBuffer instanceof VideoFrame.WrapTextureBuffer;
        boolean isTexture = isTextureBuffer || isWrapTextureBuffer;
        int frameWidth = videoFrame.getBuffer().getWidth();
        int frameHeight = videoFrame.getBuffer().getHeight();
        boolean bl = shouldUseSurfaceMode = this.canUseSurface() && (isTexture || this.yuvSurfaceMode >= 1);
        if (frameWidth != this.actualWidth || frameHeight != this.actualHeight || shouldUseSurfaceMode != this.useSurfaceMode) {
            Logging.i(TAG, " origin size is: " + this.actualWidth + "x" + this.actualHeight + " useSurfaceMode = " + this.useSurfaceMode + ", new size is: " + frameWidth + "x" + frameHeight + " shouldUseSurfaceMode = " + shouldUseSurfaceMode);
            this.actualWidth = frameWidth;
            this.actualHeight = frameHeight;
            this.useSurfaceMode = shouldUseSurfaceMode;
            this.alignResolutionIfNeeded();
            boolean isSizeSupport = MediaCodecUtils.checkSize(this.capabilities, this.width, this.height, this.fallbackResolution);
            if (!isSizeSupport && !this.forceHardwareEncode) {
                Logging.w(TAG, " resetCodec: " + this.width + " x " + this.height + " isSizeSupport: " + isSizeSupport + " FALLBACK_SOFTWARE");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (this.fallbackResolution > 0 && frameWidth * frameHeight < this.fallbackResolution) {
                Logging.w(TAG, " resetCodec: " + frameWidth + " x " + frameHeight + " fallbackResolution " + this.fallbackResolution + " SDK_INT: " + Build.VERSION.SDK_INT + " FALLBACK_SOFTWARE");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            VideoCodecStatus videoCodecStatus = this.resetCodec();
            if (videoCodecStatus != VideoCodecStatus.OK) {
                Logging.e(TAG, "resetCodec faile, status: " + (Object)((Object)videoCodecStatus));
                return videoCodecStatus;
            }
        }
        if (this.syncMode && this.outputBuilders.size() > 0) {
            this.loopForDeliverEncodedImage();
        }
        if (this.outputBuilders.size() > 2) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            return VideoCodecStatus.NO_OUTPUT;
        }
        boolean requestedKeyFrame = false;
        for (EncodedImage.FrameType frameType : encodeInfo.frameTypes) {
            if (frameType != EncodedImage.FrameType.VideoFrameKey) continue;
            requestedKeyFrame = true;
        }
        if (requestedKeyFrame || this.shouldForceKeyFrame(videoFrame.getTimestampNs())) {
            this.requestKeyFrame(videoFrame.getTimestampNs());
        }
        int n = this.width * this.height * 3 / 2;
        EncodedImage.Builder builder = EncodedImage.builder().setCaptureTimeNs(videoFrame.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(this.width).setEncodedHeight(this.height).setActualWidth(this.actualWidth).setActualHeight(this.actualHeight).setRotation(videoFrame.getRotation());
        try {
            this.outputBuilders.offer(builder);
        }
        catch (Exception e) {
            e.printStackTrace();
            return VideoCodecStatus.ERROR;
        }
        VideoCodecStatus returnValue = this.useSurfaceMode ? this.encodeTextureBuffer(videoFrame) : this.encodeByteBuffer(videoFrame, videoFrameBuffer, n);
        if (returnValue != VideoCodecStatus.OK) {
            this.outputBuilders.pollLast();
            Logging.e(TAG, "encode error: " + (Object)((Object)returnValue) + ", outputBuilders.size(): " + this.outputBuilders.size());
        }
        if (this.syncMode && this.outputBuilders.size() > 0) {
            this.loopForDeliverEncodedImage();
        }
        return returnValue;
    }

    private VideoCodecStatus encodeTextureBuffer(VideoFrame videoFrame) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            GLES20.glClear((int)16384);
            VideoFrame derotatedFrame = new VideoFrame(videoFrame.getBuffer(), 0, videoFrame.getTimestampNs());
            this.videoFrameDrawer.drawFrame(derotatedFrame, this.textureDrawer, null, 0, 0, this.width, this.height, this.width, this.height);
            this.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "encodeTexture failed", e);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus encodeByteBuffer(VideoFrame videoFrame, VideoFrame.Buffer videoFrameBuffer, int bufferSize) {
        int index;
        this.encodeThreadChecker.checkIsOnValidThread();
        long presentationTimestampUs = (videoFrame.getTimestampNs() + 500L) / 1000L;
        try {
            index = this.codec.dequeueInputBuffer(0L);
        }
        catch (Exception e) {
            Logging.e(TAG, "dequeueInputBuffer failed", e);
            return VideoCodecStatus.ERROR;
        }
        if (index == -1) {
            Logging.d(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            ByteBuffer buffer = this.codec.getInputBuffers()[index];
            this.fillInputBuffer(buffer, videoFrameBuffer);
        }
        catch (Exception e) {
            Logging.e(TAG, "getInputBuffers failed", e);
            return VideoCodecStatus.ERROR;
        }
        try {
            this.codec.queueInputBuffer(index, 0, bufferSize, presentationTimestampUs, 0);
        }
        catch (Exception e) {
            Logging.e(TAG, "queueInputBuffer failed", e);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int framerate) {
        int bitrateBps;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (framerate > 30) {
            framerate = 30;
        }
        if ((bitrateBps = bitrateAllocation.getSum()) < 0) {
            return VideoCodecStatus.ERROR;
        }
        if (this.targetQosBitrateBps != bitrateBps) {
            this.bitrateAdjuster.setTargets(bitrateBps, this.targetFPS);
            this.targetQosBitrateBps = bitrateBps;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.automaticResizeOn) {
            if (this.codecType == VideoCodecType.VP8) {
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (this.codecType == VideoCodecType.H264) {
                return new VideoEncoder.ScalingSettings(30, 37);
            }
            if (this.codecType == VideoCodecType.H265) {
                return new VideoEncoder.ScalingSettings(30, 36);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public void reportQP(int qp) {
        this.bitrateAdjuster.reportQP(qp);
    }

    @Override
    @Nullable
    public String getImplementationName() {
        return this.codecName;
    }

    @Override
    public boolean isSupportHardwareTextureEncoder() {
        return this.canUseSurface();
    }

    @Override
    public boolean isDimensityCpu() {
        return AndroidDeviceInfo.isHardWareVendorDimensity();
    }

    private VideoCodecStatus resetCodec() {
        this.encodeThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, " resetCodec");
        VideoCodecStatus status = this.release();
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        return this.initEncodeInternal();
    }

    private boolean shouldForceKeyFrame(long presentationTimestampNs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        return this.forcedKeyFrameNs > 0L && presentationTimestampNs > this.lastKeyFrameNs + this.forcedKeyFrameNs;
    }

    private void requestKeyFrame(long presentationTimestampNs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            Bundle b = new Bundle();
            b.putInt("request-sync", 0);
            this.codec.setParameters(b);
        }
        catch (Exception e) {
            Logging.e(TAG, "requestKeyFrame failed", e);
            return;
        }
        this.lastKeyFrameNs = presentationTimestampNs;
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
                HardwareVideoEncoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    private void loopForDeliverEncodedImage() {
        while (this.syncMode && this.deliverEncodedImage()) {
        }
    }

    protected boolean deliverEncodedImage() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int index = this.codec.dequeueOutputBuffer(info, this.dequeOutputTimeoutUs);
            if (index < 0) {
                return index == -3 || index == -2;
            }
            ByteBuffer codecOutputBuffer = this.codec.getOutputBuffers()[index];
            codecOutputBuffer.position(info.offset);
            codecOutputBuffer.limit(info.offset + info.size);
            boolean result = false;
            if ((info.flags & 2) != 0) {
                Logging.d(TAG, "Config frame generated. Offset: " + info.offset + ". Size: " + info.size);
                this.configBuffer = ByteBuffer.allocateDirect(info.size);
                this.configBuffer.put(codecOutputBuffer);
            } else {
                ByteBuffer frameBuffer;
                boolean isKeyFrame;
                this.bitrateAdjuster.reportEncodedFrame(info.size);
                if (this.adjustedBitrate != this.bitrateAdjuster.getAdjustedBitrateBps()) {
                    this.updateBitrate();
                }
                boolean bl = isKeyFrame = (info.flags & 1) != 0;
                if (isKeyFrame) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (isKeyFrame && (this.codecType == VideoCodecType.H264 || this.codecType == VideoCodecType.H265)) {
                    Logging.d(TAG, "Prepending config frame of size " + this.configBuffer.capacity() + " to output buffer with offset " + info.offset + ", size " + info.size);
                    frameBuffer = ByteBuffer.allocateDirect(info.size + this.configBuffer.capacity());
                    this.configBuffer.rewind();
                    frameBuffer.put(this.configBuffer);
                    frameBuffer.put(codecOutputBuffer);
                    frameBuffer.rewind();
                } else {
                    frameBuffer = codecOutputBuffer.slice();
                }
                EncodedImage.FrameType frameType = isKeyFrame ? EncodedImage.FrameType.VideoFrameKey : EncodedImage.FrameType.VideoFrameDelta;
                EncodedImage.Builder builder = this.outputBuilders.poll();
                builder.setBuffer(frameBuffer).setFrameType(frameType).setTargetEncBps(this.adjustedBitrate);
                this.callback.onEncodedFrame(builder.createEncodedImage(), new VideoEncoder.CodecSpecificInfo());
            }
            this.codec.releaseOutputBuffer(index, false);
            this.outputThreadExceptionCount = 0;
            return true;
        }
        catch (Exception e) {
            ++this.outputThreadExceptionCount;
            if (this.outputThreadExceptionCount > 5) {
                this.outputThreadError = true;
            }
            Logging.e(TAG, "deliverOutput failed", e);
            return false;
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.i(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media encoder stop failed", e);
        }
        try {
            this.codec.release();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media encoder release failed", e);
            this.shutdownException = e;
        }
        MediaCodecUtils.removeCodecInstances(true, this.codecName);
        this.configBuffer = null;
        Logging.i(TAG, "Release on output thread done");
    }

    private VideoCodecStatus updateBitrate() {
        this.outputThreadChecker.checkIsOnValidThread();
        int preBitrate = this.adjustedBitrate;
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        try {
            Bundle params = new Bundle();
            params.putInt("video-bitrate", this.adjustedBitrate);
            this.codec.setParameters(params);
            return VideoCodecStatus.OK;
        }
        catch (Exception e) {
            Logging.e(TAG, "updateBitrate failed", e);
            return VideoCodecStatus.ERROR;
        }
    }

    private boolean canUseSurface() {
        return this.sharedContext != null && this.surfaceColorFormat > 0;
    }

    private void updateYuvSurfaceModeForMtk(int width, int height) {
        if ((width % 16 != 0 || height % 16 != 0) && AndroidDeviceInfo.isHardWareVendorMediaTek() && this.yuvSurfaceMode == -1) {
            this.yuvSurfaceMode = this.canUseSurface() ? 2 : this.yuvSurfaceMode;
        } else if (width % 16 == 0 && height % 16 == 0 && AndroidDeviceInfo.isHardWareVendorMediaTek() && this.yuvSurfaceMode == 2) {
            this.yuvSurfaceMode = -1;
        }
        Logging.i(TAG, "updateYuvSurfaceModeForMtk, yuvSurfaceMode: " + this.yuvSurfaceMode + " width: " + width + " height: " + height);
    }

    protected void fillInputBuffer(ByteBuffer buffer, VideoFrame.Buffer videoFrameBuffer) {
        this.yuvFormat.fillBuffer(buffer, videoFrameBuffer, this.width, this.height);
    }

    private void alignResolutionIfNeeded() {
        if (this.enableAlignment) {
            if (this.codecWidthAlign == 0) {
                int capWidthAlign = 0;
                int capHeightAlign = 0;
                if (Build.VERSION.SDK_INT >= 21) {
                    MediaCodecInfo.VideoCapabilities videoCapabilities = this.capabilities.getVideoCapabilities();
                    capWidthAlign = videoCapabilities.getWidthAlignment();
                    capHeightAlign = videoCapabilities.getHeightAlignment();
                }
                this.codecWidthAlign = capWidthAlign > 16 ? capWidthAlign : 16;
                this.codecHeightAlign = capHeightAlign > 4 ? capHeightAlign : 4;
                Logging.i(TAG, "qijiyue: alignResolutionIfNeeded, capabilities align is: " + capWidthAlign + " x " + capHeightAlign + ", final codec align is:" + this.codecWidthAlign + " x " + this.codecHeightAlign);
            }
            this.width = this.actualWidth + this.codecWidthAlign - 1 & ~(this.codecWidthAlign - 1);
            this.height = this.actualHeight + this.codecHeightAlign - 1 & ~(this.codecHeightAlign - 1);
        } else {
            this.width = this.actualWidth;
            this.height = this.actualHeight;
        }
        Logging.i(TAG, "qijiyue: alignResolutionIfNeeded, actual: " + this.actualWidth + "x" + this.actualHeight + ", align to: " + this.width + "x" + this.height);
    }

    private static enum YuvFormat {
        I420{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer, int dstWidth, int dstHeight) {
                VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                if (i420 == null) {
                    return;
                }
                YuvHelper.I420Copy(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstBuffer, dstWidth, dstHeight);
                i420.release();
            }
        }
        ,
        NV12{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer, int dstWidth, int dstHeight) {
                VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                if (i420 == null) {
                    return;
                }
                YuvHelper.I420ToNV12(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstBuffer, dstWidth, dstHeight);
                i420.release();
            }
        };


        abstract void fillBuffer(ByteBuffer var1, VideoFrame.Buffer var2, int var3, int var4);

        static YuvFormat valueOf(int colorFormat) {
            switch (colorFormat) {
                case 19: {
                    return I420;
                }
                case 21: 
                case 2141391872: 
                case 2141391876: {
                    return NV12;
                }
            }
            Logging.w(HardwareVideoEncoder.TAG, "Unsupported colorFormat: " + colorFormat + " falling back to I420");
            return I420;
        }
    }
}

