/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import com.netease.lava.webrtc.CompatVideoCodecInfo;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.EglBase14;
import com.netease.lava.webrtc.H264Utils;
import com.netease.lava.webrtc.HardwareVideoEncoder;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.MediaCodecUtils;
import com.netease.lava.webrtc.MediaCodecWrapperFactoryImpl;
import com.netease.lava.webrtc.VideoCodecInfo;
import com.netease.lava.webrtc.VideoCodecType;
import com.netease.lava.webrtc.VideoEncoder;
import com.netease.lava.webrtc.VideoEncoderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    private static final int INIT_DROP_FREAM_DEFALUT_COUNT = 2;
    private static final List<String> H264_HW_ENCODE_BLACKLIST = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060", "vivo Y67A", "PAFM00", "PACM00", "PBAM00");
    private static final List<String> H265_HW_ENCODE_BLACKLIST = Arrays.asList("CPH2399");
    @Nullable
    private EglBase14.Context sharedContext;
    private boolean enableIntelVp8Encoder;
    private boolean enableH264HighProfile;
    @Nullable
    private CompatVideoCodecInfo compatInfo;
    private int initDropFrameCount = 2;

    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, int initDropFrameCount) {
        if (sharedContext instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)sharedContext;
        } else {
            Logging.w(TAG, "Ctor sharedContext is  null! ");
            this.sharedContext = null;
        }
        this.enableIntelVp8Encoder = enableIntelVp8Encoder;
        this.enableH264HighProfile = enableH264HighProfile;
        this.initDropFrameCount = initDropFrameCount;
        MediaCodecUtils.cleanCodecInstances(true);
    }

    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this(sharedContext, enableIntelVp8Encoder, enableH264HighProfile, 2);
    }

    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, CompatVideoCodecInfo compatInfo) {
        if (sharedContext instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)sharedContext;
        } else {
            Logging.w(TAG, "No shared EglBase.Context.");
            this.sharedContext = null;
        }
        MediaCodecUtils.cleanCodecInstances(true);
        this.compatInfo = compatInfo;
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this(null, enableIntelVp8Encoder, enableH264HighProfile, 2);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo input) {
        CompatVideoCodecInfo compatFormNative;
        if (Build.VERSION.SDK_INT < 19 || input == null) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf(input.getName());
        if (type == null) {
            Logging.e(TAG, "createEncoder failed for: " + input.name);
            return null;
        }
        MediaCodecInfo info = this.findCodecForType(type);
        if (info == null) {
            Logging.e(TAG, "createEncoder failed for: " + input.name);
            return null;
        }
        String codecName = info.getName();
        String mime = type.mimeType();
        MediaCodecUtils.printMetadata(info.getCapabilitiesForType(mime));
        Integer surfaceColorFormat = MediaCodecUtils.selectColorFormat(codecName, MediaCodecUtils.TEXTURE_COLOR_FORMATS, info.getCapabilitiesForType(mime));
        Integer yuvColorFormat = MediaCodecUtils.selectColorFormat(codecName, MediaCodecUtils.ENCODER_COLOR_FORMATS, info.getCapabilitiesForType(mime));
        if (type == VideoCodecType.H264) {
            boolean isHighProfile = H264Utils.isSameH264Profile(input.params, MediaCodecUtils.getCodecProperties(type, true));
            boolean isBaselineProfile = H264Utils.isSameH264Profile(input.params, MediaCodecUtils.getCodecProperties(type, false));
            if (!(isHighProfile || isBaselineProfile || this.compatInfo != null && this.compatInfo.getForceHardwareEncodeingForH264() == 1)) {
                return null;
            }
            if (isHighProfile && !this.isH264HighProfileSupported(info) && (this.compatInfo == null || this.compatInfo.getForceHardwareEncodeingForH264() != 1)) {
                return null;
            }
        }
        int forceHardwareEncodeingForH264 = 0;
        int forceHardwareEncodeingForH265 = 0;
        if (this.compatInfo != null) {
            if (this.compatInfo.getForceHardwareEncodeingForH264() > 0) {
                forceHardwareEncodeingForH264 = this.compatInfo.getForceHardwareEncodeingForH264();
            }
            if (this.compatInfo.getForceHardwareEncodeingForH265() > 0) {
                forceHardwareEncodeingForH265 = this.compatInfo.getForceHardwareEncodeingForH265();
            }
            if (this.compatInfo.getCodecName() != null) {
                switch (type) {
                    case H264: {
                        if (codecName == null || !this.compatInfo.getCodecName().toLowerCase(Locale.ROOT).contains("h264") && !this.compatInfo.getCodecName().toLowerCase(Locale.ROOT).contains("avc")) break;
                        Logging.i(TAG, "old codecName: " + codecName + ", new codecName: " + this.compatInfo.getCodecName());
                        codecName = this.compatInfo.getCodecName();
                        break;
                    }
                    case H265: {
                        if (codecName == null || !this.compatInfo.getCodecName().toLowerCase(Locale.ROOT).contains("h265") && !this.compatInfo.getCodecName().toLowerCase(Locale.ROOT).contains("hevc")) break;
                        Logging.i(TAG, "old codecName: " + codecName + ", new codecName: " + this.compatInfo.getCodecName());
                        codecName = this.compatInfo.getCodecName();
                        break;
                    }
                }
            }
            if (this.compatInfo.getEnSurfaceColorFormat() >= 0) {
                surfaceColorFormat = this.compatInfo.getEnSurfaceColorFormat();
            }
            if (this.compatInfo.getEnYUVColorFormat() >= 0) {
                yuvColorFormat = this.compatInfo.getEnYUVColorFormat();
            }
            if (input.params != null) {
                if (this.compatInfo.getProfile() > 0) {
                    input.params.put("profile-id", String.valueOf(this.compatInfo.getProfile()));
                }
                if (this.compatInfo.getLevel() > 0) {
                    input.params.put("level-id", String.valueOf(this.compatInfo.getLevel()));
                }
            }
        }
        if ((compatFormNative = input.getCompatInfo()) != null) {
            EglBase.Context eglContext;
            if (compatFormNative.getKeyFrameIntervalSec() > 0) {
                this.compatInfo.setKeyFrameIntervalSec(compatFormNative.getKeyFrameIntervalSec());
            }
            if (compatFormNative.getInitDropFrameCount() > 0) {
                this.initDropFrameCount = compatFormNative.getInitDropFrameCount();
            }
            if ((eglContext = compatFormNative.getEGLContext()) != null && eglContext instanceof EglBase14.Context) {
                this.sharedContext = (EglBase14.Context)compatFormNative.getEGLContext();
            }
        }
        compatFormNative.setCodecName(codecName);
        compatFormNative.setEnSurfaceColorFormat(surfaceColorFormat != null ? surfaceColorFormat : 0);
        compatFormNative.setEnYUVColorFormat(yuvColorFormat != null ? yuvColorFormat : 0);
        compatFormNative.setKeyFrameIntervalSec(this.getKeyFrameIntervalSec());
        compatFormNative.setForceKeyFrameIntervalMs(this.getForcedKeyFrameIntervalMs(type, codecName));
        compatFormNative.setInitDropFrameCount(this.initDropFrameCount);
        compatFormNative.setForceHardwareEncodeingForH264(forceHardwareEncodeingForH264);
        compatFormNative.setForceHardwareEncodeingForH265(forceHardwareEncodeingForH265);
        return new HardwareVideoEncoder(new MediaCodecWrapperFactoryImpl(), type, input.params, this.sharedContext, compatFormNative, info.getCapabilitiesForType(mime));
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        if (Build.VERSION.SDK_INT < 19) {
            return new VideoCodecInfo[0];
        }
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.H264, VideoCodecType.H265}) {
            MediaCodecInfo codec = this.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType type) {
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            if (info == null || !info.isEncoder() || !this.isSupportedCodec(info, type)) continue;
            return info;
        }
        Logging.w(TAG, "Cannot find encoder for type:" + type.mimeType());
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(info.getName(), MediaCodecUtils.ENCODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
            return false;
        }
        boolean forceHwEnable = false;
        if (this.compatInfo != null) {
            switch (type) {
                case H264: {
                    forceHwEnable = this.compatInfo.getForceHardwareEncodeingForH264() == 1;
                    break;
                }
                case H265: {
                    forceHwEnable = this.compatInfo.getForceHardwareEncodeingForH265() == 1;
                    break;
                }
                default: {
                    forceHwEnable = false;
                }
            }
        }
        return this.isHardwareSupportedInCurrentSdk(info, type) || forceHwEnable;
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        if (this.isEncoderBlackList(type)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            boolean isHardwareAccelerated = info.isHardwareAccelerated();
            Logging.i(TAG, "Codec Name: " + info.getName() + ", isHardwareAccelerated: " + isHardwareAccelerated);
            return isHardwareAccelerated;
        }
        boolean isHardwareSupported = true;
        switch (type) {
            case VP8: {
                isHardwareSupported = this.isHardwareSupportedInCurrentSdkVp8(info);
                break;
            }
            case VP9: {
                isHardwareSupported = this.isHardwareSupportedInCurrentSdkVp9(info);
                break;
            }
            case H264: {
                isHardwareSupported = this.isHardwareSupportedInCurrentSdkH264(info);
                break;
            }
            case H265: {
                isHardwareSupported = this.isHardwareSupportedInCurrentSdkH265(info);
            }
        }
        if (!isHardwareSupported) {
            Logging.w(TAG, "Soc or SDK_INT is not Supported, Codec Name: " + info.getName() + "SDK_INT: " + Build.VERSION.SDK_INT);
        }
        return isHardwareSupported;
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo info) {
        String name = info.getName();
        return name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || name.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo info) {
        String name = info.getName();
        return (name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info) {
        String name = info.getName();
        return name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.MTK.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.IMG.TOPAZ.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.hisi.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.k3.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.amlogic.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.rk.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 21 || name.startsWith("OMX.MS.") && Build.VERSION.SDK_INT >= 21;
    }

    private boolean isHardwareSupportedInCurrentSdkH265(MediaCodecInfo info) {
        String name = info.getName();
        return name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 24 || name.startsWith("OMX.MTK.") && Build.VERSION.SDK_INT >= 24 || name.startsWith("OMX.IMG.TOPAZ.") && Build.VERSION.SDK_INT >= 24 || name.startsWith("OMX.hisi.") && Build.VERSION.SDK_INT >= 24 || name.startsWith("OMX.k3.") && Build.VERSION.SDK_INT >= 24 || name.startsWith("OMX.amlogic.") && Build.VERSION.SDK_INT >= 24 || name.startsWith("OMX.rk.") && Build.VERSION.SDK_INT >= 24 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 24 || name.startsWith("OMX.MS.") && Build.VERSION.SDK_INT >= 24;
    }

    private int getKeyFrameIntervalSec() {
        if (this.compatInfo != null && this.compatInfo.getKeyFrameIntervalSec() > 0) {
            return this.compatInfo.getKeyFrameIntervalSec();
        }
        return -1;
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecType type, String codecName) {
        if (this.compatInfo != null && this.compatInfo.getForceKeyFrameIntervalMs() > 0) {
            return this.compatInfo.getForceKeyFrameIntervalMs();
        }
        if (type == VideoCodecType.VP8 && codecName.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    private boolean isEncoderBlackList(VideoCodecType type) {
        if (type == VideoCodecType.H264 && H264_HW_ENCODE_BLACKLIST.contains(Build.MODEL)) {
            Logging.w(TAG, "The model is in local h264_encode blacklist.");
            return true;
        }
        if (type == VideoCodecType.H265 && H265_HW_ENCODE_BLACKLIST.contains(Build.MODEL)) {
            Logging.w(TAG, "The model is in local h265_encode blacklist.");
            return true;
        }
        return false;
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        return this.enableH264HighProfile && Build.VERSION.SDK_INT > 23 && info.getName().startsWith("OMX.Exynos.");
    }
}

