/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.JniCommon;
import com.netease.lava.webrtc.RefCountDelegate;
import com.netease.lava.webrtc.VideoFrame;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class JavaNV12Buffer
implements VideoFrame.NV12Buffer {
    private int width;
    private int height;
    private int oriWidth;
    private int oriHeight;
    private int stride;
    private int sliceHeight;
    private ByteBuffer buffer;
    private RefCountDelegate refCountDelegate;
    private ByteBuffer dataY;
    private ByteBuffer dataUV;

    public JavaNV12Buffer(int width, int height, int stride, int sliceHeight, ByteBuffer buffer, @Nullable Runnable releaseCallback) {
        this.width = width;
        this.height = height;
        this.oriWidth = width;
        this.oriHeight = height;
        this.stride = stride;
        this.sliceHeight = sliceHeight;
        this.buffer = buffer;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
        int chromaHeight = (height + 1) / 2;
        int strideUV = width;
        int yPos = 0;
        int uvPos = yPos + width * height;
        buffer.position(yPos);
        buffer.limit(uvPos);
        this.dataY = buffer.slice();
        buffer.position(uvPos);
        buffer.limit(uvPos + strideUV * chromaHeight);
        this.dataUV = buffer.slice();
    }

    public static JavaNV12Buffer allocate(int width, int height) {
        int chromaHeight = (height + 1) / 2;
        ByteBuffer buffer = JniCommon.nativeAllocateByteBuffer(width * height + width * chromaHeight);
        return new JavaNV12Buffer(width, height, width, height, buffer, () -> JniCommon.nativeFreeByteBuffer(buffer));
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataUV() {
        return this.dataUV.slice();
    }

    @Override
    public int getStride() {
        return this.stride;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getOriWidth() {
        return this.oriWidth;
    }

    @Override
    public int getOriHeight() {
        return this.oriHeight;
    }

    @Override
    public int getBufferType() {
        return 2;
    }

    @Override
    public VideoFrame.Buffer.BufferType getInternalBufferType() {
        return VideoFrame.Buffer.BufferType.kBufferTypeNV12;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public int getRefCount() {
        return this.refCountDelegate.getRefCount();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(scaleWidth, scaleHeight);
        JavaNV12Buffer.nativeCropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight, this.buffer, this.width, this.height, this.stride, this.sliceHeight, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV());
        return newBuffer;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, ByteBuffer var6, int var7, int var8, int var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14, ByteBuffer var15, int var16);
}

