/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.media.MediaCodecInfo;
import android.os.Build;
import android.util.Range;
import com.netease.lava.webrtc.H264Utils;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.VideoCodecType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

class MediaCodecUtils {
    private static final String TAG = "MediaCodecUtils";
    static final String QCOM_PREFIX = "OMX.qcom.";
    static final String EXYNOS_PREFIX = "OMX.Exynos.";
    static final String MTK_PREFIX = "OMX.MTK.";
    static final String IMG_PREFIX = "OMX.IMG.TOPAZ.";
    static final String HISI_PREFIX = "OMX.hisi.";
    static final String K3_PREFIX = "OMX.k3.";
    static final String AMLOGIC_PREFIX = "OMX.amlogic.";
    static final String INTEL_PREFIX = "OMX.Intel.";
    static final String RK_PREFIX = "OMX.rk.";
    static final String NVIDIA_PREFIX = "OMX.Nvidia.";
    static final String MS_PREFIX = "OMX.MS.";
    static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES = new String[]{"OMX.google.", "OMX.SEC."};
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    static final int COLOR_HISENSE_S7_FormatYUV420SemiPlanar_NV21 = 47;
    static Map<String, Integer> currentEncodeInstancesMap = new HashMap<String, Integer>();
    static Map<String, Integer> currentDecodeInstancesMap = new HashMap<String, Integer>();
    static Object codecInstanceLock = new Object();
    static final int[] DECODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 47, 2141391873, 2141391874, 2141391875, 2141391876};
    static final int[] ENCODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391876};
    static final int[] TEXTURE_COLOR_FORMATS = MediaCodecUtils.getTextureColorFormats();

    private static int[] getTextureColorFormats() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new int[]{2130708361};
        }
        return new int[0];
    }

    @Nullable
    static Integer selectColorFormat(String name, int[] supportedColorFormats, MediaCodecInfo.CodecCapabilities capabilities) {
        boolean YUV420SemiPlanarOk = false;
        for (int colorFormat : capabilities.colorFormats) {
            if (21 != colorFormat) continue;
            YUV420SemiPlanarOk = true;
        }
        for (int supportedColorFormat : supportedColorFormats) {
            for (int codecColorFormat : capabilities.colorFormats) {
                if (codecColorFormat != supportedColorFormat) continue;
                if (codecColorFormat == 19 && YUV420SemiPlanarOk && (name.startsWith(IMG_PREFIX) || name.startsWith(HISI_PREFIX) || name.startsWith(K3_PREFIX))) {
                    codecColorFormat = 21;
                }
                return codecColorFormat;
            }
        }
        return null;
    }

    static void printMetadata(MediaCodecInfo.CodecCapabilities capabilities) {
        if (Build.VERSION.SDK_INT >= 23) {
            Range widths = capabilities.getVideoCapabilities().getSupportedWidths();
            Range heights = capabilities.getVideoCapabilities().getSupportedHeights();
            Range frameRates = capabilities.getVideoCapabilities().getSupportedFrameRates();
            Range bitRates = capabilities.getVideoCapabilities().getBitrateRange();
            if (widths == null || heights == null || frameRates == null || bitRates == null) {
                Logging.w(TAG, "null mediacodec metadata.");
                return;
            }
            int widthAlignment = capabilities.getVideoCapabilities().getWidthAlignment();
            int heightAlignment = capabilities.getVideoCapabilities().getHeightAlignment();
            int maxEncoderInstance = capabilities.getMaxSupportedInstances();
            Logging.d(TAG, "supported widths Range:[" + widths.getLower() + "," + widths.getUpper() + "], height Range:[" + heights.getLower() + "," + heights.getUpper() + "], fps range:[" + frameRates.getLower() + "," + frameRates.getUpper() + "], bitrate range: [" + bitRates.getLower() + "," + bitRates.getUpper() + "], widthAlignment:" + widthAlignment + " heightAlignment:" + heightAlignment + " maxEncoderInstance:" + maxEncoderInstance);
        }
    }

    static boolean checkSize(MediaCodecInfo.CodecCapabilities capabilities, int width, int height, int fallbackResolution) {
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecInfo.VideoCapabilities videoCapabilities = capabilities.getVideoCapabilities();
            if (videoCapabilities == null) {
                Logging.w(TAG, "VideoCapabilities is NULL");
                return false;
            }
            if (!videoCapabilities.isSizeSupported(width, height) && !videoCapabilities.isSizeSupported(height, width)) {
                Logging.w(TAG, "checkSize\uff1aSize not Supported width:" + width + " height:" + height + " SDK_INT: " + Build.VERSION.SDK_INT);
                return false;
            }
        } else if (fallbackResolution > 0 && Build.VERSION.SDK_INT < 21) {
            if (width * height < fallbackResolution) {
                Logging.w(TAG, " checkSize: Size not Supported:" + width + " x " + height + " fallbackResolution " + fallbackResolution + " SDK_INT: " + Build.VERSION.SDK_INT);
                return false;
            }
        } else {
            Logging.w(TAG, "checkSize: Can not check Size,because:SDK_INT < 21 or fallbackResolution <= 0 SDK_INT: " + Build.VERSION.SDK_INT + " fallbackResolution: " + fallbackResolution);
        }
        return true;
    }

    static boolean checkBitrate(MediaCodecInfo.CodecCapabilities capabilities, int bitrate) {
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecInfo.VideoCapabilities videoCapabilities = capabilities.getVideoCapabilities();
            if (videoCapabilities == null) {
                Logging.w(TAG, "VideoCapabilities is NULL");
                return false;
            }
            Range bitrateRange = videoCapabilities.getBitrateRange();
            if (bitrateRange == null) {
                Logging.w(TAG, "bitrateRange is NULL");
                return true;
            }
            return bitrateRange.contains((Comparable)Integer.valueOf(bitrate));
        }
        Logging.w(TAG, "checkBitrate: Can not get bitrateRange,because:SDK_INT < 21  SDK_INT: " + Build.VERSION.SDK_INT);
        return true;
    }

    static boolean checkFrameRate(MediaCodecInfo.CodecCapabilities capabilities, int frameRate) {
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecInfo.VideoCapabilities videoCapabilities = capabilities.getVideoCapabilities();
            if (videoCapabilities == null) {
                Logging.w(TAG, "VideoCapabilities is NULL");
                return false;
            }
            Range frameRateRange = videoCapabilities.getSupportedFrameRates();
            if (frameRateRange == null) {
                Logging.w(TAG, "frameRateRange is NULL");
                return true;
            }
            return frameRateRange.contains((Comparable)Integer.valueOf(frameRate));
        }
        Logging.w(TAG, "checkFrameRate: Can not get frameRateRange,because:SDK_INT < 21  SDK_INT: " + Build.VERSION.SDK_INT);
        return true;
    }

    static int getMaxSupportedInstances(MediaCodecInfo.CodecCapabilities capabilities) {
        if (Build.VERSION.SDK_INT >= 23 && capabilities != null) {
            return capabilities.getMaxSupportedInstances();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addCodecInstances(boolean isEncoderCodec, String codecName) {
        Object object = codecInstanceLock;
        synchronized (object) {
            Map<String, Integer> map;
            String codecTag = isEncoderCodec ? "[encoder] " : "[decoder] ";
            Map<String, Integer> map2 = map = isEncoderCodec ? currentEncodeInstancesMap : currentDecodeInstancesMap;
            if (map != null && codecName != null) {
                int count = map.containsKey(codecName) ? map.get(codecName) : 0;
                map.put(codecName, count + 1);
                Logging.i(TAG, codecTag + "addCodecInstances-done: currentCodecInstancesCount: " + (count + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeCodecInstances(boolean isEncoderCodec, String codecName) {
        Object object = codecInstanceLock;
        synchronized (object) {
            Map<String, Integer> map;
            String codecTag = isEncoderCodec ? "[encoder] " : "[decoder] ";
            Map<String, Integer> map2 = map = isEncoderCodec ? currentEncodeInstancesMap : currentDecodeInstancesMap;
            if (map != null && codecName != null) {
                int count;
                int n = count = map.containsKey(codecName) ? map.get(codecName) : 0;
                if (count < 1) {
                    Logging.w(TAG, codecTag + "Can not remove Codec Instance,because currentCodecInstancesCount: " + count);
                    map.remove(codecName);
                } else {
                    map.put(codecName, count - 1);
                }
                Logging.i(TAG, codecTag + "removeCodecInstances-done: currentCodecInstancesCount: " + (count - 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getCodecInstances(boolean isEncoderCodec, String codecName) {
        Object object = codecInstanceLock;
        synchronized (object) {
            Map<String, Integer> map;
            Map<String, Integer> map2 = map = isEncoderCodec ? currentEncodeInstancesMap : currentDecodeInstancesMap;
            if (map != null && codecName != null) {
                return map.containsKey(codecName) ? map.get(codecName) : 0;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanCodecInstances(boolean isEncodeCodec) {
        Object object = codecInstanceLock;
        synchronized (object) {
            Map<String, Integer> map;
            Map<String, Integer> map2 = map = isEncodeCodec ? currentEncodeInstancesMap : currentDecodeInstancesMap;
            if (map != null) {
                map.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkCodecInstances(MediaCodecInfo.CodecCapabilities capabilities, boolean isEncoderCodec, String codecName) {
        Object object = codecInstanceLock;
        synchronized (object) {
            String codecTag;
            String string = codecTag = isEncoderCodec ? "[encoder] " : "[decoder] ";
            if (Build.VERSION.SDK_INT >= 23) {
                if (capabilities != null) {
                    int maxInstances = -1;
                    Map<String, Integer> map = isEncoderCodec ? currentEncodeInstancesMap : currentDecodeInstancesMap;
                    maxInstances = capabilities.getMaxSupportedInstances();
                    int currentInstances = MediaCodecUtils.getCodecInstances(isEncoderCodec, codecName);
                    if (currentInstances >= maxInstances) {
                        Logging.w(TAG, codecTag + "checkCodecInstances: currentInstances: " + currentInstances + " is out of range, maxInstances is " + maxInstances);
                        return false;
                    }
                }
            } else {
                Logging.w(TAG, codecTag + "checkCodecInstances: Can not get maxCodecInstances,because:SDK_INT < 23  SDK_INT: " + Build.VERSION.SDK_INT);
            }
            return true;
        }
    }

    static boolean codecSupportsType(MediaCodecInfo info, VideoCodecType type) {
        for (String mimeType : info.getSupportedTypes()) {
            if (!type.mimeType().equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    static Map<String, String> getCodecProperties(VideoCodecType type, boolean highProfile) {
        switch (type) {
            case VP8: 
            case VP9: 
            case H265: {
                return new HashMap<String, String>();
            }
            case H264: {
                return H264Utils.getDefaultH264Params(highProfile);
            }
        }
        throw new IllegalArgumentException("Unsupported codec: " + (Object)((Object)type));
    }

    private MediaCodecUtils() {
    }
}

