/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import com.netease.lava.webrtc.AndroidVideoDecoder;
import com.netease.lava.webrtc.CompatVideoCodecInfo;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.MediaCodecUtils;
import com.netease.lava.webrtc.MediaCodecWrapperFactoryImpl;
import com.netease.lava.webrtc.VideoCodecInfo;
import com.netease.lava.webrtc.VideoCodecType;
import com.netease.lava.webrtc.VideoDecoder;
import com.netease.lava.webrtc.VideoDecoderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

class MediaCodecVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "MediaCodecVideoDecoderFactory";
    @Nullable
    private EglBase.Context sharedContext;
    private final String[] prefixWhitelist;
    private final String[] prefixBlacklist;
    private int initDropFrameCount;
    private CompatVideoCodecInfo compatInfo;
    private static final List<String> H264_HW_DECODE_BLACKLIST = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060", "vivo Y67A", "PAFM00", "PACM00", "COL-AL10", "OPPO R9m", "PAR-AL00", "MHA-AL00", "PBAM00", "LYA-AL00");

    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context sharedContext, String[] prefixWhitelist, String[] prefixBlacklist, CompatVideoCodecInfo compatInfo) {
        this.sharedContext = sharedContext;
        this.prefixWhitelist = Arrays.copyOf(prefixWhitelist, prefixWhitelist.length);
        this.prefixBlacklist = Arrays.copyOf(prefixBlacklist, prefixBlacklist.length);
        this.compatInfo = compatInfo;
        MediaCodecUtils.cleanCodecInstances(false);
    }

    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context sharedContext, String[] prefixWhitelist, String[] prefixBlacklist, int initDropFrameCount) {
        this.sharedContext = sharedContext;
        this.prefixWhitelist = Arrays.copyOf(prefixWhitelist, prefixWhitelist.length);
        this.prefixBlacklist = Arrays.copyOf(prefixBlacklist, prefixBlacklist.length);
        this.initDropFrameCount = initDropFrameCount;
        MediaCodecUtils.cleanCodecInstances(false);
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        CompatVideoCodecInfo compatFormNative;
        if (codecType == null) {
            Logging.e(TAG, "codecType is null! ");
            return null;
        }
        VideoCodecType type = this.getDecoderType(codecType.compatInfo, codecType.getName());
        if (type == null) {
            Logging.e(TAG, "create Decoder failed for: " + codecType.getName());
            return null;
        }
        MediaCodecInfo info = this.findCodecForType(type);
        if (info == null) {
            Logging.e(TAG, "Cannot find Video CodecInfo: " + codecType.getName());
            return null;
        }
        MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(type.mimeType());
        String codecName = info.getName();
        int colorFormat = MediaCodecUtils.selectColorFormat(codecName, MediaCodecUtils.DECODER_COLOR_FORMATS, capabilities);
        int forceHardwareDecodeingForH264 = 0;
        int forceHardwareDecodeingForH265 = 0;
        if (this.compatInfo != null) {
            if (this.compatInfo.getForceHardwareDecodeingForH264() > 0) {
                forceHardwareDecodeingForH264 = this.compatInfo.getForceHardwareDecodeingForH264();
            }
            if (this.compatInfo.getForceHardwareDecodeingForH265() > 0) {
                forceHardwareDecodeingForH265 = this.compatInfo.getForceHardwareDecodeingForH265();
            }
            if (this.compatInfo.getCodecName() != null) {
                switch (type) {
                    case H264: {
                        if (codecName == null || !this.compatInfo.getCodecName().toLowerCase(Locale.ROOT).contains("h264") && !this.compatInfo.getCodecName().toLowerCase(Locale.ROOT).contains("avc")) break;
                        Logging.i(TAG, "old codecName: " + codecName + ", new codecName: " + this.compatInfo.getCodecName());
                        codecName = this.compatInfo.getCodecName();
                        break;
                    }
                    case H265: {
                        if (codecName == null || !this.compatInfo.getCodecName().toLowerCase(Locale.ROOT).contains("h265") && !this.compatInfo.getCodecName().toLowerCase(Locale.ROOT).contains("hevc")) break;
                        Logging.i(TAG, "old codecName: " + codecName + ", new codecName: " + this.compatInfo.getCodecName());
                        codecName = this.compatInfo.getCodecName();
                        break;
                    }
                }
            }
            if (this.compatInfo.getInitDropFrameCount() >= 0) {
                this.initDropFrameCount = this.compatInfo.getInitDropFrameCount();
            }
            if (this.compatInfo.getDecoderColorFormat() > 0) {
                colorFormat = this.compatInfo.getDecoderColorFormat();
            }
        }
        if ((compatFormNative = codecType.getCompatInfo()) != null) {
            EglBase.Context eglContext;
            if (compatFormNative.getInitDropFrameCount() > 0) {
                this.initDropFrameCount = compatFormNative.getInitDropFrameCount();
            }
            if ((eglContext = compatFormNative.getEGLContext()) != null && eglContext instanceof EglBase.Context) {
                this.sharedContext = compatFormNative.getEGLContext();
            }
        }
        compatFormNative.setCodecName(codecName);
        compatFormNative.setDecoderColorFormat(colorFormat);
        compatFormNative.setInitDropFrameCount(this.initDropFrameCount);
        compatFormNative.setForceHardwareDecodeingForH264(forceHardwareDecodeingForH264);
        compatFormNative.setForceHardwareDecodeingForH265(forceHardwareDecodeingForH265);
        return new AndroidVideoDecoder(new MediaCodecWrapperFactoryImpl(), type, this.sharedContext, compatFormNative, info.getCapabilitiesForType(type.mimeType()));
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264, VideoCodecType.H265}) {
            MediaCodecInfo codec = this.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType type) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", e);
            }
            if (info == null || info.isEncoder() || !this.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        String name = info.getName();
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(name, MediaCodecUtils.DECODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
            return false;
        }
        boolean forceHwEnable = false;
        if (this.compatInfo != null) {
            switch (type) {
                case H264: {
                    forceHwEnable = this.compatInfo.getForceHardwareDecodeingForH264() == 1;
                    break;
                }
                case H265: {
                    forceHwEnable = this.compatInfo.getForceHardwareDecodeingForH265() == 1;
                    break;
                }
                default: {
                    forceHwEnable = false;
                }
            }
        }
        return this.isCodecAllowed(info, type, name) || forceHwEnable;
    }

    @Nullable
    private VideoCodecType getDecoderType(CompatVideoCodecInfo compatInfo, String typeName) {
        VideoCodecType type = VideoCodecType.valueOf(typeName);
        if (compatInfo != null) {
            switch (type) {
                case H265: {
                    if (compatInfo.getHardwareDecodingForH265()) break;
                    Logging.w(TAG, "Compat not support HW H265");
                    return null;
                }
                case H264: {
                    if (compatInfo.getHardwareDecodingForH264()) break;
                    Logging.w(TAG, "Compat not support HW H264");
                    return null;
                }
            }
        }
        return type;
    }

    private boolean isWhitelisted(String name) {
        for (String prefix : this.prefixWhitelist) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isCodecAllowed(MediaCodecInfo info, VideoCodecType type, String name) {
        if (type == null || name == null) {
            return true;
        }
        if (this.isDecoderBlackList(type)) {
            return false;
        }
        for (String prefix : this.prefixBlacklist) {
            if (!name.startsWith(prefix)) continue;
            Logging.w(TAG, "Codec Name: " + name + "is in prefixBlacklist!");
            return false;
        }
        return this.isHardwareAccelerated(info);
    }

    private boolean isHardwareAccelerated(MediaCodecInfo info) {
        if (info == null) {
            return true;
        }
        boolean isHardwareAccelerated = true;
        if (Build.VERSION.SDK_INT >= 29) {
            isHardwareAccelerated = info.isHardwareAccelerated();
            Logging.w(TAG, "Codec Name: " + info.getName() + ", isHardwareAccelerated: " + isHardwareAccelerated);
        }
        return isHardwareAccelerated;
    }

    private boolean isDecoderBlackList(VideoCodecType type) {
        if (type == VideoCodecType.H264 && H264_HW_DECODE_BLACKLIST.contains(Build.MODEL)) {
            Logging.w(TAG, "The model is in local decode blacklist.");
            return true;
        }
        return false;
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        String name = info.getName();
        if (Build.VERSION.SDK_INT >= 21 && name.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && name.startsWith("OMX.Exynos.");
    }
}

