/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.RefCountDelegate;
import com.netease.lava.webrtc.VideoFrame;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class NV21Buffer
implements VideoFrame.Buffer {
    private final byte[] data;
    private int width;
    private int height;
    private int oriWidth;
    private int oriHeight;
    private final RefCountDelegate refCountDelegate;

    public NV21Buffer(byte[] data, int width, int height, @Nullable Runnable releaseCallback) {
        this.data = data;
        this.width = width;
        this.height = height;
        this.oriWidth = width;
        this.oriHeight = height;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getOriWidth() {
        return this.oriWidth;
    }

    @Override
    public int getOriHeight() {
        return this.oriHeight;
    }

    @Override
    public int getBufferType() {
        return 3;
    }

    @Override
    public VideoFrame.Buffer.BufferType getInternalBufferType() {
        return VideoFrame.Buffer.BufferType.kBufferTypeNV21;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public int getRefCount() {
        return this.refCountDelegate.getRefCount();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(scaleWidth, scaleHeight);
        NV21Buffer.nativeCropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight, this.data, this.width, this.height, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV());
        return newBuffer;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, ByteBuffer var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14);
}

