/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.content.Context;
import android.net.NetworkCapabilities;
import android.os.Build;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.ContextUtils;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.NetworkMonitorAutoDetect;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class NetworkMonitor {
    private static final String TAG = "NetworkMonitor";
    private final ArrayList<Long> nativeNetworkObservers;
    private final ArrayList<NetworkObserver> networkObservers;
    private final Object autoDetectLock = new Object();
    @Nullable
    private NetworkMonitorAutoDetect autoDetect;
    private int numObservers = 0;
    private volatile NetworkMonitorAutoDetect.ConnectionType currentConnectionType;

    private NetworkMonitor() {
        this.nativeNetworkObservers = new ArrayList();
        this.networkObservers = new ArrayList();
        this.currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;
    }

    @Deprecated
    public static void init(Context context) {
    }

    @CalledByNative
    public static NetworkMonitor getInstance() {
        return InstanceHolder.instance;
    }

    private static void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected to be true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoring(Context applicationContext, boolean needCollectNetwork) {
        Object object = this.autoDetectLock;
        synchronized (object) {
            ++this.numObservers;
            if (this.autoDetect == null) {
                this.autoDetect = this.createAutoDetect(applicationContext);
            }
            this.currentConnectionType = NetworkMonitorAutoDetect.getConnectionType(this.autoDetect.getCurrentNetworkState());
            if (needCollectNetwork) {
                this.updateObserverActiveNetworkList(0L, true);
            }
        }
    }

    @Deprecated
    public void startMonitoring() {
        this.startMonitoring(ContextUtils.getApplicationContext(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void startMonitoring(@Nullable Context applicationContext, long nativeObserver) {
        try {
            this.startMonitoring(applicationContext != null ? applicationContext : ContextUtils.getApplicationContext(), false);
            ArrayList<Long> arrayList = this.nativeNetworkObservers;
            synchronized (arrayList) {
                this.nativeNetworkObservers.add(nativeObserver);
            }
            this.updateObserverActiveNetworkList(nativeObserver, false);
            this.notifyObserversOfConnectionTypeChange(this.currentConnectionType, true);
        }
        catch (Exception e) {
            Logging.w(TAG, "startMonitoring exception:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            if (--this.numObservers == 0 && this.autoDetect != null) {
                this.autoDetect.destroy();
                this.autoDetect = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void stopMonitoring(long nativeObserver) {
        Logging.d(TAG, "Stop monitoring with native observer " + nativeObserver);
        this.stopMonitoring();
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            this.nativeNetworkObservers.remove(nativeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean networkBindingSupported() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect != null && this.autoDetect.supportNetworkCallback();
        }
    }

    @CalledByNative
    private static int androidSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    public NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentDefaultNetId() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect == null ? -1L : this.autoDetect.getDefaultNetId();
        }
    }

    private NetworkMonitorAutoDetect createAutoDetect(Context appContext) {
        return new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(){

            @Override
            public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType newConnectionType) {
                NetworkMonitor.this.updateCurrentConnectionType(newConnectionType);
            }

            @Override
            public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInfo) {
                NetworkMonitor.this.notifyObserversOfNetworkConnect(networkInfo);
            }

            @Override
            public void onNetworkDisconnect(long networkHandle) {
                NetworkMonitor.this.notifyObserversOfNetworkDisconnect(networkHandle);
            }

            @Override
            public void onNetworkCapabilitiesChanged(NetworkCapabilities networkCapabilities) {
                NetworkMonitor.this.notifyObserversOfNetworkCapabilitiesChanged(networkCapabilities);
            }
        }, appContext);
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType newConnectionType) {
        this.currentConnectionType = newConnectionType;
        this.notifyObserversOfConnectionTypeChange(newConnectionType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType newConnectionType, boolean fromNative) {
        List<Long> nativeObservers = this.getNativeNetworkObserversSync();
        for (Long nativeObserver : nativeObservers) {
            this.nativeNotifyConnectionTypeChanged(nativeObserver);
        }
        if (!fromNative) {
            ArrayList<NetworkObserver> javaObservers;
            this.updateObserverActiveNetworkList(0L, true);
            ArrayList<NetworkObserver> arrayList = this.networkObservers;
            synchronized (arrayList) {
                javaObservers = new ArrayList<NetworkObserver>(this.networkObservers);
            }
            for (NetworkObserver observer : javaObservers) {
                observer.onConnectionTypeChanged(newConnectionType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserversOfNetworkCapabilitiesChanged(NetworkCapabilities networkCapabilities) {
        ArrayList<NetworkObserver> javaObservers;
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            javaObservers = new ArrayList<NetworkObserver>(this.networkObservers);
        }
        for (NetworkObserver observer : javaObservers) {
            observer.onNetworkCapabilitiesChanged(networkCapabilities);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInfo) {
        List<Long> nativeObservers = this.getNativeNetworkObserversSync();
        this.updateObserverActiveNetworkList(0L, true);
        for (Long nativeObserver : nativeObservers) {
            this.nativeNotifyOfNetworkConnect(nativeObserver, networkInfo);
        }
    }

    private void notifyObserversOfNetworkDisconnect(long networkHandle) {
        List<Long> nativeObservers = this.getNativeNetworkObserversSync();
        for (Long nativeObserver : nativeObservers) {
            this.nativeNotifyOfNetworkDisconnect(nativeObserver, networkHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObserverActiveNetworkList(long nativeObserver, boolean notifyNetworkInfo) {
        List<NetworkMonitorAutoDetect.NetworkInformation> networkInfoList;
        Object object = this.autoDetectLock;
        synchronized (object) {
            networkInfoList = this.autoDetect == null ? null : this.autoDetect.getActiveNetworkList();
        }
        if (networkInfoList == null || networkInfoList.size() == 0) {
            return;
        }
        NetworkMonitorAutoDetect.NetworkInformation[] networkInfos = new NetworkMonitorAutoDetect.NetworkInformation[networkInfoList.size()];
        networkInfos = networkInfoList.toArray(networkInfos);
        if (notifyNetworkInfo) {
            ArrayList<NetworkObserver> javaObservers;
            ArrayList<NetworkObserver> arrayList = this.networkObservers;
            synchronized (arrayList) {
                javaObservers = new ArrayList<NetworkObserver>(this.networkObservers);
            }
            for (NetworkObserver observer : javaObservers) {
                observer.onNetworkCollect(networkInfos, Build.VERSION.SDK_INT);
            }
        } else {
            this.nativeNotifyOfActiveNetworkList(nativeObserver, networkInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getNativeNetworkObserversSync() {
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            return new ArrayList<Long>(this.nativeNetworkObservers);
        }
    }

    @Deprecated
    public static void addNetworkObserver(NetworkObserver observer) {
        NetworkMonitor.getInstance().addObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(NetworkObserver observer) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.add(observer);
        }
    }

    @Deprecated
    public static void removeNetworkObserver(NetworkObserver observer) {
        NetworkMonitor.getInstance().removeObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(NetworkObserver observer) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.remove(observer);
        }
    }

    public static boolean isOnline() {
        NetworkMonitorAutoDetect.ConnectionType connectionType = NetworkMonitor.getInstance().getCurrentConnectionType();
        return connectionType != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
    }

    private native void nativeNotifyConnectionTypeChanged(long var1);

    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    NetworkMonitorAutoDetect getNetworkMonitorAutoDetect() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumObservers() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.numObservers;
        }
    }

    static NetworkMonitorAutoDetect createAndSetAutoDetectForTest(Context context) {
        NetworkMonitorAutoDetect autoDetect;
        NetworkMonitor networkMonitor = NetworkMonitor.getInstance();
        networkMonitor.autoDetect = autoDetect = networkMonitor.createAutoDetect(context);
        return networkMonitor.autoDetect;
    }

    private static class InstanceHolder {
        static final NetworkMonitor instance = new NetworkMonitor();

        private InstanceHolder() {
        }
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);

        public void onNetworkCapabilitiesChanged(NetworkCapabilities var1);

        public void onNetworkCollect(NetworkMonitorAutoDetect.NetworkInformation[] var1, int var2);
    }
}

