/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import java.util.ArrayList;

public class RendererGatherer {
    private static final String TAG = "RendererGatherer";
    ArrayList<EglRenderInfo> eglRenderInfos = new ArrayList();

    public void addEglRenderInfo(EglRenderInfo eglRenderInfo) {
        boolean isAdd = true;
        for (EglRenderInfo info : this.eglRenderInfos) {
            if (info != eglRenderInfo) continue;
            Logging.d(TAG, "setEglRenderInfo : info is exist! " + info + ", " + eglRenderInfo);
            isAdd = false;
            break;
        }
        if (isAdd) {
            this.eglRenderInfos.add(eglRenderInfo);
            Logging.d(TAG, "setEglRenderInfo : " + eglRenderInfo + ", size : " + this.eglRenderInfos.size());
        }
    }

    public void removeEglRenderInfo(EglRenderInfo eglRenderInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public float getRenderTime(long uid) {
        ArrayList<EglRenderInfo> arrayList = this.eglRenderInfos;
        synchronized (arrayList) {
            try {
                for (EglRenderInfo info : this.eglRenderInfos) {
                    if (info.getUid() != uid) continue;
                    return info.getAvgRenderTimeNs();
                }
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "getRenderTime throws IllegalArgumentException = " + e.getMessage());
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public static class EglRenderInfo {
        ArrayList<Long> renderTimeNs = new ArrayList();
        ArrayList<Long> swapBufferTimeNs = new ArrayList();
        long uid;

        public long getUid() {
            return this.uid;
        }

        public void setUid(long uid) {
            Logging.d(RendererGatherer.TAG, "setUid : " + uid);
            this.uid = uid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderTimeNs(long time) {
            ArrayList<Long> arrayList = this.renderTimeNs;
            synchronized (arrayList) {
                try {
                    if (this.renderTimeNs.size() > 30) {
                        this.renderTimeNs.remove(0);
                    }
                    this.renderTimeNs.add(time);
                }
                catch (IllegalArgumentException e) {
                    Logging.e(RendererGatherer.TAG, "setRenderTimeNs throws IllegalArgumentException = " + e.getMessage());
                }
            }
        }

        public void setSwapBufferTimeNs(long time) {
            if (this.swapBufferTimeNs.size() > 30) {
                this.swapBufferTimeNs.remove(0);
            }
            this.swapBufferTimeNs.add(time);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getAvgRenderTimeNs() {
            if (this.renderTimeNs == null || this.renderTimeNs.isEmpty()) {
                return 0.0f;
            }
            ArrayList<Long> arrayList = this.renderTimeNs;
            synchronized (arrayList) {
                try {
                    long sum = 0L;
                    for (Long time : this.renderTimeNs) {
                        sum += time.longValue();
                    }
                    return sum / (long)this.renderTimeNs.size();
                }
                catch (IllegalArgumentException e) {
                    Logging.e(RendererGatherer.TAG, "getAvgRenderTimeNs throws IllegalArgumentException = " + e.getMessage());
                    return 0.0f;
                }
            }
        }

        public void reset() {
            this.renderTimeNs.clear();
            this.swapBufferTimeNs.clear();
        }
    }
}

