/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.os.Environment;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.RefCounted;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class TextToTexture
implements RefCounted {
    private static final String TAG = "TextToTexture";
    private static final String MAP_KEY_WIDTH = "width";
    private static final String MAP_KEY_HEIGHT = "height";
    private String content = "";
    private int pageWidth = 0;
    private int pageHeight = 0;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private String fontName = "";
    private int fontSize = 0;
    private long fontColor;
    private long bgColor = 0L;
    private int videoWidth = 0;
    private int videoHeight = 0;
    private int imgTextureId = 0;
    private int rgbaByteCnt = 0;
    @Nullable
    private ByteBuffer rgbaBuffer = null;
    @Nullable
    private Bitmap bitmap = null;
    @Nullable
    private Canvas canvas = null;

    @CalledByNative
    public TextToTexture() {
    }

    @CalledByNative
    public int drawString(int page_width, int page_height, String font_name, int font_size, long font_color, long bg_color, String content_str, int video_width, int video_height) {
        Boolean needDraw = this.checkCondition(page_width, page_height, font_name, font_size, font_color, bg_color, content_str, video_width, video_height);
        if (!needDraw.booleanValue()) {
            return this.imgTextureId;
        }
        this.pageWidth = page_width;
        this.pageHeight = page_height;
        this.fontSize = font_size;
        this.fontColor = font_color;
        this.bgColor = bg_color;
        this.content = content_str;
        this.videoWidth = video_width;
        this.videoHeight = video_height;
        this.fontName = font_name;
        return this.internalDraw(this.pageWidth, this.pageHeight, this.fontName, this.fontSize, this.fontColor, this.bgColor, this.content, this.videoWidth, this.videoHeight);
    }

    @CalledByNative
    public byte[] convertStringToRgbaData(int page_width, int page_height, String font_name, int font_size, long font_color, long bg_color, String content_str, int video_width, int video_height) {
        Boolean needDraw = this.checkCondition(page_width, page_height, font_name, font_size, font_color, bg_color, content_str, video_width, video_height);
        if (!needDraw.booleanValue()) {
            return this.rgbaBuffer.array();
        }
        this.pageWidth = page_width;
        this.pageHeight = page_height;
        this.fontSize = font_size;
        this.fontColor = font_color;
        this.bgColor = bg_color;
        this.content = content_str;
        this.videoWidth = video_width;
        this.videoHeight = video_height;
        this.fontName = font_name;
        this.internalConvertStringToRgbaData(this.pageWidth, this.pageHeight, this.fontName, this.fontSize, this.fontColor, this.bgColor, this.content, this.videoWidth, this.videoHeight);
        return this.rgbaBuffer.array();
    }

    @CalledByNative
    public int getImgWidth() {
        return this.imgWidth;
    }

    @CalledByNative
    public int getImgHeight() {
        return this.imgHeight;
    }

    @Override
    public void retain() {
    }

    @Override
    public void release() {
        if (this.canvas != null) {
            this.canvas.setBitmap(null);
            this.canvas = null;
        }
        if (this.bitmap != null) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
    }

    private Boolean checkCondition(int page_width, int page_height, String font_name, int font_size, long font_color, long bg_color, String content_str, int video_width, int video_height) {
        if (page_width != this.pageWidth || page_height != this.pageHeight || !font_name.equals(this.fontName) || font_size != this.fontSize || font_color != this.fontColor || bg_color != this.bgColor || !content_str.equals(this.content) || video_width != this.videoWidth || video_height != this.videoHeight) {
            return true;
        }
        return false;
    }

    private int internalDraw(int page_width, int page_height, String font_name, int font_size, long font_color, long bg_color, String content_str, int video_width, int video_height) {
        String str = content_str;
        int width = page_width;
        int height = page_height;
        if (page_width == 0) {
            width = video_width;
        }
        if (page_height == 0) {
            height = video_height;
        }
        Map<String, Integer> size = this.genBitmap(width, height, font_name, font_size, font_color, bg_color, content_str, video_width, video_height);
        int real_text_width = size.get(MAP_KEY_WIDTH);
        int real_text_height = size.get(MAP_KEY_HEIGHT);
        if (page_width == 0 && (width = real_text_width) > video_width) {
            width = video_width;
        }
        if (page_height == 0 && (height = real_text_height) > video_height) {
            height = video_height;
        }
        if (page_width == 0 || page_height == 0) {
            this.genBitmap(width, height, font_name, font_size, font_color, bg_color, content_str, video_width, video_height);
        }
        if (this.imgTextureId == 0) {
            int[] textureIds = new int[1];
            GLES20.glGenTextures((int)1, (int[])textureIds, (int)0);
            this.imgTextureId = textureIds[0];
        }
        GLES20.glBindTexture((int)3553, (int)this.imgTextureId);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.bitmap, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glFlush();
        this.imgWidth = width;
        this.imgHeight = height;
        return this.imgTextureId;
    }

    private byte[] internalConvertStringToRgbaData(int page_width, int page_height, String font_name, int font_size, long font_color, long bg_color, String content_str, int video_width, int video_height) {
        int byte_cnt;
        String str = content_str;
        int width = page_width;
        int height = page_height;
        if (page_width == 0) {
            width = video_width;
        }
        if (page_height == 0) {
            height = video_height;
        }
        Map<String, Integer> size = this.genBitmap(width, height, font_name, font_size, font_color, bg_color, content_str, video_width, video_height);
        int real_text_width = size.get(MAP_KEY_WIDTH);
        int real_text_height = size.get(MAP_KEY_HEIGHT);
        if (page_width == 0 && (width = real_text_width) > video_width) {
            width = video_width;
        }
        if (page_height == 0 && (height = real_text_height) > video_height) {
            height = video_height;
        }
        if (page_width == 0 || page_height == 0) {
            this.genBitmap(width, height, font_name, font_size, font_color, bg_color, content_str, video_width, video_height);
        }
        if (this.rgbaByteCnt != (byte_cnt = this.bitmap.getByteCount())) {
            this.rgbaBuffer = null;
            this.rgbaBuffer = ByteBuffer.allocate(byte_cnt);
            this.rgbaByteCnt = byte_cnt;
        }
        this.rgbaBuffer.clear();
        this.bitmap.copyPixelsToBuffer((Buffer)this.rgbaBuffer);
        byte[] rgba_data = this.rgbaBuffer.array();
        this.imgWidth = width;
        this.imgHeight = height;
        return rgba_data;
    }

    private Map<String, Integer> genBitmap(int width, int height, String font_name, int font_size, long font_color, long bg_color, String content_str, int video_width, int video_height) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int text_width = 0;
        int text_height = 0;
        String str = content_str;
        if (this.canvas != null) {
            this.canvas.setBitmap(null);
            this.canvas = null;
        }
        if (this.bitmap != null) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas(this.bitmap);
        this.canvas.drawColor((int)bg_color);
        TextPaint textPaint = new TextPaint();
        Typeface tpeyface = null;
        if (font_name != null && (font_name.contains(".") || font_name.contains("/")) && this.fileIsValid(font_name)) {
            tpeyface = Typeface.createFromFile((String)font_name);
        }
        if (tpeyface == null) {
            tpeyface = Typeface.create((String)font_name, (int)0);
        }
        textPaint.setTypeface(tpeyface);
        textPaint.setColor((int)font_color);
        textPaint.setTextSize((float)font_size);
        textPaint.setAntiAlias(true);
        textPaint.setTextAlign(Paint.Align.LEFT);
        StaticLayout textLayout = new StaticLayout((CharSequence)str, textPaint, width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        text_width = (int)Math.ceil(textPaint.measureText(str));
        text_height = textLayout.getHeight();
        this.canvas.save();
        this.canvas.translate(0.0f, 0.0f);
        textLayout.draw(this.canvas);
        this.canvas.restore();
        map.put(MAP_KEY_WIDTH, text_width);
        map.put(MAP_KEY_HEIGHT, text_height);
        return map;
    }

    private void saveBitmap(Bitmap bitmap) {
        try {
            FileOutputStream file_output_stream;
            String path = Environment.getExternalStorageDirectory().getPath() + "/backups/images/watermark_bitmap.png";
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)(file_output_stream = new FileOutputStream(file)))) {
                file_output_stream.flush();
                file_output_stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRgb2Bitmap(Buffer buf, String filename, int width, int height) {
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(filename));
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bmp.copyPixelsToBuffer(buf);
            if (bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos)) {
                ((BufferedOutputStream)bos).flush();
                bos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bos == null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void saveTextureToImage(int textureID, int width, int height, String fileName) {
        int[] frameBuffer = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffer, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)frameBuffer[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)textureID, (int)0);
        if (GLES20.glCheckFramebufferStatus((int)36160) != 36053) {
            return;
        }
        ByteBuffer rgbaBuf = ByteBuffer.allocateDirect(width * height * 4);
        rgbaBuf.position(0);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)rgbaBuf);
        this.saveRgb2Bitmap(rgbaBuf, fileName, width, height);
        GLES20.glDeleteFramebuffers((int)1, (IntBuffer)IntBuffer.wrap(frameBuffer));
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    private boolean fileIsValid(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                return false;
            }
            if (f.length() == 0L) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

