/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.graphics.Matrix;
import android.os.Handler;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.RefCountDelegate;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.YuvConverter;
import com.netease.lava.webrtc.YuvHelper;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int unscaledWidth;
    private final int unscaledHeight;
    private int width;
    private int height;
    private int oriWidth;
    private int oriHeight;
    private VideoFrame.TextureBuffer.Type type;
    private int id;
    private final Matrix transformMatrix;
    private Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final RefCountDelegate refCountDelegate;
    private final long fenceSyncObject;

    @CalledByNative
    public TextureBufferImpl(int width, int height, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this.unscaledWidth = width;
        this.unscaledHeight = height;
        this.width = width;
        this.height = height;
        this.oriWidth = width;
        this.oriHeight = height;
        this.type = VideoFrame.TextureBuffer.Type.RGB;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
        this.fenceSyncObject = 0L;
    }

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this.unscaledWidth = width;
        this.unscaledHeight = height;
        this.width = width;
        this.height = height;
        this.oriWidth = width;
        this.oriHeight = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
        this.fenceSyncObject = 0L;
    }

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback, long fenceSyncObject) {
        this.unscaledWidth = width;
        this.unscaledHeight = height;
        this.width = width;
        this.height = height;
        this.oriWidth = width;
        this.oriHeight = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
        this.fenceSyncObject = fenceSyncObject;
    }

    private TextureBufferImpl(int unscaledWidth, int unscaledHeight, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this.unscaledWidth = unscaledWidth;
        this.unscaledHeight = unscaledHeight;
        this.width = width;
        this.height = height;
        this.oriWidth = width;
        this.oriHeight = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
        this.fenceSyncObject = 0L;
    }

    @Override
    public long getFenceSyncObject() {
        return this.fenceSyncObject;
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getBufferType() {
        return 0;
    }

    @Override
    public VideoFrame.Buffer.BufferType getInternalBufferType() {
        return VideoFrame.Buffer.BufferType.kBufferTypeTexture;
    }

    public void setType(VideoFrame.TextureBuffer.Type textureType) {
        this.type = textureType;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    public void setTextureId(int textureId) {
        this.id = textureId;
    }

    @Override
    public void setTextureId(int textureType, int textureId) {
        this.type = textureType == 0 ? VideoFrame.TextureBuffer.Type.OES : VideoFrame.TextureBuffer.Type.RGB;
        this.id = textureId;
    }

    @Override
    public boolean isOESTexture() {
        return this.type == VideoFrame.TextureBuffer.Type.OES;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public Handler getHandler() {
        return this.toI420Handler;
    }

    @Override
    public void setHandler(Handler handler) {
        this.toI420Handler = handler;
    }

    @Override
    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getOriWidth() {
        return this.oriWidth;
    }

    @Override
    public int getOriHeight() {
        return this.oriHeight;
    }

    @Override
    @Nullable
    public VideoFrame.I420Buffer toI420() {
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> this.yuvConverter.wrapConvert(this));
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
            return this.generateBlackI420();
        }
    }

    private VideoFrame.I420Buffer generateBlackI420() {
        int chromaHeight = (this.height + 1) / 2;
        int strideUV = (this.width + 1) / 2;
        int yPos = 0;
        int uPos = yPos + this.width * this.height;
        int vPos = uPos + strideUV * chromaHeight;
        ByteBuffer buffer = YuvHelper.nativeAllocateBlackI420ByteBuffer(this.width, this.height);
        buffer.position(yPos);
        buffer.limit(uPos);
        ByteBuffer dataY = buffer.slice();
        buffer.position(uPos);
        buffer.limit(vPos);
        ByteBuffer dataU = buffer.slice();
        buffer.position(vPos);
        buffer.limit(vPos + strideUV * chromaHeight);
        ByteBuffer dataV = buffer.slice();
        return JavaI420Buffer.wrap(this.width, this.height, dataY, this.width, dataU, strideUV, dataV, strideUV, () -> YuvHelper.nativeFreeBlackI420ByteBuffer(buffer));
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public int getRefCount() {
        return this.refCountDelegate.getRefCount();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        return this.applyTransformMatrix(cropAndScaleMatrix, Math.round((float)(this.unscaledWidth * cropWidth) / (float)this.width), Math.round((float)(this.unscaledHeight * cropHeight) / (float)this.height), scaleWidth, scaleHeight);
    }

    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    public TextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int newWidth, int newHeight) {
        return this.applyTransformMatrix(transformMatrix, newWidth, newHeight, newWidth, newHeight);
    }

    private TextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int unscaledWidth, int unscaledHeight, int scaledWidth, int scaledHeight) {
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preConcat(transformMatrix);
        this.retain();
        return new TextureBufferImpl(unscaledWidth, unscaledHeight, scaledWidth, scaledHeight, this.type, this.id, newMatrix, this.toI420Handler, this.yuvConverter, this::release);
    }
}

