/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.EncodedImage;
import com.netease.lava.webrtc.VideoCodecStatus;
import com.netease.lava.webrtc.VideoFrame;
import javax.annotation.Nullable;

public interface VideoEncoder {
    @CalledByNative
    default public long createNativeVideoEncoder() {
        return 0L;
    }

    @CalledByNative
    default public boolean isHardwareEncoder() {
        return true;
    }

    @CalledByNative
    default public boolean isDimensityCpu() {
        return false;
    }

    @CalledByNative
    default public boolean isSupportHardwareTextureEncoder() {
        return false;
    }

    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2);

    @CalledByNative
    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    @CalledByNative
    public ScalingSettings getScalingSettings();

    @CalledByNative
    public void reportQP(int var1);

    @CalledByNative
    public String getImplementationName();

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);

        public void onUpdateEncoderFormat(boolean var1);
    }

    public static class ScalingSettings {
        public final boolean on;
        @Nullable
        public final Integer low;
        @Nullable
        public final Integer high;
        public static final ScalingSettings OFF = new ScalingSettings();

        public ScalingSettings(int low, int high) {
            this.on = true;
            this.low = low;
            this.high = high;
        }

        private ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean on) {
            this.on = on;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean on, int low, int high) {
            this.on = on;
            this.low = low;
            this.high = high;
        }

        public String toString() {
            return this.on ? "[ " + this.low + ", " + this.high + " ]" : "OFF";
        }
    }

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        @CalledByNative(value="BitrateAllocation")
        public BitrateAllocation(int[][] bitratesBbs) {
            this.bitratesBbs = bitratesBbs;
        }

        public int getSum() {
            int sum = 0;
            int[][] nArray = this.bitratesBbs;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] spatialLayer;
                for (int bitrate : spatialLayer = nArray[i]) {
                    sum += bitrate;
                }
            }
            return sum;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfo {
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        @CalledByNative(value="EncodeInfo")
        public EncodeInfo(EncodedImage.FrameType[] frameTypes) {
            this.frameTypes = frameTypes;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final int startBitrate;
        public final int maxFramerate;
        public final int gop;
        public final int numberOfSimulcastStreams;
        public final boolean automaticResizeOn;
        public final boolean syncMode;
        public final int bitrateAdjusterType;
        public final float minAdjustedBitratePct;
        public final float maxAdjustedBitratePct;
        public final boolean isScreenShare;
        public final boolean enableAlignment;

        @CalledByNative(value="Settings")
        public Settings(int numberOfCores, int width, int height, int startBitrate, int maxFramerate, int gop, int numberOfSimulcastStreams, boolean automaticResizeOn, boolean syncMode, int bitrateAdjusterType, float minAdjustedBitratePct, float maxAdjustedBitratePct, boolean isScreenShare, boolean enableAlignment) {
            this.numberOfCores = numberOfCores;
            this.width = width;
            this.height = height;
            this.startBitrate = startBitrate;
            this.maxFramerate = maxFramerate;
            this.gop = gop;
            this.numberOfSimulcastStreams = numberOfSimulcastStreams;
            this.automaticResizeOn = automaticResizeOn;
            this.syncMode = syncMode;
            this.bitrateAdjusterType = bitrateAdjusterType;
            this.minAdjustedBitratePct = minAdjustedBitratePct;
            this.maxAdjustedBitratePct = maxAdjustedBitratePct;
            this.isScreenShare = isScreenShare;
            this.enableAlignment = enableAlignment;
        }
    }
}

