/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.EncodedImage;
import com.netease.lava.webrtc.VideoEncoder;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

class VideoEncoderWrapper {
    VideoEncoderWrapper() {
    }

    @CalledByNative
    static boolean getScalingSettingsOn(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.on;
    }

    @Nullable
    @CalledByNative
    static Integer getScalingSettingsLow(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.low;
    }

    @Nullable
    @CalledByNative
    static Integer getScalingSettingsHigh(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.high;
    }

    @Nullable
    @CalledByNative
    static VideoEncoder.Callback createEncoderCallback(final long nativeEncoder) {
        return new VideoEncoder.Callback(){

            @Override
            public void onEncodedFrame(EncodedImage frame, VideoEncoder.CodecSpecificInfo info) {
                VideoEncoderWrapper.nativeOnEncodedFrame(nativeEncoder, frame.buffer, frame.encodedWidth, frame.encodedHeight, frame.actualWidth, frame.actualHeight, frame.captureTimeNs, frame.frameType.getNative(), frame.rotation, frame.completeFrame, frame.qp, frame.targetEncBps);
            }

            @Override
            public void onUpdateEncoderFormat(boolean isSurfaceMode) {
                VideoEncoderWrapper.nativeOnUpdateEncoderFormat(nativeEncoder, isSurfaceMode);
            }
        };
    }

    private static native void nativeOnUpdateEncoderFormat(long var0, boolean var2);

    private static native void nativeOnEncodedFrame(long var0, ByteBuffer var2, int var3, int var4, int var5, int var6, long var7, int var9, int var10, boolean var11, Integer var12, long var13);
}

