/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.graphics.Matrix;
import android.os.Handler;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.RefCounted;
import com.netease.lava.webrtc.YuvConverter;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class VideoFrame
implements RefCounted {
    private final Buffer buffer;
    private int rotation;
    private final long timestampNs;
    private final long timestampRtp;
    private final long transformTextureStartTimeMs;
    private final long receiveFinishMs;
    private final long broadcastRenderMs;
    private boolean isDualFrame;
    private boolean isMirror;
    private long externalBeautyProcessTimeMs;

    @CalledByNative
    public VideoFrame(Buffer buffer, int rotation, long timestampNs, long timestampRtp, long transformTextureStartTimeMs, long receiveFinishMs, long broadcastRenderMs) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.timestampRtp = timestampRtp;
        this.transformTextureStartTimeMs = transformTextureStartTimeMs;
        this.receiveFinishMs = receiveFinishMs;
        this.broadcastRenderMs = broadcastRenderMs;
    }

    public VideoFrame(Buffer buffer, int rotation, long timestampNs) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.timestampRtp = 0L;
        this.transformTextureStartTimeMs = 0L;
        this.receiveFinishMs = 0L;
        this.broadcastRenderMs = 0L;
    }

    @CalledByNative
    public boolean isDualFrame() {
        return this.isDualFrame;
    }

    @CalledByNative
    public void setDualFrame(boolean dualFrame) {
        this.isDualFrame = dualFrame;
    }

    public boolean isMirror() {
        return this.isMirror;
    }

    public void setIsMirror(boolean isMirror) {
        this.isMirror = isMirror;
    }

    @CalledByNative
    public Buffer getBuffer() {
        return this.buffer;
    }

    @CalledByNative
    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    @CalledByNative
    public long getTimestampNs() {
        return this.timestampNs;
    }

    public long getTimestampRtp() {
        return this.timestampRtp;
    }

    public long getTransformTextureStartTimeMs() {
        return this.transformTextureStartTimeMs;
    }

    public long getReceiveFinishMs() {
        return this.receiveFinishMs;
    }

    public long getBroadcastRenderMs() {
        return this.broadcastRenderMs;
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getWidth();
        }
        return this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getHeight();
        }
        return this.buffer.getWidth();
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    @CalledByNative
    public void release() {
        this.buffer.release();
    }

    public int getRefCount() {
        return this.buffer.getRefCount();
    }

    public void setExternalBeautyProcessTimeMs(long externalBeautyProcessTimeMs) {
        this.externalBeautyProcessTimeMs = externalBeautyProcessTimeMs;
    }

    public long getExternalBeautyProcessTimeMs() {
        return this.externalBeautyProcessTimeMs;
    }

    public static interface WrapTextureBuffer
    extends Buffer {
        public TextureType getType();

        public boolean isYUVTexture();

        @CalledByNative(value="WrapTextureBuffer")
        public int getTextureType();

        @CalledByNative(value="WrapTextureBuffer")
        public int getTextureId();

        @CalledByNative(value="WrapTextureBuffer")
        public void setTextureId(int var1, int var2);

        @CalledByNative(value="WrapTextureBuffer")
        public int[] getTextureIds();

        @CalledByNative(value="WrapTextureBuffer")
        public void setTextureIds(int[] var1);

        @CalledByNative(value="WrapTextureBuffer")
        public Matrix getTransformMatrix();

        @CalledByNative(value="WrapTextureBuffer")
        public void setFlipVertical();

        @CalledByNative(value="WrapTextureBuffer")
        public long getFenceSyncObject();

        @CalledByNative(value="WrapTextureBuffer")
        public Handler getHandler();

        public static enum TextureType {
            kTextureTypeOES,
            kTextureTypeRGB,
            kTextureTypeYUV;

        }
    }

    public static interface TextureBuffer
    extends Buffer {
        public Type getType();

        @CalledByNative(value="TextureBuffer")
        public int getTextureId();

        @CalledByNative(value="TextureBuffer")
        public boolean isOESTexture();

        @CalledByNative(value="TextureBuffer")
        public Matrix getTransformMatrix();

        @CalledByNative(value="TextureBuffer")
        public long getFenceSyncObject();

        @CalledByNative(value="TextureBuffer")
        public Handler getHandler();

        @CalledByNative(value="TextureBuffer")
        public YuvConverter getYuvConverter();

        @CalledByNative(value="TextureBuffer")
        public void setTextureId(int var1, int var2);

        @CalledByNative(value="TextureBuffer")
        public void setHandler(Handler var1);

        public static enum Type {
            OES(36197),
            RGB(3553);

            private final int glTarget;

            private Type(int glTarget) {
                this.glTarget = glTarget;
            }

            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }

    public static interface NV12Buffer
    extends Buffer {
        public ByteBuffer getDataY();

        public ByteBuffer getDataUV();

        public int getStride();
    }

    public static interface I420Buffer
    extends Buffer {
        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I420Buffer")
        public int getStrideY();

        @CalledByNative(value="I420Buffer")
        public int getStrideU();

        @CalledByNative(value="I420Buffer")
        public int getStrideV();
    }

    public static interface Buffer
    extends RefCounted {
        @CalledByNative(value="Buffer")
        public int getWidth();

        @CalledByNative(value="Buffer")
        public int getHeight();

        @Nullable
        @CalledByNative(value="Buffer")
        public I420Buffer toI420();

        @Override
        @CalledByNative(value="Buffer")
        public void retain();

        @Override
        @CalledByNative(value="Buffer")
        public void release();

        @CalledByNative(value="Buffer")
        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);

        @CalledByNative(value="Buffer")
        public void setWidth(int var1);

        @CalledByNative(value="Buffer")
        public void setHeight(int var1);

        @CalledByNative(value="Buffer")
        public int getOriWidth();

        @CalledByNative(value="Buffer")
        public int getOriHeight();

        @CalledByNative(value="Buffer")
        public int getBufferType();

        public BufferType getInternalBufferType();

        @CalledByNative(value="Buffer")
        public int getRefCount();

        public static enum BufferType {
            kBufferTypeTexture,
            kBufferTypeI420,
            kBufferTypeNV12,
            kBufferTypeNV21,
            kBufferTypeWrapTexture;

        }
    }
}

