/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import com.netease.lava.webrtc.GlUtil;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.RendererCommon;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.WrapTextureBufferImpl;
import com.netease.lava.webrtc.YuvHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class VideoFrameDrawer {
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private int dstWidth;
    private int dstHeight;
    private final YuvUploader yuvUploader = new YuvUploader();
    private final NV12Uploader nv12Uploader = new NV12Uploader();
    @Nullable
    private VideoFrame lastI420Frame;
    @Nullable
    private VideoFrame lastNV12Frame;
    private final Matrix renderMatrix = new Matrix();

    public static void drawTexture(RendererCommon.GlDrawer drawer, VideoFrame.TextureBuffer buffer, Matrix renderMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        Matrix finalMatrix = new Matrix(buffer.getTransformMatrix());
        finalMatrix.preConcat(renderMatrix);
        float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(finalMatrix);
        switch (buffer.getType()) {
            case OES: {
                drawer.drawOes(buffer.getTextureId(), finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                break;
            }
            case RGB: {
                drawer.drawRgb(buffer.getTextureId(), finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
    }

    public static void drawTexture(RendererCommon.GlDrawer drawer, VideoFrame.TextureBuffer buffer, Matrix renderMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int dstWidth, int dstHeight) {
        Matrix finalMatrix = new Matrix(buffer.getTransformMatrix());
        finalMatrix.preConcat(renderMatrix);
        float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(finalMatrix);
        switch (buffer.getType()) {
            case OES: {
                drawer.drawOes(buffer.getTextureId(), finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, dstWidth, dstHeight);
                break;
            }
            case RGB: {
                drawer.drawRgb(buffer.getTextureId(), finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, dstWidth, dstHeight);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
    }

    public static void drawWrapTexture(RendererCommon.GlDrawer drawer, VideoFrame.WrapTextureBuffer buffer, Matrix renderMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        Matrix finalMatrix = new Matrix(buffer.getTransformMatrix());
        finalMatrix.preConcat(renderMatrix);
        float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(finalMatrix);
        switch (buffer.getType()) {
            case kTextureTypeOES: {
                drawer.drawOes(buffer.getTextureId(), finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                break;
            }
            case kTextureTypeRGB: {
                drawer.drawRgb(buffer.getTextureId(), finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                break;
            }
            case kTextureTypeYUV: {
                drawer.drawYuv(buffer.getTextureIds(), finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
    }

    private static int distance(float x0, float y0, float x1, float y1) {
        return (int)Math.round(Math.hypot(x1 - x0, y1 - y0));
    }

    private void calculateTransformedRenderSize(int frameWidth, int frameHeight, @Nullable Matrix renderMatrix) {
        if (renderMatrix == null) {
            this.renderWidth = frameWidth;
            this.renderHeight = frameHeight;
            return;
        }
        renderMatrix.mapPoints(this.dstPoints, srcPoints);
        for (int i = 0; i < 3; ++i) {
            int n = i * 2 + 0;
            this.dstPoints[n] = this.dstPoints[n] * (float)frameWidth;
            int n2 = i * 2 + 1;
            this.dstPoints[n2] = this.dstPoints[n2] * (float)frameHeight;
        }
        this.renderWidth = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[2], this.dstPoints[3]);
        this.renderHeight = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[4], this.dstPoints[5]);
    }

    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer) {
        this.drawFrame(frame, drawer, null);
    }

    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer, Matrix additionalRenderMatrix) {
        this.drawFrame(frame, drawer, additionalRenderMatrix, 0, 0, frame.getRotatedWidth(), frame.getRotatedHeight());
    }

    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer, @Nullable Matrix additionalRenderMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int dstWidth, int dstHeight) {
        this.dstWidth = dstWidth;
        this.dstHeight = dstHeight;
        this.drawFrame(frame, drawer, additionalRenderMatrix, viewportX, viewportY, viewportWidth, viewportHeight);
    }

    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer, @Nullable Matrix additionalRenderMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        int width = frame.getRotatedWidth();
        int height = frame.getRotatedHeight();
        this.calculateTransformedRenderSize(width, height, additionalRenderMatrix);
        boolean isTextureFrame = false;
        boolean isYUVTexture = false;
        VideoFrame.Buffer.BufferType type = frame.getBuffer().getInternalBufferType();
        if (type == VideoFrame.Buffer.BufferType.kBufferTypeTexture) {
            isTextureFrame = true;
        } else if (type == VideoFrame.Buffer.BufferType.kBufferTypeWrapTexture && !(isYUVTexture = ((WrapTextureBufferImpl)frame.getBuffer()).isYUVTexture())) {
            isTextureFrame = true;
        }
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (!isTextureFrame || isYUVTexture) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate((float)frame.getRotation());
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (additionalRenderMatrix != null) {
            this.renderMatrix.preConcat(additionalRenderMatrix);
        }
        if (isYUVTexture) {
            int[] yuvTextures = ((WrapTextureBufferImpl)frame.getBuffer()).getTextureIds();
            this.lastI420Frame = null;
            this.lastNV12Frame = null;
            drawer.drawYuv(yuvTextures, RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight);
        } else if (isTextureFrame) {
            this.lastI420Frame = null;
            this.lastNV12Frame = null;
            if (type == VideoFrame.Buffer.BufferType.kBufferTypeTexture) {
                if (this.dstWidth > 0 && this.dstHeight > 0) {
                    VideoFrameDrawer.drawTexture(drawer, (VideoFrame.TextureBuffer)frame.getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight, this.dstWidth, this.dstHeight);
                } else {
                    VideoFrameDrawer.drawTexture(drawer, (VideoFrame.TextureBuffer)frame.getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                }
            } else {
                VideoFrameDrawer.drawWrapTexture(drawer, (VideoFrame.WrapTextureBuffer)frame.getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight);
            }
        } else if (type == VideoFrame.Buffer.BufferType.kBufferTypeNV12) {
            this.lastI420Frame = null;
            if (frame != this.lastNV12Frame) {
                this.lastNV12Frame = frame;
                VideoFrame.NV12Buffer nv12Buffer = (VideoFrame.NV12Buffer)frame.getBuffer();
                this.nv12Uploader.uploadFromBuffer(nv12Buffer);
                nv12Buffer.release();
            }
            drawer.drawNV12(this.nv12Uploader.getNV12Textures(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight);
        } else {
            this.lastNV12Frame = null;
            if (frame != this.lastI420Frame) {
                this.lastI420Frame = frame;
                VideoFrame.I420Buffer i420Buffer = frame.getBuffer().toI420();
                this.yuvUploader.uploadFromBuffer(i420Buffer);
                i420Buffer.release();
            }
            drawer.drawYuv(this.yuvUploader.getYuvTextures(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight);
        }
    }

    public void release() {
        this.yuvUploader.release();
        this.nv12Uploader.release();
        this.lastI420Frame = null;
        this.lastNV12Frame = null;
    }

    public static class NV12Uploader {
        @Nullable
        private ByteBuffer copyBuffer;
        @Nullable
        private int[] nv12Textures;

        @Nullable
        public int[] uploadNV12Data(int width, int height, int[] strides, ByteBuffer[] planes) {
            int i;
            int[] planeWidths = new int[]{width, width};
            int[] planeHeights = new int[]{height, height / 2};
            int copyCapacityNeeded = 0;
            for (i = 0; i < 2; ++i) {
                if (strides[i] <= planeWidths[i]) continue;
                copyCapacityNeeded = Math.max(copyCapacityNeeded, planeWidths[i] * planeHeights[i]);
            }
            if (copyCapacityNeeded > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < copyCapacityNeeded)) {
                this.copyBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
            }
            if (this.nv12Textures == null) {
                this.nv12Textures = new int[2];
                for (i = 0; i < 2; ++i) {
                    this.nv12Textures[i] = GlUtil.generateTexture(3553);
                }
            }
            for (i = 0; i < 2; ++i) {
                ByteBuffer packedByteBuffer;
                GLES20.glActiveTexture((int)(33984 + i));
                GLES20.glBindTexture((int)3553, (int)this.nv12Textures[i]);
                if (strides[i] == planeWidths[i]) {
                    packedByteBuffer = planes[i];
                } else {
                    YuvHelper.copyPlane(planes[i], strides[i], this.copyBuffer, planeWidths[i], planeWidths[i], planeHeights[i]);
                    packedByteBuffer = this.copyBuffer;
                }
                if (i == 0) {
                    GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)planeWidths[i], (int)planeHeights[i], (int)0, (int)6409, (int)5121, (Buffer)packedByteBuffer);
                    continue;
                }
                if (i != 1) continue;
                GLES20.glTexImage2D((int)3553, (int)0, (int)6410, (int)(planeWidths[i] / 2), (int)planeHeights[i], (int)0, (int)6410, (int)5121, (Buffer)packedByteBuffer);
            }
            return this.nv12Textures;
        }

        @Nullable
        public int[] uploadFromBuffer(VideoFrame.NV12Buffer buffer) {
            int[] strides = new int[]{buffer.getStride(), buffer.getStride()};
            ByteBuffer[] planes = new ByteBuffer[]{buffer.getDataY(), buffer.getDataUV()};
            return this.uploadNV12Data(buffer.getWidth(), buffer.getHeight(), strides, planes);
        }

        @Nullable
        public int[] getNV12Textures() {
            return this.nv12Textures;
        }

        public void release() {
            this.copyBuffer = null;
            if (this.nv12Textures != null) {
                GLES20.glDeleteTextures((int)2, (int[])this.nv12Textures, (int)0);
                this.nv12Textures = null;
            }
        }
    }

    public static class YuvUploader {
        @Nullable
        private ByteBuffer copyBuffer;
        @Nullable
        private int[] yuvTextures;

        @Nullable
        public int[] uploadYuvData(int width, int height, int[] strides, ByteBuffer[] planes) {
            int i;
            int[] planeWidths = new int[]{width, width / 2, width / 2};
            int[] planeHeights = new int[]{height, height / 2, height / 2};
            int copyCapacityNeeded = 0;
            for (i = 0; i < 3; ++i) {
                if (strides[i] <= planeWidths[i]) continue;
                copyCapacityNeeded = Math.max(copyCapacityNeeded, planeWidths[i] * planeHeights[i]);
            }
            if (copyCapacityNeeded > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < copyCapacityNeeded)) {
                this.copyBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (i = 0; i < 3; ++i) {
                    this.yuvTextures[i] = GlUtil.generateTexture(3553);
                }
            }
            for (i = 0; i < 3; ++i) {
                ByteBuffer packedByteBuffer;
                GLES20.glActiveTexture((int)(33984 + i));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[i]);
                if (strides[i] == planeWidths[i]) {
                    packedByteBuffer = planes[i];
                } else {
                    YuvHelper.copyPlane(planes[i], strides[i], this.copyBuffer, planeWidths[i], planeWidths[i], planeHeights[i]);
                    packedByteBuffer = this.copyBuffer;
                }
                if (packedByteBuffer != null && packedByteBuffer.capacity() > 0) {
                    GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)planeWidths[i], (int)planeHeights[i], (int)0, (int)6409, (int)5121, (Buffer)packedByteBuffer);
                    continue;
                }
                Logging.e("YuvUploader", "uploadYuvData: packedByteBuffer is null or capacity is 0");
            }
            return this.yuvTextures;
        }

        @Nullable
        public int[] uploadFromBuffer(VideoFrame.I420Buffer buffer) {
            int[] strides = new int[]{buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV()};
            ByteBuffer[] planes = new ByteBuffer[]{buffer.getDataY(), buffer.getDataU(), buffer.getDataV()};
            return this.uploadYuvData(buffer.getWidth(), buffer.getHeight(), strides, planes);
        }

        @Nullable
        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            this.copyBuffer = null;
            if (this.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])this.yuvTextures, (int)0);
                this.yuvTextures = null;
            }
        }
    }
}

