/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.os.Handler;
import android.os.Looper;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.ThreadUtils;
import javax.annotation.Nullable;

public class WrapCameraHandler {
    private static final String TAG = "WrapCameraHandler";
    private final Object handlerLock;
    private long activeCaller;
    private Handler cameraHandler;

    @Nullable
    @CalledByNative
    public static WrapCameraHandler create(long caller) {
        try {
            return new WrapCameraHandler(caller);
        }
        catch (Exception e) {
            Logging.e(TAG, "create error: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WrapCameraHandler(long caller) {
        Object object = this.handlerLock = new Object();
        synchronized (object) {
            try {
                this.activeCaller = caller;
                if (this.cameraHandler == null && Looper.myLooper() != null) {
                    this.cameraHandler = new Handler(Looper.myLooper());
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "WrapCameraHandler throws IllegalArgumentException: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void invoke(int type) {
        Object object = this.handlerLock;
        synchronized (object) {
            try {
                if (this.cameraHandler == null) {
                    Logging.e(TAG, "WrapCameraHandler invoke cameraHandler is null");
                    return;
                }
                ThreadUtils.invokeAtFrontUninterruptibly(this.cameraHandler, () -> WrapCameraHandler.nativeInvokeCameraHandler(this.activeCaller, type));
            }
            catch (Exception e) {
                Logging.e(TAG, "WrapCameraHandler invoke throws IllegalArgumentException: " + e.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exception) {
                    exception.printStackTrace();
                }
                throw new RuntimeException("WrapCameraHandler invoke crash");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void post(int type) {
        Object object = this.handlerLock;
        synchronized (object) {
            try {
                if (this.cameraHandler == null) {
                    Logging.e(TAG, "WrapCameraHandler post cameraHandler is null");
                    return;
                }
                this.cameraHandler.post(() -> WrapCameraHandler.nativePostCameraHandler(this.activeCaller, type));
            }
            catch (Exception e) {
                Logging.e(TAG, "WrapCameraHandler post throws IllegalArgumentException: " + e.getMessage());
            }
        }
    }

    public static native void nativeInvokeCameraHandler(long var0, int var2);

    public static native void nativePostCameraHandler(long var0, int var2);
}

