/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.WrapYuvConverter;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class WrapEGLTextureHelper {
    private static final String TAG = "WrapEGLTextureHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private final WrapYuvConverter wrapYuvConverter = new WrapYuvConverter();

    @CalledByNative
    public static WrapEGLTextureHelper create(final String threadName, final EglBase.Context sharedContext) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<WrapEGLTextureHelper>(){

            @Override
            @Nullable
            public WrapEGLTextureHelper call() {
                try {
                    return new WrapEGLTextureHelper(sharedContext, handler);
                }
                catch (RuntimeException e) {
                    Logging.e(WrapEGLTextureHelper.TAG, threadName + " create failure", e);
                    return null;
                }
            }
        });
    }

    private WrapEGLTextureHelper(EglBase.Context sharedContext, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("WrapEGLTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase.create(sharedContext, EglBase.ConfigType.kConfigType_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
            this.wrapYuvConverter.setOpenGles3(this.eglBase.getOpenGlesVersion() == 3);
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
    }

    @CalledByNative
    public Handler getHandler() {
        return this.handler;
    }

    @CalledByNative
    public WrapYuvConverter getWrapYuvConverter() {
        return this.wrapYuvConverter;
    }

    @CalledByNative
    public void dispose() {
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> this.release());
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        this.wrapYuvConverter.release();
        this.eglBase.release();
        if (Build.VERSION.SDK_INT >= 18) {
            this.handler.getLooper().quitSafely();
        } else {
            this.handler.getLooper().quit();
        }
    }
}

