/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.graphics.Matrix;
import android.os.Handler;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.WrapYuvConverter;
import com.netease.lava.webrtc.YuvHelper;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class WrapTextureBufferImpl
implements VideoFrame.WrapTextureBuffer {
    private int width;
    private int height;
    private int oriWidth;
    private int oriHeight;
    private VideoFrame.WrapTextureBuffer.TextureType textureType;
    private int id;
    private int type;
    private Matrix transformMatrix;
    private int yTextureId;
    private int uTextureId;
    private int vTextureId;
    private final Handler toI420Handler;
    private final WrapYuvConverter yuvConverter;
    private final long fenceSyncObject;

    @CalledByNative
    public WrapTextureBufferImpl(int width, int height, int type, int id, int[] ids, Matrix transformMatrix, Handler toI420Handler, WrapYuvConverter yuvConverter, long fenceSyncObject) {
        this.width = width;
        this.height = height;
        this.oriWidth = width;
        this.oriHeight = height;
        this.type = type;
        this.textureType = type == 0 ? VideoFrame.WrapTextureBuffer.TextureType.kTextureTypeOES : (type == 1 ? VideoFrame.WrapTextureBuffer.TextureType.kTextureTypeRGB : VideoFrame.WrapTextureBuffer.TextureType.kTextureTypeYUV);
        this.id = id;
        if (ids != null && ids.length == 3) {
            this.yTextureId = ids[0];
            this.uTextureId = ids[1];
            this.vTextureId = ids[2];
        }
        this.transformMatrix = transformMatrix == null ? new Matrix() : transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.fenceSyncObject = fenceSyncObject;
    }

    @Override
    public long getFenceSyncObject() {
        return this.fenceSyncObject;
    }

    @Override
    public VideoFrame.WrapTextureBuffer.TextureType getType() {
        return this.textureType;
    }

    @Override
    public boolean isYUVTexture() {
        return this.getType() == VideoFrame.WrapTextureBuffer.TextureType.kTextureTypeYUV;
    }

    @Override
    public Handler getHandler() {
        return this.toI420Handler;
    }

    @Override
    public int getBufferType() {
        return 4;
    }

    @Override
    public VideoFrame.Buffer.BufferType getInternalBufferType() {
        return VideoFrame.Buffer.BufferType.kBufferTypeWrapTexture;
    }

    @Override
    public int getTextureType() {
        return this.type;
    }

    public void setType(VideoFrame.WrapTextureBuffer.TextureType textureType) {
        this.textureType = textureType;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public void setTextureId(int textureType, int textureId) {
        this.type = textureType;
        this.id = textureId;
        this.textureType = textureType == 0 ? VideoFrame.WrapTextureBuffer.TextureType.kTextureTypeOES : (textureType == 1 ? VideoFrame.WrapTextureBuffer.TextureType.kTextureTypeRGB : VideoFrame.WrapTextureBuffer.TextureType.kTextureTypeYUV);
    }

    @Override
    public int[] getTextureIds() {
        int[] textures = new int[]{this.yTextureId, this.uTextureId, this.vTextureId};
        return textures;
    }

    @Override
    public void setTextureIds(int[] textureIds) {
        if (textureIds != null && textureIds.length == 3) {
            this.yTextureId = textureIds[0];
            this.uTextureId = textureIds[1];
            this.vTextureId = textureIds[2];
            this.type = 2;
            this.textureType = VideoFrame.WrapTextureBuffer.TextureType.kTextureTypeYUV;
        }
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getOriWidth() {
        return this.oriWidth;
    }

    @Override
    public int getOriHeight() {
        return this.oriHeight;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public void setFlipVertical() {
        if (this.isYUVTexture()) {
            return;
        }
        this.transformMatrix.preTranslate(0.5f, 0.5f);
        this.transformMatrix.preScale(1.0f, -1.0f);
        this.transformMatrix.preTranslate(-0.5f, -0.5f);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    public VideoFrame.I420Buffer toI420() {
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> this.yuvConverter.convertToI420(this));
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
            return this.generateBlackI420();
        }
    }

    private VideoFrame.I420Buffer generateBlackI420() {
        int chromaHeight = (this.height + 1) / 2;
        int strideUV = (this.width + 1) / 2;
        int yPos = 0;
        int uPos = yPos + this.width * this.height;
        int vPos = uPos + strideUV * chromaHeight;
        ByteBuffer buffer = YuvHelper.nativeAllocateBlackI420ByteBuffer(this.width, this.height);
        buffer.position(yPos);
        buffer.limit(uPos);
        ByteBuffer dataY = buffer.slice();
        buffer.position(uPos);
        buffer.limit(vPos);
        ByteBuffer dataU = buffer.slice();
        buffer.position(vPos);
        buffer.limit(vPos + strideUV * chromaHeight);
        ByteBuffer dataV = buffer.slice();
        return JavaI420Buffer.wrap(this.width, this.height, dataY, this.width, dataU, strideUV, dataV, strideUV, () -> YuvHelper.nativeFreeBlackI420ByteBuffer(buffer));
    }

    @Override
    public void retain() {
    }

    @Override
    public void release() {
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        return this.applyTransformMatrix(cropAndScaleMatrix, scaleWidth, scaleHeight);
    }

    private WrapTextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int scaledWidth, int scaledHeight) {
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preConcat(transformMatrix);
        this.retain();
        int[] textures = new int[]{this.yTextureId, this.uTextureId, this.vTextureId};
        return new WrapTextureBufferImpl(scaledWidth, scaledHeight, this.type, this.id, textures, newMatrix, this.toI420Handler, this.yuvConverter, this.fenceSyncObject);
    }
}

