/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.opengl.GLES20;
import android.opengl.GLES30;
import com.netease.lava.webrtc.GlGenericDrawer;
import com.netease.lava.webrtc.GlRectDrawer;
import com.netease.lava.webrtc.GlShader;
import com.netease.lava.webrtc.GlTextureFrameBuffer;
import com.netease.lava.webrtc.GlUtil;
import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.JniCommon;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.VideoFrameDrawer;
import com.netease.lava.webrtc.WrapTextureBufferImpl;
import com.netease.lava.webrtc.YuvHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class WrapYuvConverter {
    private static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
    private final ShaderCallbacks shaderCallbacks = new ShaderCallbacks();
    private final GlGenericDrawer drawer = new GlGenericDrawer("uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n", this.shaderCallbacks);
    private final GlTextureFrameBuffer rgbTextureFrameBuffer = new GlTextureFrameBuffer(6408);
    private final GlGenericDrawer rgbDrawer = new GlRectDrawer();
    private static final String TAG = "WrapYuvConverter";
    private boolean isGles3;
    private int srcWidth;
    private int srcHeight;
    @Nullable
    private int[] downloadPboIds;
    private int m_FrameIndex;
    private boolean is_clear;

    public WrapYuvConverter() {
        this.threadChecker.detachThread();
        this.isGles3 = false;
        this.srcWidth = 0;
        this.srcHeight = 0;
        this.m_FrameIndex = 0;
        this.is_clear = true;
    }

    public VideoFrame.I420Buffer convertToI420(VideoFrame.WrapTextureBuffer inputTextureBuffer) {
        if (inputTextureBuffer.isYUVTexture()) {
            VideoFrame.WrapTextureBuffer buffer = this.yuvConvertToRGB(inputTextureBuffer);
            return this.wrapConvert(buffer);
        }
        return this.wrapConvert(inputTextureBuffer);
    }

    public VideoFrame.WrapTextureBuffer yuvConvertToRGB(VideoFrame.WrapTextureBuffer inputTextureBuffer) {
        this.threadChecker.checkIsOnValidThread();
        int frameWidth = inputTextureBuffer.getWidth();
        int frameHeight = inputTextureBuffer.getHeight();
        this.rgbTextureFrameBuffer.setSize(frameWidth, frameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.rgbTextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preScale(1.0f, -1.0f);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        VideoFrameDrawer.drawWrapTexture(this.rgbDrawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, 0, frameWidth, frameHeight);
        GlUtil.checkNoGLES2Error("WrapYuvConverter.yuvConvertToRGB");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        int[] textures = new int[]{0, 0, 0};
        WrapTextureBufferImpl impl = new WrapTextureBufferImpl(frameWidth, frameHeight, 1, this.rgbTextureFrameBuffer.getTextureId(), textures, null, inputTextureBuffer.getHandler(), this, inputTextureBuffer.getFenceSyncObject());
        return impl;
    }

    public VideoFrame.I420Buffer rgbConvertToI420(VideoFrame.WrapTextureBuffer inputTextureBuffer) {
        this.threadChecker.checkIsOnValidThread();
        int frameWidth = inputTextureBuffer.getWidth();
        int frameHeight = inputTextureBuffer.getHeight();
        int stride = (frameWidth + 7) / 8 * 8;
        int uvHeight = (frameHeight + 1) / 2;
        int totalHeight = frameHeight + uvHeight;
        ByteBuffer i420ByteBuffer = JniCommon.nativeAllocateByteBuffer(stride * totalHeight);
        int viewportWidth = stride / 4;
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preScale(1.0f, -1.0f);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        this.i420TextureFrameBuffer.setSize(viewportWidth, totalHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawWrapTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, 0, viewportWidth, frameHeight);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawWrapTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, frameHeight, viewportWidth / 2, uvHeight);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawWrapTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, viewportWidth / 2, frameHeight, viewportWidth / 2, uvHeight);
        GLES20.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (Buffer)i420ByteBuffer);
        GlUtil.checkNoGLES2Error("WrapYuvConverter.rgbConvertToI420");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        boolean yPos = false;
        int uPos = 0 + stride * frameHeight;
        int vPos = uPos + stride / 2;
        i420ByteBuffer.position(0);
        i420ByteBuffer.limit(0 + stride * frameHeight);
        ByteBuffer dataY = i420ByteBuffer.slice();
        i420ByteBuffer.position(uPos);
        int uvSize = stride * (uvHeight - 1) + stride / 2;
        i420ByteBuffer.limit(uPos + uvSize);
        ByteBuffer dataU = i420ByteBuffer.slice();
        i420ByteBuffer.position(vPos);
        i420ByteBuffer.limit(vPos + uvSize);
        ByteBuffer dataV = i420ByteBuffer.slice();
        ByteBuffer dataByteBufferU = JniCommon.nativeAllocateByteBuffer(stride * uvHeight / 2);
        ByteBuffer dataByteBufferV = JniCommon.nativeAllocateByteBuffer(stride * uvHeight / 2);
        YuvHelper.copyPlane(dataU, stride, dataByteBufferU, stride / 2, stride / 2, uvHeight);
        YuvHelper.copyPlane(dataV, stride, dataByteBufferV, stride / 2, stride / 2, uvHeight);
        dataByteBufferU.position(0);
        dataByteBufferV.position(0);
        return JavaI420Buffer.wrap(frameWidth, frameHeight, dataY, stride, dataByteBufferU, stride / 2, dataByteBufferV, stride / 2, () -> {
            JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
            JniCommon.nativeFreeByteBuffer(dataByteBufferU);
            JniCommon.nativeFreeByteBuffer(dataByteBufferV);
        });
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.drawer.release();
        this.i420TextureFrameBuffer.release();
        this.rgbDrawer.release();
        this.rgbTextureFrameBuffer.release();
        this.clearPBO();
        this.threadChecker.detachThread();
    }

    public void setOpenGles3(boolean isGles3) {
        this.isGles3 = isGles3;
    }

    public boolean isOpenGles3() {
        return this.isGles3;
    }

    public VideoFrame.I420Buffer wrapConvert(VideoFrame.WrapTextureBuffer inputTextureBuffer) {
        return this.rgbConvertToI420(inputTextureBuffer);
    }

    @TargetApi(value=26)
    public VideoFrame.I420Buffer rgbConvertToI420_2(VideoFrame.WrapTextureBuffer inputTextureBuffer) {
        this.threadChecker.checkIsOnValidThread();
        this.is_clear = false;
        int frameWidth = inputTextureBuffer.getWidth();
        int frameHeight = inputTextureBuffer.getHeight();
        int stride = (frameWidth + 7) / 8 * 8;
        int uvHeight = (frameHeight + 1) / 2;
        int totalHeight = frameHeight + uvHeight;
        ByteBuffer i420ByteBuffer = JniCommon.nativeAllocateByteBuffer(stride * totalHeight);
        int viewportWidth = stride / 4;
        boolean isUpdate = false;
        if (this.srcWidth != frameWidth || this.srcHeight != frameHeight) {
            isUpdate = true;
            this.srcWidth = frameWidth;
            this.srcHeight = frameHeight;
            if (this.downloadPboIds == null) {
                this.downloadPboIds = new int[2];
                for (int i = 0; i < 2; ++i) {
                    this.downloadPboIds[i] = 0;
                }
            }
            if (this.downloadPboIds[0] != 0) {
                GLES30.glDeleteBuffers((int)2, (int[])this.downloadPboIds, (int)0);
            }
            GLES30.glGenBuffers((int)2, (int[])this.downloadPboIds, (int)0);
            int imgByteSize = viewportWidth * totalHeight * 4;
            GLES30.glBindBuffer((int)35051, (int)this.downloadPboIds[0]);
            GLES30.glBufferData((int)35051, (int)imgByteSize, null, (int)35041);
            GLES30.glBindBuffer((int)35051, (int)this.downloadPboIds[1]);
            GLES30.glBufferData((int)35051, (int)imgByteSize, null, (int)35041);
            GLES30.glBindBuffer((int)35051, (int)0);
        }
        int index = this.m_FrameIndex % 2;
        int nextIndex = (index + 1) % 2;
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preScale(1.0f, -1.0f);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        this.i420TextureFrameBuffer.setSize(viewportWidth, totalHeight);
        GLES30.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawWrapTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, 0, viewportWidth, frameHeight);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawWrapTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, frameHeight, viewportWidth / 2, uvHeight);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawWrapTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, viewportWidth / 2, frameHeight, viewportWidth / 2, uvHeight);
        int imgByteSize = this.i420TextureFrameBuffer.getWidth() * this.i420TextureFrameBuffer.getHeight() * 4;
        GLES30.glBindBuffer((int)35051, (int)this.downloadPboIds[index]);
        GLES30.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (int)0);
        GLES30.glBindBuffer((int)35051, (int)this.downloadPboIds[nextIndex]);
        ByteBuffer mapped = (ByteBuffer)GLES30.glMapBufferRange((int)35051, (int)0, (int)imgByteSize, (int)1);
        if (!isUpdate) {
            i420ByteBuffer.position(0);
            i420ByteBuffer.put(mapped);
        }
        GLES30.glUnmapBuffer((int)35051);
        GLES30.glBindBuffer((int)35051, (int)0);
        GLES30.glBindFramebuffer((int)36160, (int)0);
        ++this.m_FrameIndex;
        GLES30.glFlush();
        GlUtil.checkNoGLES2Error("WrapYuvConverter.rgbConvertToI420_2");
        if (isUpdate) {
            JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
            return this.rgbConvertToI420(inputTextureBuffer);
        }
        boolean yPos = false;
        int uPos = 0 + stride * frameHeight;
        int vPos = uPos + stride / 2;
        i420ByteBuffer.position(0);
        i420ByteBuffer.limit(0 + stride * frameHeight);
        ByteBuffer dataY = i420ByteBuffer.slice();
        i420ByteBuffer.position(uPos);
        int uvSize = stride * (uvHeight - 1) + stride / 2;
        i420ByteBuffer.limit(uPos + uvSize);
        ByteBuffer dataU = i420ByteBuffer.slice();
        i420ByteBuffer.position(vPos);
        i420ByteBuffer.limit(vPos + uvSize);
        ByteBuffer dataV = i420ByteBuffer.slice();
        ByteBuffer dataByteBufferU = JniCommon.nativeAllocateByteBuffer(stride * uvHeight / 2);
        ByteBuffer dataByteBufferV = JniCommon.nativeAllocateByteBuffer(stride * uvHeight / 2);
        YuvHelper.copyPlane(dataU, stride, dataByteBufferU, stride / 2, stride / 2, uvHeight);
        YuvHelper.copyPlane(dataV, stride, dataByteBufferV, stride / 2, stride / 2, uvHeight);
        dataByteBufferU.position(0);
        dataByteBufferV.position(0);
        return JavaI420Buffer.wrap(frameWidth, frameHeight, dataY, stride, dataByteBufferU, stride / 2, dataByteBufferV, stride / 2, () -> {
            JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
            JniCommon.nativeFreeByteBuffer(dataByteBufferU);
            JniCommon.nativeFreeByteBuffer(dataByteBufferV);
        });
    }

    public void clearPBO() {
        if (this.downloadPboIds != null && !this.is_clear) {
            GLES30.glDeleteBuffers((int)2, (int[])this.downloadPboIds, (int)0);
            this.is_clear = true;
            this.srcWidth = 0;
            this.srcHeight = 0;
            this.downloadPboIds = null;
        }
    }

    public static Bitmap getBitmapImageFromYUV(byte[] data, int width, int height) {
        YuvImage yuvimage = new YuvImage(data, 17, width, height, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        yuvimage.compressToJpeg(new Rect(0, 0, width, height), 80, (OutputStream)baos);
        byte[] jdata = baos.toByteArray();
        BitmapFactory.Options bitmapFatoryOptions = new BitmapFactory.Options();
        bitmapFatoryOptions.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bmp = BitmapFactory.decodeByteArray((byte[])jdata, (int)0, (int)jdata.length, (BitmapFactory.Options)bitmapFatoryOptions);
        return bmp;
    }

    private static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        private static final float[] yCoeffs = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f};
        private static final float[] uCoeffs = new float[]{-0.148223f, -0.290993f, 0.439216f, 0.501961f};
        private static final float[] vCoeffs = new float[]{0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        private int xUnitLoc;
        private int coeffsLoc;
        private float[] coeffs;
        private float stepSize;

        private ShaderCallbacks() {
        }

        public void setPlaneY() {
            this.coeffs = yCoeffs;
            this.stepSize = 1.0f;
        }

        public void setPlaneU() {
            this.coeffs = uCoeffs;
            this.stepSize = 2.0f;
        }

        public void setPlaneV() {
            this.coeffs = vCoeffs;
            this.stepSize = 2.0f;
        }

        @Override
        public void onNewShader(GlShader shader) {
            this.xUnitLoc = shader.getUniformLocation("xUnit");
            this.coeffsLoc = shader.getUniformLocation("coeffs");
        }

        @Override
        public void onPrepareShader(GlShader shader, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight) {
            GLES20.glUniform4fv((int)this.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(this.stepSize * texMatrix[0] / (float)frameWidth), (float)(this.stepSize * texMatrix[1] / (float)frameWidth));
        }
    }
}

